/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus;

import com.google.appengine.api.datastore.ShortBlob;
import com.google.appengine.api.datastore.Text;
import com.google.appengine.datanucleus.PrimitiveArrays;
import com.google.appengine.datanucleus.PrimitiveUtils;
import com.google.appengine.datanucleus.Utils;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.store.types.ObjectLongConverter;
import org.datanucleus.store.types.ObjectStringConverter;
import org.datanucleus.store.types.TypeManager;

class TypeConversionUtils {
    private static final Set<Class> SUPPORTED_CLASSES = TypeConversionUtils.buildSupportedClasses();
    private static final Utils.Function<Object, Object> LONG_TO_INTEGER = new Utils.Function<Object, Object>(){

        @Override
        public Integer apply(Object in) {
            return null == in ? null : Integer.valueOf(((Long)in).intValue());
        }
    };
    private static final Utils.Function<Object, Object> LONG_TO_SHORT = new Utils.Function<Object, Object>(){

        @Override
        public Short apply(Object in) {
            return null == in ? null : Short.valueOf(((Long)in).shortValue());
        }
    };
    private static final Utils.Function<Object, Object> LONG_TO_BYTE = new Utils.Function<Object, Object>(){

        @Override
        public Byte apply(Object in) {
            return null == in ? null : Byte.valueOf(((Long)in).byteValue());
        }
    };
    private static final Utils.Function<Object, Object> LONG_TO_CHARACTER = new Utils.Function<Object, Object>(){

        @Override
        public Character apply(Object in) {
            return Character.valueOf((char)((Long)in).longValue());
        }
    };
    private static final Utils.Function<Object, Object> DOUBLE_TO_FLOAT = new Utils.Function<Object, Object>(){

        @Override
        public Float apply(Object in) {
            return null == in ? null : Float.valueOf(((Double)in).floatValue());
        }
    };
    private static final Utils.Function<Object, Object> DOUBLE_TO_BIG_DECIMAL = new Utils.Function<Object, Object>(){

        @Override
        public BigDecimal apply(Object in) {
            return null == in ? null : new BigDecimal((Double)in);
        }
    };
    private static final Utils.Function<Object, Object> STRING_TO_TEXT = new Utils.Function<Object, Object>(){

        @Override
        public Text apply(Object in) {
            if (in instanceof String) {
                return null == in ? null : new Text((String)in);
            }
            return (Text)in;
        }
    };
    private static final Utils.Function<Object, Object> INTEGER_TO_LONG = new Utils.Function<Object, Object>(){

        @Override
        public Long apply(Object in) {
            return null == in ? null : Long.valueOf(((Integer)in).longValue());
        }
    };
    private static final Utils.Function<Object, Object> SHORT_TO_LONG = new Utils.Function<Object, Object>(){

        @Override
        public Long apply(Object in) {
            return null == in ? null : Long.valueOf(((Short)in).longValue());
        }
    };
    private static final Utils.Function<Object, Object> CHARACTER_TO_LONG = new Utils.Function<Object, Object>(){

        @Override
        public Long apply(Object character) {
            return null == character ? null : Long.valueOf(((Character)character).charValue());
        }
    };
    private static final Utils.Function<Object, Object> BYTE_TO_LONG = new Utils.Function<Object, Object>(){

        @Override
        public Long apply(Object in) {
            return null == in ? null : Long.valueOf(((Byte)in).longValue());
        }
    };
    private static final Utils.Function<Object, Object> FLOAT_TO_DOUBLE = new Utils.Function<Object, Object>(){

        @Override
        public Double apply(Object in) {
            return null == in ? null : Double.valueOf(((Float)in).doubleValue());
        }
    };
    private static final Utils.Function<Object, Object> BIG_DECIMAL_TO_DOUBLE = new Utils.Function<Object, Object>(){

        @Override
        public Double apply(Object in) {
            return null == in ? null : Double.valueOf(((BigDecimal)in).doubleValue());
        }
    };
    private static final Map<Class<?>, Utils.Function<Object, Object>> DATASTORE_TO_POJO_TYPE_FUNC = TypeConversionUtils.buildDatastoreToPojoTypeFuncMap();
    private static final Map<Class<?>, Utils.Function<Object, Object>> POJO_TO_DATASTORE_TYPE_FUNC = TypeConversionUtils.buildPojoToDatastoreTypeFuncMap();
    private static Utils.Function<Object, Object> IDENTITY = new Utils.Function<Object, Object>(){

        @Override
        public Object apply(Object from) {
            return from;
        }
    };

    TypeConversionUtils() {
    }

    private static final Set<Class> buildSupportedClasses() {
        HashSet<Class> classes = new HashSet<Class>();
        classes.add(Byte.class);
        classes.add(Boolean.class);
        classes.add(Character.class);
        classes.add(Double.class);
        classes.add(Float.class);
        classes.add(Integer.class);
        classes.add(Long.class);
        classes.add(Short.class);
        classes.add(Byte.TYPE);
        classes.add(Boolean.TYPE);
        classes.add(Character.TYPE);
        classes.add(Double.TYPE);
        classes.add(Float.TYPE);
        classes.add(Integer.TYPE);
        classes.add(Long.TYPE);
        classes.add(Short.TYPE);
        classes.add(String.class);
        classes.add(Enum.class);
        classes.add(java.util.Date.class);
        classes.add(BigDecimal.class);
        return classes;
    }

    private static Map<Class<?>, Utils.Function<Object, Object>> buildDatastoreToPojoTypeFuncMap() {
        HashMap map = new HashMap();
        map.put(Integer.class, LONG_TO_INTEGER);
        map.put(Integer.TYPE, LONG_TO_INTEGER);
        map.put(Short.class, LONG_TO_SHORT);
        map.put(Short.TYPE, LONG_TO_SHORT);
        map.put(Byte.class, LONG_TO_BYTE);
        map.put(Byte.TYPE, LONG_TO_BYTE);
        map.put(Character.class, LONG_TO_CHARACTER);
        map.put(Character.TYPE, LONG_TO_CHARACTER);
        map.put(Float.class, DOUBLE_TO_FLOAT);
        map.put(Float.TYPE, DOUBLE_TO_FLOAT);
        map.put(BigDecimal.class, DOUBLE_TO_BIG_DECIMAL);
        map.put(Text.class, STRING_TO_TEXT);
        return map;
    }

    private static Map<Class<?>, Utils.Function<Object, Object>> buildPojoToDatastoreTypeFuncMap() {
        HashMap map = new HashMap();
        map.put(Integer.class, INTEGER_TO_LONG);
        map.put(Integer.TYPE, INTEGER_TO_LONG);
        map.put(Short.class, SHORT_TO_LONG);
        map.put(Short.TYPE, SHORT_TO_LONG);
        map.put(Byte.class, BYTE_TO_LONG);
        map.put(Byte.TYPE, BYTE_TO_LONG);
        map.put(Character.class, CHARACTER_TO_LONG);
        map.put(Character.TYPE, CHARACTER_TO_LONG);
        map.put(Float.class, FLOAT_TO_DOUBLE);
        map.put(Float.TYPE, FLOAT_TO_DOUBLE);
        map.put(BigDecimal.class, BIG_DECIMAL_TO_DOUBLE);
        return map;
    }

    private boolean pojoPropertyIsByteArray(AbstractMemberMetaData metaData) {
        Class<?> componentType = metaData.getType().getComponentType();
        return componentType.equals(Byte.class) || componentType.equals(Byte.TYPE);
    }

    private boolean pojoPropertyIsByteCollection(AbstractMemberMetaData metaData) {
        String containerClassStr = metaData.getCollection().getElementType();
        return containerClassStr.equals(Byte.class.getName()) || containerClassStr.equals(Byte.TYPE.getName());
    }

    private ShortBlob convertByteArrayToShortBlob(Object value) {
        if (value.getClass().getComponentType().isPrimitive()) {
            return new ShortBlob((byte[])value);
        }
        return this.convertByteCollectionToShortBlob(Arrays.asList((Byte[])value));
    }

    private ShortBlob convertByteCollectionToShortBlob(Collection<Byte> value) {
        return new ShortBlob(PrimitiveArrays.toByteArray(value));
    }

    private List<?> convertPojoArrayToDatastoreList(Object value) {
        Class<?> componentType = value.getClass().getComponentType();
        if (componentType.isPrimitive()) {
            List<Object> datastoreList = PrimitiveUtils.PRIMITIVE_ARRAY_TO_LIST_FUNC_MAP.get(componentType).apply(value);
            if (POJO_TO_DATASTORE_TYPE_FUNC.get(componentType) != null) {
                datastoreList = Utils.transform(datastoreList, POJO_TO_DATASTORE_TYPE_FUNC.get(componentType));
            }
            return datastoreList;
        }
        return this.convertNonPrimitivePojoArrayToDatastoreList((Object[])value);
    }

    private List<?> convertNonPrimitivePojoArrayToDatastoreList(Object[] array) {
        List<Object> datastoreList = Arrays.asList(array);
        if (POJO_TO_DATASTORE_TYPE_FUNC.get(array.getClass().getComponentType()) != null) {
            datastoreList = Utils.transform(Arrays.asList(array), POJO_TO_DATASTORE_TYPE_FUNC.get(array.getClass().getComponentType()));
        }
        return datastoreList;
    }

    Object datastoreValueToPojoValue(TypeManager typeMgr, ClassLoaderResolver clr, Object value, AbstractMemberMetaData ammd) {
        if (ammd.hasArray()) {
            value = this.datastoreValueToPojoArray(value, ammd);
        } else if (ammd.hasCollection()) {
            value = this.datastoreValueToPojoCollection(clr, value, ammd);
        } else if (value != null) {
            if (Time.class.isAssignableFrom(ammd.getType())) {
                value = new Time((Long)value);
            } else if (Date.class.isAssignableFrom(ammd.getType())) {
                value = new Date((Long)value);
            } else if (Timestamp.class.isAssignableFrom(ammd.getType())) {
                value = new Timestamp((Long)value);
            } else if (Enum.class.isAssignableFrom(ammd.getType())) {
                String jdbcType;
                boolean asOrdinal = false;
                if (ammd.getColumnMetaData() != null && ammd.getColumnMetaData().length > 0 && (jdbcType = ammd.getColumnMetaData()[0].getJdbcType()) != null && jdbcType.equalsIgnoreCase("integer")) {
                    asOrdinal = true;
                }
                Class enumClass = ammd.getType();
                value = asOrdinal ? ((Enum[])enumClass.getEnumConstants())[(Integer)value] : Enum.valueOf(enumClass, (String)value);
            } else if (SUPPORTED_CLASSES.contains(ammd.getType()) || ammd.getTypeName().startsWith("com.google.appengine.api")) {
                value = this.getDatastoreToPojoTypeFunc(Utils.<Object>identity(), ammd).apply(value);
            } else if (value instanceof String) {
                ObjectStringConverter conv = typeMgr.getStringConverter(ammd.getType());
                if (conv != null) {
                    value = conv.toObject((String)value);
                }
            } else if (value instanceof Long) {
                ObjectLongConverter conv = typeMgr.getLongConverter(ammd.getType());
                if (conv != null) {
                    value = conv.toObject((Long)value);
                }
            } else {
                value = this.getDatastoreToPojoTypeFunc(Utils.<Object>identity(), ammd).apply(value);
            }
        }
        return value;
    }

    private Object datastoreValueToPojoCollection(ClassLoaderResolver clr, Object value, AbstractMemberMetaData ammd) {
        String memberTypeStr = ammd.getCollection().getElementType();
        Class<?> memberType = this.classForName(clr, memberTypeStr);
        Utils.Function<Object, Object> conversionFunc = DATASTORE_TO_POJO_TYPE_FUNC.get(memberType);
        if (value instanceof ShortBlob) {
            if (!memberType.equals(Byte.TYPE) && !memberType.equals(Byte.class)) {
                throw new NucleusException("Cannot convert a ShortBlob to an array of type " + memberType.getName());
            }
            value = Arrays.asList((Byte[])this.convertShortBlobToByteArray((ShortBlob)value, memberType));
            conversionFunc = null;
        }
        List datastoreList = value;
        if (this.pojoPropertyIsSet(ammd)) {
            Class setType = ammd.getType();
            value = this.convertDatastoreListToPojoSet(datastoreList, memberType, setType, conversionFunc);
        } else if (this.pojoPropertyIsCollection(ammd)) {
            Class listType = ammd.getType();
            value = this.convertDatastoreListToPojoCollection(datastoreList, memberType, listType, conversionFunc);
        }
        return value;
    }

    private Object datastoreValueToPojoArray(Object value, AbstractMemberMetaData ammd) {
        Class<?> memberType = ammd.getType().getComponentType();
        if (value instanceof ShortBlob) {
            if (!memberType.equals(Byte.TYPE) && !memberType.equals(Byte.class)) {
                throw new NucleusException("Cannot convert a ShortBlob to an array of type " + memberType.getName());
            }
            value = this.convertShortBlobToByteArray((ShortBlob)value, memberType);
        } else {
            List datastoreList = (List)value;
            value = this.convertDatastoreListToPojoArray(datastoreList, memberType);
        }
        return value;
    }

    private Object convertShortBlobToByteArray(ShortBlob shortBlob, Class<?> pojoType) {
        if (pojoType.isPrimitive()) {
            return shortBlob.getBytes();
        }
        byte[] bytes = shortBlob.getBytes();
        Byte[] array = (Byte[])Array.newInstance(pojoType, bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            array[i] = bytes[i];
        }
        return array;
    }

    private Collection<Object> newCollection(Class<? extends Collection> collType) {
        Collection<Object> collToReturn;
        if (collType.isInterface()) {
            collToReturn = Utils.newArrayList(new Object[0]);
        } else {
            try {
                collToReturn = collType.newInstance();
            }
            catch (InstantiationException e) {
                throw new NucleusException("Cannot instantiate Collection of type " + collType.getName(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new NucleusException("Cannot instantiate Collection of type " + collType.getName(), (Throwable)e);
            }
        }
        return collToReturn;
    }

    Collection<Object> convertDatastoreListToPojoCollection(List<Object> datastoreList, Class<?> pojoType, Class<? extends Collection> collType) {
        Utils.Function<Object, Object> func = DATASTORE_TO_POJO_TYPE_FUNC.get(pojoType);
        return this.convertDatastoreListToPojoCollection(datastoreList, pojoType, collType, func);
    }

    Collection<Object> convertDatastoreListToPojoCollection(List<Object> datastoreList, Class<?> pojoType, Class<? extends Collection> collType, Utils.Function<Object, Object> func) {
        Collection<Object> listToReturn = this.newCollection(collType);
        if (datastoreList == null) {
            return listToReturn;
        }
        if (func != null) {
            datastoreList = Utils.transform(datastoreList, func);
        } else if (Enum.class.isAssignableFrom(pojoType)) {
            Class<Enum> enumClass = pojoType;
            datastoreList = new ArrayList<Object>(Arrays.asList(this.convertStringListToEnumArray(datastoreList, enumClass)));
        }
        if (collType.isAssignableFrom(datastoreList.getClass())) {
            return datastoreList;
        }
        listToReturn.addAll(datastoreList);
        return listToReturn;
    }

    private Set<Object> newSet(Class<? extends Set> setType) {
        Set<Object> setToReturn;
        if (Set.class.equals(setType)) {
            setToReturn = Utils.newHashSet(new Object[0]);
        } else if (SortedSet.class.equals(setType)) {
            setToReturn = Utils.newTreeSet(new Object[0]);
        } else {
            try {
                setToReturn = setType.newInstance();
            }
            catch (InstantiationException e) {
                throw new NucleusException("Cannot instantiate Set of type " + setType.getName(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new NucleusException("Cannot instantiate Set of type " + setType.getName(), (Throwable)e);
            }
        }
        return setToReturn;
    }

    Set<Object> convertDatastoreListToPojoSet(List<Object> datastoreList, Class<?> pojoType, Class<? extends Set> setType, Utils.Function<Object, Object> conversionFunc) {
        Collection<Object> convertedList = this.convertDatastoreListToPojoCollection(datastoreList, pojoType, ArrayList.class, conversionFunc);
        Set<Object> setToReturn = this.newSet(setType);
        setToReturn.addAll(convertedList);
        return setToReturn;
    }

    Object convertDatastoreListToPojoArray(List<Object> datastoreList, Class<?> pojoType) {
        Collection<Object> datastoreColl = this.convertDatastoreListToPojoCollection(datastoreList, pojoType, ArrayList.class);
        if (pojoType.isPrimitive()) {
            return PrimitiveUtils.COLLECTION_TO_PRIMITIVE_ARRAY_FUNC_MAP.get(pojoType).apply(datastoreColl);
        }
        Object[] array = (Object[])Array.newInstance(pojoType, datastoreColl.size());
        return datastoreColl.toArray(array);
    }

    private Object[] convertStringListToEnumArray(List<?> datastoreList, Class<Enum> pojoType) {
        Object[] result = (Object[])Array.newInstance(pojoType, datastoreList.size());
        int i = 0;
        for (Object obj : datastoreList) {
            result[i++] = obj == null ? null : Enum.valueOf(pojoType, (String)obj);
        }
        return result;
    }

    private Class<?> classForName(ClassLoaderResolver clr, String typeStr) {
        Class clazz = PrimitiveUtils.PRIMITIVE_CLASSNAMES.get(typeStr);
        if (clazz == null) {
            clazz = clr.classForName(typeStr);
        }
        return clazz;
    }

    private Utils.Function<Object, Object> getDatastoreToPojoTypeFunc(Utils.Function<Object, Object> defaultVal, AbstractMemberMetaData ammd) {
        Utils.Function<Object, Object> candidate = DATASTORE_TO_POJO_TYPE_FUNC.get(ammd.getType());
        return candidate != null ? candidate : defaultVal;
    }

    private Utils.Function<Object, Object> getPojoToDatastoreTypeFunc(Utils.Function<Object, Object> defaultVal, AbstractMemberMetaData ammd) {
        Utils.Function<Object, Object> candidate = POJO_TO_DATASTORE_TYPE_FUNC.get(ammd.getType());
        return candidate != null ? candidate : defaultVal;
    }

    private boolean pojoPropertyIsSet(AbstractMemberMetaData ammd) {
        return Set.class.isAssignableFrom(ammd.getType());
    }

    private boolean pojoPropertyIsCollection(AbstractMemberMetaData ammd) {
        return Collection.class.isAssignableFrom(ammd.getType());
    }

    private List<String> convertEnumsToStringList(Iterable<Enum> enums) {
        ArrayList<Object> result = Utils.newArrayList(new Object[0]);
        for (Enum e : enums) {
            result.add(e == null ? null : e.name());
        }
        return result;
    }

    Object pojoValueToDatastoreValue(TypeManager typeMgr, ClassLoaderResolver clr, Object value, AbstractMemberMetaData ammd) {
        if (ammd.hasArray()) {
            value = this.convertPojoArrayToDatastoreValue(ammd, value);
        } else if (ammd.hasCollection()) {
            value = this.convertPojoCollectionToDatastoreValue(clr, ammd, (Collection)value);
        } else if (value != null) {
            if (Time.class.isAssignableFrom(ammd.getType())) {
                value = ((Time)value).getTime();
            } else if (Date.class.isAssignableFrom(ammd.getType())) {
                value = ((Date)value).getTime();
            } else if (Timestamp.class.isAssignableFrom(ammd.getType())) {
                value = ((Timestamp)value).getTime();
            } else if (java.util.Date.class.isAssignableFrom(ammd.getType())) {
                ColumnMetaData[] colmds = ammd.getColumnMetaData();
                if (colmds != null && colmds.length > 0 && colmds[0].getJdbcType() != null) {
                    String jdbcType = colmds[0].getJdbcType();
                    if (jdbcType.equalsIgnoreCase("time")) {
                        Calendar cal = Calendar.getInstance();
                        cal.setTime((java.util.Date)value);
                        Time time = new Time(0L);
                        time.setHours(cal.get(11));
                        time.setMinutes(cal.get(12));
                        time.setSeconds(cal.get(13));
                        value = new java.util.Date(time.getTime());
                    } else if (jdbcType.equalsIgnoreCase("date")) {
                        Calendar cal = Calendar.getInstance();
                        cal.setTime((java.util.Date)value);
                        Date date = new Date(0L);
                        date.setDate(cal.get(5));
                        date.setMonth(cal.get(2));
                        date.setYear(cal.get(1) - 1900);
                        value = new java.util.Date(date.getTime());
                    }
                }
            } else if (Enum.class.isAssignableFrom(ammd.getType())) {
                String jdbcType;
                boolean asOrdinal = false;
                if (ammd.getColumnMetaData() != null && ammd.getColumnMetaData().length > 0 && (jdbcType = ammd.getColumnMetaData()[0].getJdbcType()) != null && jdbcType.equalsIgnoreCase("integer")) {
                    asOrdinal = true;
                }
                value = asOrdinal ? Integer.valueOf(((Enum)value).ordinal()) : ((Enum)value).name();
            } else {
                ObjectLongConverter longConv;
                ObjectStringConverter strConv;
                value = SUPPORTED_CLASSES.contains(ammd.getType()) || ammd.getTypeName().startsWith("com.google.appengine.api") ? this.getPojoToDatastoreTypeFunc(Utils.<Object>identity(), ammd).apply(value) : ((strConv = typeMgr.getStringConverter(ammd.getType())) != null ? strConv.toString(value) : ((longConv = typeMgr.getLongConverter(ammd.getType())) != null ? longConv.toLong(value) : this.getPojoToDatastoreTypeFunc(Utils.<Object>identity(), ammd).apply(value)));
            }
        }
        return value;
    }

    private Object convertPojoCollectionToDatastoreValue(ClassLoaderResolver clr, AbstractMemberMetaData ammd, Collection<?> value) {
        Object result = value;
        Class elementType = clr.classForName(ammd.getCollection().getElementType());
        if (Enum.class.isAssignableFrom(elementType)) {
            ShortBlob enums = value;
            result = this.convertEnumsToStringList((Iterable<Enum>)enums);
        } else if (this.pojoPropertyIsByteCollection(ammd)) {
            result = this.convertByteCollectionToShortBlob((Collection<Byte>)value);
        } else if (POJO_TO_DATASTORE_TYPE_FUNC.get(elementType) != null) {
            result = Utils.transform(value, POJO_TO_DATASTORE_TYPE_FUNC.get(elementType));
        } else if (!(value instanceof List)) {
            result = Utils.transform(value, IDENTITY);
        }
        return result;
    }

    private Object convertPojoArrayToDatastoreValue(AbstractMemberMetaData ammd, Object value) {
        Object result = this.pojoPropertyIsByteArray(ammd) ? this.convertByteArrayToShortBlob(value) : (Enum.class.isAssignableFrom(ammd.getType().getComponentType()) ? this.convertEnumsToStringList(Arrays.asList((Enum[])value)) : this.convertPojoArrayToDatastoreList(value));
        return result;
    }
}

