/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.remoteapi;

import com.google.appengine.repackaged.org.apache.commons.httpclient.Cookie;
import com.google.appengine.repackaged.org.apache.commons.httpclient.util.EncodingUtil;
import com.google.appengine.tools.remoteapi.RemoteApiOptions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

abstract class AppEngineClient {
    private final String hostname;
    private final int port;
    private final String userEmail;
    private final Cookie[] authCookies;
    private final String remoteApiPath;
    private final int maxResponseSize;
    private final String appId;

    AppEngineClient(RemoteApiOptions options, List<Cookie> authCookies, String appId) {
        if (options == null) {
            throw new IllegalArgumentException("options not set");
        }
        if (authCookies == null) {
            throw new IllegalArgumentException("authCookies not set");
        }
        this.hostname = options.getHostname();
        this.port = options.getPort();
        this.userEmail = options.getUserEmail();
        this.authCookies = authCookies.toArray(new Cookie[0]);
        this.remoteApiPath = options.getRemoteApiPath();
        this.maxResponseSize = options.getMaxHttpResponseSize();
        this.appId = appId;
    }

    Cookie[] getAuthCookies() {
        return this.authCookies;
    }

    int getMaxResponseSize() {
        return this.maxResponseSize;
    }

    String getRemoteApiPath() {
        return this.remoteApiPath;
    }

    String getAppId() {
        return this.appId;
    }

    int getPort() {
        return this.port;
    }

    String serializeCredentials() {
        StringBuilder out = new StringBuilder();
        out.append("host=" + this.hostname + "\n");
        out.append("email=" + this.userEmail + "\n");
        for (Cookie cookie : this.authCookies) {
            out.append("cookie=" + cookie.getName() + "=" + cookie.getValue() + "\n");
        }
        return out.toString();
    }

    String makeUrl(String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("path doesn't start with a slash: " + path);
        }
        String protocol = this.port == 443 ? "https" : "http";
        return protocol + "://" + this.hostname + ":" + this.port + path;
    }

    List<String[]> getHeadersForPost(String mimeType) {
        List<String[]> headers = this.getHeadersBase();
        headers.add(new String[]{"Content-type", mimeType});
        return headers;
    }

    List<String[]> getHeadersForGet() {
        return this.getHeadersBase();
    }

    List<String[]> getHeadersBase() {
        ArrayList<String[]> headers = new ArrayList<String[]>();
        headers.add(new String[]{"Host", this.hostname});
        headers.add(new String[]{"X-appcfg-api-version", "1"});
        return headers;
    }

    abstract Response get(String var1) throws IOException;

    abstract Response post(String var1, String var2, byte[] var3) throws IOException;

    static class Response {
        private final int statusCode;
        private final byte[] responseBody;
        private final String responseCharSet;

        Response(int statusCode, byte[] responseBody, String responseCharSet) {
            this.statusCode = statusCode;
            this.responseBody = responseBody;
            this.responseCharSet = responseCharSet;
        }

        int getStatusCode() {
            return this.statusCode;
        }

        byte[] getBodyAsBytes() {
            return this.responseBody;
        }

        String getBodyAsString() {
            return EncodingUtil.getString(this.responseBody, this.responseCharSet);
        }
    }
}

