/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.remoteapi;

import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPMethod;
import com.google.appengine.api.urlfetch.HTTPRequest;
import com.google.appengine.api.urlfetch.HTTPResponse;
import com.google.appengine.api.urlfetch.URLFetchService;
import com.google.appengine.api.urlfetch.URLFetchServiceFactory;
import com.google.appengine.repackaged.org.apache.commons.httpclient.Cookie;
import com.google.appengine.repackaged.org.apache.commons.httpclient.Header;
import com.google.appengine.repackaged.org.apache.commons.httpclient.HttpMethodBase;
import com.google.appengine.tools.remoteapi.AppEngineClient;
import com.google.appengine.tools.remoteapi.RemoteApiOptions;
import java.io.IOException;
import java.net.URL;
import java.util.List;

class HostedAppEngineClient
extends AppEngineClient {
    private final URLFetchService urlFetch = URLFetchServiceFactory.getURLFetchService();

    HostedAppEngineClient(RemoteApiOptions options, List<Cookie> authCookies, String appId) {
        super(options, authCookies, appId);
    }

    private void addCookies(HTTPRequest req) {
        for (Cookie cookie : this.getAuthCookies()) {
            req.addHeader(new HTTPHeader("Cookie", String.format("%s=%s", cookie.getName(), cookie.getValue())));
        }
    }

    @Override
    AppEngineClient.Response get(String path) throws IOException {
        HTTPRequest req = new HTTPRequest(new URL(this.makeUrl(path)), HTTPMethod.GET);
        req.getFetchOptions().doNotFollowRedirects();
        for (String[] headerPair : this.getHeadersForGet()) {
            req.addHeader(new HTTPHeader(headerPair[0], headerPair[1]));
        }
        this.addCookies(req);
        HTTPResponse resp = this.urlFetch.fetch(req);
        return HostedAppEngineClient.createResponse(resp);
    }

    @Override
    AppEngineClient.Response post(String path, String mimeType, byte[] body) throws IOException {
        HTTPRequest req = new HTTPRequest(new URL(this.makeUrl(path)), HTTPMethod.POST);
        req.getFetchOptions().doNotFollowRedirects();
        for (String[] headerPair : this.getHeadersForPost(mimeType)) {
            req.addHeader(new HTTPHeader(headerPair[0], headerPair[1]));
        }
        this.addCookies(req);
        req.setPayload(body);
        HTTPResponse resp = this.urlFetch.fetch(req);
        return HostedAppEngineClient.createResponse(resp);
    }

    static AppEngineClient.Response createResponse(HTTPResponse resp) {
        byte[] body = resp.getContent();
        String charset = null;
        for (HTTPHeader header : resp.getHeaders()) {
            if (!header.getName().toLowerCase().equals("content-type")) continue;
            charset = DummyMethod.getCharset(header);
            break;
        }
        return new AppEngineClient.Response(resp.getResponseCode(), body, charset);
    }

    private static class DummyMethod
    extends HttpMethodBase {
        private static final DummyMethod INSTANCE = new DummyMethod();

        private DummyMethod() {
        }

        static String getCharset(HTTPHeader header) {
            Header apacheHeader = new Header(header.getName(), header.getValue());
            return INSTANCE.getContentCharSet(apacheHeader);
        }

        @Override
        public String getName() {
            return "dummy";
        }
    }
}

