/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

class LoggingConfigurationManager {
    @VisibleForTesting
    static final Logger LOGGER = Logger.getLogger(LoggingConfigurationManager.class.getName());
    public static final String LOGGING_CONFIG_FILE = "java.util.logging.config.file";
    private final Properties readProperties = new Properties();

    LoggingConfigurationManager() {
    }

    void read(Properties systemProperties, Map<String, String> userSystemProperties, File warDir, File externalResourceDir) {
        String sdkConfigFile;
        Properties sdkProperties;
        boolean shouldLogWarning;
        String userConfigFile = userSystemProperties.get(LOGGING_CONFIG_FILE);
        Properties userProperties = LoggingConfigurationManager.loadPropertiesFile(userConfigFile, warDir, shouldLogWarning = externalResourceDir == null);
        if (userProperties == null && externalResourceDir != null) {
            userProperties = LoggingConfigurationManager.loadPropertiesFile(userConfigFile, externalResourceDir, true);
        }
        if ((sdkProperties = LoggingConfigurationManager.loadPropertiesFile(sdkConfigFile = systemProperties.getProperty(LOGGING_CONFIG_FILE), warDir, true)) != null) {
            this.mergeProperties(sdkProperties);
        }
        if (userProperties != null) {
            this.mergeProperties(userProperties);
        }
    }

    @VisibleForTesting
    Properties getReadProperties() {
        Properties result = new Properties();
        result.putAll((Map<?, ?>)this.readProperties);
        return result;
    }

    void updateLoggingConfiguration() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.readProperties.store(out, null);
            LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(out.toByteArray()));
        }
        catch (IOException e) {
            LOGGER.logp(Level.WARNING, "com.google.appengine.tools.development.LoggingConfigurationManager", "updateLoggingConfiguration", "Unable to configure logging properties.", e);
        }
    }

    private void mergeProperties(Properties additional) {
        for (Map.Entry<Object, Object> entry : additional.entrySet()) {
            if (!(entry.getKey() instanceof String)) continue;
            String key = (String)entry.getKey();
            if (!(entry.getValue() instanceof String)) continue;
            String newValue = (String)entry.getValue();
            String oldValue = this.readProperties.getProperty(key);
            if (oldValue != null && key.endsWith(".level") && this.compareLevels(newValue, oldValue) <= 0) continue;
            this.readProperties.setProperty(key, newValue);
        }
    }

    @VisibleForTesting
    int compareLevels(String levelName1, String levelName2) {
        Integer level2;
        Integer level1;
        if (levelName1.equals(levelName2)) {
            return 0;
        }
        try {
            level1 = Level.parse(levelName1).intValue();
        }
        catch (IllegalArgumentException iae) {
            return -1;
        }
        try {
            level2 = Level.parse(levelName2).intValue();
        }
        catch (IllegalArgumentException iae) {
            return 1;
        }
        return level2.compareTo(level1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadPropertiesFile(String file, File appDir, boolean logWarning) {
        Object object;
        if (file == null) {
            return null;
        }
        File f = new File(file = file.replace('/', File.separatorChar));
        if (!f.isAbsolute()) {
            String string = String.valueOf(appDir);
            String string2 = File.separator;
            object = f.getPath();
            f = new File(new StringBuilder(String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(object).length()).append(string).append(string2).append((String)object).toString());
        }
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(f));
            Properties props = new Properties();
            props.load(inputStream);
            object = props;
            return object;
        }
        catch (IOException e) {
            if (logWarning) {
                String string = String.valueOf(f.getAbsolutePath());
                LOGGER.logp(Level.WARNING, "com.google.appengine.tools.development.LoggingConfigurationManager", "loadPropertiesFile", string.length() != 0 ? "Unable to load properties file, ".concat(string) : new String("Unable to load properties file, "), e);
            }
            object = null;
            return object;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.logp(Level.WARNING, "com.google.appengine.tools.development.LoggingConfigurationManager", "loadPropertiesFile", "Stream close failure", e);
                }
            }
        }
    }
}

