/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_Cursor;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.IndexValue;
import com.google.cloud.datastore.core.rep.PropertyPath;
import javax.annotation.Nullable;

@AutoValue
public abstract class Cursor {
    public static final Cursor EMPTY = new AutoValue_Cursor(Category.EMPTY, null, null, (ImmutableList<IndexValue>)ImmutableList.of(), (ImmutableList<PropertyPath>)ImmutableList.of(), false);
    public static final Cursor RAW_INDEX_KEY_FIRST = new AutoValue_Cursor(Category.RAW_INDEX, null, null, (ImmutableList<IndexValue>)ImmutableList.of(), (ImmutableList<PropertyPath>)ImmutableList.of(), false);

    public static Cursor after(EntityRef key, @Nullable ImmutableList<PropertyPath> propertyPaths, ImmutableList<IndexValue> indexValues) {
        return Cursor.create((EntityRef)Preconditions.checkNotNull((Object)key), propertyPaths, indexValues, false);
    }

    public static Cursor create(@Nullable EntityRef key, @Nullable ImmutableList<PropertyPath> propertyPaths, ImmutableList<IndexValue> indexValues, boolean before) {
        return new AutoValue_Cursor(Category.REGULAR, null, key, indexValues, propertyPaths, before);
    }

    public static Cursor createRawIndex(byte[] rawIndexKey, boolean before) {
        Preconditions.checkNotNull((Object)rawIndexKey);
        return new AutoValue_Cursor(Category.RAW_INDEX, rawIndexKey, null, (ImmutableList<IndexValue>)ImmutableList.of(), (ImmutableList<PropertyPath>)ImmutableList.of(), before);
    }

    protected abstract Category category();

    @Nullable
    public abstract byte[] rawIndexKey();

    @Nullable
    public abstract EntityRef key();

    public abstract ImmutableList<IndexValue> indexValues();

    @Nullable
    public abstract ImmutableList<PropertyPath> propertyPaths();

    public abstract boolean before();

    public boolean isRawIndex() {
        return this.category() == Category.RAW_INDEX;
    }

    public boolean isRegular() {
        return this.category() == Category.REGULAR;
    }

    protected static enum Category {
        EMPTY,
        RAW_INDEX,
        REGULAR;

    }
}

