// Copyright 2007 Google Inc. All rights reserved.

package com.google.appengine.api.datastore;

/**
 * {@code DatastoreFailureException} is thrown when any unknown error occurs while communicating
 * with the data store.
 *
 * <p>Clients should not attempt to retry after receiving this exception.
 *
 */
public class DatastoreFailureException extends RuntimeException {
  private static final long serialVersionUID = 1451732305516011801L;

  public DatastoreFailureException(String message) {
    super(message);
  }

  public DatastoreFailureException(String message, Throwable cause) {
    super(message, cause);
  }
}
