/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.IFn;
import clojure.lang.IHashEq;
import clojure.lang.IPending;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.Murmur3;
import clojure.lang.Obj;
import clojure.lang.PersistentList;
import clojure.lang.RT;
import clojure.lang.SeqIterator;
import clojure.lang.Sequential;
import clojure.lang.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public final class LazySeq
extends Obj
implements ISeq,
Sequential,
List,
IPending,
IHashEq {
    private IFn fn;
    private Object sv;
    private ISeq s;

    public LazySeq(IFn fn) {
        this.fn = fn;
    }

    private LazySeq(IPersistentMap meta, ISeq s) {
        super(meta);
        this.fn = null;
        this.s = s;
    }

    @Override
    public Obj withMeta(IPersistentMap meta) {
        return new LazySeq(meta, this.seq());
    }

    final synchronized Object sval() {
        if (this.fn != null) {
            this.sv = this.fn.invoke();
            this.fn = null;
        }
        if (this.sv != null) {
            return this.sv;
        }
        return this.s;
    }

    @Override
    public final synchronized ISeq seq() {
        this.sval();
        if (this.sv != null) {
            Object ls = this.sv;
            this.sv = null;
            while (ls instanceof LazySeq) {
                ls = ((LazySeq)ls).sval();
            }
            this.s = RT.seq(ls);
        }
        return this.s;
    }

    @Override
    public int count() {
        int c = 0;
        for (ISeq s = this.seq(); s != null; s = s.next()) {
            ++c;
        }
        return c;
    }

    @Override
    public Object first() {
        this.seq();
        if (this.s == null) {
            return null;
        }
        return this.s.first();
    }

    @Override
    public ISeq next() {
        this.seq();
        if (this.s == null) {
            return null;
        }
        return this.s.next();
    }

    @Override
    public ISeq more() {
        this.seq();
        if (this.s == null) {
            return PersistentList.EMPTY;
        }
        return this.s.more();
    }

    @Override
    public ISeq cons(Object o) {
        return RT.cons(o, this.seq());
    }

    @Override
    public IPersistentCollection empty() {
        return PersistentList.EMPTY;
    }

    @Override
    public boolean equiv(Object o) {
        ISeq s = this.seq();
        if (s != null) {
            return s.equiv(o);
        }
        return (o instanceof Sequential || o instanceof List) && RT.seq(o) == null;
    }

    @Override
    public int hashCode() {
        ISeq s = this.seq();
        if (s == null) {
            return 1;
        }
        return Util.hash(this.seq());
    }

    @Override
    public int hasheq() {
        return Murmur3.hashOrdered(this);
    }

    @Override
    public boolean equals(Object o) {
        ISeq s = this.seq();
        if (s != null) {
            return s.equals(o);
        }
        return (o instanceof Sequential || o instanceof List) && RT.seq(o) == null;
    }

    @Override
    public Object[] toArray() {
        return RT.seqToArray(this.seq());
    }

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object[] toArray(Object[] a) {
        return RT.seqToPassedArray(this.seq(), a);
    }

    @Override
    public int size() {
        return this.count();
    }

    @Override
    public boolean isEmpty() {
        return this.seq() == null;
    }

    @Override
    public boolean contains(Object o) {
        for (ISeq s = this.seq(); s != null; s = s.next()) {
            if (!Util.equiv(s.first(), o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator iterator() {
        return new SeqIterator(this);
    }

    private List reify() {
        return new ArrayList(this);
    }

    public List subList(int fromIndex, int toIndex) {
        return this.reify().subList(fromIndex, toIndex);
    }

    public Object set(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    public Object remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        ISeq s = this.seq();
        int i = 0;
        while (s != null) {
            if (Util.equiv(s.first(), o)) {
                return i;
            }
            s = s.next();
            ++i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.reify().lastIndexOf(o);
    }

    public ListIterator listIterator() {
        return this.reify().listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.reify().listIterator(index);
    }

    public Object get(int index) {
        return RT.nth(this, index);
    }

    public void add(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int index, Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized boolean isRealized() {
        return this.fn == null;
    }
}

