/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.beanutils.ConversionException;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class HiddenFieldCheck
extends Check {
    private FieldFrame mCurrentFrame;
    private RE mRegexp;
    private boolean mIgnoreSetter;
    private boolean mIgnoreConstructorParameter;

    public int[] getDefaultTokens() {
        return new int[]{10, 21, 14};
    }

    public int[] getAcceptableTokens() {
        return new int[]{10, 21};
    }

    public int[] getRequiredTokens() {
        return new int[]{14};
    }

    public void beginTree(DetailAST aRootAST) {
        this.mCurrentFrame = new FieldFrame(null, true);
    }

    public void visitToken(DetailAST aAST) {
        if (aAST.getType() == 14) {
            DetailAST classMods = aAST.findFirstToken(5);
            boolean isStaticInnerClass = classMods.branchContains(64);
            FieldFrame frame = new FieldFrame(this.mCurrentFrame, isStaticInnerClass);
            DetailAST objBlock = aAST.findFirstToken(6);
            for (DetailAST child = (DetailAST)objBlock.getFirstChild(); child != null; child = (DetailAST)child.getNextSibling()) {
                if (child.getType() != 10) continue;
                String name = child.findFirstToken(58).getText();
                DetailAST mods = child.findFirstToken(5);
                if (mods.branchContains(64)) {
                    frame.addStaticField(name);
                    continue;
                }
                frame.addInstanceField(name);
            }
            this.mCurrentFrame = frame;
        } else {
            this.processVariable(aAST);
        }
    }

    public void leaveToken(DetailAST aAST) {
        if (aAST.getType() == 14) {
            this.mCurrentFrame = this.mCurrentFrame.getParent();
        }
    }

    private void processVariable(DetailAST aAST) {
        DetailAST nameAST;
        String name;
        if (!(ScopeUtils.inInterfaceBlock(aAST) || !ScopeUtils.isLocalVariableDef(aAST) && aAST.getType() != 21 || !this.mCurrentFrame.containsStaticField(name = (nameAST = aAST.findFirstToken(58)).getText()) && (this.inStatic(aAST) || !this.mCurrentFrame.containsInstanceField(name)) || this.mRegexp != null && this.getRegexp().match(name) || this.isIgnoredSetterParam(aAST, name) || this.isIgnoredConstructorParam(aAST))) {
            this.log(nameAST, "hidden.field", (Object)name);
        }
    }

    private boolean inStatic(DetailAST aAST) {
        for (DetailAST parent = aAST.getParent(); parent != null; parent = parent.getParent()) {
            switch (parent.getType()) {
                case 12: {
                    return true;
                }
                case 9: {
                    DetailAST mods = parent.findFirstToken(5);
                    return mods.branchContains(64);
                }
            }
        }
        return false;
    }

    private boolean isIgnoredSetterParam(DetailAST aAST, String aName) {
        if (aAST.getType() != 21 || !this.mIgnoreSetter) {
            return false;
        }
        DetailAST parametersAST = aAST.getParent();
        if (parametersAST.getChildCount() != 1) {
            return false;
        }
        DetailAST methodAST = parametersAST.getParent();
        if (methodAST.getType() != 9) {
            return false;
        }
        String expectedName = "set" + aName.substring(0, 1).toUpperCase() + aName.substring(1);
        DetailAST methodNameAST = methodAST.findFirstToken(58);
        String methodName = methodNameAST.getText();
        if (!methodName.equals(expectedName)) {
            return false;
        }
        DetailAST typeAST = methodAST.findFirstToken(13);
        return typeAST.branchContains(49);
    }

    private boolean isIgnoredConstructorParam(DetailAST aAST) {
        if (aAST.getType() != 21 || !this.mIgnoreConstructorParameter) {
            return false;
        }
        DetailAST parametersAST = aAST.getParent();
        DetailAST constructorAST = parametersAST.getParent();
        return constructorAST.getType() == 8;
    }

    public void setIgnoreFormat(String aFormat) throws ConversionException {
        try {
            this.mRegexp = Utils.getRE(aFormat);
        }
        catch (RESyntaxException e) {
            throw new ConversionException("unable to parse " + aFormat, e);
        }
    }

    public void setIgnoreSetter(boolean aIgnoreSetter) {
        this.mIgnoreSetter = aIgnoreSetter;
    }

    public void setIgnoreConstructorParameter(boolean aIgnoreConstructorParameter) {
        this.mIgnoreConstructorParameter = aIgnoreConstructorParameter;
    }

    public RE getRegexp() {
        return this.mRegexp;
    }

    private static class FieldFrame {
        private boolean mStaticClass;
        private FieldFrame mParent;
        private Set mInstanceFields = new HashSet();
        private Set mStaticFields = new HashSet();

        public FieldFrame(FieldFrame aParent, boolean aStaticClass) {
            this.mParent = aParent;
            this.mStaticClass = aStaticClass;
        }

        public void addInstanceField(String aField) {
            this.mInstanceFields.add(aField);
        }

        public void addStaticField(String aField) {
            this.mStaticFields.add(aField);
        }

        public boolean containsInstanceField(String aField) {
            if (this.mInstanceFields.contains(aField)) {
                return true;
            }
            if (this.mStaticClass) {
                return false;
            }
            return this.mParent != null && this.mParent.containsInstanceField(aField);
        }

        public boolean containsStaticField(String aField) {
            if (this.mStaticFields.contains(aField)) {
                return true;
            }
            return this.mParent != null && this.mParent.containsStaticField(aField);
        }

        public FieldFrame getParent() {
            return this.mParent;
        }
    }
}

