/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.strings;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTAdditiveExpression;
import net.sourceforge.pmd.ast.ASTBlockStatement;
import net.sourceforge.pmd.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.ast.ASTFormalParameter;
import net.sourceforge.pmd.ast.ASTIfStatement;
import net.sourceforge.pmd.ast.ASTLiteral;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.ast.ASTSwitchLabel;
import net.sourceforge.pmd.ast.ASTSwitchStatement;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.rules.strings.InefficientStringBuffering;
import net.sourceforge.pmd.symboltable.NameOccurrence;

public class InsufficientStringBufferDeclaration
extends AbstractRule {
    private static final Set blockParents = new HashSet();
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTPrimaryExpression;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTSwitchLabel;

    public Object visit(ASTVariableDeclaratorId node, Object data) {
        if (!"StringBuffer".equals(node.getNameDeclaration().getTypeImage())) {
            return data;
        }
        SimpleNode rootNode = node;
        int anticipatedLength = 0;
        int constructorLength = 16;
        constructorLength = this.getConstructorLength(node, constructorLength);
        anticipatedLength = this.getInitialLength(node);
        List usage = node.getUsages();
        HashMap blocks = new HashMap();
        for (int ix = 0; ix < usage.size(); ++ix) {
            NameOccurrence no = (NameOccurrence)usage.get(ix);
            SimpleNode n = no.getLocation();
            if (!InefficientStringBuffering.isInStringBufferOperation(n, 3, "append")) {
                if (!no.isOnLeftHandSide() && !InefficientStringBuffering.isInStringBufferOperation(n, 3, "setLength")) continue;
                if (constructorLength != -1 && anticipatedLength > constructorLength) {
                    Object[] param = new String[]{String.valueOf(constructorLength), String.valueOf(anticipatedLength += this.processBlocks(blocks))};
                    this.addViolation(data, (Node)rootNode, param);
                }
                constructorLength = this.getConstructorLength(n, constructorLength);
                rootNode = n;
                anticipatedLength = this.getInitialLength(node);
            }
            ASTPrimaryExpression s = (ASTPrimaryExpression)n.getFirstParentOfType(class$net$sourceforge$pmd$ast$ASTPrimaryExpression == null ? InsufficientStringBufferDeclaration.class$("net.sourceforge.pmd.ast.ASTPrimaryExpression") : class$net$sourceforge$pmd$ast$ASTPrimaryExpression);
            int numChildren = s.jjtGetNumChildren();
            for (int jx = 0; jx < numChildren; ++jx) {
                SimpleNode sn = (SimpleNode)s.jjtGetChild(jx);
                if (!(sn instanceof ASTPrimarySuffix) || sn.getImage() != null) continue;
                int thisSize = 0;
                Node block = this.getFirstParentBlock(sn);
                thisSize = this.isAdditive(sn) ? this.processAdditive(sn) : this.processNode(sn);
                if (block != null) {
                    this.storeBlockStatistics(blocks, thisSize, block);
                    continue;
                }
                anticipatedLength += thisSize;
            }
        }
        if (constructorLength != -1 && (anticipatedLength += this.processBlocks(blocks)) > constructorLength) {
            Object[] param = new String[]{String.valueOf(constructorLength), String.valueOf(anticipatedLength)};
            this.addViolation(data, (Node)rootNode, param);
        }
        return data;
    }

    private void storeBlockStatistics(Map blocks, int thisSize, Node block) {
        Integer x;
        HashMap<Node, Integer> thisBranch;
        Node statement = block.jjtGetParent();
        if (ASTIfStatement.class.equals(block.jjtGetParent().getClass())) {
            Node possibleStatement = ((SimpleNode)statement).getFirstParentOfType(ASTIfStatement.class);
            while (possibleStatement != null && possibleStatement.getClass().equals(class$net$sourceforge$pmd$ast$ASTIfStatement == null ? InsufficientStringBufferDeclaration.class$("net.sourceforge.pmd.ast.ASTIfStatement") : class$net$sourceforge$pmd$ast$ASTIfStatement)) {
                statement = possibleStatement;
                possibleStatement = ((SimpleNode)possibleStatement).getFirstParentOfType(class$net$sourceforge$pmd$ast$ASTIfStatement == null ? InsufficientStringBufferDeclaration.class$("net.sourceforge.pmd.ast.ASTIfStatement") : class$net$sourceforge$pmd$ast$ASTIfStatement);
            }
        }
        if ((thisBranch = (HashMap<Node, Integer>)blocks.get(statement)) == null) {
            thisBranch = new HashMap<Node, Integer>();
            blocks.put(statement, thisBranch);
        }
        if ((x = (Integer)thisBranch.get(block)) != null) {
            thisSize += x.intValue();
        }
        thisBranch.put(statement, new Integer(thisSize));
    }

    private int processBlocks(Map blocks) {
        int anticipatedLength = 0;
        int ifLength = 0;
        Iterator iter = blocks.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ifLength = 0;
            Iterator iter2 = ((Map)entry.getValue()).entrySet().iterator();
            while (iter2.hasNext()) {
                Map.Entry entry2 = iter2.next();
                Integer value = (Integer)entry2.getValue();
                ifLength = Math.max(ifLength, value);
            }
            anticipatedLength += ifLength;
        }
        return anticipatedLength;
    }

    private int processAdditive(SimpleNode sn) {
        ASTAdditiveExpression additive = (ASTAdditiveExpression)sn.getFirstChildOfType(ASTAdditiveExpression.class);
        if (additive == null) {
            return 0;
        }
        int anticipatedLength = 0;
        for (int ix = 0; ix < additive.jjtGetNumChildren(); ++ix) {
            SimpleNode childNode = (SimpleNode)additive.jjtGetChild(ix);
            ASTLiteral literal = (ASTLiteral)childNode.getFirstChildOfType(class$net$sourceforge$pmd$ast$ASTLiteral == null ? InsufficientStringBufferDeclaration.class$("net.sourceforge.pmd.ast.ASTLiteral") : class$net$sourceforge$pmd$ast$ASTLiteral);
            if (literal == null || literal.getImage() == null) continue;
            anticipatedLength += literal.getImage().length() - 2;
        }
        return anticipatedLength;
    }

    private static final boolean isLiteral(String str) {
        if (str.length() == 0) {
            return false;
        }
        char c = str.charAt(0);
        return c == '\"' || c == '\'';
    }

    private int processNode(SimpleNode sn) {
        int anticipatedLength = 0;
        ASTPrimaryPrefix xn = (ASTPrimaryPrefix)sn.getFirstChildOfType(ASTPrimaryPrefix.class);
        if (xn.jjtGetNumChildren() != 0 && xn.jjtGetChild(0).getClass().equals(ASTLiteral.class)) {
            String str = ((SimpleNode)xn.jjtGetChild(0)).getImage();
            anticipatedLength = InsufficientStringBufferDeclaration.isLiteral(str) ? (anticipatedLength += str.length() - 2) : (str.startsWith("0x") ? ++anticipatedLength : (anticipatedLength += str.length()));
        }
        return anticipatedLength;
    }

    private int getConstructorLength(SimpleNode node, int constructorLength) {
        List literal;
        int iConstructorLength = constructorLength;
        SimpleNode block = (SimpleNode)node.getFirstParentOfType(ASTBlockStatement.class);
        if (block == null) {
            block = (ASTFieldDeclaration)node.getFirstParentOfType(ASTFieldDeclaration.class);
        }
        if (block == null && (block = (ASTFormalParameter)node.getFirstParentOfType(ASTFormalParameter.class)) != null) {
            iConstructorLength = -1;
        }
        if ((literal = block.findChildrenOfType(ASTLiteral.class)).isEmpty()) {
            List name = block.findChildrenOfType(ASTName.class);
            if (!name.isEmpty()) {
                iConstructorLength = -1;
            }
        } else {
            String str;
            iConstructorLength = literal.size() == 1 ? ((str = ((SimpleNode)literal.get(0)).getImage()) == null ? 0 : (InsufficientStringBufferDeclaration.isLiteral(str) ? 14 + str.length() : Integer.parseInt(str))) : -1;
        }
        if (iConstructorLength == 0) {
            iConstructorLength = 16;
        }
        return iConstructorLength;
    }

    private int getInitialLength(SimpleNode node) {
        String str;
        List literal;
        SimpleNode block = (SimpleNode)node.getFirstParentOfType(ASTBlockStatement.class);
        if (block == null && (block = (ASTFieldDeclaration)node.getFirstParentOfType(ASTFieldDeclaration.class)) == null) {
            block = (ASTFormalParameter)node.getFirstParentOfType(ASTFormalParameter.class);
        }
        if ((literal = block.findChildrenOfType(ASTLiteral.class)).size() == 1 && (str = ((SimpleNode)literal.get(0)).getImage()) != null && InsufficientStringBufferDeclaration.isLiteral(str)) {
            return str.length() - 2;
        }
        return 0;
    }

    private boolean isAdditive(SimpleNode n) {
        return n.findChildrenOfType(ASTAdditiveExpression.class).size() >= 1;
    }

    private Node getFirstParentBlock(Node node) {
        Node parentNode;
        Node lastNode = node;
        for (parentNode = node.jjtGetParent(); parentNode != null && !blockParents.contains(parentNode.getClass()); parentNode = parentNode.jjtGetParent()) {
            lastNode = parentNode;
        }
        if (parentNode != null && ASTIfStatement.class.equals(parentNode.getClass())) {
            parentNode = lastNode;
        } else if (parentNode != null && parentNode.getClass().equals(ASTSwitchStatement.class)) {
            parentNode = InsufficientStringBufferDeclaration.getSwitchParent(parentNode, lastNode);
        }
        return parentNode;
    }

    private static Node getSwitchParent(Node parentNode, Node lastNode) {
        int allChildren = parentNode.jjtGetNumChildren();
        ASTSwitchLabel label = null;
        for (int ix = 0; ix < allChildren; ++ix) {
            Node n = parentNode.jjtGetChild(ix);
            if (n.getClass().equals(class$net$sourceforge$pmd$ast$ASTSwitchLabel == null ? InsufficientStringBufferDeclaration.class$("net.sourceforge.pmd.ast.ASTSwitchLabel") : class$net$sourceforge$pmd$ast$ASTSwitchLabel)) {
                label = (ASTSwitchLabel)n;
                continue;
            }
            if (!n.equals(lastNode)) continue;
            parentNode = label;
            break;
        }
        return parentNode;
    }

    static {
        blockParents.add(ASTIfStatement.class);
        blockParents.add(ASTSwitchStatement.class);
    }
}

