/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.symboltable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.symboltable.AbstractScope;
import net.sourceforge.pmd.symboltable.ClassNameDeclaration;
import net.sourceforge.pmd.symboltable.ImageFinderFunction;
import net.sourceforge.pmd.symboltable.MethodNameDeclaration;
import net.sourceforge.pmd.symboltable.NameDeclaration;
import net.sourceforge.pmd.symboltable.NameOccurrence;
import net.sourceforge.pmd.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.symboltable.VariableUsageFinderFunction;
import net.sourceforge.pmd.util.Applier;

public class ClassScope
extends AbstractScope {
    protected Map classNames = new HashMap();
    protected Map methodNames = new HashMap();
    protected Map variableNames = new HashMap();
    private static int anonymousInnerClassCounter = 1;
    private String className;

    public ClassScope(String className) {
        this.className = className;
        anonymousInnerClassCounter = 1;
    }

    public ClassScope() {
        this.className = "Anonymous$" + anonymousInnerClassCounter;
        ++anonymousInnerClassCounter;
    }

    public void addDeclaration(VariableNameDeclaration variableDecl) {
        if (this.variableNames.containsKey(variableDecl)) {
            throw new RuntimeException(variableDecl + " is already in the symbol table");
        }
        this.variableNames.put(variableDecl, new ArrayList());
    }

    public NameDeclaration addVariableNameOccurrence(NameOccurrence occurrence) {
        List nameOccurrences;
        NameDeclaration decl = this.findVariableHere(occurrence);
        if (decl != null && occurrence.isMethodOrConstructorInvocation()) {
            List nameOccurrences2 = (List)this.methodNames.get(decl);
            if (nameOccurrences2 != null) {
                nameOccurrences2.add(occurrence);
                SimpleNode n = occurrence.getLocation();
                if (n instanceof ASTName) {
                    ((ASTName)n).setNameDeclaration(decl);
                }
            }
        } else if (decl != null && !occurrence.isThisOrSuper() && (nameOccurrences = (List)this.variableNames.get(decl)) != null) {
            nameOccurrences.add(occurrence);
            SimpleNode n = occurrence.getLocation();
            if (n instanceof ASTName) {
                ((ASTName)n).setNameDeclaration(decl);
            }
        }
        return decl;
    }

    public Map getVariableDeclarations() {
        VariableUsageFinderFunction f = new VariableUsageFinderFunction(this.variableNames);
        Applier.apply(f, this.variableNames.keySet().iterator());
        return f.getUsed();
    }

    public Map getMethodDeclarations() {
        return this.methodNames;
    }

    public Map getClassDeclarations() {
        return this.classNames;
    }

    public ClassScope getEnclosingClassScope() {
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    public void addDeclaration(MethodNameDeclaration decl) {
        this.methodNames.put(decl, new ArrayList());
    }

    public void addDeclaration(ClassNameDeclaration decl) {
        this.classNames.put(decl, new ArrayList());
    }

    protected NameDeclaration findVariableHere(NameOccurrence occurrence) {
        if (occurrence.isThisOrSuper() || occurrence.getImage().equals(this.className)) {
            if (this.variableNames.isEmpty() && this.methodNames.isEmpty()) {
                return null;
            }
            if (!this.variableNames.isEmpty()) {
                return (NameDeclaration)this.variableNames.keySet().iterator().next();
            }
            return (NameDeclaration)this.methodNames.keySet().iterator().next();
        }
        if (occurrence.isMethodOrConstructorInvocation()) {
            Iterator i = this.methodNames.keySet().iterator();
            while (i.hasNext()) {
                int args;
                MethodNameDeclaration mnd = (MethodNameDeclaration)i.next();
                if (!mnd.getImage().equals(occurrence.getImage()) || (args = occurrence.getArgumentCount()) != mnd.getParameterCount()) continue;
                return mnd;
            }
            return null;
        }
        ArrayList<String> images = new ArrayList<String>();
        images.add(occurrence.getImage());
        if (occurrence.getImage().startsWith(this.className)) {
            images.add(this.clipClassName(occurrence.getImage()));
        }
        ImageFinderFunction finder = new ImageFinderFunction(images);
        Applier.apply(finder, this.variableNames.keySet().iterator());
        return finder.getDecl();
    }

    public String toString() {
        String res = "ClassScope (" + this.className + "): ";
        if (!this.classNames.isEmpty()) {
            res = res + "(" + this.glomNames(this.classNames.keySet().iterator()) + ")";
        }
        if (!this.methodNames.isEmpty()) {
            Iterator i = this.methodNames.keySet().iterator();
            while (i.hasNext()) {
                MethodNameDeclaration mnd = (MethodNameDeclaration)i.next();
                res = res + mnd.toString();
                int usages = ((List)this.methodNames.get(mnd)).size();
                res = res + "(begins at line " + mnd.getNode().getBeginLine() + ", " + usages + " usages)";
                res = res + ",";
            }
        }
        if (!this.variableNames.isEmpty()) {
            res = res + "(" + this.glomNames(this.variableNames.keySet().iterator()) + ")";
        }
        return res;
    }

    private String clipClassName(String in) {
        return in.substring(in.indexOf(46) + 1);
    }
}

