/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.pmd.util.ClassUtil;

public class TypeMap {
    private Map typesByName;

    public TypeMap(int initialSize) {
        this.typesByName = new HashMap(initialSize);
    }

    public TypeMap(Class[] types) {
        this(types.length);
        this.add(types);
    }

    public void add(Class type) {
        this.typesByName.put(type.getName(), type);
        this.typesByName.put(ClassUtil.withoutPackageName(type.getName()), type);
    }

    public boolean contains(Class type) {
        return this.typesByName.containsValue(type);
    }

    public boolean contains(String typeName) {
        return this.typesByName.containsKey(typeName);
    }

    public Class typeFor(String typeName) {
        return (Class)this.typesByName.get(typeName);
    }

    public void add(Class[] types) {
        for (int i = 0; i < types.length; ++i) {
            this.add(types[i]);
        }
    }
}

