/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.unicodeconvert.converter;

import java.io.File;
import net.sourceforge.unicodeconvert.converter.Converter;

public class ViqrConverter
extends Converter {
    final String[] VIQR_char = new String[]{"y~", "Y~", "y?", "Y?", "y.", "Y.", "y`", "Y`", "u+.", "U+.", "u+~", "U+~", "u+?", "U+?", "u+`", "U+`", "u+'", "U+'", "u?", "U?", "u.", "U.", "o+.", "O+.", "o+~", "O+~", "o+?", "O+?", "o+`", "O+`", "o+'", "O+'", "o^.", "O^.", "o^~", "O^~", "o^?", "O^?", "o^`", "O^`", "o^'", "O^'", "o?", "O?", "o.", "O.", "i.", "I.", "i?", "I?", "e^.", "E^.", "e^~", "E^~", "e^?", "E^?", "e^`", "E^`", "e^'", "E^'", "e~", "E~", "e?", "E?", "e.", "E.", "a(.", "A(.", "a(~", "A(~", "a(?", "A(?", "a(`", "A(`", "a('", "A('", "a^.", "A^.", "a^~", "A^~", "a^?", "A^?", "a^`", "A^`", "a^'", "A^'", "a?", "A?", "a.", "A.", "u+", "U+", "o+", "O+", "u~", "U~", "i~", "I~", "dd", "a(", "A(", "y'", "u'", "u`", "o~", "o^", "o'", "o`", "i'", "i`", "e^", "e'", "e`", "a~", "a^", "a'", "a`", "Y'", "U'", "U`", "O~", "O^", "O'", "O`", "DD", "I'", "I`", "E^", "E'", "E`", "A~", "A^", "A'", "A`"};
    final String[] Unicode_char = new String[]{"\u1ef9", "\u1ef8", "\u1ef7", "\u1ef6", "\u1ef5", "\u1ef4", "\u1ef3", "\u1ef2", "\u1ef1", "\u1ef0", "\u1eef", "\u1eee", "\u1eed", "\u1eec", "\u1eeb", "\u1eea", "\u1ee9", "\u1ee8", "\u1ee7", "\u1ee6", "\u1ee5", "\u1ee4", "\u1ee3", "\u1ee2", "\u1ee1", "\u1ee0", "\u1edf", "\u1ede", "\u1edd", "\u1edc", "\u1edb", "\u1eda", "\u1ed9", "\u1ed8", "\u1ed7", "\u1ed6", "\u1ed5", "\u1ed4", "\u1ed3", "\u1ed2", "\u1ed1", "\u1ed0", "\u1ecf", "\u1ece", "\u1ecd", "\u1ecc", "\u1ecb", "\u1eca", "\u1ec9", "\u1ec8", "\u1ec7", "\u1ec6", "\u1ec5", "\u1ec4", "\u1ec3", "\u1ec2", "\u1ec1", "\u1ec0", "\u1ebf", "\u1ebe", "\u1ebd", "\u1ebc", "\u1ebb", "\u1eba", "\u1eb9", "\u1eb8", "\u1eb7", "\u1eb6", "\u1eb5", "\u1eb4", "\u1eb3", "\u1eb2", "\u1eb1", "\u1eb0", "\u1eaf", "\u1eae", "\u1ead", "\u1eac", "\u1eab", "\u1eaa", "\u1ea9", "\u1ea8", "\u1ea7", "\u1ea6", "\u1ea5", "\u1ea4", "\u1ea3", "\u1ea2", "\u1ea1", "\u1ea0", "\u01b0", "\u01af", "\u01a1", "\u01a0", "\u0169", "\u0168", "\u0129", "\u0128", "\u0111", "\u0103", "\u0102", "\u00fd", "\u00fa", "\u00f9", "\u00f5", "\u00f4", "\u00f3", "\u00f2", "\u00ed", "\u00ec", "\u00ea", "\u00e9", "\u00e8", "\u00e3", "\u00e2", "\u00e1", "\u00e0", "\u00dd", "\u00da", "\u00d9", "\u00d5", "\u00d4", "\u00d3", "\u00d2", "\u0110", "\u00cd", "\u00cc", "\u00ca", "\u00c9", "\u00c8", "\u00c3", "\u00c2", "\u00c1", "\u00c0"};

    @Override
    public String convert(File file) {
        String string = this.readToStr(file, "Cp1252");
        if (this.isHTML(file)) {
            string = this.convertHTML(string);
        }
        string = string.replaceAll("(?i)(?<=[uo])\\*", "+").replaceAll("(?i)(d)([-d])", "$1$1").replace('\u0092', '\'').replaceAll("(?i)(?<=(?:(?:[aeiouy][`?~'.^(+]{1,2})|[ae])[aeiouy])(?=[?'.](?:\\s|$|\\p{Punct}))", "\\\\");
        string = this.replaceString(string, this.VIQR_char, this.Unicode_char);
        string = string.replaceAll("(?i)\\\\(?=[-.?'\\\\])", "");
        string = this.cleanupURL(string);
        if (this.isRTF(file)) {
            string = this.convertToRTF(string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String cleanupURL(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        String[] stringArray = new String[]{"://", "mailto:"};
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                int n;
                int n2 = 0;
                while ((n = stringBuffer.indexOf(stringArray[i], n2)) != -1) {
                    char c;
                    n2 = n + stringArray[i].length();
                    while ((c = stringBuffer.charAt(n2)) != ' ' && c != '\n') {
                        if (c >= '\u1ea0') {
                            String string2 = null;
                            switch (c) {
                                case '\u1ea1': {
                                    string2 = "a.";
                                    break;
                                }
                                case '\u1eb9': {
                                    string2 = "e.";
                                    break;
                                }
                                case '\u1ecb': {
                                    string2 = "i.";
                                    break;
                                }
                                case '\u1ecd': {
                                    string2 = "o.";
                                    break;
                                }
                                case '\u1ee5': {
                                    string2 = "u.";
                                    break;
                                }
                                case '\u1ef5': {
                                    string2 = "y.";
                                    break;
                                }
                                case '\u1ea0': {
                                    string2 = "A.";
                                    break;
                                }
                                case '\u1eb8': {
                                    string2 = "E.";
                                    break;
                                }
                                case '\u1eca': {
                                    string2 = "I.";
                                    break;
                                }
                                case '\u1ecc': {
                                    string2 = "O.";
                                    break;
                                }
                                case '\u1ee4': {
                                    string2 = "U.";
                                    break;
                                }
                                case '\u1ef4': {
                                    string2 = "Y.";
                                    break;
                                }
                            }
                            if (string2 != null) {
                                stringBuffer.replace(n2, n2 + 1, string2);
                                ++n2;
                            }
                        }
                        ++n2;
                    }
                }
                continue;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                continue;
            }
            finally {
                string = stringBuffer.toString();
            }
        }
        return string;
    }
}

