/**
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
package org.apache.airavata.api;

import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;

import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.server.AbstractNonblockingServer.*;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.EnumMap;
import java.util.Set;
import java.util.HashSet;
import java.util.EnumSet;
import java.util.Collections;
import java.util.BitSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings({"cast", "rawtypes", "serial", "unchecked"})
@Generated(value = "Autogenerated by Thrift Compiler (0.9.3)")
public class Airavata {

  public interface Iface {

    /**
     * Fetch Apache Airavata API version
     * 
     * 
     * @param authzToken
     */
    public String getAPIVersion(org.apache.airavata.model.security.AuthzToken authzToken) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Verify if User Exists within Airavata.
     * 
     * @param gatewayId
     * 
     *  @param userName
     * 
     * @return true/false
     * 
     * 
     * 
     * @param authzToken
     * @param gatewayId
     * @param userName
     */
    public boolean isUserExists(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String userName) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Register a Gateway with Airavata.
     * 
     * @param gateway
     *    The gateway data model.
     * 
     * @return gatewayId
     *   Th unique identifier of the  newly registered gateway.
     * 
     * 
     * 
     * @param authzToken
     * @param gateway
     */
    public String addGateway(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.workspace.Gateway gateway) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Get all users in the gateway
     * 
     * @param gatewayId
     *    The gateway data model.
     * 
     * @return users
     *   list of usernames of the users in the gateway
     * 
     * 
     * 
     * @param authzToken
     * @param gatewayId
     */
    public List<String> getAllUsersInGateway(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Update previously registered Gateway metadata.
     * 
     * @param gatewayId
     *    The gateway Id of the Gateway which require an update.
     * 
     * @return gateway
     *    Modified gateway obejct.
     * 
     * @exception AiravataClientException
     * 
     * 
     * 
     * @param authzToken
     * @param gatewayId
     * @param updatedGateway
     */
    public boolean updateGateway(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.workspace.Gateway updatedGateway) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Get Gateway details by providing gatewayId
     * 
     * @param gatewayId
     *    The gateway Id of the Gateway.
     * 
     * @return gateway
     *    Gateway obejct.
     * 
     * 
     * 
     * @param authzToken
     * @param gatewayId
     */
    public org.apache.airavata.model.workspace.Gateway getGateway(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Delete a Gateway
     * 
     * @param gatewayId
     *    The gateway Id of the Gateway to be deleted.
     * 
     * @return boolean
     *    Boolean identifier for the success or failure of the deletion operation.
     * 
     * 
     * 
     * @param authzToken
     * @param gatewayId
     */
    public boolean deleteGateway(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Get All the Gateways Connected to Airavata.
     * 
     * 
     * @param authzToken
     */
    public List<org.apache.airavata.model.workspace.Gateway> getAllGateways(org.apache.airavata.model.security.AuthzToken authzToken) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Check for the Existance of a Gateway within Airavata
     * 
     * @param gatewayId
     *   Provide the gatewayId of the gateway you want to check the existancy
     * 
     * @return boolean
     *   Boolean idetifier for the existance or non-existane of the gatewayId
     * 
     * @return gatewayId
     *   return the gatewayId of the existing gateway.
     * 
     * 
     * 
     * @param authzToken
     * @param gatewayId
     */
    public boolean isGatewayExist(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     *   * API methods to retrieve notifications
     * *
     * 
     * @param authzToken
     * @param notification
     */
    public String createNotification(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.workspace.Notification notification) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    public boolean updateNotification(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.workspace.Notification notification) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    public boolean deleteNotification(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String notificationId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    public org.apache.airavata.model.workspace.Notification getNotification(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String notificationId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    public List<org.apache.airavata.model.workspace.Notification> getAllNotifications(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Generate and Register SSH Key Pair with Airavata Credential Store.
     * 
     * @param gatewayId
     *    The identifier for the requested Gateway.
     * 
     * @param userName
     *    The User for which the credential should be registered. For community accounts, this user is the name of the
     *    community user name. For computational resources, this user name need not be the same user name on resoruces.
     * 
     * @param description
     *    The description field for a credential type, all type of credential can have a description.
     * 
     * @param credentialOwnerType
     *    The type of owner of this credential. Two possible values: GATEWAY (default) and USER
     * 
     * @return airavataCredStoreToken
     *   An SSH Key pair is generated and stored in the credential store and associated with users or community account
     *   belonging to a Gateway.
     * 
     * 
     * 
     * @param authzToken
     * @param gatewayId
     * @param userName
     * @param description
     * @param credentialOwnerType
     */
    public String generateAndRegisterSSHKeys(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String userName, String description, org.apache.airavata.model.credential.store.CredentialOwnerType credentialOwnerType) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.thrift.TException;

    /**
     * Generate and Register Username PWD Pair with Airavata Credential Store.
     * 
     * @param gatewayId
     *    The identifier for the requested Gateway.
     * 
     * @param portalUserName
     *    The User for which the credential should be registered. For community accounts, this user is the name of the
     *    community user name. For computational resources, this user name need not be the same user name on resoruces.
     * 
     * @param loginUserName
     * 
     * @param password
     * 
     * @return airavataCredStoreToken
     *   An SSH Key pair is generated and stored in the credential store and associated with users or community account
     *   belonging to a Gateway.
     * 
     * 
     * 
     * @param authzToken
     * @param gatewayId
     * @param portalUserName
     * @param loginUserName
     * @param password
     * @param description
     */
    public String registerPwdCredential(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String portalUserName, String loginUserName, String password, String description) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.thrift.TException;

    /**
     * Get a Public Key by Providing the Token
     * 
     * @param CredStoreToken
     *    Credential Store Token which you want to find the Public Key for.
     * 
     * @param gatewayId
     *    This is the unique identifier of your gateway where the token and public key was generated from.
     * 
     * @return publicKey
     * 
     * 
     * 
     * @param authzToken
     * @param airavataCredStoreToken
     * @param gatewayId
     */
    public String getSSHPubKey(org.apache.airavata.model.security.AuthzToken authzToken, String airavataCredStoreToken, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.thrift.TException;

    /**
     * 
     * Get all Public Keys of the Gateway
     * 
     * @param CredStoreToken
     *    Credential Store Token which you want to find the Public Key for.
     * 
     * @param gatewayId
     *    This is the unique identifier of your gateway where the token and public key was generated from.
     * 
     * @return publicKey
     * 
     * 
     * 
     * @param authzToken
     * @param gatewayId
     */
    public Map<String,String> getAllGatewaySSHPubKeys(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.thrift.TException;

    /**
     * 
     * Get all Credential summaries for the Gateway
     * 
     * @param CredStoreToken
     *    Credential Store Token which you want to find the Public Key for.
     * 
     * @param credential_store_data_models.SummaryType
     *    Summary type : SSH,PASSWD or CERT
     * 
     * @param gatewayId
     *    This is the unique identifier of your gateway where the token and public key was generated from.
     * 
     * @return List of Credential Summary Objects
     * 
     * 
     * 
     * @param authzToken
     * @param type
     * @param gatewayId
     */
    public List<org.apache.airavata.model.credential.store.CredentialSummary> getAllCredentialSummaryForGateway(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.credential.store.SummaryType type, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.thrift.TException;

    /**
     * 
     * Get all Credential summaries for user in a Gateway
     * 
     * @param CredStoreToken
     *    Credential Store Token which you want to find the Public Key for.
     * 
     * @param credential_store_data_models.SummaryType
     *    Summary type : SSH,PASSWD or CERT
     * 
     * @param gatewayId
     *    This is the unique identifier of your gateway where the token and public key was generated from.
     * 
     * @param userId
     *    This is the unique identifier of user whose public keys are to be fetched.
     * 
     * @return CredentialSummary
     * 
     * 
     * 
     * @param authzToken
     * @param type
     * @param gatewayId
     * @param userId
     */
    public List<org.apache.airavata.model.credential.store.CredentialSummary> getAllCredentialSummaryForUsersInGateway(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.credential.store.SummaryType type, String gatewayId, String userId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.thrift.TException;

    public Map<String,String> getAllGatewayPWDCredentials(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.thrift.TException;

    /**
     * 
     * Delete a Gateway
     * 
     * @param gatewayId
     *    The gateway Id of the Gateway to be deleted.
     * 
     * @return boolean
     *    Boolean identifier for the success or failure of the deletion operation.
     * 
     * 
     * 
     * @param authzToken
     * @param airavataCredStoreToken
     * @param gatewayId
     */
    public boolean deleteSSHPubKey(org.apache.airavata.model.security.AuthzToken authzToken, String airavataCredStoreToken, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.thrift.TException;

    public boolean deletePWDCredential(org.apache.airavata.model.security.AuthzToken authzToken, String airavataCredStoreToken, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.thrift.TException;

    /**
     * 
     * Creates a Project with basic metadata.
     *    A Project is a container of experiments.
     * 
     * @param gatewayId
     *    The identifier for the requested gateway.
     * 
     * @param Project
     *    The Project Object described in the workspace_model.
     * 
     * 
     * 
     * @param authzToken
     * @param gatewayId
     * @param project
     */
    public String createProject(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.workspace.Project project) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Update an Existing Project
     * 
     * @param projectId
     *    The projectId of the project needed an update.
     * 
     * @return void
     *    Currently this does not return any value.
     * 
     * 
     * 
     * @param authzToken
     * @param projectId
     * @param updatedProject
     */
    public void updateProject(org.apache.airavata.model.security.AuthzToken authzToken, String projectId, org.apache.airavata.model.workspace.Project updatedProject) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Get a Project by ID
     *    This method is to obtain a project by providing a projectId.
     * 
     * @param projectId
     *    projectId of the project you require.
     * 
     * @return project
     *    project data model will be returned.
     * 
     * 
     * 
     * @param authzToken
     * @param projectId
     */
    public org.apache.airavata.model.workspace.Project getProject(org.apache.airavata.model.security.AuthzToken authzToken, String projectId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Delete a Project
     *    This method is used to delete an existing Project.
     * 
     * @param projectId
     *    projectId of the project you want to delete.
     * 
     * @return boolean
     *    Boolean identifier for the success or failure of the deletion operation.
     * 
     *    NOTE: This method is not used within gateways connected with Airavata.
     * 
     * 
     * 
     * @param authzToken
     * @param projectId
     */
    public boolean deleteProject(org.apache.airavata.model.security.AuthzToken authzToken, String projectId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Get All User Projects
     * Get all Project for the user with pagination. Results will be ordered based on creation time DESC.
     * 
     * @param gatewayId
     *    The identifier for the requested gateway.
     * 
     * @param userName
     *    The identifier of the user.
     * 
     * @param limit
     *    The amount results to be fetched.
     * 
     * @param offset
     *    The starting point of the results to be fetched.
     * 
     * 
     * 
     * @param authzToken
     * @param gatewayId
     * @param userName
     * @param limit
     * @param offset
     */
    public List<org.apache.airavata.model.workspace.Project> getUserProjects(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String userName, int limit, int offset) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Search User Projects
     * Search and get all Projects for user by project description or/and project name  with pagination.
     * Results will be ordered based on creation time DESC.
     * 
     * @param gatewayId
     *    The unique identifier of the gateway making the request.
     * 
     * @param userName
     *    The identifier of the user.
     * 
     * @param filters
     *    Map of multiple filter criteria. Currenlt search filters includes Project Name and Project Description
     * 
     * @param limit
     *    The amount results to be fetched.
     * 
     * @param offset
     *    The starting point of the results to be fetched.
     * 
     * 
     * 
     * @param authzToken
     * @param gatewayId
     * @param userName
     * @param filters
     * @param limit
     * @param offset
     */
    public List<org.apache.airavata.model.workspace.Project> searchProjects(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String userName, Map<org.apache.airavata.model.experiment.ProjectSearchFields,String> filters, int limit, int offset) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Search Experiments.
     * Search Experiments by using multiple filter criteria with pagination. Results will be sorted based on creation time DESC.
     * 
     * @param gatewayId
     *       Identifier of the requested gateway.
     * 
     * @param userName
     *       Username of the user requesting the search function.
     * 
     * @param filters
     *       Map of multiple filter criteria. Currenlt search filters includes Experiment Name, Description, Application, etc....
     * 
     * @param limit
     *       Amount of results to be fetched.
     * 
     * @param offset
     *       The starting point of the results to be fetched.
     * 
     * @return ExperimentSummaryModel
     *    List of experiments for the given search filter. Here only the Experiment summary will be returned.
     * 
     * 
     * 
     * @param authzToken
     * @param gatewayId
     * @param userName
     * @param filters
     * @param limit
     * @param offset
     */
    public List<org.apache.airavata.model.experiment.ExperimentSummaryModel> searchExperiments(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String userName, Map<org.apache.airavata.model.experiment.ExperimentSearchFields,String> filters, int limit, int offset) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Get Experiment Statistics
     * Get Experiment Statisitics for a given gateway for a specific time period. This feature is available only for admins of a particular gateway. Gateway admin access is managed by the user roles.
     * 
     * @param gatewayId
     *       Unique identifier of the gateway making the request to fetch statistics.
     * 
     * @param fromTime
     *       Starting date time.
     * 
     * @param toTime
     *       Ending data time.
     * 
     * @param userName
     *       Gateway username substring with which to further filter statistics.
     * 
     * @param applicationName
     *       Application id substring with which to further filter statistics.
     * 
     * @param resourceHostName
     *       Hostname id substring with which to further filter statistics.
     * 
     * 
     * 
     * @param authzToken
     * @param gatewayId
     * @param fromTime
     * @param toTime
     * @param userName
     * @param applicationName
     * @param resourceHostName
     */
    public org.apache.airavata.model.experiment.ExperimentStatistics getExperimentStatistics(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, long fromTime, long toTime, String userName, String applicationName, String resourceHostName) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Get All Experiments of the Project
     * Get Experiments within project with pagination. Results will be sorted based on creation time DESC.
     * 
     * @param projectId
     *       Uniqie identifier of the project.
     * 
     * @param limit
     *       Amount of results to be fetched.
     * 
     * @param offset
     *       The starting point of the results to be fetched.
     * 
     * 
     * 
     * @param authzToken
     * @param projectId
     * @param limit
     * @param offset
     */
    public List<org.apache.airavata.model.experiment.ExperimentModel> getExperimentsInProject(org.apache.airavata.model.security.AuthzToken authzToken, String projectId, int limit, int offset) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Get All Experiments of the User
     * Get experiments by user with pagination. Results will be sorted based on creation time DESC.
     * 
     * @param gatewayId
     *       Identifier of the requesting gateway.
     * 
     * @param userName
     *       Username of the requested end user.
     * 
     * @param limit
     *       Amount of results to be fetched.
     * 
     * @param offset
     *       The starting point of the results to be fetched.
     * 
     * 
     * 
     * @param authzToken
     * @param gatewayId
     * @param userName
     * @param limit
     * @param offset
     */
    public List<org.apache.airavata.model.experiment.ExperimentModel> getUserExperiments(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String userName, int limit, int offset) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     *   *
     *   * Create New Experiment
     *   * Create an experiment for the specified user belonging to the gateway. The gateway identity is not explicitly passed
     *   *   but inferred from the sshKeyAuthentication header. This experiment is just a persistent place holder. The client
     *   *   has to subsequently configure and launch the created experiment. No action is taken on Airavata Server except
     *   *   registering the experiment in a persistent store.
     *   *
     *   * @param gatewayId
     *   *    The unique ID of the gateway where the experiment is been created.
     *   *
     *   * @param ExperimentModel
     *   *    The create experiment will require the basic experiment metadata like the name and description, intended user,
     *   *      the gateway identifer and if the experiment should be shared public by defualt. During the creation of an experiment
     *   *      the ExperimentMetadata is a required field.
     *   *
     *   * @return
     *   *   The server-side generated.airavata.registry.core.experiment.globally unique identifier.
     *   *
     *   * @throws org.apache.airavata.model.error.InvalidRequestException
     *   *    For any incorrect forming of the request itself.
     *   *
     *   * @throws org.apache.airavata.model.error.AiravataClientException
     *   *    The following list of exceptions are thrown which Airavata Client can take corrective actions to resolve:
     *   *
     *   *      UNKNOWN_GATEWAY_ID - If a Gateway is not registered with Airavata as a one time administrative
     *   *         step, then Airavata Registry will not have a provenance area setup. The client has to follow
     *   *         gateway registration steps and retry this request.
     *   *
     *   *      AUTHENTICATION_FAILURE - How Authentication will be implemented is yet to be determined.
     *   *         For now this is a place holder.
     *   *
     *   *      INVALID_AUTHORIZATION - This will throw an authorization exception. When a more robust security hand-shake
     *   *         is implemented, the authorization will be more substantial.
     *   *
     *   * @throws org.apache.airavata.model.error.AiravataSystemException
     *   *    This exception will be thrown for any Airavata Server side issues and if the problem cannot be corrected by the client
     *   *       rather an Airavata Administrator will be notified to take corrective action.
     *   *
     * *
     * 
     * @param authzToken
     * @param gatewayId
     * @param experiment
     */
    public String createExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.experiment.ExperimentModel experiment) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Delete an Experiment
     * If the experiment is not already launched experiment can be deleted.
     * 
     * @param authzToken
     * 
     * @param experiementId
     *     Experiment ID of the experimnet you want to delete.
     * 
     * @return boolean
     *     Identifier for the success or failure of the deletion operation.
     * 
     * 
     * 
     * @param authzToken
     * @param experimentId
     */
    public boolean deleteExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String experimentId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     *   *
     *   * Get Experiment
     *   * Fetch previously created experiment metadata.
     *   *
     *   * @param airavataExperimentId
     *   *    The unique identifier of the requested experiment. This ID is returned during the create experiment step.
     *   *
     *   * @return ExperimentModel
     *   *   This method will return the previously stored experiment metadata.
     *   *
     *   * @throws org.apache.airavata.model.error.InvalidRequestException
     *   *    For any incorrect forming of the request itself.
     *   *
     *   * @throws org.apache.airavata.model.error.ExperimentNotFoundException
     *   *    If the specified experiment is not previously created, then an Experiment Not Found Exception is thrown.
     *   *
     *   * @throws org.apache.airavata.model.error.AiravataClientException
     *   *    The following list of exceptions are thrown which Airavata Client can take corrective actions to resolve:
     *   *
     *   *      UNKNOWN_GATEWAY_ID - If a Gateway is not registered with Airavata as a one time administrative
     *   *         step, then Airavata Registry will not have a provenance area setup. The client has to follow
     *   *         gateway registration steps and retry this request.
     *   *
     *   *      AUTHENTICATION_FAILURE - How Authentication will be implemented is yet to be determined.
     *   *         For now this is a place holder.
     *   *
     *   *      INVALID_AUTHORIZATION - This will throw an authorization exception. When a more robust security hand-shake
     *   *         is implemented, the authorization will be more substantial.
     *   *
     *   * @throws org.apache.airavata.model.error.AiravataSystemException
     *   *    This exception will be thrown for any Airavata Server side issues and if the problem cannot be corrected by the client
     *   *       rather an Airavata Administrator will be notified to take corrective action.
     *   *
     * *
     * 
     * @param authzToken
     * @param airavataExperimentId
     */
    public org.apache.airavata.model.experiment.ExperimentModel getExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     *   *
     *   * Get Experiment by an admin user
     *   *
     *   * Used by an admin user to fetch previously created experiment metadata.
     *   *
     *   * @param airavataExperimentId
     *   *    The unique identifier of the requested experiment. This ID is returned during the create experiment step.
     *   *
     *   * @return ExperimentModel
     *   *   This method will return the previously stored experiment metadata.
     *   *
     *   * @throws org.apache.airavata.model.error.InvalidRequestException
     *   *    For any incorrect forming of the request itself.
     *   *
     *   * @throws org.apache.airavata.model.error.ExperimentNotFoundException
     *   *    If the specified experiment is not previously created, then an Experiment Not Found Exception is thrown.
     *   *
     *   * @throws org.apache.airavata.model.error.AiravataClientException
     *   *    The following list of exceptions are thrown which Airavata Client can take corrective actions to resolve:
     *   *
     *   *      UNKNOWN_GATEWAY_ID - If a Gateway is not registered with Airavata as a one time administrative
     *   *         step, then Airavata Registry will not have a provenance area setup. The client has to follow
     *   *         gateway registration steps and retry this request.
     *   *
     *   *      AUTHENTICATION_FAILURE - How Authentication will be implemented is yet to be determined.
     *   *         For now this is a place holder.
     *   *
     *   *      INVALID_AUTHORIZATION - This will throw an authorization exception. When a more robust security hand-shake
     *   *         is implemented, the authorization will be more substantial.
     *   *
     *   * @throws org.apache.airavata.model.error.AiravataSystemException
     *   *    This exception will be thrown for any Airavata Server side issues and if the problem cannot be corrected by the client
     *   *       rather an Airavata Administrator will be notified to take corrective action.
     *   *
     * *
     * 
     * @param authzToken
     * @param airavataExperimentId
     */
    public org.apache.airavata.model.experiment.ExperimentModel getExperimentByAdmin(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Get Complete Experiment Details
     * Fetch the completed nested tree structue of previously created experiment metadata which includes processes ->
     * tasks -> jobs information.
     * 
     * @param airavataExperimentId
     *    The identifier for the requested experiment. This is returned during the create experiment step.
     * 
     * @return ExperimentModel
     *   This method will return the previously stored experiment metadata including application input parameters, computational resource scheduling
     *   information, special input output handling and additional quality of service parameters.
     * 
     * @throws org.apache.airavata.model.error.InvalidRequestException
     *    For any incorrect forming of the request itself.
     * 
     * @throws org.apache.airavata.model.error.ExperimentNotFoundException
     *    If the specified experiment is not previously created, then an Experiment Not Found Exception is thrown.
     * 
     * @throws org.apache.airavata.model.error.AiravataClientException
     *    The following list of exceptions are thrown which Airavata Client can take corrective actions to resolve:
     * 
     *      UNKNOWN_GATEWAY_ID - If a Gateway is not registered with Airavata as a one time administrative
     *         step, then Airavata Registry will not have a provenance area setup. The client has to follow
     *         gateway registration steps and retry this request.
     * 
     *      AUTHENTICATION_FAILURE - How Authentication will be implemented is yet to be determined.
     *         For now this is a place holder.
     * 
     *      INVALID_AUTHORIZATION - This will throw an authorization exception. When a more robust security hand-shake
     *         is implemented, the authorization will be more substantial.
     * 
     * @throws org.apache.airavata.model.error.AiravataSystemException
     *    This exception will be thrown for any Airavata Server side issues and if the problem cannot be corrected by the client
     *       rather an Airavata Administrator will be notified to take corrective action.
     * 
     * 
     * @param authzToken
     * @param airavataExperimentId
     */
    public org.apache.airavata.model.experiment.ExperimentModel getDetailedExperimentTree(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Update a Previously Created Experiment
     * Configure the CREATED experiment with required inputs, scheduling and other quality of service parameters. This method only updates the experiment object within the registry.
     * The experiment has to be launched to make it actionable by the server.
     * 
     * @param airavataExperimentId
     *    The identifier for the requested experiment. This is returned during the create experiment step.
     * 
     * @param ExperimentModel
     *    The configuration information of the experiment with application input parameters, computational resource scheduling
     *      information, special input output handling and additional quality of service parameters.
     * 
     * @return
     *   This method call does not have a return value.
     * 
     * @throws org.apache.airavata.model.error.InvalidRequestException
     *    For any incorrect forming of the request itself.
     * 
     * @throws org.apache.airavata.model.error.ExperimentNotFoundException
     *    If the specified experiment is not previously created, then an Experiment Not Found Exception is thrown.
     * 
     * @throws org.apache.airavata.model.error.AiravataClientException
     *    The following list of exceptions are thrown which Airavata Client can take corrective actions to resolve:
     *      
     *      UNKNOWN_GATEWAY_ID - If a Gateway is not registered with Airavata as a one time administrative
     *         step, then Airavata Registry will not have a provenance area setup. The client has to follow
     *         gateway registration steps and retry this request.
     * 
     *      AUTHENTICATION_FAILURE - How Authentication will be implemented is yet to be determined.
     *         For now this is a place holder.
     * 
     *      INVALID_AUTHORIZATION - This will throw an authorization exception. When a more robust security hand-shake
     *         is implemented, the authorization will be more substantial.
     * 
     * @throws org.apache.airavata.model.error.AiravataSystemException
     *    This exception will be thrown for any Airavata Server side issues and if the problem cannot be corrected by the client
     *       rather an Airavata Administrator will be notified to take corrective action.
     * 
     * 
     * @param authzToken
     * @param airavataExperimentId
     * @param experiment
     */
    public void updateExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.airavata.model.experiment.ExperimentModel experiment) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    public void updateExperimentConfiguration(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.airavata.model.experiment.UserConfigurationDataModel userConfiguration) throws org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    public void updateResourceScheduleing(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel resourceScheduling) throws org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     *  *
     *  * Validate experiment configuration.
     *  * A true in general indicates, the experiment is ready to be launched.
     *  *
     *  * @param airavataExperimentId
     *  *    Unique identifier of the experiment (Experimnent ID) of the experiment which need to be validated.
     *  *
     *  * @return boolean
     *  *      Identifier for the success or failure of the validation operation.
     *  *
     * *
     * 
     * @param authzToken
     * @param airavataExperimentId
     */
    public boolean validateExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Launch a Previously Created & Configured Experiment.
     * Airavata Server will then start processing the request and appropriate notifications and intermediate and output data will be subsequently available for this experiment.
     * 
     * @gatewayId
     *    ID of the gateway which will launch the experiment.
     * 
     * @param airavataExperimentId
     *    The identifier for the requested experiment. This is returned during the create experiment step.
     * 
     * @return
     *   This method call does not have a return value.
     * 
     * @throws org.apache.airavata.model.error.InvalidRequestException
     *    For any incorrect forming of the request itself.
     * 
     * @throws org.apache.airavata.model.error.ExperimentNotFoundException
     *    If the specified experiment is not previously created, then an Experiment Not Found Exception is thrown.
     * 
     * @throws org.apache.airavata.model.error.AiravataClientException
     *    The following list of exceptions are thrown which Airavata Client can take corrective actions to resolve:
     *      
     *      UNKNOWN_GATEWAY_ID - If a Gateway is not registered with Airavata as a one time administrative
     *         step, then Airavata Registry will not have a provenance area setup. The client has to follow
     *         gateway registration steps and retry this request.
     * 
     *      AUTHENTICATION_FAILURE - How Authentication will be implemented is yet to be determined.
     *         For now this is a place holder.
     * 
     *      INVALID_AUTHORIZATION - This will throw an authorization exception. When a more robust security hand-shake
     *         is implemented, the authorization will be more substantial.
     * 
     * @throws org.apache.airavata.model.error.AiravataSystemException
     *    This exception will be thrown for any Airavata Server side issues and if the problem cannot be corrected by the client
     *       rather an Airavata Administrator will be notified to take corrective action.
     * 
     * 
     * @param authzToken
     * @param airavataExperimentId
     * @param gatewayId
     */
    public void launchExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Get Experiment Status
     * 
     * Obtain the status of an experiment by providing the Experiment Id
     * 
     * @param authzToken
     * 
     * @param airavataExperimentId
     *     Experiment ID of the experimnet you require the status.
     * 
     * @return ExperimentStatus
     *     ExperimentStatus model with the current status will be returned.
     * 
     * 
     * 
     * @param authzToken
     * @param airavataExperimentId
     */
    public org.apache.airavata.model.status.ExperimentStatus getExperimentStatus(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Get Experiment Outputs
     * This method to be used when need to obtain final outputs of a certain Experiment
     * 
     * @param authzToken
     * 
     * @param airavataExperimentId
     *     Experiment ID of the experimnet you need the outputs.
     * 
     * @return list
     *     List of experiment outputs will be returned. They will be returned as a list of OutputDataObjectType for the experiment.
     * 
     * 
     * 
     * @param authzToken
     * @param airavataExperimentId
     */
    public List<org.apache.airavata.model.application.io.OutputDataObjectType> getExperimentOutputs(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Get Intermediate Experiment Outputs
     * This method to be used when need to obtain intermediate outputs of a certain Experiment
     * 
     * @param authzToken
     * 
     * @param airavataExperimentId
     *     Experiment ID of the experimnet you need intermediate outputs.
     * 
     * @return list
     *     List of intermediate experiment outputs will be returned. They will be returned as a list of OutputDataObjectType for the experiment.
     * 
     * 
     * 
     * @param authzToken
     * @param airavataExperimentId
     */
    public List<org.apache.airavata.model.application.io.OutputDataObjectType> getIntermediateOutputs(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Get Job Statuses for an Experiment
     * This method to be used when need to get the job status of an Experiment. An experiment may have one or many jobs; there for one or many job statuses may turnup
     * 
     * @param authzToken
     * 
     * @param experiementId
     *     Experiment ID of the experimnet you need the job statuses.
     * 
     * @return JobStatus
     *     Job status (string) for all all the existing jobs for the experiment will be returned in the form of a map
     * 
     * 
     * 
     * @param authzToken
     * @param airavataExperimentId
     */
    public Map<String,org.apache.airavata.model.status.JobStatus> getJobStatuses(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Get Job Details for all the jobs within an Experiment.
     * This method to be used when need to get the job details for one or many jobs of an Experiment.
     * 
     * @param authzToken
     * 
     * @param experiementId
     *     Experiment ID of the experimnet you need job details.
     * 
     * @return list of JobDetails
     *     Job details.
     * 
     * 
     * 
     * @param authzToken
     * @param airavataExperimentId
     */
    public List<org.apache.airavata.model.job.JobModel> getJobDetails(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Clone an Existing Experiment
     * Existing specified experiment is cloned and a new name is provided. A copy of the experiment configuration is made and is persisted with new metadata.
     *   The client has to subsequently update this configuration if needed and launch the cloned experiment.
     * 
     * @param newExperimentName
     *    experiment name that should be used in the cloned experiment
     * 
     * @param updatedExperiment
     *    Once an experiment is cloned, to disambiguate, the users are suggested to provide new metadata. This will again require
     *      the basic experiment metadata like the name and description, intended user, the gateway identifier and if the experiment
     *      should be shared public by default.
     * @param newExperimentProjectId
     *    The project in which to create the cloned experiment. This is optional and if null the experiment will be created
     *      in the same project as the existing experiment.
     * 
     * @return
     *   The server-side generated.airavata.registry.core.experiment.globally unique identifier (Experiment ID) for the newly cloned experiment.
     * 
     * @throws org.apache.airavata.model.error.InvalidRequestException
     *    For any incorrect forming of the request itself.
     * 
     * @throws org.apache.airavata.model.error.ExperimentNotFoundException
     *    If the specified experiment is not previously created, then an Experiment Not Found Exception is thrown.
     * 
     * @throws org.apache.airavata.model.error.AiravataClientException
     *    The following list of exceptions are thrown which Airavata Client can take corrective actions to resolve:
     *      
     *      UNKNOWN_GATEWAY_ID - If a Gateway is not registered with Airavata as a one time administrative
     *         step, then Airavata Registry will not have a provenance area setup. The client has to follow
     *         gateway registration steps and retry this request.
     * 
     *      AUTHENTICATION_FAILURE - How Authentication will be implemented is yet to be determined.
     *         For now this is a place holder.
     * 
     *      INVALID_AUTHORIZATION - This will throw an authorization exception. When a more robust security hand-shake
     *         is implemented, the authorization will be more substantial.
     * 
     * @throws org.apache.airavata.model.error.AiravataSystemException
     *    This exception will be thrown for any Airavata Server side issues and if the problem cannot be corrected by the client
     *       rather an Airavata Administrator will be notified to take corrective action.
     * 
     * 
     * @param authzToken
     * @param existingExperimentID
     * @param newExperimentName
     * @param newExperimentProjectId
     */
    public String cloneExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String existingExperimentID, String newExperimentName, String newExperimentProjectId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.thrift.TException;

    /**
     * 
     * Clone an Existing Experiment by an admin user
     * Existing specified experiment is cloned and a new name is provided. A copy of the experiment configuration is made and is persisted with new metadata.
     *   The client has to subsequently update this configuration if needed and launch the cloned experiment.
     * 
     * @param newExperimentName
     *    experiment name that should be used in the cloned experiment
     * 
     * @param updatedExperiment
     *    Once an experiment is cloned, to disambiguate, the users are suggested to provide new metadata. This will again require
     *      the basic experiment metadata like the name and description, intended user, the gateway identifier and if the experiment
     *      should be shared public by default.
     * @param newExperimentProjectId
     *    The project in which to create the cloned experiment. This is optional and if null the experiment will be created
     *      in the same project as the existing experiment.
     * 
     * @return
     *   The server-side generated.airavata.registry.core.experiment.globally unique identifier (Experiment ID) for the newly cloned experiment.
     * 
     * @throws org.apache.airavata.model.error.InvalidRequestException
     *    For any incorrect forming of the request itself.
     * 
     * @throws org.apache.airavata.model.error.ExperimentNotFoundException
     *    If the specified experiment is not previously created, then an Experiment Not Found Exception is thrown.
     * 
     * @throws org.apache.airavata.model.error.AiravataClientException
     *    The following list of exceptions are thrown which Airavata Client can take corrective actions to resolve:
     * 
     *      UNKNOWN_GATEWAY_ID - If a Gateway is not registered with Airavata as a one time administrative
     *         step, then Airavata Registry will not have a provenance area setup. The client has to follow
     *         gateway registration steps and retry this request.
     * 
     *      AUTHENTICATION_FAILURE - How Authentication will be implemented is yet to be determined.
     *         For now this is a place holder.
     * 
     *      INVALID_AUTHORIZATION - This will throw an authorization exception. When a more robust security hand-shake
     *         is implemented, the authorization will be more substantial.
     * 
     * @throws org.apache.airavata.model.error.AiravataSystemException
     *    This exception will be thrown for any Airavata Server side issues and if the problem cannot be corrected by the client
     *       rather an Airavata Administrator will be notified to take corrective action.
     * 
     * 
     * @param authzToken
     * @param existingExperimentID
     * @param newExperimentName
     * @param newExperimentProjectId
     */
    public String cloneExperimentByAdmin(org.apache.airavata.model.security.AuthzToken authzToken, String existingExperimentID, String newExperimentName, String newExperimentProjectId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.thrift.TException;

    /**
     * 
     * Terminate a running Experiment.
     * 
     * @gatewayId
     *    ID of the gateway which will terminate the running Experiment.
     * 
     * @param airavataExperimentId
     *    The identifier of the experiment required termination. This ID is returned during the create experiment step.
     * 
     * @return status
     *   This method call does not have a return value.
     * 
     * @throws org.apache.airavata.model.error.InvalidRequestException
     *    For any incorrect forming of the request itself.
     * 
     * @throws org.apache.airavata.model.error.ExperimentNotFoundException
     *    If the specified experiment is not previously created, then an Experiment Not Found Exception is thrown.
     * 
     * @throws org.apache.airavata.model.error.AiravataClientException
     *    The following list of exceptions are thrown which Airavata Client can take corrective actions to resolve:
     *      
     *      UNKNOWN_GATEWAY_ID - If a Gateway is not registered with Airavata as a one time administrative
     *         step, then Airavata Registry will not have a provenance area setup. The client has to follow
     *         gateway registration steps and retry this request.
     * 
     *      AUTHENTICATION_FAILURE - How Authentication will be implemented is yet to be determined.
     *         For now this is a place holder.
     * 
     *      INVALID_AUTHORIZATION - This will throw an authorization exception. When a more robust security hand-shake
     *         is implemented, the authorization will be more substantial.
     * 
     * @throws org.apache.airavata.model.error.AiravataSystemException
     *    This exception will be thrown for any Airavata Server side issues and if the problem cannot be corrected by the client
     *       rather an Airavata Administrator will be notified to take corrective action.
     * 
     * 
     * @param authzToken
     * @param airavataExperimentId
     * @param gatewayId
     */
    public void terminateExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Register a Application Module.
     * 
     * @gatewayId
     *    ID of the gateway which is registering the new Application Module.
     * 
     * @param applicationModule
     *    Application Module Object created from the datamodel.
     * 
     * @return appModuleId
     *   Returns the server-side generated airavata appModule globally unique identifier.
     * 
     * 
     * @param authzToken
     * @param gatewayId
     * @param applicationModule
     */
    public String registerApplicationModule(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule applicationModule) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Fetch a Application Module.
     * 
     * @param appModuleId
     *   The unique identifier of the application module required
     * 
     * @return applicationModule
     *   Returns an Application Module Object.
     * 
     * 
     * @param authzToken
     * @param appModuleId
     */
    public org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule getApplicationModule(org.apache.airavata.model.security.AuthzToken authzToken, String appModuleId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Update a Application Module.
     * 
     * @param appModuleId
     *   The identifier for the requested application module to be updated.
     * 
     * @param applicationModule
     *    Application Module Object created from the datamodel.
     * 
     * @return status
     *   Returns a success/failure of the update.
     * 
     * 
     * @param authzToken
     * @param appModuleId
     * @param applicationModule
     */
    public boolean updateApplicationModule(org.apache.airavata.model.security.AuthzToken authzToken, String appModuleId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule applicationModule) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Fetch all Application Module Descriptions.
     * 
     * @param gatewayId
     *    ID of the gateway which need to list all available application deployment documentation.
     * 
     * @return list
     *    Returns the list of all Application Module Objects.
     * 
     * 
     * @param authzToken
     * @param gatewayId
     */
    public List<org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule> getAllAppModules(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Delete an Application Module.
     * 
     * @param appModuleId
     *   The identifier of the Application Module to be deleted.
     * 
     * @return status
     *   Returns a success/failure of the deletion.
     * 
     * 
     * @param authzToken
     * @param appModuleId
     */
    public boolean deleteApplicationModule(org.apache.airavata.model.security.AuthzToken authzToken, String appModuleId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Register an Application Deployment.
     * 
     * @param gatewayId
     *    ID of the gateway which is registering the new Application Deployment.
     * 
     * @param applicationDeployment
     *    Application Module Object created from the datamodel.
     * 
     * @return appDeploymentId
     *   Returns a server-side generated airavata appDeployment globally unique identifier.
     * 
     * 
     * @param authzToken
     * @param gatewayId
     * @param applicationDeployment
     */
    public String registerApplicationDeployment(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription applicationDeployment) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Fetch a Application Deployment.
     * 
     * @param appDeploymentId
     *   The identifier for the requested application module
     * 
     * @return applicationDeployment
     *   Returns a application Deployment Object.
     * 
     * 
     * @param authzToken
     * @param appDeploymentId
     */
    public org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription getApplicationDeployment(org.apache.airavata.model.security.AuthzToken authzToken, String appDeploymentId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Update an Application Deployment.
     * 
     * @param appDeploymentId
     *   The identifier of the requested application deployment to be updated.
     * 
     * @param appDeployment
     *    Application Deployment Object created from the datamodel.
     * 
     * @return status
     *   Returns a success/failure of the update.
     * 
     * 
     * @param authzToken
     * @param appDeploymentId
     * @param applicationDeployment
     */
    public boolean updateApplicationDeployment(org.apache.airavata.model.security.AuthzToken authzToken, String appDeploymentId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription applicationDeployment) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Delete an Application Deployment.
     * 
     * @param appDeploymentId
     *   The unique identifier of application deployment to be deleted.
     * 
     * @return status
     *   Returns a success/failure of the deletion.
     * 
     * 
     * @param authzToken
     * @param appDeploymentId
     */
    public boolean deleteApplicationDeployment(org.apache.airavata.model.security.AuthzToken authzToken, String appDeploymentId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Fetch all Application Deployment Descriptions.
     * 
     * @param gatewayId
     *    ID of the gateway which need to list all available application deployment documentation.
     * 
     * @return list<applicationDeployment.
     *    Returns the list of all application Deployment Objects.
     * 
     * 
     * @param authzToken
     * @param gatewayId
     */
    public List<org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription> getAllApplicationDeployments(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Fetch a list of Deployed Compute Hosts.
     * 
     * @param appModuleId
     *   The identifier for the requested application module
     * 
     * @return list<string>
     *   Returns a list of Deployed Resources.
     * 
     * 
     * @param authzToken
     * @param appModuleId
     */
    public List<String> getAppModuleDeployedResources(org.apache.airavata.model.security.AuthzToken authzToken, String appModuleId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Register a Application Interface.
     * 
     * @param applicationInterface
     *    Application Module Object created from the datamodel.
     * 
     * @return appInterfaceId
     *   Returns a server-side generated airavata application interface globally unique identifier.
     * 
     * 
     * @param authzToken
     * @param gatewayId
     * @param applicationInterface
     */
    public String registerApplicationInterface(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription applicationInterface) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Clone an Application Interface.
     * 
     * @gatewayId
     *    The identifier for the gateway profile to be requested
     * 
     * @param existingAppInterfaceID
     *    Identifier of the existing Application interface you wich to clone.
     * 
     * @param newApplicationName
     *    Name for the new application interface.
     * 
     * @return appInterfaceId
     *    Returns a server-side generated globally unique identifier for the newly cloned application interface.
     * 
     * 
     * @param authzToken
     * @param existingAppInterfaceID
     * @param newApplicationName
     * @param gatewayId
     */
    public String cloneApplicationInterface(org.apache.airavata.model.security.AuthzToken authzToken, String existingAppInterfaceID, String newApplicationName, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Fetch an Application Interface.
     * 
     * @param appInterfaceId
     *   The identifier for the requested application interface.
     * 
     * @return applicationInterface
     *   Returns an application Interface Object.
     * 
     * 
     * @param authzToken
     * @param appInterfaceId
     */
    public org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription getApplicationInterface(org.apache.airavata.model.security.AuthzToken authzToken, String appInterfaceId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Update a Application Interface.
     * 
     * @param appInterfaceId
     *   The identifier of the requested application deployment to be updated.
     * 
     * @param appInterface
     *    Application Interface Object created from the datamodel.
     * 
     * @return status
     *   Returns a success/failure of the update.
     * 
     * 
     * @param authzToken
     * @param appInterfaceId
     * @param applicationInterface
     */
    public boolean updateApplicationInterface(org.apache.airavata.model.security.AuthzToken authzToken, String appInterfaceId, org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription applicationInterface) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Delete an Application Interface.
     * 
     * @param appInterfaceId
     *   The identifier for the requested application interface to be deleted.
     * 
     * @return status
     *   Returns a success/failure of the deletion.
     * 
     * 
     * @param authzToken
     * @param appInterfaceId
     */
    public boolean deleteApplicationInterface(org.apache.airavata.model.security.AuthzToken authzToken, String appInterfaceId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Fetch name and ID of  Application Interface documents.
     * 
     * 
     * @return map<applicationId, applicationInterfaceNames>
     *   Returns a list of application interfaces with corresponsing ID's
     * 
     * 
     * @param authzToken
     * @param gatewayId
     */
    public Map<String,String> getAllApplicationInterfaceNames(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Fetch all Application Interface documents.
     * 
     * 
     * @return map<applicationId, applicationInterfaceNames>
     *   Returns a list of application interfaces documents (Application Interface ID, name, description, Inputs and Outputs objects).
     * 
     * 
     * @param authzToken
     * @param gatewayId
     */
    public List<org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription> getAllApplicationInterfaces(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Fetch the list of Application Inputs.
     * 
     * @param appInterfaceId
     *   The identifier of the application interface which need inputs to be fetched.
     * 
     * @return list<application_interface_model.InputDataObjectType>
     *   Returns a list of application inputs.
     * 
     * 
     * @param authzToken
     * @param appInterfaceId
     */
    public List<org.apache.airavata.model.application.io.InputDataObjectType> getApplicationInputs(org.apache.airavata.model.security.AuthzToken authzToken, String appInterfaceId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Fetch list of Application Outputs.
     * 
     * @param appInterfaceId
     *   The identifier of the application interface which need outputs to be fetched.
     * 
     * @return list<application_interface_model.OutputDataObjectType>
     *   Returns a list of application outputs.
     * 
     * 
     * @param authzToken
     * @param appInterfaceId
     */
    public List<org.apache.airavata.model.application.io.OutputDataObjectType> getApplicationOutputs(org.apache.airavata.model.security.AuthzToken authzToken, String appInterfaceId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Fetch a list of all deployed Compute Hosts for a given application interfaces.
     * 
     * @param appInterfaceId
     *   The identifier for the requested application interface.
     * 
     * @return map<computeResourceId, computeResourceName>
     *   A map of registered compute resource id's and their corresponding hostnames.
     *   Deployments of each modules listed within the interfaces will be listed.
     * 
     * 
     * @param authzToken
     * @param appInterfaceId
     */
    public Map<String,String> getAvailableAppInterfaceComputeResources(org.apache.airavata.model.security.AuthzToken authzToken, String appInterfaceId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Register a Compute Resource.
     * 
     * @param computeResourceDescription
     *    Compute Resource Object created from the datamodel.
     * 
     * @return computeResourceId
     *   Returns a server-side generated airavata compute resource globally unique identifier.
     * 
     * 
     * @param authzToken
     * @param computeResourceDescription
     */
    public String registerComputeResource(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription computeResourceDescription) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Fetch the given Compute Resource.
     * 
     * @param computeResourceId
     *   The identifier for the requested compute resource
     * 
     * @return computeResourceDescription
     *    Compute Resource Object created from the datamodel..
     * 
     * 
     * @param authzToken
     * @param computeResourceId
     */
    public org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription getComputeResource(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Fetch all registered Compute Resources.
     * 
     * @return A map of registered compute resource id's and thier corresponding hostnames.
     *    Compute Resource Object created from the datamodel..
     * 
     * 
     * @param authzToken
     */
    public Map<String,String> getAllComputeResourceNames(org.apache.airavata.model.security.AuthzToken authzToken) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Update a Compute Resource.
     * 
     * @param computeResourceId
     *   The identifier for the requested compute resource to be updated.
     * 
     * @param computeResourceDescription
     *    Compute Resource Object created from the datamodel.
     * 
     * @return status
     *   Returns a success/failure of the update.
     * 
     * 
     * @param authzToken
     * @param computeResourceId
     * @param computeResourceDescription
     */
    public boolean updateComputeResource(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription computeResourceDescription) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Delete a Compute Resource.
     * 
     * @param computeResourceId
     *   The identifier for the requested compute resource to be deleted.
     * 
     * @return status
     *   Returns a success/failure of the deletion.
     * 
     * 
     * @param authzToken
     * @param computeResourceId
     */
    public boolean deleteComputeResource(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Register a Storage Resource.
     * 
     * @param storageResourceDescription
     *    Storge Resource Object created from the datamodel.
     * 
     * @return storageResourceId
     *   Returns a server-side generated airavata storage resource globally unique identifier.
     * 
     * 
     * @param authzToken
     * @param storageResourceDescription
     */
    public String registerStorageResource(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription storageResourceDescription) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Fetch the given Storage Resource.
     * 
     * @param storageResourceId
     *   The identifier for the requested storage resource
     * 
     * @return storageResourceDescription
     *    Storage Resource Object created from the datamodel..
     * 
     * 
     * @param authzToken
     * @param storageResourceId
     */
    public org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription getStorageResource(org.apache.airavata.model.security.AuthzToken authzToken, String storageResourceId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Fetch all registered Storage Resources.
     * 
     * @return A map of registered compute resource id's and thier corresponding hostnames.
     *    Compute Resource Object created from the datamodel..
     * 
     * 
     * @param authzToken
     */
    public Map<String,String> getAllStorageResourceNames(org.apache.airavata.model.security.AuthzToken authzToken) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Update a Storage Resource.
     * 
     * @param storageResourceId
     *   The identifier for the requested compute resource to be updated.
     * 
     * @param storageResourceDescription
     *    Storage Resource Object created from the datamodel.
     * 
     * @return status
     *   Returns a success/failure of the update.
     * 
     * 
     * @param authzToken
     * @param storageResourceId
     * @param storageResourceDescription
     */
    public boolean updateStorageResource(org.apache.airavata.model.security.AuthzToken authzToken, String storageResourceId, org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription storageResourceDescription) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Delete a Storage Resource.
     * 
     * @param storageResourceId
     *   The identifier of the requested compute resource to be deleted.
     * 
     * @return status
     *   Returns a success/failure of the deletion.
     * 
     * 
     * @param authzToken
     * @param storageResourceId
     */
    public boolean deleteStorageResource(org.apache.airavata.model.security.AuthzToken authzToken, String storageResourceId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Add a Local Job Submission details to a compute resource
     *  App catalog will return a jobSubmissionInterfaceId which will be added to the jobSubmissionInterfaces.
     * 
     * @param computeResourceId
     *   The identifier of the compute resource to which JobSubmission protocol to be added
     * 
     * @param priorityOrder
     *   Specify the priority of this job manager. If this is the only jobmanager, the priority can be zero.
     * 
     * @param localSubmission
     *   The LOCALSubmission object to be added to the resource.
     * 
     * @return status
     *   Returns the unique job submission id.
     * 
     * 
     * @param authzToken
     * @param computeResourceId
     * @param priorityOrder
     * @param localSubmission
     */
    public String addLocalSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission localSubmission) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Update the given Local Job Submission details
     * 
     * @param jobSubmissionInterfaceId
     *   The identifier of the JobSubmission Interface to be updated.
     * 
     * @param localSubmission
     *   The LOCALSubmission object to be updated.
     * 
     * @return status
     *   Returns a success/failure of the deletion.
     * 
     * 
     * @param authzToken
     * @param jobSubmissionInterfaceId
     * @param localSubmission
     */
    public boolean updateLocalSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission localSubmission) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * This method returns localJobSubmission object
     * @param jobSubmissionInterfaceId
     *   The identifier of the JobSubmission Interface to be retrieved.
     *  @return LOCALSubmission instance
     * 
     * 
     * @param authzToken
     * @param jobSubmissionId
     */
    public org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission getLocalJobSubmission(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Add a SSH Job Submission details to a compute resource
     *  App catalog will return a jobSubmissionInterfaceId which will be added to the jobSubmissionInterfaces.
     * 
     * @param computeResourceId
     *   The identifier of the compute resource to which JobSubmission protocol to be added
     * 
     * @param priorityOrder
     *   Specify the priority of this job manager. If this is the only jobmanager, the priority can be zero.
     * 
     * @param sshJobSubmission
     *   The SSHJobSubmission object to be added to the resource.
     * 
     * @return status
     *   Returns the unique job submission id.
     * 
     * 
     * @param authzToken
     * @param computeResourceId
     * @param priorityOrder
     * @param sshJobSubmission
     */
    public String addSSHJobSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Add a SSH_FORK Job Submission details to a compute resource
     *  App catalog will return a jobSubmissionInterfaceId which will be added to the jobSubmissionInterfaces.
     * 
     * @param computeResourceId
     *   The identifier of the compute resource to which JobSubmission protocol to be added
     * 
     * @param priorityOrder
     *   Specify the priority of this job manager. If this is the only jobmanager, the priority can be zero.
     * 
     * @param sshJobSubmission
     *   The SSHJobSubmission object to be added to the resource.
     * 
     * @return status
     *   Returns the unique job submission id.
     * 
     * 
     * @param authzToken
     * @param computeResourceId
     * @param priorityOrder
     * @param sshJobSubmission
     */
    public String addSSHForkJobSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * This method returns SSHJobSubmission object
     * @param jobSubmissionInterfaceId
     *   The identifier of the JobSubmission Interface to be retrieved.
     *  @return SSHJobSubmission instance
     * 
     * 
     * @param authzToken
     * @param jobSubmissionId
     */
    public org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission getSSHJobSubmission(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Add a UNICORE Job Submission details to a compute resource
     *  App catalog will return a jobSubmissionInterfaceId which will be added to the jobSubmissionInterfaces.
     * 
     * @param computeResourceId
     *   The identifier of the compute resource to which JobSubmission protocol to be added
     * 
     * @param priorityOrder
     *   Specify the priority of this job manager. If this is the only jobmanager, the priority can be zero.
     * 
     * @param unicoreJobSubmission
     *   The UnicoreJobSubmission object to be added to the resource.
     * 
     * @return status
     *  Returns the unique job submission id.
     * 
     * 
     * @param authzToken
     * @param computeResourceId
     * @param priorityOrder
     * @param unicoreJobSubmission
     */
    public String addUNICOREJobSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission unicoreJobSubmission) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     *   *
     *   * This method returns UnicoreJobSubmission object
     *   *
     *   * @param jobSubmissionInterfaceId
     *   *   The identifier of the JobSubmission Interface to be retrieved.
     *   *  @return UnicoreJobSubmission instance
     *   *
     * *
     * 
     * @param authzToken
     * @param jobSubmissionId
     */
    public org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission getUnicoreJobSubmission(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     *    *
     *    * Add a Cloud Job Submission details to a compute resource
     *    *  App catalog will return a jobSubmissionInterfaceId which will be added to the jobSubmissionInterfaces.
     *    *
     *    * @param computeResourceId
     *    *   The identifier of the compute resource to which JobSubmission protocol to be added
     *    *
     *    * @param priorityOrder
     *    *   Specify the priority of this job manager. If this is the only jobmanager, the priority can be zero.
     *    *
     *    * @param sshJobSubmission
     *    *   The SSHJobSubmission object to be added to the resource.
     *    *
     *    * @return status
     *    *   Returns the unique job submission id.
     *    *
     * *
     * 
     * @param authzToken
     * @param computeResourceId
     * @param priorityOrder
     * @param cloudSubmission
     */
    public String addCloudJobSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission cloudSubmission) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     *    *
     *    * This method returns cloudJobSubmission object
     *    * @param jobSubmissionInterfaceI
     *        *   The identifier of the JobSubmission Interface to be retrieved.
     *    *  @return CloudJobSubmission instance
     * *
     * 
     * @param authzToken
     * @param jobSubmissionId
     */
    public org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission getCloudJobSubmission(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Update the given SSH Job Submission details
     * 
     * @param jobSubmissionInterfaceId
     *   The identifier of the JobSubmission Interface to be updated.
     * 
     * @param sshJobSubmission
     *   The SSHJobSubmission object to be updated.
     * 
     * @return status
     *   Returns a success/failure of the update.
     * 
     * 
     * @param authzToken
     * @param jobSubmissionInterfaceId
     * @param sshJobSubmission
     */
    public boolean updateSSHJobSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Update the cloud Job Submission details
     * 
     * @param jobSubmissionInterfaceId
     *   The identifier of the JobSubmission Interface to be updated.
     * 
     * @param cloudJobSubmission
     *   The CloudJobSubmission object to be updated.
     * 
     * @return status
     *   Returns a success/failure of the update.
     * 
     * 
     * @param authzToken
     * @param jobSubmissionInterfaceId
     * @param sshJobSubmission
     */
    public boolean updateCloudJobSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission sshJobSubmission) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Update the UNIOCRE Job Submission details
     * 
     * @param jobSubmissionInterfaceId
     *   The identifier of the JobSubmission Interface to be updated.
     * 
     * @param UnicoreJobSubmission
     *   The UnicoreJobSubmission object to be updated.
     * 
     * @return status
     *   Returns a success/failure of the update.
     * 
     * 
     * 
     * @param authzToken
     * @param jobSubmissionInterfaceId
     * @param unicoreJobSubmission
     */
    public boolean updateUnicoreJobSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission unicoreJobSubmission) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Add a Local data movement details to a compute resource
     *  App catalog will return a dataMovementInterfaceId which will be added to the dataMovementInterfaces.
     * 
     * @param productUri
     *   The identifier of the compute resource to which JobSubmission protocol to be added
     * 
     * @param DMType
     *   DMType object to be added to the resource.
     * 
     * @param priorityOrder
     *   Specify the priority of this job manager. If this is the only jobmanager, the priority can be zero.
     * 
     * @param localDataMovement
     *   The LOCALDataMovement object to be added to the resource.
     * 
     * @return status
     *   Returns the unique job submission id.
     * 
     * 
     * 
     * @param authzToken
     * @param productUri
     * @param dataMoveType
     * @param priorityOrder
     * @param localDataMovement
     */
    public String addLocalDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.LOCALDataMovement localDataMovement) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Update the given Local data movement details
     * 
     * @param dataMovementInterfaceId
     *   The identifier of the data movement Interface to be updated.
     * 
     * @param localDataMovement
     *   The LOCALDataMovement object to be updated.
     * 
     * @return status
     *   Returns a success/failure of the update.
     * 
     * 
     * 
     * @param authzToken
     * @param dataMovementInterfaceId
     * @param localDataMovement
     */
    public boolean updateLocalDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementInterfaceId, org.apache.airavata.model.data.movement.LOCALDataMovement localDataMovement) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * This method returns local datamovement object.
     * 
     * @param dataMovementId
     *   The identifier of the datamovement Interface to be retrieved.
     * 
     *  @return LOCALDataMovement instance
     * 
     * 
     * 
     * @param authzToken
     * @param dataMovementId
     */
    public org.apache.airavata.model.data.movement.LOCALDataMovement getLocalDataMovement(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Add a SCP data movement details to a compute resource
     *  App catalog will return a dataMovementInterfaceId which will be added to the dataMovementInterfaces.
     * 
     * @param productUri
     *   The identifier of the compute resource to which JobSubmission protocol to be added
     * 
     * @param priorityOrder
     *   Specify the priority of this job manager. If this is the only jobmanager, the priority can be zero.
     * 
     * @param scpDataMovement
     *   The SCPDataMovement object to be added to the resource.
     * 
     * @return status
     *   Returns the unique job submission id.
     * 
     * 
     * @param authzToken
     * @param productUri
     * @param dataMoveType
     * @param priorityOrder
     * @param scpDataMovement
     */
    public String addSCPDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.SCPDataMovement scpDataMovement) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Update the given scp data movement details
     *  App catalog will return a dataMovementInterfaceId which will be added to the dataMovementInterfaces.
     * 
     * @param dataMovementInterfaceId
     *   The identifier of the data movement Interface to be updated.
     * 
     * @param scpDataMovement
     *   The SCPDataMovement object to be updated.
     * 
     * @return status
     *   Returns a success/failure of the update.
     * 
     * 
     * @param authzToken
     * @param dataMovementInterfaceId
     * @param scpDataMovement
     */
    public boolean updateSCPDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementInterfaceId, org.apache.airavata.model.data.movement.SCPDataMovement scpDataMovement) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * This method returns SCP datamovement object
     * 
     * @param dataMovementId
     *   The identifier of the datamovement Interface to be retrieved.
     * 
     * @return SCPDataMovement instance
     * 
     * 
     * 
     * @param authzToken
     * @param dataMovementId
     */
    public org.apache.airavata.model.data.movement.SCPDataMovement getSCPDataMovement(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Add a UNICORE data movement details to a compute resource
     *  App catalog will return a dataMovementInterfaceId which will be added to the dataMovementInterfaces.
     * 
     * @param productUri
     *   The identifier of the compute resource to which data movement protocol to be added
     * 
     * @param priorityOrder
     *   Specify the priority of this job manager. If this is the only jobmanager, the priority can be zero.
     * 
     * @param UnicoreDataMovement
     *   The UnicoreDataMovement object to be added to the resource.
     * 
     * @return status
     *   Returns the unique data movement id.
     * 
     * 
     * @param authzToken
     * @param productUri
     * @param dataMoveType
     * @param priorityOrder
     * @param unicoreDataMovement
     */
    public String addUnicoreDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.UnicoreDataMovement unicoreDataMovement) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Update a selected UNICORE data movement details
     *  App catalog will return a dataMovementInterfaceId which will be added to the dataMovementInterfaces.
     * 
     * @param dataMovementInterfaceId
     *   The identifier of the data movement Interface to be updated.
     * 
     * @param UnicoreDataMovement
     *   The UnicoreDataMovement object to be updated.
     * 
     * @return status
     *   Returns a success/failure of the update.
     * 
     * 
     * 
     * @param authzToken
     * @param dataMovementInterfaceId
     * @param unicoreDataMovement
     */
    public boolean updateUnicoreDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementInterfaceId, org.apache.airavata.model.data.movement.UnicoreDataMovement unicoreDataMovement) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * This method returns UNICORE datamovement object
     * 
     * @param dataMovementId
     *   The identifier of the datamovement Interface to be retrieved.
     * 
     * @return UnicoreDataMovement instance
     * 
     * 
     * 
     * @param authzToken
     * @param dataMovementId
     */
    public org.apache.airavata.model.data.movement.UnicoreDataMovement getUnicoreDataMovement(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Add a GridFTP data movement details to a compute resource
     *  App catalog will return a dataMovementInterfaceId which will be added to the dataMovementInterfaces.
     * 
     * @param productUri
     *   The identifier of the compute resource to which dataMovement protocol to be added
     * 
     * @param DMType
     *    The DMType object to be added to the resource.
     * 
     * @param priorityOrder
     *   Specify the priority of this job manager. If this is the only jobmanager, the priority can be zero.
     * 
     * @param gridFTPDataMovement
     *   The GridFTPDataMovement object to be added to the resource.
     * 
     * @return status
     *   Returns the unique data movement id.
     * 
     * 
     * 
     * @param authzToken
     * @param productUri
     * @param dataMoveType
     * @param priorityOrder
     * @param gridFTPDataMovement
     */
    public String addGridFTPDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.GridFTPDataMovement gridFTPDataMovement) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Update the given GridFTP data movement details to a compute resource
     *  App catalog will return a dataMovementInterfaceId which will be added to the dataMovementInterfaces.
     * 
     * @param dataMovementInterfaceId
     *   The identifier of the data movement Interface to be updated.
     * 
     * @param gridFTPDataMovement
     *   The GridFTPDataMovement object to be updated.
     * 
     * @return boolean
     *   Returns a success/failure of the update.
     * 
     * 
     * 
     * @param authzToken
     * @param dataMovementInterfaceId
     * @param gridFTPDataMovement
     */
    public boolean updateGridFTPDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementInterfaceId, org.apache.airavata.model.data.movement.GridFTPDataMovement gridFTPDataMovement) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * This method returns GridFTP datamovement object
     * 
     * @param dataMovementId
     *   The identifier of the datamovement Interface to be retrieved.
     * 
     *  @return GridFTPDataMovement instance
     * 
     * 
     * 
     * @param authzToken
     * @param dataMovementId
     */
    public org.apache.airavata.model.data.movement.GridFTPDataMovement getGridFTPDataMovement(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Change the priority of a given job submisison interface
     * 
     * @param jobSubmissionInterfaceId
     *   The identifier of the JobSubmission Interface to be changed
     * 
     * @param priorityOrder
     *   The new priority of the job manager interface.
     * 
     * @return status
     *   Returns a success/failure of the change.
     * 
     * 
     * 
     * @param authzToken
     * @param jobSubmissionInterfaceId
     * @param newPriorityOrder
     */
    public boolean changeJobSubmissionPriority(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionInterfaceId, int newPriorityOrder) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Change the priority of a given data movement interface
     * 
     * @param dataMovementInterfaceId
     *   The identifier of the DataMovement Interface to be changed
     * 
     * @param priorityOrder
     *   The new priority of the data movement interface.
     * 
     * @return status
     *   Returns a success/failure of the change.
     * 
     * 
     * 
     * @param authzToken
     * @param dataMovementInterfaceId
     * @param newPriorityOrder
     */
    public boolean changeDataMovementPriority(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementInterfaceId, int newPriorityOrder) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Change the priorities of a given set of job submission interfaces
     * 
     * @param jobSubmissionPriorityMap
     *   A Map of identifiers of the JobSubmission Interfaces and thier associated priorities to be set.
     * 
     * @return status
     *   Returns a success/failure of the changes.
     * 
     * 
     * @param authzToken
     * @param jobSubmissionPriorityMap
     */
    public boolean changeJobSubmissionPriorities(org.apache.airavata.model.security.AuthzToken authzToken, Map<String,Integer> jobSubmissionPriorityMap) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Change the priorities of a given set of data movement interfaces
     * 
     * @param dataMovementPriorityMap
     *   A Map of identifiers of the DataMovement Interfaces and thier associated priorities to be set.
     * 
     * @return status
     *   Returns a success/failure of the changes.
     * 
     * 
     * 
     * @param authzToken
     * @param dataMovementPriorityMap
     */
    public boolean changeDataMovementPriorities(org.apache.airavata.model.security.AuthzToken authzToken, Map<String,Integer> dataMovementPriorityMap) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Delete a given job submisison interface
     * 
     * @param jobSubmissionInterfaceId
     *   The identifier of the JobSubmission Interface to be changed
     * 
     * @return status
     *   Returns a success/failure of the deletion.
     * 
     * 
     * 
     * @param authzToken
     * @param computeResourceId
     * @param jobSubmissionInterfaceId
     */
    public boolean deleteJobSubmissionInterface(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, String jobSubmissionInterfaceId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Delete a given data movement interface
     * 
     * @param dataMovementInterfaceId
     *   The identifier of the DataMovement Interface to be changed
     * 
     * @return status
     *   Returns a success/failure of the deletion.
     * 
     * 
     * 
     * @param authzToken
     * @param productUri
     * @param dataMovementInterfaceId
     * @param dataMoveType
     */
    public boolean deleteDataMovementInterface(org.apache.airavata.model.security.AuthzToken authzToken, String productUri, String dataMovementInterfaceId, org.apache.airavata.model.data.movement.DMType dataMoveType) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    public String registerResourceJobManager(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager resourceJobManager) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    public boolean updateResourceJobManager(org.apache.airavata.model.security.AuthzToken authzToken, String resourceJobManagerId, org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager updatedResourceJobManager) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    public org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager getResourceJobManager(org.apache.airavata.model.security.AuthzToken authzToken, String resourceJobManagerId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    public boolean deleteResourceJobManager(org.apache.airavata.model.security.AuthzToken authzToken, String resourceJobManagerId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Delete a Compute Resource Queue
     * 
     * @param computeResourceId
     *   The identifier of the compute resource which has the queue to be deleted
     * 
     * @param queueName
     *   Name of the queue need to be deleted. Name is the uniqueue identifier for the queue within a compute resource
     * 
     * @return status
     *   Returns a success/failure of the deletion.
     * 
     * 
     * 
     * @param authzToken
     * @param computeResourceId
     * @param queueName
     */
    public boolean deleteBatchQueue(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, String queueName) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Register a Gateway Resource Profile.
     * 
     * @param gatewayResourceProfile
     *    Gateway Resource Profile Object.
     *    The GatewayID should be obtained from Airavata gateway registration and passed to register a corresponding
     *      resource profile.
     * 
     * @return status
     *   Returns a success/failure of the update.
     * 
     * 
     * @param authzToken
     * @param gatewayResourceProfile
     */
    public String registerGatewayResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile gatewayResourceProfile) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Fetch the given Gateway Resource Profile.
     * 
     * @param gatewayID
     *   The identifier for the requested gateway resource.
     * 
     * @return gatewayResourceProfile
     *    Gateway Resource Profile Object.
     * 
     * 
     * @param authzToken
     * @param gatewayID
     */
    public org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile getGatewayResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Update a Gateway Resource Profile.
     * 
     * @param gatewayID
     *   The identifier for the requested gateway resource to be updated.
     * 
     * @param gatewayResourceProfile
     *    Gateway Resource Profile Object.
     * 
     * @return status
     *   Returns a success/failure of the update.
     * 
     * 
     * @param authzToken
     * @param gatewayID
     * @param gatewayResourceProfile
     */
    public boolean updateGatewayResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile gatewayResourceProfile) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Delete the given Gateway Resource Profile.
     * 
     * @param gatewayID
     *   The identifier for the requested gateway resource to be deleted.
     * 
     * @return status
     *   Returns a success/failure of the deletion.
     * 
     * 
     * @param authzToken
     * @param gatewayID
     */
    public boolean deleteGatewayResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Add a Compute Resource Preference to a registered gateway profile.
     * 
     * @param gatewayID
     *   The identifier for the gateway profile to be added.
     * 
     * @param computeResourceId
     *   Preferences related to a particular compute resource
     * 
     * @param computeResourcePreference
     *   The ComputeResourcePreference object to be added to the resource profile.
     * 
     * @return status
     *   Returns a success/failure of the addition. If a profile already exists, this operation will fail.
     *    Instead an update should be used.
     * 
     * 
     * @param authzToken
     * @param gatewayID
     * @param computeResourceId
     * @param computeResourcePreference
     */
    public boolean addGatewayComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String computeResourceId, org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference computeResourcePreference) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Add a Storage Resource Preference to a registered gateway profile.
     * 
     * @param gatewayID
     *   The identifier of the gateway profile to be added.
     * 
     * @param storageResourceId
     *   Preferences related to a particular compute resource
     * 
     * @param computeResourcePreference
     *   The ComputeResourcePreference object to be added to the resource profile.
     * 
     * @return status
     *   Returns a success/failure of the addition. If a profile already exists, this operation will fail.
     *    Instead an update should be used.
     * 
     * 
     * @param authzToken
     * @param gatewayID
     * @param storageResourceId
     * @param storagePreference
     */
    public boolean addGatewayStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String storageResourceId, org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference storagePreference) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Fetch a Compute Resource Preference of a registered gateway profile.
     * 
     * @param gatewayID
     *   The identifier for the gateway profile to be requested
     * 
     * @param computeResourceId
     *   Preferences related to a particular compute resource
     * 
     * @return computeResourcePreference
     *   Returns the ComputeResourcePreference object.
     * 
     * 
     * @param authzToken
     * @param gatewayID
     * @param computeResourceId
     */
    public org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference getGatewayComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String computeResourceId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Fetch a Storage Resource Preference of a registered gateway profile.
     * 
     * @param gatewayID
     *   The identifier of the gateway profile to request to fetch the particular storage resource preference.
     * 
     * @param storageResourceId
     *   Identifier of the Stprage Preference required to be fetched.
     * 
     * @return StoragePreference
     *   Returns the StoragePreference object.
     * 
     * 
     * @param authzToken
     * @param gatewayID
     * @param storageResourceId
     */
    public org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference getGatewayStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String storageResourceId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Fetch all Compute Resource Preferences of a registered gateway profile.
     * 
     * @param gatewayID
     *   The identifier for the gateway profile to be requested
     * 
     * @return computeResourcePreference
     *   Returns the ComputeResourcePreference object.
     * 
     * 
     * @param authzToken
     * @param gatewayID
     */
    public List<org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference> getAllGatewayComputeResourcePreferences(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Fetch all Storage Resource Preferences of a registered gateway profile.
     * 
     * @param gatewayID
     *   The identifier for the gateway profile to be requested
     * 
     * @return StoragePreference
     *   Returns the StoragePreference object.
     * 
     * 
     * @param authzToken
     * @param gatewayID
     */
    public List<org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference> getAllGatewayStoragePreferences(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Fetch all Gateway Profiles registered
     * 
     * @return GatewayResourceProfile
     *   Returns all the GatewayResourcePrifle list object.
     * 
     * 
     * 
     * @param authzToken
     */
    public List<org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile> getAllGatewayResourceProfiles(org.apache.airavata.model.security.AuthzToken authzToken) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Update a Compute Resource Preference to a registered gateway profile.
     * 
     * @param gatewayID
     *   The identifier for the gateway profile to be updated.
     * 
     * @param computeResourceId
     *   Preferences related to a particular compute resource
     * 
     * @param computeResourcePreference
     *   The ComputeResourcePreference object to be updated to the resource profile.
     * 
     * @return status
     *   Returns a success/failure of the updation.
     * 
     * 
     * @param authzToken
     * @param gatewayID
     * @param computeResourceId
     * @param computeResourcePreference
     */
    public boolean updateGatewayComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String computeResourceId, org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference computeResourcePreference) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Update a Storage Resource Preference of a registered gateway profile.
     * 
     * @param gatewayID
     *   The identifier of the gateway profile to be updated.
     * 
     * @param storageId
     *   The Storage resource identifier of the one that you want to update
     * 
     * @param storagePreference
     *   The storagePreference object to be updated to the resource profile.
     * 
     * @return status
     *   Returns a success/failure of the updation.
     * 
     * 
     * @param authzToken
     * @param gatewayID
     * @param storageId
     * @param storagePreference
     */
    public boolean updateGatewayStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String storageId, org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference storagePreference) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Delete the Compute Resource Preference of a registered gateway profile.
     * 
     * @param gatewayID
     *   The identifier for the gateway profile to be deleted.
     * 
     * @param computeResourceId
     *   Preferences related to a particular compute resource
     * 
     * @return status
     *   Returns a success/failure of the deletion.
     * 
     * 
     * @param authzToken
     * @param gatewayID
     * @param computeResourceId
     */
    public boolean deleteGatewayComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String computeResourceId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Delete the Storage Resource Preference of a registered gateway profile.
     * 
     * @param gatewayID
     *   The identifier of the gateway profile to be deleted.
     * 
     * @param storageId
     *   ID of the storage preference you want to delete.
     * 
     * @return status
     *   Returns a success/failure of the deletion.
     * 
     * 
     * @param authzToken
     * @param gatewayID
     * @param storageId
     */
    public boolean deleteGatewayStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String storageId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    public List<org.apache.airavata.model.appcatalog.accountprovisioning.SSHAccountProvisioner> getSSHAccountProvisioners(org.apache.airavata.model.security.AuthzToken authzToken) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Check if user has an SSH account on the given compute resource. This
     * method will only work if the compute resource has an SSHAccountProvisioner configured for it.
     * 
     * @param authzToken
     * @param computeResourceId
     * @param userId
     */
    public boolean doesUserHaveSSHAccount(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, String userId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Check if SSH account setup is complete for this user on the given compute resource.
     * 
     * @param authzToken
     * @param computeResourceId
     * @param airavataCredStoreToken
     */
    public boolean isSSHSetupCompleteForUserComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, String airavataCredStoreToken) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Setup and return a UserComputeResourcePreference object for this user to SSH into the given compute resource with
     * the given SSH credential. This method will only work if the compute resource has an SSHAccountProvisioner
     * configured for it. The returned UserComputeResourcePreference object is not saved; it is up to the client to
     * call addUserComputeResourcePreference to persist it.
     * 
     * @param authzToken
     * @param computeResourceId
     * @param userId
     * @param airavataCredStoreToken
     */
    public org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference setupUserComputeResourcePreferencesForSSH(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, String userId, String airavataCredStoreToken) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Register User Resource Profile.
     * 
     * @param UserResourceProfile
     *    User Resource Profile Object.
     *    The userId should be obtained from Airavata user profile data model and passed to register a corresponding
     *      resource profile.
     * 
     * @return status
     *   Returns a success/failure of the update.
     * 
     * 
     * @param authzToken
     * @param userResourceProfile
     */
    public String registerUserResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile userResourceProfile) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Fetch the given User Resource Profile.
     * 
     * @param userId
     *   The identifier for the requested user resource profile.
     * 
     * @param gatewayID
     *   The identifier to link a gateway for the requested user resource profile.
     * 
     * @return UserResourceProfile
     *    User Resource Profile Object.
     * 
     * 
     * @param authzToken
     * @param userId
     * @param gatewayID
     */
    public org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile getUserResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Update a User Resource Profile.
     * 
     * @param userId
     *   The identifier for the requested user resource to be updated.
     * 
     * @param gatewayID
     *   The identifier to link a gateway for the requested user resource profile.
     * 
     * @param UserResourceProfile
     *    User Resource Profile Object.
     * 
     * @return status
     *   Returns a success/failure of the update.
     * 
     * 
     * @param authzToken
     * @param userId
     * @param gatewayID
     * @param userResourceProfile
     */
    public boolean updateUserResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile userResourceProfile) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Delete the given User Resource Profile.
     * 
     * @param userId
     *   The identifier for the requested user resource to be deleted.
     * 
     * @param gatewayID
     *   The identifier to link a gateway for the requested user resource profile.
     * 
     * @return status
     *   Returns a success/failure of the deletion.
     * 
     * 
     * @param authzToken
     * @param userId
     * @param gatewayID
     */
    public boolean deleteUserResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Add a Compute Resource Preference to a registered User profile.
     * 
     * @param userId
     *   The identifier for the User resource profile to be added.
     * 
     * @param gatewayID
     *   The identifier to link a gateway for the requested user resource profile.
     * 
     * @param computeResourceId
     *   Preferences related to a particular compute resource
     * 
     * @param computeResourcePreference
     *   The ComputeResourcePreference object to be added to the resource profile.
     * 
     * @return status
     *   Returns a success/failure of the addition. If a profile already exists, this operation will fail.
     *    Instead an update should be used.
     * 
     * 
     * @param authzToken
     * @param userId
     * @param gatewayID
     * @param userComputeResourceId
     * @param userComputeResourcePreference
     */
    public boolean addUserComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userComputeResourceId, org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference userComputeResourcePreference) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Add a Storage Resource Preference to a registered user resource profile.
     * 
     * @param userId
     *   The identifier of the user resource profile to be added.
     * 
     * @param gatewayID
     *   The identifier to link a gateway for the requested user resource profile.
     * 
     * @param storageResourceId
     *   Preferences related to a particular compute resource
     * 
     * @param computeResourcePreference
     *   The ComputeResourcePreference object to be added to the resource profile.
     * 
     * @return status
     *   Returns a success/failure of the addition. If a profile already exists, this operation will fail.
     *    Instead an update should be used.
     * 
     * 
     * @param authzToken
     * @param userId
     * @param gatewayID
     * @param userStorageResourceId
     * @param userStoragePreference
     */
    public boolean addUserStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userStorageResourceId, org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference userStoragePreference) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Fetch a Compute Resource Preference of a registered user resource profile.
     * 
     * @param userId
     *   The identifier for the user profile to be requested
     * 
     * @param gatewayID
     *   The identifier to link a gateway for the requested user resource profile.
     * 
     * @param userComputeResourceId
     *   Preferences related to a particular compute resource
     * 
     * @return computeResourcePreference
     *   Returns the ComputeResourcePreference object.
     * 
     * 
     * @param authzToken
     * @param userId
     * @param gatewayID
     * @param userComputeResourceId
     */
    public org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference getUserComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userComputeResourceId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Fetch a Storage Resource Preference of a registered user resource profile.
     * 
     * @param userId
     *   The identifier of the user resource profile to request to fetch the particular storage resource preference.
     * 
     * @param gatewayID
     *   The identifier to link a gateway for the requested user resource profile.
     * 
     * @param userStorageResourceId
     *   Identifier of the Stprage Preference required to be fetched.
     * 
     * @return UserStoragePreference
     *   Returns the StoragePreference object.
     * 
     * 
     * @param authzToken
     * @param userId
     * @param gatewayID
     * @param userStorageResourceId
     */
    public org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference getUserStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userStorageResourceId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Fetch all Compute Resource Preferences of a registered gateway profile.
     * 
     * @param userId
     *   The identifier of the user resource profile to request to fetch the particular storage resource preference.
     * 
     * @param gatewayID
     *   The identifier for the gateway profile to be requested
     * 
     * @return computeResourcePreference
     *   Returns the ComputeResourcePreference object.
     * 
     * 
     * @param authzToken
     * @param userId
     * @param gatewayID
     */
    public List<org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference> getAllUserComputeResourcePreferences(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Fetch all User Storage Resource Preferences of a registered user profile.
     * 
     * @param userId
     *   The identifier of the user resource profile to request to fetch the particular storage resource preference.
     * 
     * @param gatewayID
     *   The identifier for the gateway profile to be requested
     * 
     * @return StoragePreference
     *   Returns the StoragePreference object.
     * 
     * 
     * @param authzToken
     * @param userId
     * @param gatewayID
     */
    public List<org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference> getAllUserStoragePreferences(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * Fetch all user resources Profiles registered
     * 
     * @return UserResourceProfile
     *   Returns all the UserResourcePrifle list object.
     * 
     * 
     * 
     * @param authzToken
     */
    public List<org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile> getAllUserResourceProfiles(org.apache.airavata.model.security.AuthzToken authzToken) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Update a Compute Resource Preference to a registered user resource profile.
     * 
     * @param userId
     *   The identifier for the user profile to be updated.
     * 
     * @param gatewayID
     *   The identifier to link a gateway for the requested user resource profile.
     * 
     * @param userComputeResourceId
     *   Preferences related to a particular compute resource
     * 
     * @param userComputeResourcePreference
     *   The ComputeResourcePreference object to be updated to the resource profile.
     * 
     * @return status
     *   Returns a success/failure of the updation.
     * 
     * 
     * @param authzToken
     * @param userId
     * @param gatewayID
     * @param userComputeResourceId
     * @param userComputeResourcePreference
     */
    public boolean updateUserComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userComputeResourceId, org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference userComputeResourcePreference) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Update a Storage Resource Preference of a registered user resource profile.
     * 
     * @param userId
     *   The identifier of the user resource profile to be updated.
     * 
     * @param gatewayID
     *   The identifier to link a gateway for the requested user resource profile.
     * 
     * @param userStorageId
     *   The Storage resource identifier of the one that you want to update
     * 
     * @param userStoragePreference
     *   The storagePreference object to be updated to the resource profile.
     * 
     * @return status
     *   Returns a success/failure of the updation.
     * 
     * 
     * @param authzToken
     * @param userId
     * @param gatewayID
     * @param userStorageId
     * @param userStoragePreference
     */
    public boolean updateUserStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userStorageId, org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference userStoragePreference) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Delete the Compute Resource Preference of a registered user resource profile.
     * 
     * @param userId
     *   The identifier for the user resource profile to be deleted.
     * 
     * @param gatewayID
     *   The identifier to link a gateway for the requested user resource profile.
     * 
     * @param userComputeResourceId
     *   Preferences related to a particular compute resource
     * 
     * @return status
     *   Returns a success/failure of the deletion.
     * 
     * 
     * @param authzToken
     * @param userId
     * @param gatewayID
     * @param userComputeResourceId
     */
    public boolean deleteUserComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userComputeResourceId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Delete the Storage Resource Preference of a registered user resource profile.
     * 
     * @param userId
     *   The identifier of the user profile to be deleted.
     * 
     * @param gatewayID
     *   The identifier to link a gateway for the requested user resource profile.
     * 
     * @param userStorageId
     *   ID of the storage preference you want to delete.
     * 
     * @return status
     *   Returns a success/failure of the deletion.
     * 
     * 
     * @param authzToken
     * @param userId
     * @param gatewayID
     * @param userStorageId
     */
    public boolean deleteUserStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userStorageId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    public List<String> getAllWorkflows(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    public List<org.apache.airavata.model.status.QueueStatusModel> getLatestQueueStatuses(org.apache.airavata.model.security.AuthzToken authzToken) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * 
     * API Methods Related for Work-Flow Submission Features.
     * 
     * 
     * @param authzToken
     * @param workflowTemplateId
     */
    public org.apache.airavata.model.WorkflowModel getWorkflow(org.apache.airavata.model.security.AuthzToken authzToken, String workflowTemplateId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    public void deleteWorkflow(org.apache.airavata.model.security.AuthzToken authzToken, String workflowTemplateId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    public String registerWorkflow(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.WorkflowModel workflow) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    public void updateWorkflow(org.apache.airavata.model.security.AuthzToken authzToken, String workflowTemplateId, org.apache.airavata.model.WorkflowModel workflow) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    public String getWorkflowTemplateId(org.apache.airavata.model.security.AuthzToken authzToken, String workflowName) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    public boolean isWorkflowExistWithName(org.apache.airavata.model.security.AuthzToken authzToken, String workflowName) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * API Methods related to replica catalog
     * 
     * 
     * @param authzToken
     * @param dataProductModel
     */
    public String registerDataProduct(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.data.replica.DataProductModel dataProductModel) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    public org.apache.airavata.model.data.replica.DataProductModel getDataProduct(org.apache.airavata.model.security.AuthzToken authzToken, String dataProductUri) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    public String registerReplicaLocation(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.data.replica.DataReplicaLocationModel replicaLocationModel) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    public org.apache.airavata.model.data.replica.DataProductModel getParentDataProduct(org.apache.airavata.model.security.AuthzToken authzToken, String productUri) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    public List<org.apache.airavata.model.data.replica.DataProductModel> getChildDataProducts(org.apache.airavata.model.security.AuthzToken authzToken, String productUri) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    /**
     * Group Manager and Data Sharing Related API methods
     * 
     * 
     * @param authzToken
     * @param resourceId
     * @param resourceType
     * @param userPermissionList
     */
    public boolean shareResourceWithUsers(org.apache.airavata.model.security.AuthzToken authzToken, String resourceId, org.apache.airavata.model.group.ResourceType resourceType, Map<String,org.apache.airavata.model.group.ResourcePermissionType> userPermissionList) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    public boolean revokeSharingOfResourceFromUsers(org.apache.airavata.model.security.AuthzToken authzToken, String resourceId, org.apache.airavata.model.group.ResourceType resourceType, Map<String,org.apache.airavata.model.group.ResourcePermissionType> userPermissionList) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    public List<String> getAllAccessibleUsers(org.apache.airavata.model.security.AuthzToken authzToken, String resourceId, org.apache.airavata.model.group.ResourceType resourceType, org.apache.airavata.model.group.ResourcePermissionType permissionType) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    public String createGroup(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.group.GroupModel groupModel) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    public boolean updateGroup(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.group.GroupModel groupModel) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    public boolean deleteGroup(org.apache.airavata.model.security.AuthzToken authzToken, String groupId, String ownerId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    public org.apache.airavata.model.group.GroupModel getGroup(org.apache.airavata.model.security.AuthzToken authzToken, String groupId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

    public List<org.apache.airavata.model.group.GroupModel> getAllGroupsUserBelongs(org.apache.airavata.model.security.AuthzToken authzToken, String userName) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException;

  }

  public interface AsyncIface {

    public void getAPIVersion(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void isUserExists(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String userName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void addGateway(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.workspace.Gateway gateway, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllUsersInGateway(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateGateway(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.workspace.Gateway updatedGateway, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getGateway(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteGateway(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllGateways(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void isGatewayExist(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void createNotification(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.workspace.Notification notification, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateNotification(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.workspace.Notification notification, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteNotification(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String notificationId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getNotification(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String notificationId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllNotifications(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void generateAndRegisterSSHKeys(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String userName, String description, org.apache.airavata.model.credential.store.CredentialOwnerType credentialOwnerType, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void registerPwdCredential(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String portalUserName, String loginUserName, String password, String description, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getSSHPubKey(org.apache.airavata.model.security.AuthzToken authzToken, String airavataCredStoreToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllGatewaySSHPubKeys(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllCredentialSummaryForGateway(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.credential.store.SummaryType type, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllCredentialSummaryForUsersInGateway(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.credential.store.SummaryType type, String gatewayId, String userId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllGatewayPWDCredentials(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteSSHPubKey(org.apache.airavata.model.security.AuthzToken authzToken, String airavataCredStoreToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deletePWDCredential(org.apache.airavata.model.security.AuthzToken authzToken, String airavataCredStoreToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void createProject(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.workspace.Project project, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateProject(org.apache.airavata.model.security.AuthzToken authzToken, String projectId, org.apache.airavata.model.workspace.Project updatedProject, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getProject(org.apache.airavata.model.security.AuthzToken authzToken, String projectId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteProject(org.apache.airavata.model.security.AuthzToken authzToken, String projectId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getUserProjects(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String userName, int limit, int offset, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void searchProjects(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String userName, Map<org.apache.airavata.model.experiment.ProjectSearchFields,String> filters, int limit, int offset, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void searchExperiments(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String userName, Map<org.apache.airavata.model.experiment.ExperimentSearchFields,String> filters, int limit, int offset, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getExperimentStatistics(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, long fromTime, long toTime, String userName, String applicationName, String resourceHostName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getExperimentsInProject(org.apache.airavata.model.security.AuthzToken authzToken, String projectId, int limit, int offset, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getUserExperiments(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String userName, int limit, int offset, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void createExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.experiment.ExperimentModel experiment, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String experimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getExperimentByAdmin(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getDetailedExperimentTree(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.airavata.model.experiment.ExperimentModel experiment, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateExperimentConfiguration(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.airavata.model.experiment.UserConfigurationDataModel userConfiguration, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateResourceScheduleing(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel resourceScheduling, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void validateExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void launchExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getExperimentStatus(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getExperimentOutputs(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getIntermediateOutputs(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getJobStatuses(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getJobDetails(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void cloneExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String existingExperimentID, String newExperimentName, String newExperimentProjectId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void cloneExperimentByAdmin(org.apache.airavata.model.security.AuthzToken authzToken, String existingExperimentID, String newExperimentName, String newExperimentProjectId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void terminateExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void registerApplicationModule(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule applicationModule, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getApplicationModule(org.apache.airavata.model.security.AuthzToken authzToken, String appModuleId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateApplicationModule(org.apache.airavata.model.security.AuthzToken authzToken, String appModuleId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule applicationModule, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllAppModules(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteApplicationModule(org.apache.airavata.model.security.AuthzToken authzToken, String appModuleId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void registerApplicationDeployment(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription applicationDeployment, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getApplicationDeployment(org.apache.airavata.model.security.AuthzToken authzToken, String appDeploymentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateApplicationDeployment(org.apache.airavata.model.security.AuthzToken authzToken, String appDeploymentId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription applicationDeployment, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteApplicationDeployment(org.apache.airavata.model.security.AuthzToken authzToken, String appDeploymentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllApplicationDeployments(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAppModuleDeployedResources(org.apache.airavata.model.security.AuthzToken authzToken, String appModuleId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void registerApplicationInterface(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription applicationInterface, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void cloneApplicationInterface(org.apache.airavata.model.security.AuthzToken authzToken, String existingAppInterfaceID, String newApplicationName, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getApplicationInterface(org.apache.airavata.model.security.AuthzToken authzToken, String appInterfaceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateApplicationInterface(org.apache.airavata.model.security.AuthzToken authzToken, String appInterfaceId, org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription applicationInterface, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteApplicationInterface(org.apache.airavata.model.security.AuthzToken authzToken, String appInterfaceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllApplicationInterfaceNames(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllApplicationInterfaces(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getApplicationInputs(org.apache.airavata.model.security.AuthzToken authzToken, String appInterfaceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getApplicationOutputs(org.apache.airavata.model.security.AuthzToken authzToken, String appInterfaceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAvailableAppInterfaceComputeResources(org.apache.airavata.model.security.AuthzToken authzToken, String appInterfaceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void registerComputeResource(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription computeResourceDescription, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getComputeResource(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllComputeResourceNames(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateComputeResource(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription computeResourceDescription, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteComputeResource(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void registerStorageResource(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription storageResourceDescription, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getStorageResource(org.apache.airavata.model.security.AuthzToken authzToken, String storageResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllStorageResourceNames(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateStorageResource(org.apache.airavata.model.security.AuthzToken authzToken, String storageResourceId, org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription storageResourceDescription, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteStorageResource(org.apache.airavata.model.security.AuthzToken authzToken, String storageResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void addLocalSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission localSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateLocalSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission localSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getLocalJobSubmission(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void addSSHJobSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void addSSHForkJobSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getSSHJobSubmission(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void addUNICOREJobSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission unicoreJobSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getUnicoreJobSubmission(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void addCloudJobSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission cloudSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getCloudJobSubmission(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateSSHJobSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateCloudJobSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission sshJobSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateUnicoreJobSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission unicoreJobSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void addLocalDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.LOCALDataMovement localDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateLocalDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementInterfaceId, org.apache.airavata.model.data.movement.LOCALDataMovement localDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getLocalDataMovement(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void addSCPDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.SCPDataMovement scpDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateSCPDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementInterfaceId, org.apache.airavata.model.data.movement.SCPDataMovement scpDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getSCPDataMovement(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void addUnicoreDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.UnicoreDataMovement unicoreDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateUnicoreDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementInterfaceId, org.apache.airavata.model.data.movement.UnicoreDataMovement unicoreDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getUnicoreDataMovement(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void addGridFTPDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.GridFTPDataMovement gridFTPDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateGridFTPDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementInterfaceId, org.apache.airavata.model.data.movement.GridFTPDataMovement gridFTPDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getGridFTPDataMovement(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void changeJobSubmissionPriority(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionInterfaceId, int newPriorityOrder, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void changeDataMovementPriority(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementInterfaceId, int newPriorityOrder, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void changeJobSubmissionPriorities(org.apache.airavata.model.security.AuthzToken authzToken, Map<String,Integer> jobSubmissionPriorityMap, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void changeDataMovementPriorities(org.apache.airavata.model.security.AuthzToken authzToken, Map<String,Integer> dataMovementPriorityMap, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteJobSubmissionInterface(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, String jobSubmissionInterfaceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteDataMovementInterface(org.apache.airavata.model.security.AuthzToken authzToken, String productUri, String dataMovementInterfaceId, org.apache.airavata.model.data.movement.DMType dataMoveType, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void registerResourceJobManager(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager resourceJobManager, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateResourceJobManager(org.apache.airavata.model.security.AuthzToken authzToken, String resourceJobManagerId, org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager updatedResourceJobManager, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getResourceJobManager(org.apache.airavata.model.security.AuthzToken authzToken, String resourceJobManagerId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteResourceJobManager(org.apache.airavata.model.security.AuthzToken authzToken, String resourceJobManagerId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteBatchQueue(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, String queueName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void registerGatewayResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile gatewayResourceProfile, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getGatewayResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateGatewayResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile gatewayResourceProfile, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteGatewayResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void addGatewayComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String computeResourceId, org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference computeResourcePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void addGatewayStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String storageResourceId, org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference storagePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getGatewayComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String computeResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getGatewayStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String storageResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllGatewayComputeResourcePreferences(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllGatewayStoragePreferences(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllGatewayResourceProfiles(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateGatewayComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String computeResourceId, org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference computeResourcePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateGatewayStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String storageId, org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference storagePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteGatewayComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String computeResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteGatewayStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String storageId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getSSHAccountProvisioners(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void doesUserHaveSSHAccount(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, String userId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void isSSHSetupCompleteForUserComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, String airavataCredStoreToken, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void setupUserComputeResourcePreferencesForSSH(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, String userId, String airavataCredStoreToken, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void registerUserResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile userResourceProfile, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getUserResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateUserResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile userResourceProfile, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteUserResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void addUserComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userComputeResourceId, org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference userComputeResourcePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void addUserStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userStorageResourceId, org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference userStoragePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getUserComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userComputeResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getUserStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userStorageResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllUserComputeResourcePreferences(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllUserStoragePreferences(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllUserResourceProfiles(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateUserComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userComputeResourceId, org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference userComputeResourcePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateUserStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userStorageId, org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference userStoragePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteUserComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userComputeResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteUserStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userStorageId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllWorkflows(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getLatestQueueStatuses(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getWorkflow(org.apache.airavata.model.security.AuthzToken authzToken, String workflowTemplateId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteWorkflow(org.apache.airavata.model.security.AuthzToken authzToken, String workflowTemplateId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void registerWorkflow(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.WorkflowModel workflow, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateWorkflow(org.apache.airavata.model.security.AuthzToken authzToken, String workflowTemplateId, org.apache.airavata.model.WorkflowModel workflow, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getWorkflowTemplateId(org.apache.airavata.model.security.AuthzToken authzToken, String workflowName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void isWorkflowExistWithName(org.apache.airavata.model.security.AuthzToken authzToken, String workflowName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void registerDataProduct(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.data.replica.DataProductModel dataProductModel, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getDataProduct(org.apache.airavata.model.security.AuthzToken authzToken, String dataProductUri, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void registerReplicaLocation(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.data.replica.DataReplicaLocationModel replicaLocationModel, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getParentDataProduct(org.apache.airavata.model.security.AuthzToken authzToken, String productUri, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getChildDataProducts(org.apache.airavata.model.security.AuthzToken authzToken, String productUri, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void shareResourceWithUsers(org.apache.airavata.model.security.AuthzToken authzToken, String resourceId, org.apache.airavata.model.group.ResourceType resourceType, Map<String,org.apache.airavata.model.group.ResourcePermissionType> userPermissionList, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void revokeSharingOfResourceFromUsers(org.apache.airavata.model.security.AuthzToken authzToken, String resourceId, org.apache.airavata.model.group.ResourceType resourceType, Map<String,org.apache.airavata.model.group.ResourcePermissionType> userPermissionList, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllAccessibleUsers(org.apache.airavata.model.security.AuthzToken authzToken, String resourceId, org.apache.airavata.model.group.ResourceType resourceType, org.apache.airavata.model.group.ResourcePermissionType permissionType, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void createGroup(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.group.GroupModel groupModel, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void updateGroup(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.group.GroupModel groupModel, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void deleteGroup(org.apache.airavata.model.security.AuthzToken authzToken, String groupId, String ownerId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getGroup(org.apache.airavata.model.security.AuthzToken authzToken, String groupId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

    public void getAllGroupsUserBelongs(org.apache.airavata.model.security.AuthzToken authzToken, String userName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException;

  }

  public static class Client extends org.apache.thrift.TServiceClient implements Iface {
    public static class Factory implements org.apache.thrift.TServiceClientFactory<Client> {
      public Factory() {}
      public Client getClient(org.apache.thrift.protocol.TProtocol prot) {
        return new Client(prot);
      }
      public Client getClient(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
        return new Client(iprot, oprot);
      }
    }

    public Client(org.apache.thrift.protocol.TProtocol prot)
    {
      super(prot, prot);
    }

    public Client(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
      super(iprot, oprot);
    }

    public String getAPIVersion(org.apache.airavata.model.security.AuthzToken authzToken) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getAPIVersion(authzToken);
      return recv_getAPIVersion();
    }

    public void send_getAPIVersion(org.apache.airavata.model.security.AuthzToken authzToken) throws org.apache.thrift.TException
    {
      getAPIVersion_args args = new getAPIVersion_args();
      args.setAuthzToken(authzToken);
      sendBase("getAPIVersion", args);
    }

    public String recv_getAPIVersion() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getAPIVersion_result result = new getAPIVersion_result();
      receiveBase(result, "getAPIVersion");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAPIVersion failed: unknown result");
    }

    public boolean isUserExists(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String userName) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_isUserExists(authzToken, gatewayId, userName);
      return recv_isUserExists();
    }

    public void send_isUserExists(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String userName) throws org.apache.thrift.TException
    {
      isUserExists_args args = new isUserExists_args();
      args.setAuthzToken(authzToken);
      args.setGatewayId(gatewayId);
      args.setUserName(userName);
      sendBase("isUserExists", args);
    }

    public boolean recv_isUserExists() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      isUserExists_result result = new isUserExists_result();
      receiveBase(result, "isUserExists");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "isUserExists failed: unknown result");
    }

    public String addGateway(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.workspace.Gateway gateway) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_addGateway(authzToken, gateway);
      return recv_addGateway();
    }

    public void send_addGateway(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.workspace.Gateway gateway) throws org.apache.thrift.TException
    {
      addGateway_args args = new addGateway_args();
      args.setAuthzToken(authzToken);
      args.setGateway(gateway);
      sendBase("addGateway", args);
    }

    public String recv_addGateway() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      addGateway_result result = new addGateway_result();
      receiveBase(result, "addGateway");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "addGateway failed: unknown result");
    }

    public List<String> getAllUsersInGateway(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getAllUsersInGateway(authzToken, gatewayId);
      return recv_getAllUsersInGateway();
    }

    public void send_getAllUsersInGateway(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId) throws org.apache.thrift.TException
    {
      getAllUsersInGateway_args args = new getAllUsersInGateway_args();
      args.setAuthzToken(authzToken);
      args.setGatewayId(gatewayId);
      sendBase("getAllUsersInGateway", args);
    }

    public List<String> recv_getAllUsersInGateway() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getAllUsersInGateway_result result = new getAllUsersInGateway_result();
      receiveBase(result, "getAllUsersInGateway");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllUsersInGateway failed: unknown result");
    }

    public boolean updateGateway(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.workspace.Gateway updatedGateway) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_updateGateway(authzToken, gatewayId, updatedGateway);
      return recv_updateGateway();
    }

    public void send_updateGateway(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.workspace.Gateway updatedGateway) throws org.apache.thrift.TException
    {
      updateGateway_args args = new updateGateway_args();
      args.setAuthzToken(authzToken);
      args.setGatewayId(gatewayId);
      args.setUpdatedGateway(updatedGateway);
      sendBase("updateGateway", args);
    }

    public boolean recv_updateGateway() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      updateGateway_result result = new updateGateway_result();
      receiveBase(result, "updateGateway");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateGateway failed: unknown result");
    }

    public org.apache.airavata.model.workspace.Gateway getGateway(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getGateway(authzToken, gatewayId);
      return recv_getGateway();
    }

    public void send_getGateway(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId) throws org.apache.thrift.TException
    {
      getGateway_args args = new getGateway_args();
      args.setAuthzToken(authzToken);
      args.setGatewayId(gatewayId);
      sendBase("getGateway", args);
    }

    public org.apache.airavata.model.workspace.Gateway recv_getGateway() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getGateway_result result = new getGateway_result();
      receiveBase(result, "getGateway");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getGateway failed: unknown result");
    }

    public boolean deleteGateway(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_deleteGateway(authzToken, gatewayId);
      return recv_deleteGateway();
    }

    public void send_deleteGateway(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId) throws org.apache.thrift.TException
    {
      deleteGateway_args args = new deleteGateway_args();
      args.setAuthzToken(authzToken);
      args.setGatewayId(gatewayId);
      sendBase("deleteGateway", args);
    }

    public boolean recv_deleteGateway() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      deleteGateway_result result = new deleteGateway_result();
      receiveBase(result, "deleteGateway");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteGateway failed: unknown result");
    }

    public List<org.apache.airavata.model.workspace.Gateway> getAllGateways(org.apache.airavata.model.security.AuthzToken authzToken) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getAllGateways(authzToken);
      return recv_getAllGateways();
    }

    public void send_getAllGateways(org.apache.airavata.model.security.AuthzToken authzToken) throws org.apache.thrift.TException
    {
      getAllGateways_args args = new getAllGateways_args();
      args.setAuthzToken(authzToken);
      sendBase("getAllGateways", args);
    }

    public List<org.apache.airavata.model.workspace.Gateway> recv_getAllGateways() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getAllGateways_result result = new getAllGateways_result();
      receiveBase(result, "getAllGateways");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllGateways failed: unknown result");
    }

    public boolean isGatewayExist(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_isGatewayExist(authzToken, gatewayId);
      return recv_isGatewayExist();
    }

    public void send_isGatewayExist(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId) throws org.apache.thrift.TException
    {
      isGatewayExist_args args = new isGatewayExist_args();
      args.setAuthzToken(authzToken);
      args.setGatewayId(gatewayId);
      sendBase("isGatewayExist", args);
    }

    public boolean recv_isGatewayExist() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      isGatewayExist_result result = new isGatewayExist_result();
      receiveBase(result, "isGatewayExist");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "isGatewayExist failed: unknown result");
    }

    public String createNotification(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.workspace.Notification notification) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_createNotification(authzToken, notification);
      return recv_createNotification();
    }

    public void send_createNotification(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.workspace.Notification notification) throws org.apache.thrift.TException
    {
      createNotification_args args = new createNotification_args();
      args.setAuthzToken(authzToken);
      args.setNotification(notification);
      sendBase("createNotification", args);
    }

    public String recv_createNotification() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      createNotification_result result = new createNotification_result();
      receiveBase(result, "createNotification");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "createNotification failed: unknown result");
    }

    public boolean updateNotification(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.workspace.Notification notification) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_updateNotification(authzToken, notification);
      return recv_updateNotification();
    }

    public void send_updateNotification(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.workspace.Notification notification) throws org.apache.thrift.TException
    {
      updateNotification_args args = new updateNotification_args();
      args.setAuthzToken(authzToken);
      args.setNotification(notification);
      sendBase("updateNotification", args);
    }

    public boolean recv_updateNotification() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      updateNotification_result result = new updateNotification_result();
      receiveBase(result, "updateNotification");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateNotification failed: unknown result");
    }

    public boolean deleteNotification(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String notificationId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_deleteNotification(authzToken, gatewayId, notificationId);
      return recv_deleteNotification();
    }

    public void send_deleteNotification(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String notificationId) throws org.apache.thrift.TException
    {
      deleteNotification_args args = new deleteNotification_args();
      args.setAuthzToken(authzToken);
      args.setGatewayId(gatewayId);
      args.setNotificationId(notificationId);
      sendBase("deleteNotification", args);
    }

    public boolean recv_deleteNotification() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      deleteNotification_result result = new deleteNotification_result();
      receiveBase(result, "deleteNotification");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteNotification failed: unknown result");
    }

    public org.apache.airavata.model.workspace.Notification getNotification(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String notificationId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getNotification(authzToken, gatewayId, notificationId);
      return recv_getNotification();
    }

    public void send_getNotification(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String notificationId) throws org.apache.thrift.TException
    {
      getNotification_args args = new getNotification_args();
      args.setAuthzToken(authzToken);
      args.setGatewayId(gatewayId);
      args.setNotificationId(notificationId);
      sendBase("getNotification", args);
    }

    public org.apache.airavata.model.workspace.Notification recv_getNotification() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getNotification_result result = new getNotification_result();
      receiveBase(result, "getNotification");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getNotification failed: unknown result");
    }

    public List<org.apache.airavata.model.workspace.Notification> getAllNotifications(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getAllNotifications(authzToken, gatewayId);
      return recv_getAllNotifications();
    }

    public void send_getAllNotifications(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId) throws org.apache.thrift.TException
    {
      getAllNotifications_args args = new getAllNotifications_args();
      args.setAuthzToken(authzToken);
      args.setGatewayId(gatewayId);
      sendBase("getAllNotifications", args);
    }

    public List<org.apache.airavata.model.workspace.Notification> recv_getAllNotifications() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getAllNotifications_result result = new getAllNotifications_result();
      receiveBase(result, "getAllNotifications");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllNotifications failed: unknown result");
    }

    public String generateAndRegisterSSHKeys(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String userName, String description, org.apache.airavata.model.credential.store.CredentialOwnerType credentialOwnerType) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.thrift.TException
    {
      send_generateAndRegisterSSHKeys(authzToken, gatewayId, userName, description, credentialOwnerType);
      return recv_generateAndRegisterSSHKeys();
    }

    public void send_generateAndRegisterSSHKeys(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String userName, String description, org.apache.airavata.model.credential.store.CredentialOwnerType credentialOwnerType) throws org.apache.thrift.TException
    {
      generateAndRegisterSSHKeys_args args = new generateAndRegisterSSHKeys_args();
      args.setAuthzToken(authzToken);
      args.setGatewayId(gatewayId);
      args.setUserName(userName);
      args.setDescription(description);
      args.setCredentialOwnerType(credentialOwnerType);
      sendBase("generateAndRegisterSSHKeys", args);
    }

    public String recv_generateAndRegisterSSHKeys() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.thrift.TException
    {
      generateAndRegisterSSHKeys_result result = new generateAndRegisterSSHKeys_result();
      receiveBase(result, "generateAndRegisterSSHKeys");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "generateAndRegisterSSHKeys failed: unknown result");
    }

    public String registerPwdCredential(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String portalUserName, String loginUserName, String password, String description) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.thrift.TException
    {
      send_registerPwdCredential(authzToken, gatewayId, portalUserName, loginUserName, password, description);
      return recv_registerPwdCredential();
    }

    public void send_registerPwdCredential(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String portalUserName, String loginUserName, String password, String description) throws org.apache.thrift.TException
    {
      registerPwdCredential_args args = new registerPwdCredential_args();
      args.setAuthzToken(authzToken);
      args.setGatewayId(gatewayId);
      args.setPortalUserName(portalUserName);
      args.setLoginUserName(loginUserName);
      args.setPassword(password);
      args.setDescription(description);
      sendBase("registerPwdCredential", args);
    }

    public String recv_registerPwdCredential() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.thrift.TException
    {
      registerPwdCredential_result result = new registerPwdCredential_result();
      receiveBase(result, "registerPwdCredential");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "registerPwdCredential failed: unknown result");
    }

    public String getSSHPubKey(org.apache.airavata.model.security.AuthzToken authzToken, String airavataCredStoreToken, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.thrift.TException
    {
      send_getSSHPubKey(authzToken, airavataCredStoreToken, gatewayId);
      return recv_getSSHPubKey();
    }

    public void send_getSSHPubKey(org.apache.airavata.model.security.AuthzToken authzToken, String airavataCredStoreToken, String gatewayId) throws org.apache.thrift.TException
    {
      getSSHPubKey_args args = new getSSHPubKey_args();
      args.setAuthzToken(authzToken);
      args.setAiravataCredStoreToken(airavataCredStoreToken);
      args.setGatewayId(gatewayId);
      sendBase("getSSHPubKey", args);
    }

    public String recv_getSSHPubKey() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.thrift.TException
    {
      getSSHPubKey_result result = new getSSHPubKey_result();
      receiveBase(result, "getSSHPubKey");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getSSHPubKey failed: unknown result");
    }

    public Map<String,String> getAllGatewaySSHPubKeys(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.thrift.TException
    {
      send_getAllGatewaySSHPubKeys(authzToken, gatewayId);
      return recv_getAllGatewaySSHPubKeys();
    }

    public void send_getAllGatewaySSHPubKeys(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId) throws org.apache.thrift.TException
    {
      getAllGatewaySSHPubKeys_args args = new getAllGatewaySSHPubKeys_args();
      args.setAuthzToken(authzToken);
      args.setGatewayId(gatewayId);
      sendBase("getAllGatewaySSHPubKeys", args);
    }

    public Map<String,String> recv_getAllGatewaySSHPubKeys() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.thrift.TException
    {
      getAllGatewaySSHPubKeys_result result = new getAllGatewaySSHPubKeys_result();
      receiveBase(result, "getAllGatewaySSHPubKeys");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllGatewaySSHPubKeys failed: unknown result");
    }

    public List<org.apache.airavata.model.credential.store.CredentialSummary> getAllCredentialSummaryForGateway(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.credential.store.SummaryType type, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.thrift.TException
    {
      send_getAllCredentialSummaryForGateway(authzToken, type, gatewayId);
      return recv_getAllCredentialSummaryForGateway();
    }

    public void send_getAllCredentialSummaryForGateway(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.credential.store.SummaryType type, String gatewayId) throws org.apache.thrift.TException
    {
      getAllCredentialSummaryForGateway_args args = new getAllCredentialSummaryForGateway_args();
      args.setAuthzToken(authzToken);
      args.setType(type);
      args.setGatewayId(gatewayId);
      sendBase("getAllCredentialSummaryForGateway", args);
    }

    public List<org.apache.airavata.model.credential.store.CredentialSummary> recv_getAllCredentialSummaryForGateway() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.thrift.TException
    {
      getAllCredentialSummaryForGateway_result result = new getAllCredentialSummaryForGateway_result();
      receiveBase(result, "getAllCredentialSummaryForGateway");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllCredentialSummaryForGateway failed: unknown result");
    }

    public List<org.apache.airavata.model.credential.store.CredentialSummary> getAllCredentialSummaryForUsersInGateway(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.credential.store.SummaryType type, String gatewayId, String userId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.thrift.TException
    {
      send_getAllCredentialSummaryForUsersInGateway(authzToken, type, gatewayId, userId);
      return recv_getAllCredentialSummaryForUsersInGateway();
    }

    public void send_getAllCredentialSummaryForUsersInGateway(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.credential.store.SummaryType type, String gatewayId, String userId) throws org.apache.thrift.TException
    {
      getAllCredentialSummaryForUsersInGateway_args args = new getAllCredentialSummaryForUsersInGateway_args();
      args.setAuthzToken(authzToken);
      args.setType(type);
      args.setGatewayId(gatewayId);
      args.setUserId(userId);
      sendBase("getAllCredentialSummaryForUsersInGateway", args);
    }

    public List<org.apache.airavata.model.credential.store.CredentialSummary> recv_getAllCredentialSummaryForUsersInGateway() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.thrift.TException
    {
      getAllCredentialSummaryForUsersInGateway_result result = new getAllCredentialSummaryForUsersInGateway_result();
      receiveBase(result, "getAllCredentialSummaryForUsersInGateway");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllCredentialSummaryForUsersInGateway failed: unknown result");
    }

    public Map<String,String> getAllGatewayPWDCredentials(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.thrift.TException
    {
      send_getAllGatewayPWDCredentials(authzToken, gatewayId);
      return recv_getAllGatewayPWDCredentials();
    }

    public void send_getAllGatewayPWDCredentials(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId) throws org.apache.thrift.TException
    {
      getAllGatewayPWDCredentials_args args = new getAllGatewayPWDCredentials_args();
      args.setAuthzToken(authzToken);
      args.setGatewayId(gatewayId);
      sendBase("getAllGatewayPWDCredentials", args);
    }

    public Map<String,String> recv_getAllGatewayPWDCredentials() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.thrift.TException
    {
      getAllGatewayPWDCredentials_result result = new getAllGatewayPWDCredentials_result();
      receiveBase(result, "getAllGatewayPWDCredentials");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllGatewayPWDCredentials failed: unknown result");
    }

    public boolean deleteSSHPubKey(org.apache.airavata.model.security.AuthzToken authzToken, String airavataCredStoreToken, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.thrift.TException
    {
      send_deleteSSHPubKey(authzToken, airavataCredStoreToken, gatewayId);
      return recv_deleteSSHPubKey();
    }

    public void send_deleteSSHPubKey(org.apache.airavata.model.security.AuthzToken authzToken, String airavataCredStoreToken, String gatewayId) throws org.apache.thrift.TException
    {
      deleteSSHPubKey_args args = new deleteSSHPubKey_args();
      args.setAuthzToken(authzToken);
      args.setAiravataCredStoreToken(airavataCredStoreToken);
      args.setGatewayId(gatewayId);
      sendBase("deleteSSHPubKey", args);
    }

    public boolean recv_deleteSSHPubKey() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.thrift.TException
    {
      deleteSSHPubKey_result result = new deleteSSHPubKey_result();
      receiveBase(result, "deleteSSHPubKey");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteSSHPubKey failed: unknown result");
    }

    public boolean deletePWDCredential(org.apache.airavata.model.security.AuthzToken authzToken, String airavataCredStoreToken, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.thrift.TException
    {
      send_deletePWDCredential(authzToken, airavataCredStoreToken, gatewayId);
      return recv_deletePWDCredential();
    }

    public void send_deletePWDCredential(org.apache.airavata.model.security.AuthzToken authzToken, String airavataCredStoreToken, String gatewayId) throws org.apache.thrift.TException
    {
      deletePWDCredential_args args = new deletePWDCredential_args();
      args.setAuthzToken(authzToken);
      args.setAiravataCredStoreToken(airavataCredStoreToken);
      args.setGatewayId(gatewayId);
      sendBase("deletePWDCredential", args);
    }

    public boolean recv_deletePWDCredential() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.thrift.TException
    {
      deletePWDCredential_result result = new deletePWDCredential_result();
      receiveBase(result, "deletePWDCredential");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deletePWDCredential failed: unknown result");
    }

    public String createProject(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.workspace.Project project) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_createProject(authzToken, gatewayId, project);
      return recv_createProject();
    }

    public void send_createProject(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.workspace.Project project) throws org.apache.thrift.TException
    {
      createProject_args args = new createProject_args();
      args.setAuthzToken(authzToken);
      args.setGatewayId(gatewayId);
      args.setProject(project);
      sendBase("createProject", args);
    }

    public String recv_createProject() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      createProject_result result = new createProject_result();
      receiveBase(result, "createProject");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "createProject failed: unknown result");
    }

    public void updateProject(org.apache.airavata.model.security.AuthzToken authzToken, String projectId, org.apache.airavata.model.workspace.Project updatedProject) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_updateProject(authzToken, projectId, updatedProject);
      recv_updateProject();
    }

    public void send_updateProject(org.apache.airavata.model.security.AuthzToken authzToken, String projectId, org.apache.airavata.model.workspace.Project updatedProject) throws org.apache.thrift.TException
    {
      updateProject_args args = new updateProject_args();
      args.setAuthzToken(authzToken);
      args.setProjectId(projectId);
      args.setUpdatedProject(updatedProject);
      sendBase("updateProject", args);
    }

    public void recv_updateProject() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      updateProject_result result = new updateProject_result();
      receiveBase(result, "updateProject");
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.pnfe != null) {
        throw result.pnfe;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      return;
    }

    public org.apache.airavata.model.workspace.Project getProject(org.apache.airavata.model.security.AuthzToken authzToken, String projectId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getProject(authzToken, projectId);
      return recv_getProject();
    }

    public void send_getProject(org.apache.airavata.model.security.AuthzToken authzToken, String projectId) throws org.apache.thrift.TException
    {
      getProject_args args = new getProject_args();
      args.setAuthzToken(authzToken);
      args.setProjectId(projectId);
      sendBase("getProject", args);
    }

    public org.apache.airavata.model.workspace.Project recv_getProject() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getProject_result result = new getProject_result();
      receiveBase(result, "getProject");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.pnfe != null) {
        throw result.pnfe;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getProject failed: unknown result");
    }

    public boolean deleteProject(org.apache.airavata.model.security.AuthzToken authzToken, String projectId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_deleteProject(authzToken, projectId);
      return recv_deleteProject();
    }

    public void send_deleteProject(org.apache.airavata.model.security.AuthzToken authzToken, String projectId) throws org.apache.thrift.TException
    {
      deleteProject_args args = new deleteProject_args();
      args.setAuthzToken(authzToken);
      args.setProjectId(projectId);
      sendBase("deleteProject", args);
    }

    public boolean recv_deleteProject() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      deleteProject_result result = new deleteProject_result();
      receiveBase(result, "deleteProject");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.pnfe != null) {
        throw result.pnfe;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteProject failed: unknown result");
    }

    public List<org.apache.airavata.model.workspace.Project> getUserProjects(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String userName, int limit, int offset) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getUserProjects(authzToken, gatewayId, userName, limit, offset);
      return recv_getUserProjects();
    }

    public void send_getUserProjects(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String userName, int limit, int offset) throws org.apache.thrift.TException
    {
      getUserProjects_args args = new getUserProjects_args();
      args.setAuthzToken(authzToken);
      args.setGatewayId(gatewayId);
      args.setUserName(userName);
      args.setLimit(limit);
      args.setOffset(offset);
      sendBase("getUserProjects", args);
    }

    public List<org.apache.airavata.model.workspace.Project> recv_getUserProjects() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getUserProjects_result result = new getUserProjects_result();
      receiveBase(result, "getUserProjects");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getUserProjects failed: unknown result");
    }

    public List<org.apache.airavata.model.workspace.Project> searchProjects(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String userName, Map<org.apache.airavata.model.experiment.ProjectSearchFields,String> filters, int limit, int offset) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_searchProjects(authzToken, gatewayId, userName, filters, limit, offset);
      return recv_searchProjects();
    }

    public void send_searchProjects(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String userName, Map<org.apache.airavata.model.experiment.ProjectSearchFields,String> filters, int limit, int offset) throws org.apache.thrift.TException
    {
      searchProjects_args args = new searchProjects_args();
      args.setAuthzToken(authzToken);
      args.setGatewayId(gatewayId);
      args.setUserName(userName);
      args.setFilters(filters);
      args.setLimit(limit);
      args.setOffset(offset);
      sendBase("searchProjects", args);
    }

    public List<org.apache.airavata.model.workspace.Project> recv_searchProjects() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      searchProjects_result result = new searchProjects_result();
      receiveBase(result, "searchProjects");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "searchProjects failed: unknown result");
    }

    public List<org.apache.airavata.model.experiment.ExperimentSummaryModel> searchExperiments(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String userName, Map<org.apache.airavata.model.experiment.ExperimentSearchFields,String> filters, int limit, int offset) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_searchExperiments(authzToken, gatewayId, userName, filters, limit, offset);
      return recv_searchExperiments();
    }

    public void send_searchExperiments(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String userName, Map<org.apache.airavata.model.experiment.ExperimentSearchFields,String> filters, int limit, int offset) throws org.apache.thrift.TException
    {
      searchExperiments_args args = new searchExperiments_args();
      args.setAuthzToken(authzToken);
      args.setGatewayId(gatewayId);
      args.setUserName(userName);
      args.setFilters(filters);
      args.setLimit(limit);
      args.setOffset(offset);
      sendBase("searchExperiments", args);
    }

    public List<org.apache.airavata.model.experiment.ExperimentSummaryModel> recv_searchExperiments() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      searchExperiments_result result = new searchExperiments_result();
      receiveBase(result, "searchExperiments");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "searchExperiments failed: unknown result");
    }

    public org.apache.airavata.model.experiment.ExperimentStatistics getExperimentStatistics(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, long fromTime, long toTime, String userName, String applicationName, String resourceHostName) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getExperimentStatistics(authzToken, gatewayId, fromTime, toTime, userName, applicationName, resourceHostName);
      return recv_getExperimentStatistics();
    }

    public void send_getExperimentStatistics(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, long fromTime, long toTime, String userName, String applicationName, String resourceHostName) throws org.apache.thrift.TException
    {
      getExperimentStatistics_args args = new getExperimentStatistics_args();
      args.setAuthzToken(authzToken);
      args.setGatewayId(gatewayId);
      args.setFromTime(fromTime);
      args.setToTime(toTime);
      args.setUserName(userName);
      args.setApplicationName(applicationName);
      args.setResourceHostName(resourceHostName);
      sendBase("getExperimentStatistics", args);
    }

    public org.apache.airavata.model.experiment.ExperimentStatistics recv_getExperimentStatistics() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getExperimentStatistics_result result = new getExperimentStatistics_result();
      receiveBase(result, "getExperimentStatistics");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getExperimentStatistics failed: unknown result");
    }

    public List<org.apache.airavata.model.experiment.ExperimentModel> getExperimentsInProject(org.apache.airavata.model.security.AuthzToken authzToken, String projectId, int limit, int offset) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getExperimentsInProject(authzToken, projectId, limit, offset);
      return recv_getExperimentsInProject();
    }

    public void send_getExperimentsInProject(org.apache.airavata.model.security.AuthzToken authzToken, String projectId, int limit, int offset) throws org.apache.thrift.TException
    {
      getExperimentsInProject_args args = new getExperimentsInProject_args();
      args.setAuthzToken(authzToken);
      args.setProjectId(projectId);
      args.setLimit(limit);
      args.setOffset(offset);
      sendBase("getExperimentsInProject", args);
    }

    public List<org.apache.airavata.model.experiment.ExperimentModel> recv_getExperimentsInProject() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getExperimentsInProject_result result = new getExperimentsInProject_result();
      receiveBase(result, "getExperimentsInProject");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.pnfe != null) {
        throw result.pnfe;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getExperimentsInProject failed: unknown result");
    }

    public List<org.apache.airavata.model.experiment.ExperimentModel> getUserExperiments(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String userName, int limit, int offset) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getUserExperiments(authzToken, gatewayId, userName, limit, offset);
      return recv_getUserExperiments();
    }

    public void send_getUserExperiments(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String userName, int limit, int offset) throws org.apache.thrift.TException
    {
      getUserExperiments_args args = new getUserExperiments_args();
      args.setAuthzToken(authzToken);
      args.setGatewayId(gatewayId);
      args.setUserName(userName);
      args.setLimit(limit);
      args.setOffset(offset);
      sendBase("getUserExperiments", args);
    }

    public List<org.apache.airavata.model.experiment.ExperimentModel> recv_getUserExperiments() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getUserExperiments_result result = new getUserExperiments_result();
      receiveBase(result, "getUserExperiments");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getUserExperiments failed: unknown result");
    }

    public String createExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.experiment.ExperimentModel experiment) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_createExperiment(authzToken, gatewayId, experiment);
      return recv_createExperiment();
    }

    public void send_createExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.experiment.ExperimentModel experiment) throws org.apache.thrift.TException
    {
      createExperiment_args args = new createExperiment_args();
      args.setAuthzToken(authzToken);
      args.setGatewayId(gatewayId);
      args.setExperiment(experiment);
      sendBase("createExperiment", args);
    }

    public String recv_createExperiment() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      createExperiment_result result = new createExperiment_result();
      receiveBase(result, "createExperiment");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "createExperiment failed: unknown result");
    }

    public boolean deleteExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String experimentId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_deleteExperiment(authzToken, experimentId);
      return recv_deleteExperiment();
    }

    public void send_deleteExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String experimentId) throws org.apache.thrift.TException
    {
      deleteExperiment_args args = new deleteExperiment_args();
      args.setAuthzToken(authzToken);
      args.setExperimentId(experimentId);
      sendBase("deleteExperiment", args);
    }

    public boolean recv_deleteExperiment() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      deleteExperiment_result result = new deleteExperiment_result();
      receiveBase(result, "deleteExperiment");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteExperiment failed: unknown result");
    }

    public org.apache.airavata.model.experiment.ExperimentModel getExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getExperiment(authzToken, airavataExperimentId);
      return recv_getExperiment();
    }

    public void send_getExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId) throws org.apache.thrift.TException
    {
      getExperiment_args args = new getExperiment_args();
      args.setAuthzToken(authzToken);
      args.setAiravataExperimentId(airavataExperimentId);
      sendBase("getExperiment", args);
    }

    public org.apache.airavata.model.experiment.ExperimentModel recv_getExperiment() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getExperiment_result result = new getExperiment_result();
      receiveBase(result, "getExperiment");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.enf != null) {
        throw result.enf;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getExperiment failed: unknown result");
    }

    public org.apache.airavata.model.experiment.ExperimentModel getExperimentByAdmin(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getExperimentByAdmin(authzToken, airavataExperimentId);
      return recv_getExperimentByAdmin();
    }

    public void send_getExperimentByAdmin(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId) throws org.apache.thrift.TException
    {
      getExperimentByAdmin_args args = new getExperimentByAdmin_args();
      args.setAuthzToken(authzToken);
      args.setAiravataExperimentId(airavataExperimentId);
      sendBase("getExperimentByAdmin", args);
    }

    public org.apache.airavata.model.experiment.ExperimentModel recv_getExperimentByAdmin() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getExperimentByAdmin_result result = new getExperimentByAdmin_result();
      receiveBase(result, "getExperimentByAdmin");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.enf != null) {
        throw result.enf;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getExperimentByAdmin failed: unknown result");
    }

    public org.apache.airavata.model.experiment.ExperimentModel getDetailedExperimentTree(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getDetailedExperimentTree(authzToken, airavataExperimentId);
      return recv_getDetailedExperimentTree();
    }

    public void send_getDetailedExperimentTree(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId) throws org.apache.thrift.TException
    {
      getDetailedExperimentTree_args args = new getDetailedExperimentTree_args();
      args.setAuthzToken(authzToken);
      args.setAiravataExperimentId(airavataExperimentId);
      sendBase("getDetailedExperimentTree", args);
    }

    public org.apache.airavata.model.experiment.ExperimentModel recv_getDetailedExperimentTree() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getDetailedExperimentTree_result result = new getDetailedExperimentTree_result();
      receiveBase(result, "getDetailedExperimentTree");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.enf != null) {
        throw result.enf;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getDetailedExperimentTree failed: unknown result");
    }

    public void updateExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.airavata.model.experiment.ExperimentModel experiment) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_updateExperiment(authzToken, airavataExperimentId, experiment);
      recv_updateExperiment();
    }

    public void send_updateExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.airavata.model.experiment.ExperimentModel experiment) throws org.apache.thrift.TException
    {
      updateExperiment_args args = new updateExperiment_args();
      args.setAuthzToken(authzToken);
      args.setAiravataExperimentId(airavataExperimentId);
      args.setExperiment(experiment);
      sendBase("updateExperiment", args);
    }

    public void recv_updateExperiment() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      updateExperiment_result result = new updateExperiment_result();
      receiveBase(result, "updateExperiment");
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.enf != null) {
        throw result.enf;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      return;
    }

    public void updateExperimentConfiguration(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.airavata.model.experiment.UserConfigurationDataModel userConfiguration) throws org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_updateExperimentConfiguration(authzToken, airavataExperimentId, userConfiguration);
      recv_updateExperimentConfiguration();
    }

    public void send_updateExperimentConfiguration(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.airavata.model.experiment.UserConfigurationDataModel userConfiguration) throws org.apache.thrift.TException
    {
      updateExperimentConfiguration_args args = new updateExperimentConfiguration_args();
      args.setAuthzToken(authzToken);
      args.setAiravataExperimentId(airavataExperimentId);
      args.setUserConfiguration(userConfiguration);
      sendBase("updateExperimentConfiguration", args);
    }

    public void recv_updateExperimentConfiguration() throws org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      updateExperimentConfiguration_result result = new updateExperimentConfiguration_result();
      receiveBase(result, "updateExperimentConfiguration");
      if (result.ae != null) {
        throw result.ae;
      }
      return;
    }

    public void updateResourceScheduleing(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel resourceScheduling) throws org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_updateResourceScheduleing(authzToken, airavataExperimentId, resourceScheduling);
      recv_updateResourceScheduleing();
    }

    public void send_updateResourceScheduleing(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel resourceScheduling) throws org.apache.thrift.TException
    {
      updateResourceScheduleing_args args = new updateResourceScheduleing_args();
      args.setAuthzToken(authzToken);
      args.setAiravataExperimentId(airavataExperimentId);
      args.setResourceScheduling(resourceScheduling);
      sendBase("updateResourceScheduleing", args);
    }

    public void recv_updateResourceScheduleing() throws org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      updateResourceScheduleing_result result = new updateResourceScheduleing_result();
      receiveBase(result, "updateResourceScheduleing");
      if (result.ae != null) {
        throw result.ae;
      }
      return;
    }

    public boolean validateExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_validateExperiment(authzToken, airavataExperimentId);
      return recv_validateExperiment();
    }

    public void send_validateExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId) throws org.apache.thrift.TException
    {
      validateExperiment_args args = new validateExperiment_args();
      args.setAuthzToken(authzToken);
      args.setAiravataExperimentId(airavataExperimentId);
      sendBase("validateExperiment", args);
    }

    public boolean recv_validateExperiment() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      validateExperiment_result result = new validateExperiment_result();
      receiveBase(result, "validateExperiment");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.enf != null) {
        throw result.enf;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "validateExperiment failed: unknown result");
    }

    public void launchExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_launchExperiment(authzToken, airavataExperimentId, gatewayId);
      recv_launchExperiment();
    }

    public void send_launchExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, String gatewayId) throws org.apache.thrift.TException
    {
      launchExperiment_args args = new launchExperiment_args();
      args.setAuthzToken(authzToken);
      args.setAiravataExperimentId(airavataExperimentId);
      args.setGatewayId(gatewayId);
      sendBase("launchExperiment", args);
    }

    public void recv_launchExperiment() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      launchExperiment_result result = new launchExperiment_result();
      receiveBase(result, "launchExperiment");
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.enf != null) {
        throw result.enf;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      return;
    }

    public org.apache.airavata.model.status.ExperimentStatus getExperimentStatus(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getExperimentStatus(authzToken, airavataExperimentId);
      return recv_getExperimentStatus();
    }

    public void send_getExperimentStatus(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId) throws org.apache.thrift.TException
    {
      getExperimentStatus_args args = new getExperimentStatus_args();
      args.setAuthzToken(authzToken);
      args.setAiravataExperimentId(airavataExperimentId);
      sendBase("getExperimentStatus", args);
    }

    public org.apache.airavata.model.status.ExperimentStatus recv_getExperimentStatus() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getExperimentStatus_result result = new getExperimentStatus_result();
      receiveBase(result, "getExperimentStatus");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.enf != null) {
        throw result.enf;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getExperimentStatus failed: unknown result");
    }

    public List<org.apache.airavata.model.application.io.OutputDataObjectType> getExperimentOutputs(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getExperimentOutputs(authzToken, airavataExperimentId);
      return recv_getExperimentOutputs();
    }

    public void send_getExperimentOutputs(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId) throws org.apache.thrift.TException
    {
      getExperimentOutputs_args args = new getExperimentOutputs_args();
      args.setAuthzToken(authzToken);
      args.setAiravataExperimentId(airavataExperimentId);
      sendBase("getExperimentOutputs", args);
    }

    public List<org.apache.airavata.model.application.io.OutputDataObjectType> recv_getExperimentOutputs() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getExperimentOutputs_result result = new getExperimentOutputs_result();
      receiveBase(result, "getExperimentOutputs");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.enf != null) {
        throw result.enf;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getExperimentOutputs failed: unknown result");
    }

    public List<org.apache.airavata.model.application.io.OutputDataObjectType> getIntermediateOutputs(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getIntermediateOutputs(authzToken, airavataExperimentId);
      return recv_getIntermediateOutputs();
    }

    public void send_getIntermediateOutputs(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId) throws org.apache.thrift.TException
    {
      getIntermediateOutputs_args args = new getIntermediateOutputs_args();
      args.setAuthzToken(authzToken);
      args.setAiravataExperimentId(airavataExperimentId);
      sendBase("getIntermediateOutputs", args);
    }

    public List<org.apache.airavata.model.application.io.OutputDataObjectType> recv_getIntermediateOutputs() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getIntermediateOutputs_result result = new getIntermediateOutputs_result();
      receiveBase(result, "getIntermediateOutputs");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.enf != null) {
        throw result.enf;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getIntermediateOutputs failed: unknown result");
    }

    public Map<String,org.apache.airavata.model.status.JobStatus> getJobStatuses(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getJobStatuses(authzToken, airavataExperimentId);
      return recv_getJobStatuses();
    }

    public void send_getJobStatuses(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId) throws org.apache.thrift.TException
    {
      getJobStatuses_args args = new getJobStatuses_args();
      args.setAuthzToken(authzToken);
      args.setAiravataExperimentId(airavataExperimentId);
      sendBase("getJobStatuses", args);
    }

    public Map<String,org.apache.airavata.model.status.JobStatus> recv_getJobStatuses() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getJobStatuses_result result = new getJobStatuses_result();
      receiveBase(result, "getJobStatuses");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.enf != null) {
        throw result.enf;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getJobStatuses failed: unknown result");
    }

    public List<org.apache.airavata.model.job.JobModel> getJobDetails(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getJobDetails(authzToken, airavataExperimentId);
      return recv_getJobDetails();
    }

    public void send_getJobDetails(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId) throws org.apache.thrift.TException
    {
      getJobDetails_args args = new getJobDetails_args();
      args.setAuthzToken(authzToken);
      args.setAiravataExperimentId(airavataExperimentId);
      sendBase("getJobDetails", args);
    }

    public List<org.apache.airavata.model.job.JobModel> recv_getJobDetails() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getJobDetails_result result = new getJobDetails_result();
      receiveBase(result, "getJobDetails");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.enf != null) {
        throw result.enf;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getJobDetails failed: unknown result");
    }

    public String cloneExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String existingExperimentID, String newExperimentName, String newExperimentProjectId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.thrift.TException
    {
      send_cloneExperiment(authzToken, existingExperimentID, newExperimentName, newExperimentProjectId);
      return recv_cloneExperiment();
    }

    public void send_cloneExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String existingExperimentID, String newExperimentName, String newExperimentProjectId) throws org.apache.thrift.TException
    {
      cloneExperiment_args args = new cloneExperiment_args();
      args.setAuthzToken(authzToken);
      args.setExistingExperimentID(existingExperimentID);
      args.setNewExperimentName(newExperimentName);
      args.setNewExperimentProjectId(newExperimentProjectId);
      sendBase("cloneExperiment", args);
    }

    public String recv_cloneExperiment() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.thrift.TException
    {
      cloneExperiment_result result = new cloneExperiment_result();
      receiveBase(result, "cloneExperiment");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.enf != null) {
        throw result.enf;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      if (result.pnfe != null) {
        throw result.pnfe;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "cloneExperiment failed: unknown result");
    }

    public String cloneExperimentByAdmin(org.apache.airavata.model.security.AuthzToken authzToken, String existingExperimentID, String newExperimentName, String newExperimentProjectId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.thrift.TException
    {
      send_cloneExperimentByAdmin(authzToken, existingExperimentID, newExperimentName, newExperimentProjectId);
      return recv_cloneExperimentByAdmin();
    }

    public void send_cloneExperimentByAdmin(org.apache.airavata.model.security.AuthzToken authzToken, String existingExperimentID, String newExperimentName, String newExperimentProjectId) throws org.apache.thrift.TException
    {
      cloneExperimentByAdmin_args args = new cloneExperimentByAdmin_args();
      args.setAuthzToken(authzToken);
      args.setExistingExperimentID(existingExperimentID);
      args.setNewExperimentName(newExperimentName);
      args.setNewExperimentProjectId(newExperimentProjectId);
      sendBase("cloneExperimentByAdmin", args);
    }

    public String recv_cloneExperimentByAdmin() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.thrift.TException
    {
      cloneExperimentByAdmin_result result = new cloneExperimentByAdmin_result();
      receiveBase(result, "cloneExperimentByAdmin");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.enf != null) {
        throw result.enf;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      if (result.pnfe != null) {
        throw result.pnfe;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "cloneExperimentByAdmin failed: unknown result");
    }

    public void terminateExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_terminateExperiment(authzToken, airavataExperimentId, gatewayId);
      recv_terminateExperiment();
    }

    public void send_terminateExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, String gatewayId) throws org.apache.thrift.TException
    {
      terminateExperiment_args args = new terminateExperiment_args();
      args.setAuthzToken(authzToken);
      args.setAiravataExperimentId(airavataExperimentId);
      args.setGatewayId(gatewayId);
      sendBase("terminateExperiment", args);
    }

    public void recv_terminateExperiment() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      terminateExperiment_result result = new terminateExperiment_result();
      receiveBase(result, "terminateExperiment");
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.enf != null) {
        throw result.enf;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      return;
    }

    public String registerApplicationModule(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule applicationModule) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_registerApplicationModule(authzToken, gatewayId, applicationModule);
      return recv_registerApplicationModule();
    }

    public void send_registerApplicationModule(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule applicationModule) throws org.apache.thrift.TException
    {
      registerApplicationModule_args args = new registerApplicationModule_args();
      args.setAuthzToken(authzToken);
      args.setGatewayId(gatewayId);
      args.setApplicationModule(applicationModule);
      sendBase("registerApplicationModule", args);
    }

    public String recv_registerApplicationModule() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      registerApplicationModule_result result = new registerApplicationModule_result();
      receiveBase(result, "registerApplicationModule");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "registerApplicationModule failed: unknown result");
    }

    public org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule getApplicationModule(org.apache.airavata.model.security.AuthzToken authzToken, String appModuleId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getApplicationModule(authzToken, appModuleId);
      return recv_getApplicationModule();
    }

    public void send_getApplicationModule(org.apache.airavata.model.security.AuthzToken authzToken, String appModuleId) throws org.apache.thrift.TException
    {
      getApplicationModule_args args = new getApplicationModule_args();
      args.setAuthzToken(authzToken);
      args.setAppModuleId(appModuleId);
      sendBase("getApplicationModule", args);
    }

    public org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule recv_getApplicationModule() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getApplicationModule_result result = new getApplicationModule_result();
      receiveBase(result, "getApplicationModule");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getApplicationModule failed: unknown result");
    }

    public boolean updateApplicationModule(org.apache.airavata.model.security.AuthzToken authzToken, String appModuleId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule applicationModule) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_updateApplicationModule(authzToken, appModuleId, applicationModule);
      return recv_updateApplicationModule();
    }

    public void send_updateApplicationModule(org.apache.airavata.model.security.AuthzToken authzToken, String appModuleId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule applicationModule) throws org.apache.thrift.TException
    {
      updateApplicationModule_args args = new updateApplicationModule_args();
      args.setAuthzToken(authzToken);
      args.setAppModuleId(appModuleId);
      args.setApplicationModule(applicationModule);
      sendBase("updateApplicationModule", args);
    }

    public boolean recv_updateApplicationModule() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      updateApplicationModule_result result = new updateApplicationModule_result();
      receiveBase(result, "updateApplicationModule");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateApplicationModule failed: unknown result");
    }

    public List<org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule> getAllAppModules(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getAllAppModules(authzToken, gatewayId);
      return recv_getAllAppModules();
    }

    public void send_getAllAppModules(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId) throws org.apache.thrift.TException
    {
      getAllAppModules_args args = new getAllAppModules_args();
      args.setAuthzToken(authzToken);
      args.setGatewayId(gatewayId);
      sendBase("getAllAppModules", args);
    }

    public List<org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule> recv_getAllAppModules() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getAllAppModules_result result = new getAllAppModules_result();
      receiveBase(result, "getAllAppModules");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllAppModules failed: unknown result");
    }

    public boolean deleteApplicationModule(org.apache.airavata.model.security.AuthzToken authzToken, String appModuleId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_deleteApplicationModule(authzToken, appModuleId);
      return recv_deleteApplicationModule();
    }

    public void send_deleteApplicationModule(org.apache.airavata.model.security.AuthzToken authzToken, String appModuleId) throws org.apache.thrift.TException
    {
      deleteApplicationModule_args args = new deleteApplicationModule_args();
      args.setAuthzToken(authzToken);
      args.setAppModuleId(appModuleId);
      sendBase("deleteApplicationModule", args);
    }

    public boolean recv_deleteApplicationModule() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      deleteApplicationModule_result result = new deleteApplicationModule_result();
      receiveBase(result, "deleteApplicationModule");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteApplicationModule failed: unknown result");
    }

    public String registerApplicationDeployment(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription applicationDeployment) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_registerApplicationDeployment(authzToken, gatewayId, applicationDeployment);
      return recv_registerApplicationDeployment();
    }

    public void send_registerApplicationDeployment(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription applicationDeployment) throws org.apache.thrift.TException
    {
      registerApplicationDeployment_args args = new registerApplicationDeployment_args();
      args.setAuthzToken(authzToken);
      args.setGatewayId(gatewayId);
      args.setApplicationDeployment(applicationDeployment);
      sendBase("registerApplicationDeployment", args);
    }

    public String recv_registerApplicationDeployment() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      registerApplicationDeployment_result result = new registerApplicationDeployment_result();
      receiveBase(result, "registerApplicationDeployment");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "registerApplicationDeployment failed: unknown result");
    }

    public org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription getApplicationDeployment(org.apache.airavata.model.security.AuthzToken authzToken, String appDeploymentId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getApplicationDeployment(authzToken, appDeploymentId);
      return recv_getApplicationDeployment();
    }

    public void send_getApplicationDeployment(org.apache.airavata.model.security.AuthzToken authzToken, String appDeploymentId) throws org.apache.thrift.TException
    {
      getApplicationDeployment_args args = new getApplicationDeployment_args();
      args.setAuthzToken(authzToken);
      args.setAppDeploymentId(appDeploymentId);
      sendBase("getApplicationDeployment", args);
    }

    public org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription recv_getApplicationDeployment() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getApplicationDeployment_result result = new getApplicationDeployment_result();
      receiveBase(result, "getApplicationDeployment");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getApplicationDeployment failed: unknown result");
    }

    public boolean updateApplicationDeployment(org.apache.airavata.model.security.AuthzToken authzToken, String appDeploymentId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription applicationDeployment) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_updateApplicationDeployment(authzToken, appDeploymentId, applicationDeployment);
      return recv_updateApplicationDeployment();
    }

    public void send_updateApplicationDeployment(org.apache.airavata.model.security.AuthzToken authzToken, String appDeploymentId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription applicationDeployment) throws org.apache.thrift.TException
    {
      updateApplicationDeployment_args args = new updateApplicationDeployment_args();
      args.setAuthzToken(authzToken);
      args.setAppDeploymentId(appDeploymentId);
      args.setApplicationDeployment(applicationDeployment);
      sendBase("updateApplicationDeployment", args);
    }

    public boolean recv_updateApplicationDeployment() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      updateApplicationDeployment_result result = new updateApplicationDeployment_result();
      receiveBase(result, "updateApplicationDeployment");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateApplicationDeployment failed: unknown result");
    }

    public boolean deleteApplicationDeployment(org.apache.airavata.model.security.AuthzToken authzToken, String appDeploymentId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_deleteApplicationDeployment(authzToken, appDeploymentId);
      return recv_deleteApplicationDeployment();
    }

    public void send_deleteApplicationDeployment(org.apache.airavata.model.security.AuthzToken authzToken, String appDeploymentId) throws org.apache.thrift.TException
    {
      deleteApplicationDeployment_args args = new deleteApplicationDeployment_args();
      args.setAuthzToken(authzToken);
      args.setAppDeploymentId(appDeploymentId);
      sendBase("deleteApplicationDeployment", args);
    }

    public boolean recv_deleteApplicationDeployment() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      deleteApplicationDeployment_result result = new deleteApplicationDeployment_result();
      receiveBase(result, "deleteApplicationDeployment");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteApplicationDeployment failed: unknown result");
    }

    public List<org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription> getAllApplicationDeployments(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getAllApplicationDeployments(authzToken, gatewayId);
      return recv_getAllApplicationDeployments();
    }

    public void send_getAllApplicationDeployments(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId) throws org.apache.thrift.TException
    {
      getAllApplicationDeployments_args args = new getAllApplicationDeployments_args();
      args.setAuthzToken(authzToken);
      args.setGatewayId(gatewayId);
      sendBase("getAllApplicationDeployments", args);
    }

    public List<org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription> recv_getAllApplicationDeployments() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getAllApplicationDeployments_result result = new getAllApplicationDeployments_result();
      receiveBase(result, "getAllApplicationDeployments");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllApplicationDeployments failed: unknown result");
    }

    public List<String> getAppModuleDeployedResources(org.apache.airavata.model.security.AuthzToken authzToken, String appModuleId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getAppModuleDeployedResources(authzToken, appModuleId);
      return recv_getAppModuleDeployedResources();
    }

    public void send_getAppModuleDeployedResources(org.apache.airavata.model.security.AuthzToken authzToken, String appModuleId) throws org.apache.thrift.TException
    {
      getAppModuleDeployedResources_args args = new getAppModuleDeployedResources_args();
      args.setAuthzToken(authzToken);
      args.setAppModuleId(appModuleId);
      sendBase("getAppModuleDeployedResources", args);
    }

    public List<String> recv_getAppModuleDeployedResources() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getAppModuleDeployedResources_result result = new getAppModuleDeployedResources_result();
      receiveBase(result, "getAppModuleDeployedResources");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAppModuleDeployedResources failed: unknown result");
    }

    public String registerApplicationInterface(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription applicationInterface) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_registerApplicationInterface(authzToken, gatewayId, applicationInterface);
      return recv_registerApplicationInterface();
    }

    public void send_registerApplicationInterface(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription applicationInterface) throws org.apache.thrift.TException
    {
      registerApplicationInterface_args args = new registerApplicationInterface_args();
      args.setAuthzToken(authzToken);
      args.setGatewayId(gatewayId);
      args.setApplicationInterface(applicationInterface);
      sendBase("registerApplicationInterface", args);
    }

    public String recv_registerApplicationInterface() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      registerApplicationInterface_result result = new registerApplicationInterface_result();
      receiveBase(result, "registerApplicationInterface");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "registerApplicationInterface failed: unknown result");
    }

    public String cloneApplicationInterface(org.apache.airavata.model.security.AuthzToken authzToken, String existingAppInterfaceID, String newApplicationName, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_cloneApplicationInterface(authzToken, existingAppInterfaceID, newApplicationName, gatewayId);
      return recv_cloneApplicationInterface();
    }

    public void send_cloneApplicationInterface(org.apache.airavata.model.security.AuthzToken authzToken, String existingAppInterfaceID, String newApplicationName, String gatewayId) throws org.apache.thrift.TException
    {
      cloneApplicationInterface_args args = new cloneApplicationInterface_args();
      args.setAuthzToken(authzToken);
      args.setExistingAppInterfaceID(existingAppInterfaceID);
      args.setNewApplicationName(newApplicationName);
      args.setGatewayId(gatewayId);
      sendBase("cloneApplicationInterface", args);
    }

    public String recv_cloneApplicationInterface() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      cloneApplicationInterface_result result = new cloneApplicationInterface_result();
      receiveBase(result, "cloneApplicationInterface");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "cloneApplicationInterface failed: unknown result");
    }

    public org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription getApplicationInterface(org.apache.airavata.model.security.AuthzToken authzToken, String appInterfaceId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getApplicationInterface(authzToken, appInterfaceId);
      return recv_getApplicationInterface();
    }

    public void send_getApplicationInterface(org.apache.airavata.model.security.AuthzToken authzToken, String appInterfaceId) throws org.apache.thrift.TException
    {
      getApplicationInterface_args args = new getApplicationInterface_args();
      args.setAuthzToken(authzToken);
      args.setAppInterfaceId(appInterfaceId);
      sendBase("getApplicationInterface", args);
    }

    public org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription recv_getApplicationInterface() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getApplicationInterface_result result = new getApplicationInterface_result();
      receiveBase(result, "getApplicationInterface");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getApplicationInterface failed: unknown result");
    }

    public boolean updateApplicationInterface(org.apache.airavata.model.security.AuthzToken authzToken, String appInterfaceId, org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription applicationInterface) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_updateApplicationInterface(authzToken, appInterfaceId, applicationInterface);
      return recv_updateApplicationInterface();
    }

    public void send_updateApplicationInterface(org.apache.airavata.model.security.AuthzToken authzToken, String appInterfaceId, org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription applicationInterface) throws org.apache.thrift.TException
    {
      updateApplicationInterface_args args = new updateApplicationInterface_args();
      args.setAuthzToken(authzToken);
      args.setAppInterfaceId(appInterfaceId);
      args.setApplicationInterface(applicationInterface);
      sendBase("updateApplicationInterface", args);
    }

    public boolean recv_updateApplicationInterface() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      updateApplicationInterface_result result = new updateApplicationInterface_result();
      receiveBase(result, "updateApplicationInterface");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateApplicationInterface failed: unknown result");
    }

    public boolean deleteApplicationInterface(org.apache.airavata.model.security.AuthzToken authzToken, String appInterfaceId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_deleteApplicationInterface(authzToken, appInterfaceId);
      return recv_deleteApplicationInterface();
    }

    public void send_deleteApplicationInterface(org.apache.airavata.model.security.AuthzToken authzToken, String appInterfaceId) throws org.apache.thrift.TException
    {
      deleteApplicationInterface_args args = new deleteApplicationInterface_args();
      args.setAuthzToken(authzToken);
      args.setAppInterfaceId(appInterfaceId);
      sendBase("deleteApplicationInterface", args);
    }

    public boolean recv_deleteApplicationInterface() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      deleteApplicationInterface_result result = new deleteApplicationInterface_result();
      receiveBase(result, "deleteApplicationInterface");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteApplicationInterface failed: unknown result");
    }

    public Map<String,String> getAllApplicationInterfaceNames(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getAllApplicationInterfaceNames(authzToken, gatewayId);
      return recv_getAllApplicationInterfaceNames();
    }

    public void send_getAllApplicationInterfaceNames(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId) throws org.apache.thrift.TException
    {
      getAllApplicationInterfaceNames_args args = new getAllApplicationInterfaceNames_args();
      args.setAuthzToken(authzToken);
      args.setGatewayId(gatewayId);
      sendBase("getAllApplicationInterfaceNames", args);
    }

    public Map<String,String> recv_getAllApplicationInterfaceNames() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getAllApplicationInterfaceNames_result result = new getAllApplicationInterfaceNames_result();
      receiveBase(result, "getAllApplicationInterfaceNames");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllApplicationInterfaceNames failed: unknown result");
    }

    public List<org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription> getAllApplicationInterfaces(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getAllApplicationInterfaces(authzToken, gatewayId);
      return recv_getAllApplicationInterfaces();
    }

    public void send_getAllApplicationInterfaces(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId) throws org.apache.thrift.TException
    {
      getAllApplicationInterfaces_args args = new getAllApplicationInterfaces_args();
      args.setAuthzToken(authzToken);
      args.setGatewayId(gatewayId);
      sendBase("getAllApplicationInterfaces", args);
    }

    public List<org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription> recv_getAllApplicationInterfaces() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getAllApplicationInterfaces_result result = new getAllApplicationInterfaces_result();
      receiveBase(result, "getAllApplicationInterfaces");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllApplicationInterfaces failed: unknown result");
    }

    public List<org.apache.airavata.model.application.io.InputDataObjectType> getApplicationInputs(org.apache.airavata.model.security.AuthzToken authzToken, String appInterfaceId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getApplicationInputs(authzToken, appInterfaceId);
      return recv_getApplicationInputs();
    }

    public void send_getApplicationInputs(org.apache.airavata.model.security.AuthzToken authzToken, String appInterfaceId) throws org.apache.thrift.TException
    {
      getApplicationInputs_args args = new getApplicationInputs_args();
      args.setAuthzToken(authzToken);
      args.setAppInterfaceId(appInterfaceId);
      sendBase("getApplicationInputs", args);
    }

    public List<org.apache.airavata.model.application.io.InputDataObjectType> recv_getApplicationInputs() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getApplicationInputs_result result = new getApplicationInputs_result();
      receiveBase(result, "getApplicationInputs");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getApplicationInputs failed: unknown result");
    }

    public List<org.apache.airavata.model.application.io.OutputDataObjectType> getApplicationOutputs(org.apache.airavata.model.security.AuthzToken authzToken, String appInterfaceId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getApplicationOutputs(authzToken, appInterfaceId);
      return recv_getApplicationOutputs();
    }

    public void send_getApplicationOutputs(org.apache.airavata.model.security.AuthzToken authzToken, String appInterfaceId) throws org.apache.thrift.TException
    {
      getApplicationOutputs_args args = new getApplicationOutputs_args();
      args.setAuthzToken(authzToken);
      args.setAppInterfaceId(appInterfaceId);
      sendBase("getApplicationOutputs", args);
    }

    public List<org.apache.airavata.model.application.io.OutputDataObjectType> recv_getApplicationOutputs() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getApplicationOutputs_result result = new getApplicationOutputs_result();
      receiveBase(result, "getApplicationOutputs");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getApplicationOutputs failed: unknown result");
    }

    public Map<String,String> getAvailableAppInterfaceComputeResources(org.apache.airavata.model.security.AuthzToken authzToken, String appInterfaceId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getAvailableAppInterfaceComputeResources(authzToken, appInterfaceId);
      return recv_getAvailableAppInterfaceComputeResources();
    }

    public void send_getAvailableAppInterfaceComputeResources(org.apache.airavata.model.security.AuthzToken authzToken, String appInterfaceId) throws org.apache.thrift.TException
    {
      getAvailableAppInterfaceComputeResources_args args = new getAvailableAppInterfaceComputeResources_args();
      args.setAuthzToken(authzToken);
      args.setAppInterfaceId(appInterfaceId);
      sendBase("getAvailableAppInterfaceComputeResources", args);
    }

    public Map<String,String> recv_getAvailableAppInterfaceComputeResources() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getAvailableAppInterfaceComputeResources_result result = new getAvailableAppInterfaceComputeResources_result();
      receiveBase(result, "getAvailableAppInterfaceComputeResources");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAvailableAppInterfaceComputeResources failed: unknown result");
    }

    public String registerComputeResource(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription computeResourceDescription) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_registerComputeResource(authzToken, computeResourceDescription);
      return recv_registerComputeResource();
    }

    public void send_registerComputeResource(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription computeResourceDescription) throws org.apache.thrift.TException
    {
      registerComputeResource_args args = new registerComputeResource_args();
      args.setAuthzToken(authzToken);
      args.setComputeResourceDescription(computeResourceDescription);
      sendBase("registerComputeResource", args);
    }

    public String recv_registerComputeResource() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      registerComputeResource_result result = new registerComputeResource_result();
      receiveBase(result, "registerComputeResource");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "registerComputeResource failed: unknown result");
    }

    public org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription getComputeResource(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getComputeResource(authzToken, computeResourceId);
      return recv_getComputeResource();
    }

    public void send_getComputeResource(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId) throws org.apache.thrift.TException
    {
      getComputeResource_args args = new getComputeResource_args();
      args.setAuthzToken(authzToken);
      args.setComputeResourceId(computeResourceId);
      sendBase("getComputeResource", args);
    }

    public org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription recv_getComputeResource() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getComputeResource_result result = new getComputeResource_result();
      receiveBase(result, "getComputeResource");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getComputeResource failed: unknown result");
    }

    public Map<String,String> getAllComputeResourceNames(org.apache.airavata.model.security.AuthzToken authzToken) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getAllComputeResourceNames(authzToken);
      return recv_getAllComputeResourceNames();
    }

    public void send_getAllComputeResourceNames(org.apache.airavata.model.security.AuthzToken authzToken) throws org.apache.thrift.TException
    {
      getAllComputeResourceNames_args args = new getAllComputeResourceNames_args();
      args.setAuthzToken(authzToken);
      sendBase("getAllComputeResourceNames", args);
    }

    public Map<String,String> recv_getAllComputeResourceNames() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getAllComputeResourceNames_result result = new getAllComputeResourceNames_result();
      receiveBase(result, "getAllComputeResourceNames");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllComputeResourceNames failed: unknown result");
    }

    public boolean updateComputeResource(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription computeResourceDescription) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_updateComputeResource(authzToken, computeResourceId, computeResourceDescription);
      return recv_updateComputeResource();
    }

    public void send_updateComputeResource(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription computeResourceDescription) throws org.apache.thrift.TException
    {
      updateComputeResource_args args = new updateComputeResource_args();
      args.setAuthzToken(authzToken);
      args.setComputeResourceId(computeResourceId);
      args.setComputeResourceDescription(computeResourceDescription);
      sendBase("updateComputeResource", args);
    }

    public boolean recv_updateComputeResource() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      updateComputeResource_result result = new updateComputeResource_result();
      receiveBase(result, "updateComputeResource");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateComputeResource failed: unknown result");
    }

    public boolean deleteComputeResource(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_deleteComputeResource(authzToken, computeResourceId);
      return recv_deleteComputeResource();
    }

    public void send_deleteComputeResource(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId) throws org.apache.thrift.TException
    {
      deleteComputeResource_args args = new deleteComputeResource_args();
      args.setAuthzToken(authzToken);
      args.setComputeResourceId(computeResourceId);
      sendBase("deleteComputeResource", args);
    }

    public boolean recv_deleteComputeResource() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      deleteComputeResource_result result = new deleteComputeResource_result();
      receiveBase(result, "deleteComputeResource");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteComputeResource failed: unknown result");
    }

    public String registerStorageResource(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription storageResourceDescription) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_registerStorageResource(authzToken, storageResourceDescription);
      return recv_registerStorageResource();
    }

    public void send_registerStorageResource(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription storageResourceDescription) throws org.apache.thrift.TException
    {
      registerStorageResource_args args = new registerStorageResource_args();
      args.setAuthzToken(authzToken);
      args.setStorageResourceDescription(storageResourceDescription);
      sendBase("registerStorageResource", args);
    }

    public String recv_registerStorageResource() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      registerStorageResource_result result = new registerStorageResource_result();
      receiveBase(result, "registerStorageResource");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "registerStorageResource failed: unknown result");
    }

    public org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription getStorageResource(org.apache.airavata.model.security.AuthzToken authzToken, String storageResourceId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getStorageResource(authzToken, storageResourceId);
      return recv_getStorageResource();
    }

    public void send_getStorageResource(org.apache.airavata.model.security.AuthzToken authzToken, String storageResourceId) throws org.apache.thrift.TException
    {
      getStorageResource_args args = new getStorageResource_args();
      args.setAuthzToken(authzToken);
      args.setStorageResourceId(storageResourceId);
      sendBase("getStorageResource", args);
    }

    public org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription recv_getStorageResource() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getStorageResource_result result = new getStorageResource_result();
      receiveBase(result, "getStorageResource");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getStorageResource failed: unknown result");
    }

    public Map<String,String> getAllStorageResourceNames(org.apache.airavata.model.security.AuthzToken authzToken) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getAllStorageResourceNames(authzToken);
      return recv_getAllStorageResourceNames();
    }

    public void send_getAllStorageResourceNames(org.apache.airavata.model.security.AuthzToken authzToken) throws org.apache.thrift.TException
    {
      getAllStorageResourceNames_args args = new getAllStorageResourceNames_args();
      args.setAuthzToken(authzToken);
      sendBase("getAllStorageResourceNames", args);
    }

    public Map<String,String> recv_getAllStorageResourceNames() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getAllStorageResourceNames_result result = new getAllStorageResourceNames_result();
      receiveBase(result, "getAllStorageResourceNames");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllStorageResourceNames failed: unknown result");
    }

    public boolean updateStorageResource(org.apache.airavata.model.security.AuthzToken authzToken, String storageResourceId, org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription storageResourceDescription) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_updateStorageResource(authzToken, storageResourceId, storageResourceDescription);
      return recv_updateStorageResource();
    }

    public void send_updateStorageResource(org.apache.airavata.model.security.AuthzToken authzToken, String storageResourceId, org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription storageResourceDescription) throws org.apache.thrift.TException
    {
      updateStorageResource_args args = new updateStorageResource_args();
      args.setAuthzToken(authzToken);
      args.setStorageResourceId(storageResourceId);
      args.setStorageResourceDescription(storageResourceDescription);
      sendBase("updateStorageResource", args);
    }

    public boolean recv_updateStorageResource() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      updateStorageResource_result result = new updateStorageResource_result();
      receiveBase(result, "updateStorageResource");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateStorageResource failed: unknown result");
    }

    public boolean deleteStorageResource(org.apache.airavata.model.security.AuthzToken authzToken, String storageResourceId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_deleteStorageResource(authzToken, storageResourceId);
      return recv_deleteStorageResource();
    }

    public void send_deleteStorageResource(org.apache.airavata.model.security.AuthzToken authzToken, String storageResourceId) throws org.apache.thrift.TException
    {
      deleteStorageResource_args args = new deleteStorageResource_args();
      args.setAuthzToken(authzToken);
      args.setStorageResourceId(storageResourceId);
      sendBase("deleteStorageResource", args);
    }

    public boolean recv_deleteStorageResource() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      deleteStorageResource_result result = new deleteStorageResource_result();
      receiveBase(result, "deleteStorageResource");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteStorageResource failed: unknown result");
    }

    public String addLocalSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission localSubmission) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_addLocalSubmissionDetails(authzToken, computeResourceId, priorityOrder, localSubmission);
      return recv_addLocalSubmissionDetails();
    }

    public void send_addLocalSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission localSubmission) throws org.apache.thrift.TException
    {
      addLocalSubmissionDetails_args args = new addLocalSubmissionDetails_args();
      args.setAuthzToken(authzToken);
      args.setComputeResourceId(computeResourceId);
      args.setPriorityOrder(priorityOrder);
      args.setLocalSubmission(localSubmission);
      sendBase("addLocalSubmissionDetails", args);
    }

    public String recv_addLocalSubmissionDetails() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      addLocalSubmissionDetails_result result = new addLocalSubmissionDetails_result();
      receiveBase(result, "addLocalSubmissionDetails");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "addLocalSubmissionDetails failed: unknown result");
    }

    public boolean updateLocalSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission localSubmission) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_updateLocalSubmissionDetails(authzToken, jobSubmissionInterfaceId, localSubmission);
      return recv_updateLocalSubmissionDetails();
    }

    public void send_updateLocalSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission localSubmission) throws org.apache.thrift.TException
    {
      updateLocalSubmissionDetails_args args = new updateLocalSubmissionDetails_args();
      args.setAuthzToken(authzToken);
      args.setJobSubmissionInterfaceId(jobSubmissionInterfaceId);
      args.setLocalSubmission(localSubmission);
      sendBase("updateLocalSubmissionDetails", args);
    }

    public boolean recv_updateLocalSubmissionDetails() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      updateLocalSubmissionDetails_result result = new updateLocalSubmissionDetails_result();
      receiveBase(result, "updateLocalSubmissionDetails");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateLocalSubmissionDetails failed: unknown result");
    }

    public org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission getLocalJobSubmission(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getLocalJobSubmission(authzToken, jobSubmissionId);
      return recv_getLocalJobSubmission();
    }

    public void send_getLocalJobSubmission(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionId) throws org.apache.thrift.TException
    {
      getLocalJobSubmission_args args = new getLocalJobSubmission_args();
      args.setAuthzToken(authzToken);
      args.setJobSubmissionId(jobSubmissionId);
      sendBase("getLocalJobSubmission", args);
    }

    public org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission recv_getLocalJobSubmission() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getLocalJobSubmission_result result = new getLocalJobSubmission_result();
      receiveBase(result, "getLocalJobSubmission");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getLocalJobSubmission failed: unknown result");
    }

    public String addSSHJobSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_addSSHJobSubmissionDetails(authzToken, computeResourceId, priorityOrder, sshJobSubmission);
      return recv_addSSHJobSubmissionDetails();
    }

    public void send_addSSHJobSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission) throws org.apache.thrift.TException
    {
      addSSHJobSubmissionDetails_args args = new addSSHJobSubmissionDetails_args();
      args.setAuthzToken(authzToken);
      args.setComputeResourceId(computeResourceId);
      args.setPriorityOrder(priorityOrder);
      args.setSshJobSubmission(sshJobSubmission);
      sendBase("addSSHJobSubmissionDetails", args);
    }

    public String recv_addSSHJobSubmissionDetails() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      addSSHJobSubmissionDetails_result result = new addSSHJobSubmissionDetails_result();
      receiveBase(result, "addSSHJobSubmissionDetails");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "addSSHJobSubmissionDetails failed: unknown result");
    }

    public String addSSHForkJobSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_addSSHForkJobSubmissionDetails(authzToken, computeResourceId, priorityOrder, sshJobSubmission);
      return recv_addSSHForkJobSubmissionDetails();
    }

    public void send_addSSHForkJobSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission) throws org.apache.thrift.TException
    {
      addSSHForkJobSubmissionDetails_args args = new addSSHForkJobSubmissionDetails_args();
      args.setAuthzToken(authzToken);
      args.setComputeResourceId(computeResourceId);
      args.setPriorityOrder(priorityOrder);
      args.setSshJobSubmission(sshJobSubmission);
      sendBase("addSSHForkJobSubmissionDetails", args);
    }

    public String recv_addSSHForkJobSubmissionDetails() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      addSSHForkJobSubmissionDetails_result result = new addSSHForkJobSubmissionDetails_result();
      receiveBase(result, "addSSHForkJobSubmissionDetails");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "addSSHForkJobSubmissionDetails failed: unknown result");
    }

    public org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission getSSHJobSubmission(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getSSHJobSubmission(authzToken, jobSubmissionId);
      return recv_getSSHJobSubmission();
    }

    public void send_getSSHJobSubmission(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionId) throws org.apache.thrift.TException
    {
      getSSHJobSubmission_args args = new getSSHJobSubmission_args();
      args.setAuthzToken(authzToken);
      args.setJobSubmissionId(jobSubmissionId);
      sendBase("getSSHJobSubmission", args);
    }

    public org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission recv_getSSHJobSubmission() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getSSHJobSubmission_result result = new getSSHJobSubmission_result();
      receiveBase(result, "getSSHJobSubmission");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getSSHJobSubmission failed: unknown result");
    }

    public String addUNICOREJobSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission unicoreJobSubmission) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_addUNICOREJobSubmissionDetails(authzToken, computeResourceId, priorityOrder, unicoreJobSubmission);
      return recv_addUNICOREJobSubmissionDetails();
    }

    public void send_addUNICOREJobSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission unicoreJobSubmission) throws org.apache.thrift.TException
    {
      addUNICOREJobSubmissionDetails_args args = new addUNICOREJobSubmissionDetails_args();
      args.setAuthzToken(authzToken);
      args.setComputeResourceId(computeResourceId);
      args.setPriorityOrder(priorityOrder);
      args.setUnicoreJobSubmission(unicoreJobSubmission);
      sendBase("addUNICOREJobSubmissionDetails", args);
    }

    public String recv_addUNICOREJobSubmissionDetails() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      addUNICOREJobSubmissionDetails_result result = new addUNICOREJobSubmissionDetails_result();
      receiveBase(result, "addUNICOREJobSubmissionDetails");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "addUNICOREJobSubmissionDetails failed: unknown result");
    }

    public org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission getUnicoreJobSubmission(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getUnicoreJobSubmission(authzToken, jobSubmissionId);
      return recv_getUnicoreJobSubmission();
    }

    public void send_getUnicoreJobSubmission(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionId) throws org.apache.thrift.TException
    {
      getUnicoreJobSubmission_args args = new getUnicoreJobSubmission_args();
      args.setAuthzToken(authzToken);
      args.setJobSubmissionId(jobSubmissionId);
      sendBase("getUnicoreJobSubmission", args);
    }

    public org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission recv_getUnicoreJobSubmission() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getUnicoreJobSubmission_result result = new getUnicoreJobSubmission_result();
      receiveBase(result, "getUnicoreJobSubmission");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getUnicoreJobSubmission failed: unknown result");
    }

    public String addCloudJobSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission cloudSubmission) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_addCloudJobSubmissionDetails(authzToken, computeResourceId, priorityOrder, cloudSubmission);
      return recv_addCloudJobSubmissionDetails();
    }

    public void send_addCloudJobSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission cloudSubmission) throws org.apache.thrift.TException
    {
      addCloudJobSubmissionDetails_args args = new addCloudJobSubmissionDetails_args();
      args.setAuthzToken(authzToken);
      args.setComputeResourceId(computeResourceId);
      args.setPriorityOrder(priorityOrder);
      args.setCloudSubmission(cloudSubmission);
      sendBase("addCloudJobSubmissionDetails", args);
    }

    public String recv_addCloudJobSubmissionDetails() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      addCloudJobSubmissionDetails_result result = new addCloudJobSubmissionDetails_result();
      receiveBase(result, "addCloudJobSubmissionDetails");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "addCloudJobSubmissionDetails failed: unknown result");
    }

    public org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission getCloudJobSubmission(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getCloudJobSubmission(authzToken, jobSubmissionId);
      return recv_getCloudJobSubmission();
    }

    public void send_getCloudJobSubmission(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionId) throws org.apache.thrift.TException
    {
      getCloudJobSubmission_args args = new getCloudJobSubmission_args();
      args.setAuthzToken(authzToken);
      args.setJobSubmissionId(jobSubmissionId);
      sendBase("getCloudJobSubmission", args);
    }

    public org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission recv_getCloudJobSubmission() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getCloudJobSubmission_result result = new getCloudJobSubmission_result();
      receiveBase(result, "getCloudJobSubmission");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getCloudJobSubmission failed: unknown result");
    }

    public boolean updateSSHJobSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_updateSSHJobSubmissionDetails(authzToken, jobSubmissionInterfaceId, sshJobSubmission);
      return recv_updateSSHJobSubmissionDetails();
    }

    public void send_updateSSHJobSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission) throws org.apache.thrift.TException
    {
      updateSSHJobSubmissionDetails_args args = new updateSSHJobSubmissionDetails_args();
      args.setAuthzToken(authzToken);
      args.setJobSubmissionInterfaceId(jobSubmissionInterfaceId);
      args.setSshJobSubmission(sshJobSubmission);
      sendBase("updateSSHJobSubmissionDetails", args);
    }

    public boolean recv_updateSSHJobSubmissionDetails() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      updateSSHJobSubmissionDetails_result result = new updateSSHJobSubmissionDetails_result();
      receiveBase(result, "updateSSHJobSubmissionDetails");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateSSHJobSubmissionDetails failed: unknown result");
    }

    public boolean updateCloudJobSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission sshJobSubmission) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_updateCloudJobSubmissionDetails(authzToken, jobSubmissionInterfaceId, sshJobSubmission);
      return recv_updateCloudJobSubmissionDetails();
    }

    public void send_updateCloudJobSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission sshJobSubmission) throws org.apache.thrift.TException
    {
      updateCloudJobSubmissionDetails_args args = new updateCloudJobSubmissionDetails_args();
      args.setAuthzToken(authzToken);
      args.setJobSubmissionInterfaceId(jobSubmissionInterfaceId);
      args.setSshJobSubmission(sshJobSubmission);
      sendBase("updateCloudJobSubmissionDetails", args);
    }

    public boolean recv_updateCloudJobSubmissionDetails() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      updateCloudJobSubmissionDetails_result result = new updateCloudJobSubmissionDetails_result();
      receiveBase(result, "updateCloudJobSubmissionDetails");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateCloudJobSubmissionDetails failed: unknown result");
    }

    public boolean updateUnicoreJobSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission unicoreJobSubmission) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_updateUnicoreJobSubmissionDetails(authzToken, jobSubmissionInterfaceId, unicoreJobSubmission);
      return recv_updateUnicoreJobSubmissionDetails();
    }

    public void send_updateUnicoreJobSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission unicoreJobSubmission) throws org.apache.thrift.TException
    {
      updateUnicoreJobSubmissionDetails_args args = new updateUnicoreJobSubmissionDetails_args();
      args.setAuthzToken(authzToken);
      args.setJobSubmissionInterfaceId(jobSubmissionInterfaceId);
      args.setUnicoreJobSubmission(unicoreJobSubmission);
      sendBase("updateUnicoreJobSubmissionDetails", args);
    }

    public boolean recv_updateUnicoreJobSubmissionDetails() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      updateUnicoreJobSubmissionDetails_result result = new updateUnicoreJobSubmissionDetails_result();
      receiveBase(result, "updateUnicoreJobSubmissionDetails");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateUnicoreJobSubmissionDetails failed: unknown result");
    }

    public String addLocalDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.LOCALDataMovement localDataMovement) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_addLocalDataMovementDetails(authzToken, productUri, dataMoveType, priorityOrder, localDataMovement);
      return recv_addLocalDataMovementDetails();
    }

    public void send_addLocalDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.LOCALDataMovement localDataMovement) throws org.apache.thrift.TException
    {
      addLocalDataMovementDetails_args args = new addLocalDataMovementDetails_args();
      args.setAuthzToken(authzToken);
      args.setProductUri(productUri);
      args.setDataMoveType(dataMoveType);
      args.setPriorityOrder(priorityOrder);
      args.setLocalDataMovement(localDataMovement);
      sendBase("addLocalDataMovementDetails", args);
    }

    public String recv_addLocalDataMovementDetails() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      addLocalDataMovementDetails_result result = new addLocalDataMovementDetails_result();
      receiveBase(result, "addLocalDataMovementDetails");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "addLocalDataMovementDetails failed: unknown result");
    }

    public boolean updateLocalDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementInterfaceId, org.apache.airavata.model.data.movement.LOCALDataMovement localDataMovement) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_updateLocalDataMovementDetails(authzToken, dataMovementInterfaceId, localDataMovement);
      return recv_updateLocalDataMovementDetails();
    }

    public void send_updateLocalDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementInterfaceId, org.apache.airavata.model.data.movement.LOCALDataMovement localDataMovement) throws org.apache.thrift.TException
    {
      updateLocalDataMovementDetails_args args = new updateLocalDataMovementDetails_args();
      args.setAuthzToken(authzToken);
      args.setDataMovementInterfaceId(dataMovementInterfaceId);
      args.setLocalDataMovement(localDataMovement);
      sendBase("updateLocalDataMovementDetails", args);
    }

    public boolean recv_updateLocalDataMovementDetails() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      updateLocalDataMovementDetails_result result = new updateLocalDataMovementDetails_result();
      receiveBase(result, "updateLocalDataMovementDetails");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateLocalDataMovementDetails failed: unknown result");
    }

    public org.apache.airavata.model.data.movement.LOCALDataMovement getLocalDataMovement(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getLocalDataMovement(authzToken, dataMovementId);
      return recv_getLocalDataMovement();
    }

    public void send_getLocalDataMovement(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementId) throws org.apache.thrift.TException
    {
      getLocalDataMovement_args args = new getLocalDataMovement_args();
      args.setAuthzToken(authzToken);
      args.setDataMovementId(dataMovementId);
      sendBase("getLocalDataMovement", args);
    }

    public org.apache.airavata.model.data.movement.LOCALDataMovement recv_getLocalDataMovement() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getLocalDataMovement_result result = new getLocalDataMovement_result();
      receiveBase(result, "getLocalDataMovement");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getLocalDataMovement failed: unknown result");
    }

    public String addSCPDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.SCPDataMovement scpDataMovement) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_addSCPDataMovementDetails(authzToken, productUri, dataMoveType, priorityOrder, scpDataMovement);
      return recv_addSCPDataMovementDetails();
    }

    public void send_addSCPDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.SCPDataMovement scpDataMovement) throws org.apache.thrift.TException
    {
      addSCPDataMovementDetails_args args = new addSCPDataMovementDetails_args();
      args.setAuthzToken(authzToken);
      args.setProductUri(productUri);
      args.setDataMoveType(dataMoveType);
      args.setPriorityOrder(priorityOrder);
      args.setScpDataMovement(scpDataMovement);
      sendBase("addSCPDataMovementDetails", args);
    }

    public String recv_addSCPDataMovementDetails() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      addSCPDataMovementDetails_result result = new addSCPDataMovementDetails_result();
      receiveBase(result, "addSCPDataMovementDetails");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "addSCPDataMovementDetails failed: unknown result");
    }

    public boolean updateSCPDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementInterfaceId, org.apache.airavata.model.data.movement.SCPDataMovement scpDataMovement) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_updateSCPDataMovementDetails(authzToken, dataMovementInterfaceId, scpDataMovement);
      return recv_updateSCPDataMovementDetails();
    }

    public void send_updateSCPDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementInterfaceId, org.apache.airavata.model.data.movement.SCPDataMovement scpDataMovement) throws org.apache.thrift.TException
    {
      updateSCPDataMovementDetails_args args = new updateSCPDataMovementDetails_args();
      args.setAuthzToken(authzToken);
      args.setDataMovementInterfaceId(dataMovementInterfaceId);
      args.setScpDataMovement(scpDataMovement);
      sendBase("updateSCPDataMovementDetails", args);
    }

    public boolean recv_updateSCPDataMovementDetails() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      updateSCPDataMovementDetails_result result = new updateSCPDataMovementDetails_result();
      receiveBase(result, "updateSCPDataMovementDetails");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateSCPDataMovementDetails failed: unknown result");
    }

    public org.apache.airavata.model.data.movement.SCPDataMovement getSCPDataMovement(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getSCPDataMovement(authzToken, dataMovementId);
      return recv_getSCPDataMovement();
    }

    public void send_getSCPDataMovement(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementId) throws org.apache.thrift.TException
    {
      getSCPDataMovement_args args = new getSCPDataMovement_args();
      args.setAuthzToken(authzToken);
      args.setDataMovementId(dataMovementId);
      sendBase("getSCPDataMovement", args);
    }

    public org.apache.airavata.model.data.movement.SCPDataMovement recv_getSCPDataMovement() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getSCPDataMovement_result result = new getSCPDataMovement_result();
      receiveBase(result, "getSCPDataMovement");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getSCPDataMovement failed: unknown result");
    }

    public String addUnicoreDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.UnicoreDataMovement unicoreDataMovement) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_addUnicoreDataMovementDetails(authzToken, productUri, dataMoveType, priorityOrder, unicoreDataMovement);
      return recv_addUnicoreDataMovementDetails();
    }

    public void send_addUnicoreDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.UnicoreDataMovement unicoreDataMovement) throws org.apache.thrift.TException
    {
      addUnicoreDataMovementDetails_args args = new addUnicoreDataMovementDetails_args();
      args.setAuthzToken(authzToken);
      args.setProductUri(productUri);
      args.setDataMoveType(dataMoveType);
      args.setPriorityOrder(priorityOrder);
      args.setUnicoreDataMovement(unicoreDataMovement);
      sendBase("addUnicoreDataMovementDetails", args);
    }

    public String recv_addUnicoreDataMovementDetails() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      addUnicoreDataMovementDetails_result result = new addUnicoreDataMovementDetails_result();
      receiveBase(result, "addUnicoreDataMovementDetails");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "addUnicoreDataMovementDetails failed: unknown result");
    }

    public boolean updateUnicoreDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementInterfaceId, org.apache.airavata.model.data.movement.UnicoreDataMovement unicoreDataMovement) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_updateUnicoreDataMovementDetails(authzToken, dataMovementInterfaceId, unicoreDataMovement);
      return recv_updateUnicoreDataMovementDetails();
    }

    public void send_updateUnicoreDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementInterfaceId, org.apache.airavata.model.data.movement.UnicoreDataMovement unicoreDataMovement) throws org.apache.thrift.TException
    {
      updateUnicoreDataMovementDetails_args args = new updateUnicoreDataMovementDetails_args();
      args.setAuthzToken(authzToken);
      args.setDataMovementInterfaceId(dataMovementInterfaceId);
      args.setUnicoreDataMovement(unicoreDataMovement);
      sendBase("updateUnicoreDataMovementDetails", args);
    }

    public boolean recv_updateUnicoreDataMovementDetails() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      updateUnicoreDataMovementDetails_result result = new updateUnicoreDataMovementDetails_result();
      receiveBase(result, "updateUnicoreDataMovementDetails");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateUnicoreDataMovementDetails failed: unknown result");
    }

    public org.apache.airavata.model.data.movement.UnicoreDataMovement getUnicoreDataMovement(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getUnicoreDataMovement(authzToken, dataMovementId);
      return recv_getUnicoreDataMovement();
    }

    public void send_getUnicoreDataMovement(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementId) throws org.apache.thrift.TException
    {
      getUnicoreDataMovement_args args = new getUnicoreDataMovement_args();
      args.setAuthzToken(authzToken);
      args.setDataMovementId(dataMovementId);
      sendBase("getUnicoreDataMovement", args);
    }

    public org.apache.airavata.model.data.movement.UnicoreDataMovement recv_getUnicoreDataMovement() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getUnicoreDataMovement_result result = new getUnicoreDataMovement_result();
      receiveBase(result, "getUnicoreDataMovement");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getUnicoreDataMovement failed: unknown result");
    }

    public String addGridFTPDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.GridFTPDataMovement gridFTPDataMovement) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_addGridFTPDataMovementDetails(authzToken, productUri, dataMoveType, priorityOrder, gridFTPDataMovement);
      return recv_addGridFTPDataMovementDetails();
    }

    public void send_addGridFTPDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.GridFTPDataMovement gridFTPDataMovement) throws org.apache.thrift.TException
    {
      addGridFTPDataMovementDetails_args args = new addGridFTPDataMovementDetails_args();
      args.setAuthzToken(authzToken);
      args.setProductUri(productUri);
      args.setDataMoveType(dataMoveType);
      args.setPriorityOrder(priorityOrder);
      args.setGridFTPDataMovement(gridFTPDataMovement);
      sendBase("addGridFTPDataMovementDetails", args);
    }

    public String recv_addGridFTPDataMovementDetails() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      addGridFTPDataMovementDetails_result result = new addGridFTPDataMovementDetails_result();
      receiveBase(result, "addGridFTPDataMovementDetails");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "addGridFTPDataMovementDetails failed: unknown result");
    }

    public boolean updateGridFTPDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementInterfaceId, org.apache.airavata.model.data.movement.GridFTPDataMovement gridFTPDataMovement) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_updateGridFTPDataMovementDetails(authzToken, dataMovementInterfaceId, gridFTPDataMovement);
      return recv_updateGridFTPDataMovementDetails();
    }

    public void send_updateGridFTPDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementInterfaceId, org.apache.airavata.model.data.movement.GridFTPDataMovement gridFTPDataMovement) throws org.apache.thrift.TException
    {
      updateGridFTPDataMovementDetails_args args = new updateGridFTPDataMovementDetails_args();
      args.setAuthzToken(authzToken);
      args.setDataMovementInterfaceId(dataMovementInterfaceId);
      args.setGridFTPDataMovement(gridFTPDataMovement);
      sendBase("updateGridFTPDataMovementDetails", args);
    }

    public boolean recv_updateGridFTPDataMovementDetails() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      updateGridFTPDataMovementDetails_result result = new updateGridFTPDataMovementDetails_result();
      receiveBase(result, "updateGridFTPDataMovementDetails");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateGridFTPDataMovementDetails failed: unknown result");
    }

    public org.apache.airavata.model.data.movement.GridFTPDataMovement getGridFTPDataMovement(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getGridFTPDataMovement(authzToken, dataMovementId);
      return recv_getGridFTPDataMovement();
    }

    public void send_getGridFTPDataMovement(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementId) throws org.apache.thrift.TException
    {
      getGridFTPDataMovement_args args = new getGridFTPDataMovement_args();
      args.setAuthzToken(authzToken);
      args.setDataMovementId(dataMovementId);
      sendBase("getGridFTPDataMovement", args);
    }

    public org.apache.airavata.model.data.movement.GridFTPDataMovement recv_getGridFTPDataMovement() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getGridFTPDataMovement_result result = new getGridFTPDataMovement_result();
      receiveBase(result, "getGridFTPDataMovement");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getGridFTPDataMovement failed: unknown result");
    }

    public boolean changeJobSubmissionPriority(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionInterfaceId, int newPriorityOrder) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_changeJobSubmissionPriority(authzToken, jobSubmissionInterfaceId, newPriorityOrder);
      return recv_changeJobSubmissionPriority();
    }

    public void send_changeJobSubmissionPriority(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionInterfaceId, int newPriorityOrder) throws org.apache.thrift.TException
    {
      changeJobSubmissionPriority_args args = new changeJobSubmissionPriority_args();
      args.setAuthzToken(authzToken);
      args.setJobSubmissionInterfaceId(jobSubmissionInterfaceId);
      args.setNewPriorityOrder(newPriorityOrder);
      sendBase("changeJobSubmissionPriority", args);
    }

    public boolean recv_changeJobSubmissionPriority() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      changeJobSubmissionPriority_result result = new changeJobSubmissionPriority_result();
      receiveBase(result, "changeJobSubmissionPriority");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "changeJobSubmissionPriority failed: unknown result");
    }

    public boolean changeDataMovementPriority(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementInterfaceId, int newPriorityOrder) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_changeDataMovementPriority(authzToken, dataMovementInterfaceId, newPriorityOrder);
      return recv_changeDataMovementPriority();
    }

    public void send_changeDataMovementPriority(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementInterfaceId, int newPriorityOrder) throws org.apache.thrift.TException
    {
      changeDataMovementPriority_args args = new changeDataMovementPriority_args();
      args.setAuthzToken(authzToken);
      args.setDataMovementInterfaceId(dataMovementInterfaceId);
      args.setNewPriorityOrder(newPriorityOrder);
      sendBase("changeDataMovementPriority", args);
    }

    public boolean recv_changeDataMovementPriority() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      changeDataMovementPriority_result result = new changeDataMovementPriority_result();
      receiveBase(result, "changeDataMovementPriority");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "changeDataMovementPriority failed: unknown result");
    }

    public boolean changeJobSubmissionPriorities(org.apache.airavata.model.security.AuthzToken authzToken, Map<String,Integer> jobSubmissionPriorityMap) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_changeJobSubmissionPriorities(authzToken, jobSubmissionPriorityMap);
      return recv_changeJobSubmissionPriorities();
    }

    public void send_changeJobSubmissionPriorities(org.apache.airavata.model.security.AuthzToken authzToken, Map<String,Integer> jobSubmissionPriorityMap) throws org.apache.thrift.TException
    {
      changeJobSubmissionPriorities_args args = new changeJobSubmissionPriorities_args();
      args.setAuthzToken(authzToken);
      args.setJobSubmissionPriorityMap(jobSubmissionPriorityMap);
      sendBase("changeJobSubmissionPriorities", args);
    }

    public boolean recv_changeJobSubmissionPriorities() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      changeJobSubmissionPriorities_result result = new changeJobSubmissionPriorities_result();
      receiveBase(result, "changeJobSubmissionPriorities");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "changeJobSubmissionPriorities failed: unknown result");
    }

    public boolean changeDataMovementPriorities(org.apache.airavata.model.security.AuthzToken authzToken, Map<String,Integer> dataMovementPriorityMap) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_changeDataMovementPriorities(authzToken, dataMovementPriorityMap);
      return recv_changeDataMovementPriorities();
    }

    public void send_changeDataMovementPriorities(org.apache.airavata.model.security.AuthzToken authzToken, Map<String,Integer> dataMovementPriorityMap) throws org.apache.thrift.TException
    {
      changeDataMovementPriorities_args args = new changeDataMovementPriorities_args();
      args.setAuthzToken(authzToken);
      args.setDataMovementPriorityMap(dataMovementPriorityMap);
      sendBase("changeDataMovementPriorities", args);
    }

    public boolean recv_changeDataMovementPriorities() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      changeDataMovementPriorities_result result = new changeDataMovementPriorities_result();
      receiveBase(result, "changeDataMovementPriorities");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "changeDataMovementPriorities failed: unknown result");
    }

    public boolean deleteJobSubmissionInterface(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, String jobSubmissionInterfaceId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_deleteJobSubmissionInterface(authzToken, computeResourceId, jobSubmissionInterfaceId);
      return recv_deleteJobSubmissionInterface();
    }

    public void send_deleteJobSubmissionInterface(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, String jobSubmissionInterfaceId) throws org.apache.thrift.TException
    {
      deleteJobSubmissionInterface_args args = new deleteJobSubmissionInterface_args();
      args.setAuthzToken(authzToken);
      args.setComputeResourceId(computeResourceId);
      args.setJobSubmissionInterfaceId(jobSubmissionInterfaceId);
      sendBase("deleteJobSubmissionInterface", args);
    }

    public boolean recv_deleteJobSubmissionInterface() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      deleteJobSubmissionInterface_result result = new deleteJobSubmissionInterface_result();
      receiveBase(result, "deleteJobSubmissionInterface");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteJobSubmissionInterface failed: unknown result");
    }

    public boolean deleteDataMovementInterface(org.apache.airavata.model.security.AuthzToken authzToken, String productUri, String dataMovementInterfaceId, org.apache.airavata.model.data.movement.DMType dataMoveType) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_deleteDataMovementInterface(authzToken, productUri, dataMovementInterfaceId, dataMoveType);
      return recv_deleteDataMovementInterface();
    }

    public void send_deleteDataMovementInterface(org.apache.airavata.model.security.AuthzToken authzToken, String productUri, String dataMovementInterfaceId, org.apache.airavata.model.data.movement.DMType dataMoveType) throws org.apache.thrift.TException
    {
      deleteDataMovementInterface_args args = new deleteDataMovementInterface_args();
      args.setAuthzToken(authzToken);
      args.setProductUri(productUri);
      args.setDataMovementInterfaceId(dataMovementInterfaceId);
      args.setDataMoveType(dataMoveType);
      sendBase("deleteDataMovementInterface", args);
    }

    public boolean recv_deleteDataMovementInterface() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      deleteDataMovementInterface_result result = new deleteDataMovementInterface_result();
      receiveBase(result, "deleteDataMovementInterface");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteDataMovementInterface failed: unknown result");
    }

    public String registerResourceJobManager(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager resourceJobManager) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_registerResourceJobManager(authzToken, resourceJobManager);
      return recv_registerResourceJobManager();
    }

    public void send_registerResourceJobManager(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager resourceJobManager) throws org.apache.thrift.TException
    {
      registerResourceJobManager_args args = new registerResourceJobManager_args();
      args.setAuthzToken(authzToken);
      args.setResourceJobManager(resourceJobManager);
      sendBase("registerResourceJobManager", args);
    }

    public String recv_registerResourceJobManager() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      registerResourceJobManager_result result = new registerResourceJobManager_result();
      receiveBase(result, "registerResourceJobManager");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "registerResourceJobManager failed: unknown result");
    }

    public boolean updateResourceJobManager(org.apache.airavata.model.security.AuthzToken authzToken, String resourceJobManagerId, org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager updatedResourceJobManager) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_updateResourceJobManager(authzToken, resourceJobManagerId, updatedResourceJobManager);
      return recv_updateResourceJobManager();
    }

    public void send_updateResourceJobManager(org.apache.airavata.model.security.AuthzToken authzToken, String resourceJobManagerId, org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager updatedResourceJobManager) throws org.apache.thrift.TException
    {
      updateResourceJobManager_args args = new updateResourceJobManager_args();
      args.setAuthzToken(authzToken);
      args.setResourceJobManagerId(resourceJobManagerId);
      args.setUpdatedResourceJobManager(updatedResourceJobManager);
      sendBase("updateResourceJobManager", args);
    }

    public boolean recv_updateResourceJobManager() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      updateResourceJobManager_result result = new updateResourceJobManager_result();
      receiveBase(result, "updateResourceJobManager");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateResourceJobManager failed: unknown result");
    }

    public org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager getResourceJobManager(org.apache.airavata.model.security.AuthzToken authzToken, String resourceJobManagerId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getResourceJobManager(authzToken, resourceJobManagerId);
      return recv_getResourceJobManager();
    }

    public void send_getResourceJobManager(org.apache.airavata.model.security.AuthzToken authzToken, String resourceJobManagerId) throws org.apache.thrift.TException
    {
      getResourceJobManager_args args = new getResourceJobManager_args();
      args.setAuthzToken(authzToken);
      args.setResourceJobManagerId(resourceJobManagerId);
      sendBase("getResourceJobManager", args);
    }

    public org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager recv_getResourceJobManager() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getResourceJobManager_result result = new getResourceJobManager_result();
      receiveBase(result, "getResourceJobManager");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getResourceJobManager failed: unknown result");
    }

    public boolean deleteResourceJobManager(org.apache.airavata.model.security.AuthzToken authzToken, String resourceJobManagerId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_deleteResourceJobManager(authzToken, resourceJobManagerId);
      return recv_deleteResourceJobManager();
    }

    public void send_deleteResourceJobManager(org.apache.airavata.model.security.AuthzToken authzToken, String resourceJobManagerId) throws org.apache.thrift.TException
    {
      deleteResourceJobManager_args args = new deleteResourceJobManager_args();
      args.setAuthzToken(authzToken);
      args.setResourceJobManagerId(resourceJobManagerId);
      sendBase("deleteResourceJobManager", args);
    }

    public boolean recv_deleteResourceJobManager() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      deleteResourceJobManager_result result = new deleteResourceJobManager_result();
      receiveBase(result, "deleteResourceJobManager");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteResourceJobManager failed: unknown result");
    }

    public boolean deleteBatchQueue(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, String queueName) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_deleteBatchQueue(authzToken, computeResourceId, queueName);
      return recv_deleteBatchQueue();
    }

    public void send_deleteBatchQueue(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, String queueName) throws org.apache.thrift.TException
    {
      deleteBatchQueue_args args = new deleteBatchQueue_args();
      args.setAuthzToken(authzToken);
      args.setComputeResourceId(computeResourceId);
      args.setQueueName(queueName);
      sendBase("deleteBatchQueue", args);
    }

    public boolean recv_deleteBatchQueue() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      deleteBatchQueue_result result = new deleteBatchQueue_result();
      receiveBase(result, "deleteBatchQueue");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteBatchQueue failed: unknown result");
    }

    public String registerGatewayResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile gatewayResourceProfile) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_registerGatewayResourceProfile(authzToken, gatewayResourceProfile);
      return recv_registerGatewayResourceProfile();
    }

    public void send_registerGatewayResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile gatewayResourceProfile) throws org.apache.thrift.TException
    {
      registerGatewayResourceProfile_args args = new registerGatewayResourceProfile_args();
      args.setAuthzToken(authzToken);
      args.setGatewayResourceProfile(gatewayResourceProfile);
      sendBase("registerGatewayResourceProfile", args);
    }

    public String recv_registerGatewayResourceProfile() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      registerGatewayResourceProfile_result result = new registerGatewayResourceProfile_result();
      receiveBase(result, "registerGatewayResourceProfile");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "registerGatewayResourceProfile failed: unknown result");
    }

    public org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile getGatewayResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getGatewayResourceProfile(authzToken, gatewayID);
      return recv_getGatewayResourceProfile();
    }

    public void send_getGatewayResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID) throws org.apache.thrift.TException
    {
      getGatewayResourceProfile_args args = new getGatewayResourceProfile_args();
      args.setAuthzToken(authzToken);
      args.setGatewayID(gatewayID);
      sendBase("getGatewayResourceProfile", args);
    }

    public org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile recv_getGatewayResourceProfile() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getGatewayResourceProfile_result result = new getGatewayResourceProfile_result();
      receiveBase(result, "getGatewayResourceProfile");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getGatewayResourceProfile failed: unknown result");
    }

    public boolean updateGatewayResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile gatewayResourceProfile) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_updateGatewayResourceProfile(authzToken, gatewayID, gatewayResourceProfile);
      return recv_updateGatewayResourceProfile();
    }

    public void send_updateGatewayResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile gatewayResourceProfile) throws org.apache.thrift.TException
    {
      updateGatewayResourceProfile_args args = new updateGatewayResourceProfile_args();
      args.setAuthzToken(authzToken);
      args.setGatewayID(gatewayID);
      args.setGatewayResourceProfile(gatewayResourceProfile);
      sendBase("updateGatewayResourceProfile", args);
    }

    public boolean recv_updateGatewayResourceProfile() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      updateGatewayResourceProfile_result result = new updateGatewayResourceProfile_result();
      receiveBase(result, "updateGatewayResourceProfile");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateGatewayResourceProfile failed: unknown result");
    }

    public boolean deleteGatewayResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_deleteGatewayResourceProfile(authzToken, gatewayID);
      return recv_deleteGatewayResourceProfile();
    }

    public void send_deleteGatewayResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID) throws org.apache.thrift.TException
    {
      deleteGatewayResourceProfile_args args = new deleteGatewayResourceProfile_args();
      args.setAuthzToken(authzToken);
      args.setGatewayID(gatewayID);
      sendBase("deleteGatewayResourceProfile", args);
    }

    public boolean recv_deleteGatewayResourceProfile() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      deleteGatewayResourceProfile_result result = new deleteGatewayResourceProfile_result();
      receiveBase(result, "deleteGatewayResourceProfile");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteGatewayResourceProfile failed: unknown result");
    }

    public boolean addGatewayComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String computeResourceId, org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference computeResourcePreference) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_addGatewayComputeResourcePreference(authzToken, gatewayID, computeResourceId, computeResourcePreference);
      return recv_addGatewayComputeResourcePreference();
    }

    public void send_addGatewayComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String computeResourceId, org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference computeResourcePreference) throws org.apache.thrift.TException
    {
      addGatewayComputeResourcePreference_args args = new addGatewayComputeResourcePreference_args();
      args.setAuthzToken(authzToken);
      args.setGatewayID(gatewayID);
      args.setComputeResourceId(computeResourceId);
      args.setComputeResourcePreference(computeResourcePreference);
      sendBase("addGatewayComputeResourcePreference", args);
    }

    public boolean recv_addGatewayComputeResourcePreference() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      addGatewayComputeResourcePreference_result result = new addGatewayComputeResourcePreference_result();
      receiveBase(result, "addGatewayComputeResourcePreference");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "addGatewayComputeResourcePreference failed: unknown result");
    }

    public boolean addGatewayStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String storageResourceId, org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference storagePreference) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_addGatewayStoragePreference(authzToken, gatewayID, storageResourceId, storagePreference);
      return recv_addGatewayStoragePreference();
    }

    public void send_addGatewayStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String storageResourceId, org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference storagePreference) throws org.apache.thrift.TException
    {
      addGatewayStoragePreference_args args = new addGatewayStoragePreference_args();
      args.setAuthzToken(authzToken);
      args.setGatewayID(gatewayID);
      args.setStorageResourceId(storageResourceId);
      args.setStoragePreference(storagePreference);
      sendBase("addGatewayStoragePreference", args);
    }

    public boolean recv_addGatewayStoragePreference() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      addGatewayStoragePreference_result result = new addGatewayStoragePreference_result();
      receiveBase(result, "addGatewayStoragePreference");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "addGatewayStoragePreference failed: unknown result");
    }

    public org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference getGatewayComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String computeResourceId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getGatewayComputeResourcePreference(authzToken, gatewayID, computeResourceId);
      return recv_getGatewayComputeResourcePreference();
    }

    public void send_getGatewayComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String computeResourceId) throws org.apache.thrift.TException
    {
      getGatewayComputeResourcePreference_args args = new getGatewayComputeResourcePreference_args();
      args.setAuthzToken(authzToken);
      args.setGatewayID(gatewayID);
      args.setComputeResourceId(computeResourceId);
      sendBase("getGatewayComputeResourcePreference", args);
    }

    public org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference recv_getGatewayComputeResourcePreference() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getGatewayComputeResourcePreference_result result = new getGatewayComputeResourcePreference_result();
      receiveBase(result, "getGatewayComputeResourcePreference");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getGatewayComputeResourcePreference failed: unknown result");
    }

    public org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference getGatewayStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String storageResourceId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getGatewayStoragePreference(authzToken, gatewayID, storageResourceId);
      return recv_getGatewayStoragePreference();
    }

    public void send_getGatewayStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String storageResourceId) throws org.apache.thrift.TException
    {
      getGatewayStoragePreference_args args = new getGatewayStoragePreference_args();
      args.setAuthzToken(authzToken);
      args.setGatewayID(gatewayID);
      args.setStorageResourceId(storageResourceId);
      sendBase("getGatewayStoragePreference", args);
    }

    public org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference recv_getGatewayStoragePreference() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getGatewayStoragePreference_result result = new getGatewayStoragePreference_result();
      receiveBase(result, "getGatewayStoragePreference");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getGatewayStoragePreference failed: unknown result");
    }

    public List<org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference> getAllGatewayComputeResourcePreferences(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getAllGatewayComputeResourcePreferences(authzToken, gatewayID);
      return recv_getAllGatewayComputeResourcePreferences();
    }

    public void send_getAllGatewayComputeResourcePreferences(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID) throws org.apache.thrift.TException
    {
      getAllGatewayComputeResourcePreferences_args args = new getAllGatewayComputeResourcePreferences_args();
      args.setAuthzToken(authzToken);
      args.setGatewayID(gatewayID);
      sendBase("getAllGatewayComputeResourcePreferences", args);
    }

    public List<org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference> recv_getAllGatewayComputeResourcePreferences() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getAllGatewayComputeResourcePreferences_result result = new getAllGatewayComputeResourcePreferences_result();
      receiveBase(result, "getAllGatewayComputeResourcePreferences");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllGatewayComputeResourcePreferences failed: unknown result");
    }

    public List<org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference> getAllGatewayStoragePreferences(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getAllGatewayStoragePreferences(authzToken, gatewayID);
      return recv_getAllGatewayStoragePreferences();
    }

    public void send_getAllGatewayStoragePreferences(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID) throws org.apache.thrift.TException
    {
      getAllGatewayStoragePreferences_args args = new getAllGatewayStoragePreferences_args();
      args.setAuthzToken(authzToken);
      args.setGatewayID(gatewayID);
      sendBase("getAllGatewayStoragePreferences", args);
    }

    public List<org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference> recv_getAllGatewayStoragePreferences() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getAllGatewayStoragePreferences_result result = new getAllGatewayStoragePreferences_result();
      receiveBase(result, "getAllGatewayStoragePreferences");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllGatewayStoragePreferences failed: unknown result");
    }

    public List<org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile> getAllGatewayResourceProfiles(org.apache.airavata.model.security.AuthzToken authzToken) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getAllGatewayResourceProfiles(authzToken);
      return recv_getAllGatewayResourceProfiles();
    }

    public void send_getAllGatewayResourceProfiles(org.apache.airavata.model.security.AuthzToken authzToken) throws org.apache.thrift.TException
    {
      getAllGatewayResourceProfiles_args args = new getAllGatewayResourceProfiles_args();
      args.setAuthzToken(authzToken);
      sendBase("getAllGatewayResourceProfiles", args);
    }

    public List<org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile> recv_getAllGatewayResourceProfiles() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getAllGatewayResourceProfiles_result result = new getAllGatewayResourceProfiles_result();
      receiveBase(result, "getAllGatewayResourceProfiles");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllGatewayResourceProfiles failed: unknown result");
    }

    public boolean updateGatewayComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String computeResourceId, org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference computeResourcePreference) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_updateGatewayComputeResourcePreference(authzToken, gatewayID, computeResourceId, computeResourcePreference);
      return recv_updateGatewayComputeResourcePreference();
    }

    public void send_updateGatewayComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String computeResourceId, org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference computeResourcePreference) throws org.apache.thrift.TException
    {
      updateGatewayComputeResourcePreference_args args = new updateGatewayComputeResourcePreference_args();
      args.setAuthzToken(authzToken);
      args.setGatewayID(gatewayID);
      args.setComputeResourceId(computeResourceId);
      args.setComputeResourcePreference(computeResourcePreference);
      sendBase("updateGatewayComputeResourcePreference", args);
    }

    public boolean recv_updateGatewayComputeResourcePreference() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      updateGatewayComputeResourcePreference_result result = new updateGatewayComputeResourcePreference_result();
      receiveBase(result, "updateGatewayComputeResourcePreference");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateGatewayComputeResourcePreference failed: unknown result");
    }

    public boolean updateGatewayStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String storageId, org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference storagePreference) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_updateGatewayStoragePreference(authzToken, gatewayID, storageId, storagePreference);
      return recv_updateGatewayStoragePreference();
    }

    public void send_updateGatewayStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String storageId, org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference storagePreference) throws org.apache.thrift.TException
    {
      updateGatewayStoragePreference_args args = new updateGatewayStoragePreference_args();
      args.setAuthzToken(authzToken);
      args.setGatewayID(gatewayID);
      args.setStorageId(storageId);
      args.setStoragePreference(storagePreference);
      sendBase("updateGatewayStoragePreference", args);
    }

    public boolean recv_updateGatewayStoragePreference() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      updateGatewayStoragePreference_result result = new updateGatewayStoragePreference_result();
      receiveBase(result, "updateGatewayStoragePreference");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateGatewayStoragePreference failed: unknown result");
    }

    public boolean deleteGatewayComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String computeResourceId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_deleteGatewayComputeResourcePreference(authzToken, gatewayID, computeResourceId);
      return recv_deleteGatewayComputeResourcePreference();
    }

    public void send_deleteGatewayComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String computeResourceId) throws org.apache.thrift.TException
    {
      deleteGatewayComputeResourcePreference_args args = new deleteGatewayComputeResourcePreference_args();
      args.setAuthzToken(authzToken);
      args.setGatewayID(gatewayID);
      args.setComputeResourceId(computeResourceId);
      sendBase("deleteGatewayComputeResourcePreference", args);
    }

    public boolean recv_deleteGatewayComputeResourcePreference() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      deleteGatewayComputeResourcePreference_result result = new deleteGatewayComputeResourcePreference_result();
      receiveBase(result, "deleteGatewayComputeResourcePreference");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteGatewayComputeResourcePreference failed: unknown result");
    }

    public boolean deleteGatewayStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String storageId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_deleteGatewayStoragePreference(authzToken, gatewayID, storageId);
      return recv_deleteGatewayStoragePreference();
    }

    public void send_deleteGatewayStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String storageId) throws org.apache.thrift.TException
    {
      deleteGatewayStoragePreference_args args = new deleteGatewayStoragePreference_args();
      args.setAuthzToken(authzToken);
      args.setGatewayID(gatewayID);
      args.setStorageId(storageId);
      sendBase("deleteGatewayStoragePreference", args);
    }

    public boolean recv_deleteGatewayStoragePreference() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      deleteGatewayStoragePreference_result result = new deleteGatewayStoragePreference_result();
      receiveBase(result, "deleteGatewayStoragePreference");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteGatewayStoragePreference failed: unknown result");
    }

    public List<org.apache.airavata.model.appcatalog.accountprovisioning.SSHAccountProvisioner> getSSHAccountProvisioners(org.apache.airavata.model.security.AuthzToken authzToken) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getSSHAccountProvisioners(authzToken);
      return recv_getSSHAccountProvisioners();
    }

    public void send_getSSHAccountProvisioners(org.apache.airavata.model.security.AuthzToken authzToken) throws org.apache.thrift.TException
    {
      getSSHAccountProvisioners_args args = new getSSHAccountProvisioners_args();
      args.setAuthzToken(authzToken);
      sendBase("getSSHAccountProvisioners", args);
    }

    public List<org.apache.airavata.model.appcatalog.accountprovisioning.SSHAccountProvisioner> recv_getSSHAccountProvisioners() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getSSHAccountProvisioners_result result = new getSSHAccountProvisioners_result();
      receiveBase(result, "getSSHAccountProvisioners");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getSSHAccountProvisioners failed: unknown result");
    }

    public boolean doesUserHaveSSHAccount(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, String userId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_doesUserHaveSSHAccount(authzToken, computeResourceId, userId);
      return recv_doesUserHaveSSHAccount();
    }

    public void send_doesUserHaveSSHAccount(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, String userId) throws org.apache.thrift.TException
    {
      doesUserHaveSSHAccount_args args = new doesUserHaveSSHAccount_args();
      args.setAuthzToken(authzToken);
      args.setComputeResourceId(computeResourceId);
      args.setUserId(userId);
      sendBase("doesUserHaveSSHAccount", args);
    }

    public boolean recv_doesUserHaveSSHAccount() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      doesUserHaveSSHAccount_result result = new doesUserHaveSSHAccount_result();
      receiveBase(result, "doesUserHaveSSHAccount");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "doesUserHaveSSHAccount failed: unknown result");
    }

    public boolean isSSHSetupCompleteForUserComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, String airavataCredStoreToken) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_isSSHSetupCompleteForUserComputeResourcePreference(authzToken, computeResourceId, airavataCredStoreToken);
      return recv_isSSHSetupCompleteForUserComputeResourcePreference();
    }

    public void send_isSSHSetupCompleteForUserComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, String airavataCredStoreToken) throws org.apache.thrift.TException
    {
      isSSHSetupCompleteForUserComputeResourcePreference_args args = new isSSHSetupCompleteForUserComputeResourcePreference_args();
      args.setAuthzToken(authzToken);
      args.setComputeResourceId(computeResourceId);
      args.setAiravataCredStoreToken(airavataCredStoreToken);
      sendBase("isSSHSetupCompleteForUserComputeResourcePreference", args);
    }

    public boolean recv_isSSHSetupCompleteForUserComputeResourcePreference() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      isSSHSetupCompleteForUserComputeResourcePreference_result result = new isSSHSetupCompleteForUserComputeResourcePreference_result();
      receiveBase(result, "isSSHSetupCompleteForUserComputeResourcePreference");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "isSSHSetupCompleteForUserComputeResourcePreference failed: unknown result");
    }

    public org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference setupUserComputeResourcePreferencesForSSH(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, String userId, String airavataCredStoreToken) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_setupUserComputeResourcePreferencesForSSH(authzToken, computeResourceId, userId, airavataCredStoreToken);
      return recv_setupUserComputeResourcePreferencesForSSH();
    }

    public void send_setupUserComputeResourcePreferencesForSSH(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, String userId, String airavataCredStoreToken) throws org.apache.thrift.TException
    {
      setupUserComputeResourcePreferencesForSSH_args args = new setupUserComputeResourcePreferencesForSSH_args();
      args.setAuthzToken(authzToken);
      args.setComputeResourceId(computeResourceId);
      args.setUserId(userId);
      args.setAiravataCredStoreToken(airavataCredStoreToken);
      sendBase("setupUserComputeResourcePreferencesForSSH", args);
    }

    public org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference recv_setupUserComputeResourcePreferencesForSSH() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      setupUserComputeResourcePreferencesForSSH_result result = new setupUserComputeResourcePreferencesForSSH_result();
      receiveBase(result, "setupUserComputeResourcePreferencesForSSH");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "setupUserComputeResourcePreferencesForSSH failed: unknown result");
    }

    public String registerUserResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile userResourceProfile) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_registerUserResourceProfile(authzToken, userResourceProfile);
      return recv_registerUserResourceProfile();
    }

    public void send_registerUserResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile userResourceProfile) throws org.apache.thrift.TException
    {
      registerUserResourceProfile_args args = new registerUserResourceProfile_args();
      args.setAuthzToken(authzToken);
      args.setUserResourceProfile(userResourceProfile);
      sendBase("registerUserResourceProfile", args);
    }

    public String recv_registerUserResourceProfile() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      registerUserResourceProfile_result result = new registerUserResourceProfile_result();
      receiveBase(result, "registerUserResourceProfile");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "registerUserResourceProfile failed: unknown result");
    }

    public org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile getUserResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getUserResourceProfile(authzToken, userId, gatewayID);
      return recv_getUserResourceProfile();
    }

    public void send_getUserResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID) throws org.apache.thrift.TException
    {
      getUserResourceProfile_args args = new getUserResourceProfile_args();
      args.setAuthzToken(authzToken);
      args.setUserId(userId);
      args.setGatewayID(gatewayID);
      sendBase("getUserResourceProfile", args);
    }

    public org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile recv_getUserResourceProfile() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getUserResourceProfile_result result = new getUserResourceProfile_result();
      receiveBase(result, "getUserResourceProfile");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getUserResourceProfile failed: unknown result");
    }

    public boolean updateUserResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile userResourceProfile) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_updateUserResourceProfile(authzToken, userId, gatewayID, userResourceProfile);
      return recv_updateUserResourceProfile();
    }

    public void send_updateUserResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile userResourceProfile) throws org.apache.thrift.TException
    {
      updateUserResourceProfile_args args = new updateUserResourceProfile_args();
      args.setAuthzToken(authzToken);
      args.setUserId(userId);
      args.setGatewayID(gatewayID);
      args.setUserResourceProfile(userResourceProfile);
      sendBase("updateUserResourceProfile", args);
    }

    public boolean recv_updateUserResourceProfile() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      updateUserResourceProfile_result result = new updateUserResourceProfile_result();
      receiveBase(result, "updateUserResourceProfile");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateUserResourceProfile failed: unknown result");
    }

    public boolean deleteUserResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_deleteUserResourceProfile(authzToken, userId, gatewayID);
      return recv_deleteUserResourceProfile();
    }

    public void send_deleteUserResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID) throws org.apache.thrift.TException
    {
      deleteUserResourceProfile_args args = new deleteUserResourceProfile_args();
      args.setAuthzToken(authzToken);
      args.setUserId(userId);
      args.setGatewayID(gatewayID);
      sendBase("deleteUserResourceProfile", args);
    }

    public boolean recv_deleteUserResourceProfile() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      deleteUserResourceProfile_result result = new deleteUserResourceProfile_result();
      receiveBase(result, "deleteUserResourceProfile");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteUserResourceProfile failed: unknown result");
    }

    public boolean addUserComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userComputeResourceId, org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference userComputeResourcePreference) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_addUserComputeResourcePreference(authzToken, userId, gatewayID, userComputeResourceId, userComputeResourcePreference);
      return recv_addUserComputeResourcePreference();
    }

    public void send_addUserComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userComputeResourceId, org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference userComputeResourcePreference) throws org.apache.thrift.TException
    {
      addUserComputeResourcePreference_args args = new addUserComputeResourcePreference_args();
      args.setAuthzToken(authzToken);
      args.setUserId(userId);
      args.setGatewayID(gatewayID);
      args.setUserComputeResourceId(userComputeResourceId);
      args.setUserComputeResourcePreference(userComputeResourcePreference);
      sendBase("addUserComputeResourcePreference", args);
    }

    public boolean recv_addUserComputeResourcePreference() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      addUserComputeResourcePreference_result result = new addUserComputeResourcePreference_result();
      receiveBase(result, "addUserComputeResourcePreference");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "addUserComputeResourcePreference failed: unknown result");
    }

    public boolean addUserStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userStorageResourceId, org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference userStoragePreference) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_addUserStoragePreference(authzToken, userId, gatewayID, userStorageResourceId, userStoragePreference);
      return recv_addUserStoragePreference();
    }

    public void send_addUserStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userStorageResourceId, org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference userStoragePreference) throws org.apache.thrift.TException
    {
      addUserStoragePreference_args args = new addUserStoragePreference_args();
      args.setAuthzToken(authzToken);
      args.setUserId(userId);
      args.setGatewayID(gatewayID);
      args.setUserStorageResourceId(userStorageResourceId);
      args.setUserStoragePreference(userStoragePreference);
      sendBase("addUserStoragePreference", args);
    }

    public boolean recv_addUserStoragePreference() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      addUserStoragePreference_result result = new addUserStoragePreference_result();
      receiveBase(result, "addUserStoragePreference");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "addUserStoragePreference failed: unknown result");
    }

    public org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference getUserComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userComputeResourceId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getUserComputeResourcePreference(authzToken, userId, gatewayID, userComputeResourceId);
      return recv_getUserComputeResourcePreference();
    }

    public void send_getUserComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userComputeResourceId) throws org.apache.thrift.TException
    {
      getUserComputeResourcePreference_args args = new getUserComputeResourcePreference_args();
      args.setAuthzToken(authzToken);
      args.setUserId(userId);
      args.setGatewayID(gatewayID);
      args.setUserComputeResourceId(userComputeResourceId);
      sendBase("getUserComputeResourcePreference", args);
    }

    public org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference recv_getUserComputeResourcePreference() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getUserComputeResourcePreference_result result = new getUserComputeResourcePreference_result();
      receiveBase(result, "getUserComputeResourcePreference");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getUserComputeResourcePreference failed: unknown result");
    }

    public org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference getUserStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userStorageResourceId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getUserStoragePreference(authzToken, userId, gatewayID, userStorageResourceId);
      return recv_getUserStoragePreference();
    }

    public void send_getUserStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userStorageResourceId) throws org.apache.thrift.TException
    {
      getUserStoragePreference_args args = new getUserStoragePreference_args();
      args.setAuthzToken(authzToken);
      args.setUserId(userId);
      args.setGatewayID(gatewayID);
      args.setUserStorageResourceId(userStorageResourceId);
      sendBase("getUserStoragePreference", args);
    }

    public org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference recv_getUserStoragePreference() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getUserStoragePreference_result result = new getUserStoragePreference_result();
      receiveBase(result, "getUserStoragePreference");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getUserStoragePreference failed: unknown result");
    }

    public List<org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference> getAllUserComputeResourcePreferences(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getAllUserComputeResourcePreferences(authzToken, userId, gatewayID);
      return recv_getAllUserComputeResourcePreferences();
    }

    public void send_getAllUserComputeResourcePreferences(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID) throws org.apache.thrift.TException
    {
      getAllUserComputeResourcePreferences_args args = new getAllUserComputeResourcePreferences_args();
      args.setAuthzToken(authzToken);
      args.setUserId(userId);
      args.setGatewayID(gatewayID);
      sendBase("getAllUserComputeResourcePreferences", args);
    }

    public List<org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference> recv_getAllUserComputeResourcePreferences() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getAllUserComputeResourcePreferences_result result = new getAllUserComputeResourcePreferences_result();
      receiveBase(result, "getAllUserComputeResourcePreferences");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllUserComputeResourcePreferences failed: unknown result");
    }

    public List<org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference> getAllUserStoragePreferences(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getAllUserStoragePreferences(authzToken, userId, gatewayID);
      return recv_getAllUserStoragePreferences();
    }

    public void send_getAllUserStoragePreferences(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID) throws org.apache.thrift.TException
    {
      getAllUserStoragePreferences_args args = new getAllUserStoragePreferences_args();
      args.setAuthzToken(authzToken);
      args.setUserId(userId);
      args.setGatewayID(gatewayID);
      sendBase("getAllUserStoragePreferences", args);
    }

    public List<org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference> recv_getAllUserStoragePreferences() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getAllUserStoragePreferences_result result = new getAllUserStoragePreferences_result();
      receiveBase(result, "getAllUserStoragePreferences");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllUserStoragePreferences failed: unknown result");
    }

    public List<org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile> getAllUserResourceProfiles(org.apache.airavata.model.security.AuthzToken authzToken) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getAllUserResourceProfiles(authzToken);
      return recv_getAllUserResourceProfiles();
    }

    public void send_getAllUserResourceProfiles(org.apache.airavata.model.security.AuthzToken authzToken) throws org.apache.thrift.TException
    {
      getAllUserResourceProfiles_args args = new getAllUserResourceProfiles_args();
      args.setAuthzToken(authzToken);
      sendBase("getAllUserResourceProfiles", args);
    }

    public List<org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile> recv_getAllUserResourceProfiles() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getAllUserResourceProfiles_result result = new getAllUserResourceProfiles_result();
      receiveBase(result, "getAllUserResourceProfiles");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllUserResourceProfiles failed: unknown result");
    }

    public boolean updateUserComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userComputeResourceId, org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference userComputeResourcePreference) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_updateUserComputeResourcePreference(authzToken, userId, gatewayID, userComputeResourceId, userComputeResourcePreference);
      return recv_updateUserComputeResourcePreference();
    }

    public void send_updateUserComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userComputeResourceId, org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference userComputeResourcePreference) throws org.apache.thrift.TException
    {
      updateUserComputeResourcePreference_args args = new updateUserComputeResourcePreference_args();
      args.setAuthzToken(authzToken);
      args.setUserId(userId);
      args.setGatewayID(gatewayID);
      args.setUserComputeResourceId(userComputeResourceId);
      args.setUserComputeResourcePreference(userComputeResourcePreference);
      sendBase("updateUserComputeResourcePreference", args);
    }

    public boolean recv_updateUserComputeResourcePreference() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      updateUserComputeResourcePreference_result result = new updateUserComputeResourcePreference_result();
      receiveBase(result, "updateUserComputeResourcePreference");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateUserComputeResourcePreference failed: unknown result");
    }

    public boolean updateUserStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userStorageId, org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference userStoragePreference) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_updateUserStoragePreference(authzToken, userId, gatewayID, userStorageId, userStoragePreference);
      return recv_updateUserStoragePreference();
    }

    public void send_updateUserStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userStorageId, org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference userStoragePreference) throws org.apache.thrift.TException
    {
      updateUserStoragePreference_args args = new updateUserStoragePreference_args();
      args.setAuthzToken(authzToken);
      args.setUserId(userId);
      args.setGatewayID(gatewayID);
      args.setUserStorageId(userStorageId);
      args.setUserStoragePreference(userStoragePreference);
      sendBase("updateUserStoragePreference", args);
    }

    public boolean recv_updateUserStoragePreference() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      updateUserStoragePreference_result result = new updateUserStoragePreference_result();
      receiveBase(result, "updateUserStoragePreference");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateUserStoragePreference failed: unknown result");
    }

    public boolean deleteUserComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userComputeResourceId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_deleteUserComputeResourcePreference(authzToken, userId, gatewayID, userComputeResourceId);
      return recv_deleteUserComputeResourcePreference();
    }

    public void send_deleteUserComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userComputeResourceId) throws org.apache.thrift.TException
    {
      deleteUserComputeResourcePreference_args args = new deleteUserComputeResourcePreference_args();
      args.setAuthzToken(authzToken);
      args.setUserId(userId);
      args.setGatewayID(gatewayID);
      args.setUserComputeResourceId(userComputeResourceId);
      sendBase("deleteUserComputeResourcePreference", args);
    }

    public boolean recv_deleteUserComputeResourcePreference() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      deleteUserComputeResourcePreference_result result = new deleteUserComputeResourcePreference_result();
      receiveBase(result, "deleteUserComputeResourcePreference");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteUserComputeResourcePreference failed: unknown result");
    }

    public boolean deleteUserStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userStorageId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_deleteUserStoragePreference(authzToken, userId, gatewayID, userStorageId);
      return recv_deleteUserStoragePreference();
    }

    public void send_deleteUserStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userStorageId) throws org.apache.thrift.TException
    {
      deleteUserStoragePreference_args args = new deleteUserStoragePreference_args();
      args.setAuthzToken(authzToken);
      args.setUserId(userId);
      args.setGatewayID(gatewayID);
      args.setUserStorageId(userStorageId);
      sendBase("deleteUserStoragePreference", args);
    }

    public boolean recv_deleteUserStoragePreference() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      deleteUserStoragePreference_result result = new deleteUserStoragePreference_result();
      receiveBase(result, "deleteUserStoragePreference");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteUserStoragePreference failed: unknown result");
    }

    public List<String> getAllWorkflows(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getAllWorkflows(authzToken, gatewayId);
      return recv_getAllWorkflows();
    }

    public void send_getAllWorkflows(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId) throws org.apache.thrift.TException
    {
      getAllWorkflows_args args = new getAllWorkflows_args();
      args.setAuthzToken(authzToken);
      args.setGatewayId(gatewayId);
      sendBase("getAllWorkflows", args);
    }

    public List<String> recv_getAllWorkflows() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getAllWorkflows_result result = new getAllWorkflows_result();
      receiveBase(result, "getAllWorkflows");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllWorkflows failed: unknown result");
    }

    public List<org.apache.airavata.model.status.QueueStatusModel> getLatestQueueStatuses(org.apache.airavata.model.security.AuthzToken authzToken) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getLatestQueueStatuses(authzToken);
      return recv_getLatestQueueStatuses();
    }

    public void send_getLatestQueueStatuses(org.apache.airavata.model.security.AuthzToken authzToken) throws org.apache.thrift.TException
    {
      getLatestQueueStatuses_args args = new getLatestQueueStatuses_args();
      args.setAuthzToken(authzToken);
      sendBase("getLatestQueueStatuses", args);
    }

    public List<org.apache.airavata.model.status.QueueStatusModel> recv_getLatestQueueStatuses() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getLatestQueueStatuses_result result = new getLatestQueueStatuses_result();
      receiveBase(result, "getLatestQueueStatuses");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getLatestQueueStatuses failed: unknown result");
    }

    public org.apache.airavata.model.WorkflowModel getWorkflow(org.apache.airavata.model.security.AuthzToken authzToken, String workflowTemplateId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getWorkflow(authzToken, workflowTemplateId);
      return recv_getWorkflow();
    }

    public void send_getWorkflow(org.apache.airavata.model.security.AuthzToken authzToken, String workflowTemplateId) throws org.apache.thrift.TException
    {
      getWorkflow_args args = new getWorkflow_args();
      args.setAuthzToken(authzToken);
      args.setWorkflowTemplateId(workflowTemplateId);
      sendBase("getWorkflow", args);
    }

    public org.apache.airavata.model.WorkflowModel recv_getWorkflow() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getWorkflow_result result = new getWorkflow_result();
      receiveBase(result, "getWorkflow");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getWorkflow failed: unknown result");
    }

    public void deleteWorkflow(org.apache.airavata.model.security.AuthzToken authzToken, String workflowTemplateId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_deleteWorkflow(authzToken, workflowTemplateId);
      recv_deleteWorkflow();
    }

    public void send_deleteWorkflow(org.apache.airavata.model.security.AuthzToken authzToken, String workflowTemplateId) throws org.apache.thrift.TException
    {
      deleteWorkflow_args args = new deleteWorkflow_args();
      args.setAuthzToken(authzToken);
      args.setWorkflowTemplateId(workflowTemplateId);
      sendBase("deleteWorkflow", args);
    }

    public void recv_deleteWorkflow() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      deleteWorkflow_result result = new deleteWorkflow_result();
      receiveBase(result, "deleteWorkflow");
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      return;
    }

    public String registerWorkflow(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.WorkflowModel workflow) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_registerWorkflow(authzToken, gatewayId, workflow);
      return recv_registerWorkflow();
    }

    public void send_registerWorkflow(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.WorkflowModel workflow) throws org.apache.thrift.TException
    {
      registerWorkflow_args args = new registerWorkflow_args();
      args.setAuthzToken(authzToken);
      args.setGatewayId(gatewayId);
      args.setWorkflow(workflow);
      sendBase("registerWorkflow", args);
    }

    public String recv_registerWorkflow() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      registerWorkflow_result result = new registerWorkflow_result();
      receiveBase(result, "registerWorkflow");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "registerWorkflow failed: unknown result");
    }

    public void updateWorkflow(org.apache.airavata.model.security.AuthzToken authzToken, String workflowTemplateId, org.apache.airavata.model.WorkflowModel workflow) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_updateWorkflow(authzToken, workflowTemplateId, workflow);
      recv_updateWorkflow();
    }

    public void send_updateWorkflow(org.apache.airavata.model.security.AuthzToken authzToken, String workflowTemplateId, org.apache.airavata.model.WorkflowModel workflow) throws org.apache.thrift.TException
    {
      updateWorkflow_args args = new updateWorkflow_args();
      args.setAuthzToken(authzToken);
      args.setWorkflowTemplateId(workflowTemplateId);
      args.setWorkflow(workflow);
      sendBase("updateWorkflow", args);
    }

    public void recv_updateWorkflow() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      updateWorkflow_result result = new updateWorkflow_result();
      receiveBase(result, "updateWorkflow");
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      return;
    }

    public String getWorkflowTemplateId(org.apache.airavata.model.security.AuthzToken authzToken, String workflowName) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getWorkflowTemplateId(authzToken, workflowName);
      return recv_getWorkflowTemplateId();
    }

    public void send_getWorkflowTemplateId(org.apache.airavata.model.security.AuthzToken authzToken, String workflowName) throws org.apache.thrift.TException
    {
      getWorkflowTemplateId_args args = new getWorkflowTemplateId_args();
      args.setAuthzToken(authzToken);
      args.setWorkflowName(workflowName);
      sendBase("getWorkflowTemplateId", args);
    }

    public String recv_getWorkflowTemplateId() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getWorkflowTemplateId_result result = new getWorkflowTemplateId_result();
      receiveBase(result, "getWorkflowTemplateId");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getWorkflowTemplateId failed: unknown result");
    }

    public boolean isWorkflowExistWithName(org.apache.airavata.model.security.AuthzToken authzToken, String workflowName) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_isWorkflowExistWithName(authzToken, workflowName);
      return recv_isWorkflowExistWithName();
    }

    public void send_isWorkflowExistWithName(org.apache.airavata.model.security.AuthzToken authzToken, String workflowName) throws org.apache.thrift.TException
    {
      isWorkflowExistWithName_args args = new isWorkflowExistWithName_args();
      args.setAuthzToken(authzToken);
      args.setWorkflowName(workflowName);
      sendBase("isWorkflowExistWithName", args);
    }

    public boolean recv_isWorkflowExistWithName() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      isWorkflowExistWithName_result result = new isWorkflowExistWithName_result();
      receiveBase(result, "isWorkflowExistWithName");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "isWorkflowExistWithName failed: unknown result");
    }

    public String registerDataProduct(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.data.replica.DataProductModel dataProductModel) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_registerDataProduct(authzToken, dataProductModel);
      return recv_registerDataProduct();
    }

    public void send_registerDataProduct(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.data.replica.DataProductModel dataProductModel) throws org.apache.thrift.TException
    {
      registerDataProduct_args args = new registerDataProduct_args();
      args.setAuthzToken(authzToken);
      args.setDataProductModel(dataProductModel);
      sendBase("registerDataProduct", args);
    }

    public String recv_registerDataProduct() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      registerDataProduct_result result = new registerDataProduct_result();
      receiveBase(result, "registerDataProduct");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "registerDataProduct failed: unknown result");
    }

    public org.apache.airavata.model.data.replica.DataProductModel getDataProduct(org.apache.airavata.model.security.AuthzToken authzToken, String dataProductUri) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getDataProduct(authzToken, dataProductUri);
      return recv_getDataProduct();
    }

    public void send_getDataProduct(org.apache.airavata.model.security.AuthzToken authzToken, String dataProductUri) throws org.apache.thrift.TException
    {
      getDataProduct_args args = new getDataProduct_args();
      args.setAuthzToken(authzToken);
      args.setDataProductUri(dataProductUri);
      sendBase("getDataProduct", args);
    }

    public org.apache.airavata.model.data.replica.DataProductModel recv_getDataProduct() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getDataProduct_result result = new getDataProduct_result();
      receiveBase(result, "getDataProduct");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getDataProduct failed: unknown result");
    }

    public String registerReplicaLocation(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.data.replica.DataReplicaLocationModel replicaLocationModel) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_registerReplicaLocation(authzToken, replicaLocationModel);
      return recv_registerReplicaLocation();
    }

    public void send_registerReplicaLocation(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.data.replica.DataReplicaLocationModel replicaLocationModel) throws org.apache.thrift.TException
    {
      registerReplicaLocation_args args = new registerReplicaLocation_args();
      args.setAuthzToken(authzToken);
      args.setReplicaLocationModel(replicaLocationModel);
      sendBase("registerReplicaLocation", args);
    }

    public String recv_registerReplicaLocation() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      registerReplicaLocation_result result = new registerReplicaLocation_result();
      receiveBase(result, "registerReplicaLocation");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "registerReplicaLocation failed: unknown result");
    }

    public org.apache.airavata.model.data.replica.DataProductModel getParentDataProduct(org.apache.airavata.model.security.AuthzToken authzToken, String productUri) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getParentDataProduct(authzToken, productUri);
      return recv_getParentDataProduct();
    }

    public void send_getParentDataProduct(org.apache.airavata.model.security.AuthzToken authzToken, String productUri) throws org.apache.thrift.TException
    {
      getParentDataProduct_args args = new getParentDataProduct_args();
      args.setAuthzToken(authzToken);
      args.setProductUri(productUri);
      sendBase("getParentDataProduct", args);
    }

    public org.apache.airavata.model.data.replica.DataProductModel recv_getParentDataProduct() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getParentDataProduct_result result = new getParentDataProduct_result();
      receiveBase(result, "getParentDataProduct");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getParentDataProduct failed: unknown result");
    }

    public List<org.apache.airavata.model.data.replica.DataProductModel> getChildDataProducts(org.apache.airavata.model.security.AuthzToken authzToken, String productUri) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getChildDataProducts(authzToken, productUri);
      return recv_getChildDataProducts();
    }

    public void send_getChildDataProducts(org.apache.airavata.model.security.AuthzToken authzToken, String productUri) throws org.apache.thrift.TException
    {
      getChildDataProducts_args args = new getChildDataProducts_args();
      args.setAuthzToken(authzToken);
      args.setProductUri(productUri);
      sendBase("getChildDataProducts", args);
    }

    public List<org.apache.airavata.model.data.replica.DataProductModel> recv_getChildDataProducts() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getChildDataProducts_result result = new getChildDataProducts_result();
      receiveBase(result, "getChildDataProducts");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getChildDataProducts failed: unknown result");
    }

    public boolean shareResourceWithUsers(org.apache.airavata.model.security.AuthzToken authzToken, String resourceId, org.apache.airavata.model.group.ResourceType resourceType, Map<String,org.apache.airavata.model.group.ResourcePermissionType> userPermissionList) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_shareResourceWithUsers(authzToken, resourceId, resourceType, userPermissionList);
      return recv_shareResourceWithUsers();
    }

    public void send_shareResourceWithUsers(org.apache.airavata.model.security.AuthzToken authzToken, String resourceId, org.apache.airavata.model.group.ResourceType resourceType, Map<String,org.apache.airavata.model.group.ResourcePermissionType> userPermissionList) throws org.apache.thrift.TException
    {
      shareResourceWithUsers_args args = new shareResourceWithUsers_args();
      args.setAuthzToken(authzToken);
      args.setResourceId(resourceId);
      args.setResourceType(resourceType);
      args.setUserPermissionList(userPermissionList);
      sendBase("shareResourceWithUsers", args);
    }

    public boolean recv_shareResourceWithUsers() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      shareResourceWithUsers_result result = new shareResourceWithUsers_result();
      receiveBase(result, "shareResourceWithUsers");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "shareResourceWithUsers failed: unknown result");
    }

    public boolean revokeSharingOfResourceFromUsers(org.apache.airavata.model.security.AuthzToken authzToken, String resourceId, org.apache.airavata.model.group.ResourceType resourceType, Map<String,org.apache.airavata.model.group.ResourcePermissionType> userPermissionList) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_revokeSharingOfResourceFromUsers(authzToken, resourceId, resourceType, userPermissionList);
      return recv_revokeSharingOfResourceFromUsers();
    }

    public void send_revokeSharingOfResourceFromUsers(org.apache.airavata.model.security.AuthzToken authzToken, String resourceId, org.apache.airavata.model.group.ResourceType resourceType, Map<String,org.apache.airavata.model.group.ResourcePermissionType> userPermissionList) throws org.apache.thrift.TException
    {
      revokeSharingOfResourceFromUsers_args args = new revokeSharingOfResourceFromUsers_args();
      args.setAuthzToken(authzToken);
      args.setResourceId(resourceId);
      args.setResourceType(resourceType);
      args.setUserPermissionList(userPermissionList);
      sendBase("revokeSharingOfResourceFromUsers", args);
    }

    public boolean recv_revokeSharingOfResourceFromUsers() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      revokeSharingOfResourceFromUsers_result result = new revokeSharingOfResourceFromUsers_result();
      receiveBase(result, "revokeSharingOfResourceFromUsers");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "revokeSharingOfResourceFromUsers failed: unknown result");
    }

    public List<String> getAllAccessibleUsers(org.apache.airavata.model.security.AuthzToken authzToken, String resourceId, org.apache.airavata.model.group.ResourceType resourceType, org.apache.airavata.model.group.ResourcePermissionType permissionType) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getAllAccessibleUsers(authzToken, resourceId, resourceType, permissionType);
      return recv_getAllAccessibleUsers();
    }

    public void send_getAllAccessibleUsers(org.apache.airavata.model.security.AuthzToken authzToken, String resourceId, org.apache.airavata.model.group.ResourceType resourceType, org.apache.airavata.model.group.ResourcePermissionType permissionType) throws org.apache.thrift.TException
    {
      getAllAccessibleUsers_args args = new getAllAccessibleUsers_args();
      args.setAuthzToken(authzToken);
      args.setResourceId(resourceId);
      args.setResourceType(resourceType);
      args.setPermissionType(permissionType);
      sendBase("getAllAccessibleUsers", args);
    }

    public List<String> recv_getAllAccessibleUsers() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getAllAccessibleUsers_result result = new getAllAccessibleUsers_result();
      receiveBase(result, "getAllAccessibleUsers");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllAccessibleUsers failed: unknown result");
    }

    public String createGroup(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.group.GroupModel groupModel) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_createGroup(authzToken, groupModel);
      return recv_createGroup();
    }

    public void send_createGroup(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.group.GroupModel groupModel) throws org.apache.thrift.TException
    {
      createGroup_args args = new createGroup_args();
      args.setAuthzToken(authzToken);
      args.setGroupModel(groupModel);
      sendBase("createGroup", args);
    }

    public String recv_createGroup() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      createGroup_result result = new createGroup_result();
      receiveBase(result, "createGroup");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "createGroup failed: unknown result");
    }

    public boolean updateGroup(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.group.GroupModel groupModel) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_updateGroup(authzToken, groupModel);
      return recv_updateGroup();
    }

    public void send_updateGroup(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.group.GroupModel groupModel) throws org.apache.thrift.TException
    {
      updateGroup_args args = new updateGroup_args();
      args.setAuthzToken(authzToken);
      args.setGroupModel(groupModel);
      sendBase("updateGroup", args);
    }

    public boolean recv_updateGroup() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      updateGroup_result result = new updateGroup_result();
      receiveBase(result, "updateGroup");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "updateGroup failed: unknown result");
    }

    public boolean deleteGroup(org.apache.airavata.model.security.AuthzToken authzToken, String groupId, String ownerId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_deleteGroup(authzToken, groupId, ownerId);
      return recv_deleteGroup();
    }

    public void send_deleteGroup(org.apache.airavata.model.security.AuthzToken authzToken, String groupId, String ownerId) throws org.apache.thrift.TException
    {
      deleteGroup_args args = new deleteGroup_args();
      args.setAuthzToken(authzToken);
      args.setGroupId(groupId);
      args.setOwnerId(ownerId);
      sendBase("deleteGroup", args);
    }

    public boolean recv_deleteGroup() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      deleteGroup_result result = new deleteGroup_result();
      receiveBase(result, "deleteGroup");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteGroup failed: unknown result");
    }

    public org.apache.airavata.model.group.GroupModel getGroup(org.apache.airavata.model.security.AuthzToken authzToken, String groupId) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getGroup(authzToken, groupId);
      return recv_getGroup();
    }

    public void send_getGroup(org.apache.airavata.model.security.AuthzToken authzToken, String groupId) throws org.apache.thrift.TException
    {
      getGroup_args args = new getGroup_args();
      args.setAuthzToken(authzToken);
      args.setGroupId(groupId);
      sendBase("getGroup", args);
    }

    public org.apache.airavata.model.group.GroupModel recv_getGroup() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getGroup_result result = new getGroup_result();
      receiveBase(result, "getGroup");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getGroup failed: unknown result");
    }

    public List<org.apache.airavata.model.group.GroupModel> getAllGroupsUserBelongs(org.apache.airavata.model.security.AuthzToken authzToken, String userName) throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      send_getAllGroupsUserBelongs(authzToken, userName);
      return recv_getAllGroupsUserBelongs();
    }

    public void send_getAllGroupsUserBelongs(org.apache.airavata.model.security.AuthzToken authzToken, String userName) throws org.apache.thrift.TException
    {
      getAllGroupsUserBelongs_args args = new getAllGroupsUserBelongs_args();
      args.setAuthzToken(authzToken);
      args.setUserName(userName);
      sendBase("getAllGroupsUserBelongs", args);
    }

    public List<org.apache.airavata.model.group.GroupModel> recv_getAllGroupsUserBelongs() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException
    {
      getAllGroupsUserBelongs_result result = new getAllGroupsUserBelongs_result();
      receiveBase(result, "getAllGroupsUserBelongs");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.ire != null) {
        throw result.ire;
      }
      if (result.ace != null) {
        throw result.ace;
      }
      if (result.ase != null) {
        throw result.ase;
      }
      if (result.ae != null) {
        throw result.ae;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllGroupsUserBelongs failed: unknown result");
    }

  }
  public static class AsyncClient extends org.apache.thrift.async.TAsyncClient implements AsyncIface {
    public static class Factory implements org.apache.thrift.async.TAsyncClientFactory<AsyncClient> {
      private org.apache.thrift.async.TAsyncClientManager clientManager;
      private org.apache.thrift.protocol.TProtocolFactory protocolFactory;
      public Factory(org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.protocol.TProtocolFactory protocolFactory) {
        this.clientManager = clientManager;
        this.protocolFactory = protocolFactory;
      }
      public AsyncClient getAsyncClient(org.apache.thrift.transport.TNonblockingTransport transport) {
        return new AsyncClient(protocolFactory, clientManager, transport);
      }
    }

    public AsyncClient(org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.transport.TNonblockingTransport transport) {
      super(protocolFactory, clientManager, transport);
    }

    public void getAPIVersion(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAPIVersion_call method_call = new getAPIVersion_call(authzToken, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAPIVersion_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      public getAPIVersion_call(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAPIVersion", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAPIVersion_args args = new getAPIVersion_args();
        args.setAuthzToken(authzToken);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAPIVersion();
      }
    }

    public void isUserExists(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String userName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      isUserExists_call method_call = new isUserExists_call(authzToken, gatewayId, userName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class isUserExists_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayId;
      private String userName;
      public isUserExists_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String userName, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayId = gatewayId;
        this.userName = userName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("isUserExists", org.apache.thrift.protocol.TMessageType.CALL, 0));
        isUserExists_args args = new isUserExists_args();
        args.setAuthzToken(authzToken);
        args.setGatewayId(gatewayId);
        args.setUserName(userName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_isUserExists();
      }
    }

    public void addGateway(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.workspace.Gateway gateway, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addGateway_call method_call = new addGateway_call(authzToken, gateway, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addGateway_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private org.apache.airavata.model.workspace.Gateway gateway;
      public addGateway_call(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.workspace.Gateway gateway, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gateway = gateway;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addGateway", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addGateway_args args = new addGateway_args();
        args.setAuthzToken(authzToken);
        args.setGateway(gateway);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_addGateway();
      }
    }

    public void getAllUsersInGateway(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllUsersInGateway_call method_call = new getAllUsersInGateway_call(authzToken, gatewayId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllUsersInGateway_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayId;
      public getAllUsersInGateway_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayId = gatewayId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllUsersInGateway", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllUsersInGateway_args args = new getAllUsersInGateway_args();
        args.setAuthzToken(authzToken);
        args.setGatewayId(gatewayId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<String> getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllUsersInGateway();
      }
    }

    public void updateGateway(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.workspace.Gateway updatedGateway, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateGateway_call method_call = new updateGateway_call(authzToken, gatewayId, updatedGateway, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateGateway_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayId;
      private org.apache.airavata.model.workspace.Gateway updatedGateway;
      public updateGateway_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.workspace.Gateway updatedGateway, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayId = gatewayId;
        this.updatedGateway = updatedGateway;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateGateway", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateGateway_args args = new updateGateway_args();
        args.setAuthzToken(authzToken);
        args.setGatewayId(gatewayId);
        args.setUpdatedGateway(updatedGateway);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateGateway();
      }
    }

    public void getGateway(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getGateway_call method_call = new getGateway_call(authzToken, gatewayId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getGateway_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayId;
      public getGateway_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayId = gatewayId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getGateway", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getGateway_args args = new getGateway_args();
        args.setAuthzToken(authzToken);
        args.setGatewayId(gatewayId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.workspace.Gateway getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getGateway();
      }
    }

    public void deleteGateway(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteGateway_call method_call = new deleteGateway_call(authzToken, gatewayId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteGateway_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayId;
      public deleteGateway_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayId = gatewayId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteGateway", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteGateway_args args = new deleteGateway_args();
        args.setAuthzToken(authzToken);
        args.setGatewayId(gatewayId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteGateway();
      }
    }

    public void getAllGateways(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllGateways_call method_call = new getAllGateways_call(authzToken, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllGateways_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      public getAllGateways_call(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllGateways", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllGateways_args args = new getAllGateways_args();
        args.setAuthzToken(authzToken);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.workspace.Gateway> getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllGateways();
      }
    }

    public void isGatewayExist(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      isGatewayExist_call method_call = new isGatewayExist_call(authzToken, gatewayId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class isGatewayExist_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayId;
      public isGatewayExist_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayId = gatewayId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("isGatewayExist", org.apache.thrift.protocol.TMessageType.CALL, 0));
        isGatewayExist_args args = new isGatewayExist_args();
        args.setAuthzToken(authzToken);
        args.setGatewayId(gatewayId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_isGatewayExist();
      }
    }

    public void createNotification(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.workspace.Notification notification, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      createNotification_call method_call = new createNotification_call(authzToken, notification, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class createNotification_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private org.apache.airavata.model.workspace.Notification notification;
      public createNotification_call(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.workspace.Notification notification, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.notification = notification;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("createNotification", org.apache.thrift.protocol.TMessageType.CALL, 0));
        createNotification_args args = new createNotification_args();
        args.setAuthzToken(authzToken);
        args.setNotification(notification);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_createNotification();
      }
    }

    public void updateNotification(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.workspace.Notification notification, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateNotification_call method_call = new updateNotification_call(authzToken, notification, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateNotification_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private org.apache.airavata.model.workspace.Notification notification;
      public updateNotification_call(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.workspace.Notification notification, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.notification = notification;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateNotification", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateNotification_args args = new updateNotification_args();
        args.setAuthzToken(authzToken);
        args.setNotification(notification);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateNotification();
      }
    }

    public void deleteNotification(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String notificationId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteNotification_call method_call = new deleteNotification_call(authzToken, gatewayId, notificationId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteNotification_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayId;
      private String notificationId;
      public deleteNotification_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String notificationId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayId = gatewayId;
        this.notificationId = notificationId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteNotification", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteNotification_args args = new deleteNotification_args();
        args.setAuthzToken(authzToken);
        args.setGatewayId(gatewayId);
        args.setNotificationId(notificationId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteNotification();
      }
    }

    public void getNotification(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String notificationId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getNotification_call method_call = new getNotification_call(authzToken, gatewayId, notificationId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getNotification_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayId;
      private String notificationId;
      public getNotification_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String notificationId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayId = gatewayId;
        this.notificationId = notificationId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getNotification", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getNotification_args args = new getNotification_args();
        args.setAuthzToken(authzToken);
        args.setGatewayId(gatewayId);
        args.setNotificationId(notificationId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.workspace.Notification getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getNotification();
      }
    }

    public void getAllNotifications(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllNotifications_call method_call = new getAllNotifications_call(authzToken, gatewayId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllNotifications_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayId;
      public getAllNotifications_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayId = gatewayId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllNotifications", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllNotifications_args args = new getAllNotifications_args();
        args.setAuthzToken(authzToken);
        args.setGatewayId(gatewayId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.workspace.Notification> getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllNotifications();
      }
    }

    public void generateAndRegisterSSHKeys(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String userName, String description, org.apache.airavata.model.credential.store.CredentialOwnerType credentialOwnerType, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      generateAndRegisterSSHKeys_call method_call = new generateAndRegisterSSHKeys_call(authzToken, gatewayId, userName, description, credentialOwnerType, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class generateAndRegisterSSHKeys_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayId;
      private String userName;
      private String description;
      private org.apache.airavata.model.credential.store.CredentialOwnerType credentialOwnerType;
      public generateAndRegisterSSHKeys_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String userName, String description, org.apache.airavata.model.credential.store.CredentialOwnerType credentialOwnerType, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayId = gatewayId;
        this.userName = userName;
        this.description = description;
        this.credentialOwnerType = credentialOwnerType;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("generateAndRegisterSSHKeys", org.apache.thrift.protocol.TMessageType.CALL, 0));
        generateAndRegisterSSHKeys_args args = new generateAndRegisterSSHKeys_args();
        args.setAuthzToken(authzToken);
        args.setGatewayId(gatewayId);
        args.setUserName(userName);
        args.setDescription(description);
        args.setCredentialOwnerType(credentialOwnerType);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_generateAndRegisterSSHKeys();
      }
    }

    public void registerPwdCredential(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String portalUserName, String loginUserName, String password, String description, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      registerPwdCredential_call method_call = new registerPwdCredential_call(authzToken, gatewayId, portalUserName, loginUserName, password, description, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class registerPwdCredential_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayId;
      private String portalUserName;
      private String loginUserName;
      private String password;
      private String description;
      public registerPwdCredential_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String portalUserName, String loginUserName, String password, String description, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayId = gatewayId;
        this.portalUserName = portalUserName;
        this.loginUserName = loginUserName;
        this.password = password;
        this.description = description;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("registerPwdCredential", org.apache.thrift.protocol.TMessageType.CALL, 0));
        registerPwdCredential_args args = new registerPwdCredential_args();
        args.setAuthzToken(authzToken);
        args.setGatewayId(gatewayId);
        args.setPortalUserName(portalUserName);
        args.setLoginUserName(loginUserName);
        args.setPassword(password);
        args.setDescription(description);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_registerPwdCredential();
      }
    }

    public void getSSHPubKey(org.apache.airavata.model.security.AuthzToken authzToken, String airavataCredStoreToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getSSHPubKey_call method_call = new getSSHPubKey_call(authzToken, airavataCredStoreToken, gatewayId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getSSHPubKey_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String airavataCredStoreToken;
      private String gatewayId;
      public getSSHPubKey_call(org.apache.airavata.model.security.AuthzToken authzToken, String airavataCredStoreToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.airavataCredStoreToken = airavataCredStoreToken;
        this.gatewayId = gatewayId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getSSHPubKey", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getSSHPubKey_args args = new getSSHPubKey_args();
        args.setAuthzToken(authzToken);
        args.setAiravataCredStoreToken(airavataCredStoreToken);
        args.setGatewayId(gatewayId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getSSHPubKey();
      }
    }

    public void getAllGatewaySSHPubKeys(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllGatewaySSHPubKeys_call method_call = new getAllGatewaySSHPubKeys_call(authzToken, gatewayId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllGatewaySSHPubKeys_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayId;
      public getAllGatewaySSHPubKeys_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayId = gatewayId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllGatewaySSHPubKeys", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllGatewaySSHPubKeys_args args = new getAllGatewaySSHPubKeys_args();
        args.setAuthzToken(authzToken);
        args.setGatewayId(gatewayId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Map<String,String> getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllGatewaySSHPubKeys();
      }
    }

    public void getAllCredentialSummaryForGateway(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.credential.store.SummaryType type, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllCredentialSummaryForGateway_call method_call = new getAllCredentialSummaryForGateway_call(authzToken, type, gatewayId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllCredentialSummaryForGateway_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private org.apache.airavata.model.credential.store.SummaryType type;
      private String gatewayId;
      public getAllCredentialSummaryForGateway_call(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.credential.store.SummaryType type, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.type = type;
        this.gatewayId = gatewayId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllCredentialSummaryForGateway", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllCredentialSummaryForGateway_args args = new getAllCredentialSummaryForGateway_args();
        args.setAuthzToken(authzToken);
        args.setType(type);
        args.setGatewayId(gatewayId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.credential.store.CredentialSummary> getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllCredentialSummaryForGateway();
      }
    }

    public void getAllCredentialSummaryForUsersInGateway(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.credential.store.SummaryType type, String gatewayId, String userId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllCredentialSummaryForUsersInGateway_call method_call = new getAllCredentialSummaryForUsersInGateway_call(authzToken, type, gatewayId, userId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllCredentialSummaryForUsersInGateway_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private org.apache.airavata.model.credential.store.SummaryType type;
      private String gatewayId;
      private String userId;
      public getAllCredentialSummaryForUsersInGateway_call(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.credential.store.SummaryType type, String gatewayId, String userId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.type = type;
        this.gatewayId = gatewayId;
        this.userId = userId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllCredentialSummaryForUsersInGateway", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllCredentialSummaryForUsersInGateway_args args = new getAllCredentialSummaryForUsersInGateway_args();
        args.setAuthzToken(authzToken);
        args.setType(type);
        args.setGatewayId(gatewayId);
        args.setUserId(userId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.credential.store.CredentialSummary> getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllCredentialSummaryForUsersInGateway();
      }
    }

    public void getAllGatewayPWDCredentials(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllGatewayPWDCredentials_call method_call = new getAllGatewayPWDCredentials_call(authzToken, gatewayId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllGatewayPWDCredentials_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayId;
      public getAllGatewayPWDCredentials_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayId = gatewayId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllGatewayPWDCredentials", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllGatewayPWDCredentials_args args = new getAllGatewayPWDCredentials_args();
        args.setAuthzToken(authzToken);
        args.setGatewayId(gatewayId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Map<String,String> getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllGatewayPWDCredentials();
      }
    }

    public void deleteSSHPubKey(org.apache.airavata.model.security.AuthzToken authzToken, String airavataCredStoreToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteSSHPubKey_call method_call = new deleteSSHPubKey_call(authzToken, airavataCredStoreToken, gatewayId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteSSHPubKey_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String airavataCredStoreToken;
      private String gatewayId;
      public deleteSSHPubKey_call(org.apache.airavata.model.security.AuthzToken authzToken, String airavataCredStoreToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.airavataCredStoreToken = airavataCredStoreToken;
        this.gatewayId = gatewayId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteSSHPubKey", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteSSHPubKey_args args = new deleteSSHPubKey_args();
        args.setAuthzToken(authzToken);
        args.setAiravataCredStoreToken(airavataCredStoreToken);
        args.setGatewayId(gatewayId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteSSHPubKey();
      }
    }

    public void deletePWDCredential(org.apache.airavata.model.security.AuthzToken authzToken, String airavataCredStoreToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deletePWDCredential_call method_call = new deletePWDCredential_call(authzToken, airavataCredStoreToken, gatewayId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deletePWDCredential_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String airavataCredStoreToken;
      private String gatewayId;
      public deletePWDCredential_call(org.apache.airavata.model.security.AuthzToken authzToken, String airavataCredStoreToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.airavataCredStoreToken = airavataCredStoreToken;
        this.gatewayId = gatewayId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deletePWDCredential", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deletePWDCredential_args args = new deletePWDCredential_args();
        args.setAuthzToken(authzToken);
        args.setAiravataCredStoreToken(airavataCredStoreToken);
        args.setGatewayId(gatewayId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deletePWDCredential();
      }
    }

    public void createProject(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.workspace.Project project, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      createProject_call method_call = new createProject_call(authzToken, gatewayId, project, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class createProject_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayId;
      private org.apache.airavata.model.workspace.Project project;
      public createProject_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.workspace.Project project, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayId = gatewayId;
        this.project = project;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("createProject", org.apache.thrift.protocol.TMessageType.CALL, 0));
        createProject_args args = new createProject_args();
        args.setAuthzToken(authzToken);
        args.setGatewayId(gatewayId);
        args.setProject(project);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_createProject();
      }
    }

    public void updateProject(org.apache.airavata.model.security.AuthzToken authzToken, String projectId, org.apache.airavata.model.workspace.Project updatedProject, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateProject_call method_call = new updateProject_call(authzToken, projectId, updatedProject, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateProject_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String projectId;
      private org.apache.airavata.model.workspace.Project updatedProject;
      public updateProject_call(org.apache.airavata.model.security.AuthzToken authzToken, String projectId, org.apache.airavata.model.workspace.Project updatedProject, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.projectId = projectId;
        this.updatedProject = updatedProject;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateProject", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateProject_args args = new updateProject_args();
        args.setAuthzToken(authzToken);
        args.setProjectId(projectId);
        args.setUpdatedProject(updatedProject);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_updateProject();
      }
    }

    public void getProject(org.apache.airavata.model.security.AuthzToken authzToken, String projectId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getProject_call method_call = new getProject_call(authzToken, projectId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getProject_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String projectId;
      public getProject_call(org.apache.airavata.model.security.AuthzToken authzToken, String projectId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.projectId = projectId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getProject", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getProject_args args = new getProject_args();
        args.setAuthzToken(authzToken);
        args.setProjectId(projectId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.workspace.Project getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getProject();
      }
    }

    public void deleteProject(org.apache.airavata.model.security.AuthzToken authzToken, String projectId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteProject_call method_call = new deleteProject_call(authzToken, projectId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteProject_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String projectId;
      public deleteProject_call(org.apache.airavata.model.security.AuthzToken authzToken, String projectId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.projectId = projectId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteProject", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteProject_args args = new deleteProject_args();
        args.setAuthzToken(authzToken);
        args.setProjectId(projectId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteProject();
      }
    }

    public void getUserProjects(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String userName, int limit, int offset, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getUserProjects_call method_call = new getUserProjects_call(authzToken, gatewayId, userName, limit, offset, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getUserProjects_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayId;
      private String userName;
      private int limit;
      private int offset;
      public getUserProjects_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String userName, int limit, int offset, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayId = gatewayId;
        this.userName = userName;
        this.limit = limit;
        this.offset = offset;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getUserProjects", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getUserProjects_args args = new getUserProjects_args();
        args.setAuthzToken(authzToken);
        args.setGatewayId(gatewayId);
        args.setUserName(userName);
        args.setLimit(limit);
        args.setOffset(offset);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.workspace.Project> getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getUserProjects();
      }
    }

    public void searchProjects(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String userName, Map<org.apache.airavata.model.experiment.ProjectSearchFields,String> filters, int limit, int offset, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      searchProjects_call method_call = new searchProjects_call(authzToken, gatewayId, userName, filters, limit, offset, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class searchProjects_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayId;
      private String userName;
      private Map<org.apache.airavata.model.experiment.ProjectSearchFields,String> filters;
      private int limit;
      private int offset;
      public searchProjects_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String userName, Map<org.apache.airavata.model.experiment.ProjectSearchFields,String> filters, int limit, int offset, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayId = gatewayId;
        this.userName = userName;
        this.filters = filters;
        this.limit = limit;
        this.offset = offset;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("searchProjects", org.apache.thrift.protocol.TMessageType.CALL, 0));
        searchProjects_args args = new searchProjects_args();
        args.setAuthzToken(authzToken);
        args.setGatewayId(gatewayId);
        args.setUserName(userName);
        args.setFilters(filters);
        args.setLimit(limit);
        args.setOffset(offset);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.workspace.Project> getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_searchProjects();
      }
    }

    public void searchExperiments(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String userName, Map<org.apache.airavata.model.experiment.ExperimentSearchFields,String> filters, int limit, int offset, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      searchExperiments_call method_call = new searchExperiments_call(authzToken, gatewayId, userName, filters, limit, offset, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class searchExperiments_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayId;
      private String userName;
      private Map<org.apache.airavata.model.experiment.ExperimentSearchFields,String> filters;
      private int limit;
      private int offset;
      public searchExperiments_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String userName, Map<org.apache.airavata.model.experiment.ExperimentSearchFields,String> filters, int limit, int offset, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayId = gatewayId;
        this.userName = userName;
        this.filters = filters;
        this.limit = limit;
        this.offset = offset;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("searchExperiments", org.apache.thrift.protocol.TMessageType.CALL, 0));
        searchExperiments_args args = new searchExperiments_args();
        args.setAuthzToken(authzToken);
        args.setGatewayId(gatewayId);
        args.setUserName(userName);
        args.setFilters(filters);
        args.setLimit(limit);
        args.setOffset(offset);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.experiment.ExperimentSummaryModel> getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_searchExperiments();
      }
    }

    public void getExperimentStatistics(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, long fromTime, long toTime, String userName, String applicationName, String resourceHostName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getExperimentStatistics_call method_call = new getExperimentStatistics_call(authzToken, gatewayId, fromTime, toTime, userName, applicationName, resourceHostName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getExperimentStatistics_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayId;
      private long fromTime;
      private long toTime;
      private String userName;
      private String applicationName;
      private String resourceHostName;
      public getExperimentStatistics_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, long fromTime, long toTime, String userName, String applicationName, String resourceHostName, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayId = gatewayId;
        this.fromTime = fromTime;
        this.toTime = toTime;
        this.userName = userName;
        this.applicationName = applicationName;
        this.resourceHostName = resourceHostName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getExperimentStatistics", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getExperimentStatistics_args args = new getExperimentStatistics_args();
        args.setAuthzToken(authzToken);
        args.setGatewayId(gatewayId);
        args.setFromTime(fromTime);
        args.setToTime(toTime);
        args.setUserName(userName);
        args.setApplicationName(applicationName);
        args.setResourceHostName(resourceHostName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.experiment.ExperimentStatistics getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getExperimentStatistics();
      }
    }

    public void getExperimentsInProject(org.apache.airavata.model.security.AuthzToken authzToken, String projectId, int limit, int offset, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getExperimentsInProject_call method_call = new getExperimentsInProject_call(authzToken, projectId, limit, offset, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getExperimentsInProject_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String projectId;
      private int limit;
      private int offset;
      public getExperimentsInProject_call(org.apache.airavata.model.security.AuthzToken authzToken, String projectId, int limit, int offset, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.projectId = projectId;
        this.limit = limit;
        this.offset = offset;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getExperimentsInProject", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getExperimentsInProject_args args = new getExperimentsInProject_args();
        args.setAuthzToken(authzToken);
        args.setProjectId(projectId);
        args.setLimit(limit);
        args.setOffset(offset);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.experiment.ExperimentModel> getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getExperimentsInProject();
      }
    }

    public void getUserExperiments(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String userName, int limit, int offset, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getUserExperiments_call method_call = new getUserExperiments_call(authzToken, gatewayId, userName, limit, offset, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getUserExperiments_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayId;
      private String userName;
      private int limit;
      private int offset;
      public getUserExperiments_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, String userName, int limit, int offset, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayId = gatewayId;
        this.userName = userName;
        this.limit = limit;
        this.offset = offset;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getUserExperiments", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getUserExperiments_args args = new getUserExperiments_args();
        args.setAuthzToken(authzToken);
        args.setGatewayId(gatewayId);
        args.setUserName(userName);
        args.setLimit(limit);
        args.setOffset(offset);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.experiment.ExperimentModel> getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getUserExperiments();
      }
    }

    public void createExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.experiment.ExperimentModel experiment, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      createExperiment_call method_call = new createExperiment_call(authzToken, gatewayId, experiment, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class createExperiment_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayId;
      private org.apache.airavata.model.experiment.ExperimentModel experiment;
      public createExperiment_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.experiment.ExperimentModel experiment, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayId = gatewayId;
        this.experiment = experiment;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("createExperiment", org.apache.thrift.protocol.TMessageType.CALL, 0));
        createExperiment_args args = new createExperiment_args();
        args.setAuthzToken(authzToken);
        args.setGatewayId(gatewayId);
        args.setExperiment(experiment);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_createExperiment();
      }
    }

    public void deleteExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String experimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteExperiment_call method_call = new deleteExperiment_call(authzToken, experimentId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteExperiment_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String experimentId;
      public deleteExperiment_call(org.apache.airavata.model.security.AuthzToken authzToken, String experimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.experimentId = experimentId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteExperiment", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteExperiment_args args = new deleteExperiment_args();
        args.setAuthzToken(authzToken);
        args.setExperimentId(experimentId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteExperiment();
      }
    }

    public void getExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getExperiment_call method_call = new getExperiment_call(authzToken, airavataExperimentId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getExperiment_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String airavataExperimentId;
      public getExperiment_call(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.airavataExperimentId = airavataExperimentId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getExperiment", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getExperiment_args args = new getExperiment_args();
        args.setAuthzToken(authzToken);
        args.setAiravataExperimentId(airavataExperimentId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.experiment.ExperimentModel getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getExperiment();
      }
    }

    public void getExperimentByAdmin(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getExperimentByAdmin_call method_call = new getExperimentByAdmin_call(authzToken, airavataExperimentId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getExperimentByAdmin_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String airavataExperimentId;
      public getExperimentByAdmin_call(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.airavataExperimentId = airavataExperimentId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getExperimentByAdmin", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getExperimentByAdmin_args args = new getExperimentByAdmin_args();
        args.setAuthzToken(authzToken);
        args.setAiravataExperimentId(airavataExperimentId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.experiment.ExperimentModel getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getExperimentByAdmin();
      }
    }

    public void getDetailedExperimentTree(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getDetailedExperimentTree_call method_call = new getDetailedExperimentTree_call(authzToken, airavataExperimentId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getDetailedExperimentTree_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String airavataExperimentId;
      public getDetailedExperimentTree_call(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.airavataExperimentId = airavataExperimentId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getDetailedExperimentTree", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getDetailedExperimentTree_args args = new getDetailedExperimentTree_args();
        args.setAuthzToken(authzToken);
        args.setAiravataExperimentId(airavataExperimentId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.experiment.ExperimentModel getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getDetailedExperimentTree();
      }
    }

    public void updateExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.airavata.model.experiment.ExperimentModel experiment, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateExperiment_call method_call = new updateExperiment_call(authzToken, airavataExperimentId, experiment, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateExperiment_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String airavataExperimentId;
      private org.apache.airavata.model.experiment.ExperimentModel experiment;
      public updateExperiment_call(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.airavata.model.experiment.ExperimentModel experiment, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.airavataExperimentId = airavataExperimentId;
        this.experiment = experiment;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateExperiment", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateExperiment_args args = new updateExperiment_args();
        args.setAuthzToken(authzToken);
        args.setAiravataExperimentId(airavataExperimentId);
        args.setExperiment(experiment);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_updateExperiment();
      }
    }

    public void updateExperimentConfiguration(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.airavata.model.experiment.UserConfigurationDataModel userConfiguration, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateExperimentConfiguration_call method_call = new updateExperimentConfiguration_call(authzToken, airavataExperimentId, userConfiguration, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateExperimentConfiguration_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String airavataExperimentId;
      private org.apache.airavata.model.experiment.UserConfigurationDataModel userConfiguration;
      public updateExperimentConfiguration_call(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.airavata.model.experiment.UserConfigurationDataModel userConfiguration, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.airavataExperimentId = airavataExperimentId;
        this.userConfiguration = userConfiguration;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateExperimentConfiguration", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateExperimentConfiguration_args args = new updateExperimentConfiguration_args();
        args.setAuthzToken(authzToken);
        args.setAiravataExperimentId(airavataExperimentId);
        args.setUserConfiguration(userConfiguration);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_updateExperimentConfiguration();
      }
    }

    public void updateResourceScheduleing(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel resourceScheduling, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateResourceScheduleing_call method_call = new updateResourceScheduleing_call(authzToken, airavataExperimentId, resourceScheduling, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateResourceScheduleing_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String airavataExperimentId;
      private org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel resourceScheduling;
      public updateResourceScheduleing_call(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel resourceScheduling, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.airavataExperimentId = airavataExperimentId;
        this.resourceScheduling = resourceScheduling;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateResourceScheduleing", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateResourceScheduleing_args args = new updateResourceScheduleing_args();
        args.setAuthzToken(authzToken);
        args.setAiravataExperimentId(airavataExperimentId);
        args.setResourceScheduling(resourceScheduling);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_updateResourceScheduleing();
      }
    }

    public void validateExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      validateExperiment_call method_call = new validateExperiment_call(authzToken, airavataExperimentId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class validateExperiment_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String airavataExperimentId;
      public validateExperiment_call(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.airavataExperimentId = airavataExperimentId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("validateExperiment", org.apache.thrift.protocol.TMessageType.CALL, 0));
        validateExperiment_args args = new validateExperiment_args();
        args.setAuthzToken(authzToken);
        args.setAiravataExperimentId(airavataExperimentId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_validateExperiment();
      }
    }

    public void launchExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      launchExperiment_call method_call = new launchExperiment_call(authzToken, airavataExperimentId, gatewayId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class launchExperiment_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String airavataExperimentId;
      private String gatewayId;
      public launchExperiment_call(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.airavataExperimentId = airavataExperimentId;
        this.gatewayId = gatewayId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("launchExperiment", org.apache.thrift.protocol.TMessageType.CALL, 0));
        launchExperiment_args args = new launchExperiment_args();
        args.setAuthzToken(authzToken);
        args.setAiravataExperimentId(airavataExperimentId);
        args.setGatewayId(gatewayId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_launchExperiment();
      }
    }

    public void getExperimentStatus(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getExperimentStatus_call method_call = new getExperimentStatus_call(authzToken, airavataExperimentId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getExperimentStatus_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String airavataExperimentId;
      public getExperimentStatus_call(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.airavataExperimentId = airavataExperimentId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getExperimentStatus", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getExperimentStatus_args args = new getExperimentStatus_args();
        args.setAuthzToken(authzToken);
        args.setAiravataExperimentId(airavataExperimentId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.status.ExperimentStatus getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getExperimentStatus();
      }
    }

    public void getExperimentOutputs(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getExperimentOutputs_call method_call = new getExperimentOutputs_call(authzToken, airavataExperimentId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getExperimentOutputs_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String airavataExperimentId;
      public getExperimentOutputs_call(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.airavataExperimentId = airavataExperimentId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getExperimentOutputs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getExperimentOutputs_args args = new getExperimentOutputs_args();
        args.setAuthzToken(authzToken);
        args.setAiravataExperimentId(airavataExperimentId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.application.io.OutputDataObjectType> getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getExperimentOutputs();
      }
    }

    public void getIntermediateOutputs(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getIntermediateOutputs_call method_call = new getIntermediateOutputs_call(authzToken, airavataExperimentId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getIntermediateOutputs_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String airavataExperimentId;
      public getIntermediateOutputs_call(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.airavataExperimentId = airavataExperimentId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getIntermediateOutputs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getIntermediateOutputs_args args = new getIntermediateOutputs_args();
        args.setAuthzToken(authzToken);
        args.setAiravataExperimentId(airavataExperimentId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.application.io.OutputDataObjectType> getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getIntermediateOutputs();
      }
    }

    public void getJobStatuses(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getJobStatuses_call method_call = new getJobStatuses_call(authzToken, airavataExperimentId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getJobStatuses_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String airavataExperimentId;
      public getJobStatuses_call(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.airavataExperimentId = airavataExperimentId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getJobStatuses", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getJobStatuses_args args = new getJobStatuses_args();
        args.setAuthzToken(authzToken);
        args.setAiravataExperimentId(airavataExperimentId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Map<String,org.apache.airavata.model.status.JobStatus> getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getJobStatuses();
      }
    }

    public void getJobDetails(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getJobDetails_call method_call = new getJobDetails_call(authzToken, airavataExperimentId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getJobDetails_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String airavataExperimentId;
      public getJobDetails_call(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.airavataExperimentId = airavataExperimentId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getJobDetails", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getJobDetails_args args = new getJobDetails_args();
        args.setAuthzToken(authzToken);
        args.setAiravataExperimentId(airavataExperimentId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.job.JobModel> getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getJobDetails();
      }
    }

    public void cloneExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String existingExperimentID, String newExperimentName, String newExperimentProjectId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      cloneExperiment_call method_call = new cloneExperiment_call(authzToken, existingExperimentID, newExperimentName, newExperimentProjectId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class cloneExperiment_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String existingExperimentID;
      private String newExperimentName;
      private String newExperimentProjectId;
      public cloneExperiment_call(org.apache.airavata.model.security.AuthzToken authzToken, String existingExperimentID, String newExperimentName, String newExperimentProjectId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.existingExperimentID = existingExperimentID;
        this.newExperimentName = newExperimentName;
        this.newExperimentProjectId = newExperimentProjectId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("cloneExperiment", org.apache.thrift.protocol.TMessageType.CALL, 0));
        cloneExperiment_args args = new cloneExperiment_args();
        args.setAuthzToken(authzToken);
        args.setExistingExperimentID(existingExperimentID);
        args.setNewExperimentName(newExperimentName);
        args.setNewExperimentProjectId(newExperimentProjectId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_cloneExperiment();
      }
    }

    public void cloneExperimentByAdmin(org.apache.airavata.model.security.AuthzToken authzToken, String existingExperimentID, String newExperimentName, String newExperimentProjectId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      cloneExperimentByAdmin_call method_call = new cloneExperimentByAdmin_call(authzToken, existingExperimentID, newExperimentName, newExperimentProjectId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class cloneExperimentByAdmin_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String existingExperimentID;
      private String newExperimentName;
      private String newExperimentProjectId;
      public cloneExperimentByAdmin_call(org.apache.airavata.model.security.AuthzToken authzToken, String existingExperimentID, String newExperimentName, String newExperimentProjectId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.existingExperimentID = existingExperimentID;
        this.newExperimentName = newExperimentName;
        this.newExperimentProjectId = newExperimentProjectId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("cloneExperimentByAdmin", org.apache.thrift.protocol.TMessageType.CALL, 0));
        cloneExperimentByAdmin_args args = new cloneExperimentByAdmin_args();
        args.setAuthzToken(authzToken);
        args.setExistingExperimentID(existingExperimentID);
        args.setNewExperimentName(newExperimentName);
        args.setNewExperimentProjectId(newExperimentProjectId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.airavata.model.error.ProjectNotFoundException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_cloneExperimentByAdmin();
      }
    }

    public void terminateExperiment(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      terminateExperiment_call method_call = new terminateExperiment_call(authzToken, airavataExperimentId, gatewayId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class terminateExperiment_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String airavataExperimentId;
      private String gatewayId;
      public terminateExperiment_call(org.apache.airavata.model.security.AuthzToken authzToken, String airavataExperimentId, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.airavataExperimentId = airavataExperimentId;
        this.gatewayId = gatewayId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("terminateExperiment", org.apache.thrift.protocol.TMessageType.CALL, 0));
        terminateExperiment_args args = new terminateExperiment_args();
        args.setAuthzToken(authzToken);
        args.setAiravataExperimentId(airavataExperimentId);
        args.setGatewayId(gatewayId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public void getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.ExperimentNotFoundException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        (new Client(prot)).recv_terminateExperiment();
      }
    }

    public void registerApplicationModule(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule applicationModule, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      registerApplicationModule_call method_call = new registerApplicationModule_call(authzToken, gatewayId, applicationModule, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class registerApplicationModule_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayId;
      private org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule applicationModule;
      public registerApplicationModule_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule applicationModule, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayId = gatewayId;
        this.applicationModule = applicationModule;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("registerApplicationModule", org.apache.thrift.protocol.TMessageType.CALL, 0));
        registerApplicationModule_args args = new registerApplicationModule_args();
        args.setAuthzToken(authzToken);
        args.setGatewayId(gatewayId);
        args.setApplicationModule(applicationModule);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_registerApplicationModule();
      }
    }

    public void getApplicationModule(org.apache.airavata.model.security.AuthzToken authzToken, String appModuleId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getApplicationModule_call method_call = new getApplicationModule_call(authzToken, appModuleId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getApplicationModule_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String appModuleId;
      public getApplicationModule_call(org.apache.airavata.model.security.AuthzToken authzToken, String appModuleId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.appModuleId = appModuleId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getApplicationModule", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getApplicationModule_args args = new getApplicationModule_args();
        args.setAuthzToken(authzToken);
        args.setAppModuleId(appModuleId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getApplicationModule();
      }
    }

    public void updateApplicationModule(org.apache.airavata.model.security.AuthzToken authzToken, String appModuleId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule applicationModule, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateApplicationModule_call method_call = new updateApplicationModule_call(authzToken, appModuleId, applicationModule, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateApplicationModule_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String appModuleId;
      private org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule applicationModule;
      public updateApplicationModule_call(org.apache.airavata.model.security.AuthzToken authzToken, String appModuleId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule applicationModule, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.appModuleId = appModuleId;
        this.applicationModule = applicationModule;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateApplicationModule", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateApplicationModule_args args = new updateApplicationModule_args();
        args.setAuthzToken(authzToken);
        args.setAppModuleId(appModuleId);
        args.setApplicationModule(applicationModule);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateApplicationModule();
      }
    }

    public void getAllAppModules(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllAppModules_call method_call = new getAllAppModules_call(authzToken, gatewayId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllAppModules_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayId;
      public getAllAppModules_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayId = gatewayId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllAppModules", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllAppModules_args args = new getAllAppModules_args();
        args.setAuthzToken(authzToken);
        args.setGatewayId(gatewayId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.appcatalog.appdeployment.ApplicationModule> getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllAppModules();
      }
    }

    public void deleteApplicationModule(org.apache.airavata.model.security.AuthzToken authzToken, String appModuleId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteApplicationModule_call method_call = new deleteApplicationModule_call(authzToken, appModuleId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteApplicationModule_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String appModuleId;
      public deleteApplicationModule_call(org.apache.airavata.model.security.AuthzToken authzToken, String appModuleId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.appModuleId = appModuleId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteApplicationModule", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteApplicationModule_args args = new deleteApplicationModule_args();
        args.setAuthzToken(authzToken);
        args.setAppModuleId(appModuleId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteApplicationModule();
      }
    }

    public void registerApplicationDeployment(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription applicationDeployment, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      registerApplicationDeployment_call method_call = new registerApplicationDeployment_call(authzToken, gatewayId, applicationDeployment, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class registerApplicationDeployment_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayId;
      private org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription applicationDeployment;
      public registerApplicationDeployment_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription applicationDeployment, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayId = gatewayId;
        this.applicationDeployment = applicationDeployment;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("registerApplicationDeployment", org.apache.thrift.protocol.TMessageType.CALL, 0));
        registerApplicationDeployment_args args = new registerApplicationDeployment_args();
        args.setAuthzToken(authzToken);
        args.setGatewayId(gatewayId);
        args.setApplicationDeployment(applicationDeployment);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_registerApplicationDeployment();
      }
    }

    public void getApplicationDeployment(org.apache.airavata.model.security.AuthzToken authzToken, String appDeploymentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getApplicationDeployment_call method_call = new getApplicationDeployment_call(authzToken, appDeploymentId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getApplicationDeployment_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String appDeploymentId;
      public getApplicationDeployment_call(org.apache.airavata.model.security.AuthzToken authzToken, String appDeploymentId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.appDeploymentId = appDeploymentId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getApplicationDeployment", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getApplicationDeployment_args args = new getApplicationDeployment_args();
        args.setAuthzToken(authzToken);
        args.setAppDeploymentId(appDeploymentId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getApplicationDeployment();
      }
    }

    public void updateApplicationDeployment(org.apache.airavata.model.security.AuthzToken authzToken, String appDeploymentId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription applicationDeployment, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateApplicationDeployment_call method_call = new updateApplicationDeployment_call(authzToken, appDeploymentId, applicationDeployment, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateApplicationDeployment_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String appDeploymentId;
      private org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription applicationDeployment;
      public updateApplicationDeployment_call(org.apache.airavata.model.security.AuthzToken authzToken, String appDeploymentId, org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription applicationDeployment, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.appDeploymentId = appDeploymentId;
        this.applicationDeployment = applicationDeployment;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateApplicationDeployment", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateApplicationDeployment_args args = new updateApplicationDeployment_args();
        args.setAuthzToken(authzToken);
        args.setAppDeploymentId(appDeploymentId);
        args.setApplicationDeployment(applicationDeployment);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateApplicationDeployment();
      }
    }

    public void deleteApplicationDeployment(org.apache.airavata.model.security.AuthzToken authzToken, String appDeploymentId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteApplicationDeployment_call method_call = new deleteApplicationDeployment_call(authzToken, appDeploymentId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteApplicationDeployment_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String appDeploymentId;
      public deleteApplicationDeployment_call(org.apache.airavata.model.security.AuthzToken authzToken, String appDeploymentId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.appDeploymentId = appDeploymentId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteApplicationDeployment", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteApplicationDeployment_args args = new deleteApplicationDeployment_args();
        args.setAuthzToken(authzToken);
        args.setAppDeploymentId(appDeploymentId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteApplicationDeployment();
      }
    }

    public void getAllApplicationDeployments(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllApplicationDeployments_call method_call = new getAllApplicationDeployments_call(authzToken, gatewayId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllApplicationDeployments_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayId;
      public getAllApplicationDeployments_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayId = gatewayId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllApplicationDeployments", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllApplicationDeployments_args args = new getAllApplicationDeployments_args();
        args.setAuthzToken(authzToken);
        args.setGatewayId(gatewayId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription> getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllApplicationDeployments();
      }
    }

    public void getAppModuleDeployedResources(org.apache.airavata.model.security.AuthzToken authzToken, String appModuleId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAppModuleDeployedResources_call method_call = new getAppModuleDeployedResources_call(authzToken, appModuleId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAppModuleDeployedResources_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String appModuleId;
      public getAppModuleDeployedResources_call(org.apache.airavata.model.security.AuthzToken authzToken, String appModuleId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.appModuleId = appModuleId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAppModuleDeployedResources", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAppModuleDeployedResources_args args = new getAppModuleDeployedResources_args();
        args.setAuthzToken(authzToken);
        args.setAppModuleId(appModuleId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<String> getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAppModuleDeployedResources();
      }
    }

    public void registerApplicationInterface(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription applicationInterface, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      registerApplicationInterface_call method_call = new registerApplicationInterface_call(authzToken, gatewayId, applicationInterface, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class registerApplicationInterface_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayId;
      private org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription applicationInterface;
      public registerApplicationInterface_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription applicationInterface, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayId = gatewayId;
        this.applicationInterface = applicationInterface;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("registerApplicationInterface", org.apache.thrift.protocol.TMessageType.CALL, 0));
        registerApplicationInterface_args args = new registerApplicationInterface_args();
        args.setAuthzToken(authzToken);
        args.setGatewayId(gatewayId);
        args.setApplicationInterface(applicationInterface);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_registerApplicationInterface();
      }
    }

    public void cloneApplicationInterface(org.apache.airavata.model.security.AuthzToken authzToken, String existingAppInterfaceID, String newApplicationName, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      cloneApplicationInterface_call method_call = new cloneApplicationInterface_call(authzToken, existingAppInterfaceID, newApplicationName, gatewayId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class cloneApplicationInterface_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String existingAppInterfaceID;
      private String newApplicationName;
      private String gatewayId;
      public cloneApplicationInterface_call(org.apache.airavata.model.security.AuthzToken authzToken, String existingAppInterfaceID, String newApplicationName, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.existingAppInterfaceID = existingAppInterfaceID;
        this.newApplicationName = newApplicationName;
        this.gatewayId = gatewayId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("cloneApplicationInterface", org.apache.thrift.protocol.TMessageType.CALL, 0));
        cloneApplicationInterface_args args = new cloneApplicationInterface_args();
        args.setAuthzToken(authzToken);
        args.setExistingAppInterfaceID(existingAppInterfaceID);
        args.setNewApplicationName(newApplicationName);
        args.setGatewayId(gatewayId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_cloneApplicationInterface();
      }
    }

    public void getApplicationInterface(org.apache.airavata.model.security.AuthzToken authzToken, String appInterfaceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getApplicationInterface_call method_call = new getApplicationInterface_call(authzToken, appInterfaceId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getApplicationInterface_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String appInterfaceId;
      public getApplicationInterface_call(org.apache.airavata.model.security.AuthzToken authzToken, String appInterfaceId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.appInterfaceId = appInterfaceId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getApplicationInterface", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getApplicationInterface_args args = new getApplicationInterface_args();
        args.setAuthzToken(authzToken);
        args.setAppInterfaceId(appInterfaceId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getApplicationInterface();
      }
    }

    public void updateApplicationInterface(org.apache.airavata.model.security.AuthzToken authzToken, String appInterfaceId, org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription applicationInterface, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateApplicationInterface_call method_call = new updateApplicationInterface_call(authzToken, appInterfaceId, applicationInterface, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateApplicationInterface_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String appInterfaceId;
      private org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription applicationInterface;
      public updateApplicationInterface_call(org.apache.airavata.model.security.AuthzToken authzToken, String appInterfaceId, org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription applicationInterface, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.appInterfaceId = appInterfaceId;
        this.applicationInterface = applicationInterface;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateApplicationInterface", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateApplicationInterface_args args = new updateApplicationInterface_args();
        args.setAuthzToken(authzToken);
        args.setAppInterfaceId(appInterfaceId);
        args.setApplicationInterface(applicationInterface);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateApplicationInterface();
      }
    }

    public void deleteApplicationInterface(org.apache.airavata.model.security.AuthzToken authzToken, String appInterfaceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteApplicationInterface_call method_call = new deleteApplicationInterface_call(authzToken, appInterfaceId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteApplicationInterface_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String appInterfaceId;
      public deleteApplicationInterface_call(org.apache.airavata.model.security.AuthzToken authzToken, String appInterfaceId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.appInterfaceId = appInterfaceId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteApplicationInterface", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteApplicationInterface_args args = new deleteApplicationInterface_args();
        args.setAuthzToken(authzToken);
        args.setAppInterfaceId(appInterfaceId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteApplicationInterface();
      }
    }

    public void getAllApplicationInterfaceNames(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllApplicationInterfaceNames_call method_call = new getAllApplicationInterfaceNames_call(authzToken, gatewayId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllApplicationInterfaceNames_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayId;
      public getAllApplicationInterfaceNames_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayId = gatewayId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllApplicationInterfaceNames", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllApplicationInterfaceNames_args args = new getAllApplicationInterfaceNames_args();
        args.setAuthzToken(authzToken);
        args.setGatewayId(gatewayId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Map<String,String> getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllApplicationInterfaceNames();
      }
    }

    public void getAllApplicationInterfaces(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllApplicationInterfaces_call method_call = new getAllApplicationInterfaces_call(authzToken, gatewayId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllApplicationInterfaces_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayId;
      public getAllApplicationInterfaces_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayId = gatewayId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllApplicationInterfaces", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllApplicationInterfaces_args args = new getAllApplicationInterfaces_args();
        args.setAuthzToken(authzToken);
        args.setGatewayId(gatewayId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription> getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllApplicationInterfaces();
      }
    }

    public void getApplicationInputs(org.apache.airavata.model.security.AuthzToken authzToken, String appInterfaceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getApplicationInputs_call method_call = new getApplicationInputs_call(authzToken, appInterfaceId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getApplicationInputs_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String appInterfaceId;
      public getApplicationInputs_call(org.apache.airavata.model.security.AuthzToken authzToken, String appInterfaceId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.appInterfaceId = appInterfaceId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getApplicationInputs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getApplicationInputs_args args = new getApplicationInputs_args();
        args.setAuthzToken(authzToken);
        args.setAppInterfaceId(appInterfaceId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.application.io.InputDataObjectType> getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getApplicationInputs();
      }
    }

    public void getApplicationOutputs(org.apache.airavata.model.security.AuthzToken authzToken, String appInterfaceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getApplicationOutputs_call method_call = new getApplicationOutputs_call(authzToken, appInterfaceId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getApplicationOutputs_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String appInterfaceId;
      public getApplicationOutputs_call(org.apache.airavata.model.security.AuthzToken authzToken, String appInterfaceId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.appInterfaceId = appInterfaceId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getApplicationOutputs", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getApplicationOutputs_args args = new getApplicationOutputs_args();
        args.setAuthzToken(authzToken);
        args.setAppInterfaceId(appInterfaceId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.application.io.OutputDataObjectType> getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getApplicationOutputs();
      }
    }

    public void getAvailableAppInterfaceComputeResources(org.apache.airavata.model.security.AuthzToken authzToken, String appInterfaceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAvailableAppInterfaceComputeResources_call method_call = new getAvailableAppInterfaceComputeResources_call(authzToken, appInterfaceId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAvailableAppInterfaceComputeResources_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String appInterfaceId;
      public getAvailableAppInterfaceComputeResources_call(org.apache.airavata.model.security.AuthzToken authzToken, String appInterfaceId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.appInterfaceId = appInterfaceId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAvailableAppInterfaceComputeResources", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAvailableAppInterfaceComputeResources_args args = new getAvailableAppInterfaceComputeResources_args();
        args.setAuthzToken(authzToken);
        args.setAppInterfaceId(appInterfaceId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Map<String,String> getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAvailableAppInterfaceComputeResources();
      }
    }

    public void registerComputeResource(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription computeResourceDescription, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      registerComputeResource_call method_call = new registerComputeResource_call(authzToken, computeResourceDescription, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class registerComputeResource_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription computeResourceDescription;
      public registerComputeResource_call(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription computeResourceDescription, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.computeResourceDescription = computeResourceDescription;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("registerComputeResource", org.apache.thrift.protocol.TMessageType.CALL, 0));
        registerComputeResource_args args = new registerComputeResource_args();
        args.setAuthzToken(authzToken);
        args.setComputeResourceDescription(computeResourceDescription);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_registerComputeResource();
      }
    }

    public void getComputeResource(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getComputeResource_call method_call = new getComputeResource_call(authzToken, computeResourceId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getComputeResource_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String computeResourceId;
      public getComputeResource_call(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.computeResourceId = computeResourceId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getComputeResource", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getComputeResource_args args = new getComputeResource_args();
        args.setAuthzToken(authzToken);
        args.setComputeResourceId(computeResourceId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getComputeResource();
      }
    }

    public void getAllComputeResourceNames(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllComputeResourceNames_call method_call = new getAllComputeResourceNames_call(authzToken, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllComputeResourceNames_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      public getAllComputeResourceNames_call(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllComputeResourceNames", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllComputeResourceNames_args args = new getAllComputeResourceNames_args();
        args.setAuthzToken(authzToken);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Map<String,String> getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllComputeResourceNames();
      }
    }

    public void updateComputeResource(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription computeResourceDescription, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateComputeResource_call method_call = new updateComputeResource_call(authzToken, computeResourceId, computeResourceDescription, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateComputeResource_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String computeResourceId;
      private org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription computeResourceDescription;
      public updateComputeResource_call(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription computeResourceDescription, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.computeResourceId = computeResourceId;
        this.computeResourceDescription = computeResourceDescription;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateComputeResource", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateComputeResource_args args = new updateComputeResource_args();
        args.setAuthzToken(authzToken);
        args.setComputeResourceId(computeResourceId);
        args.setComputeResourceDescription(computeResourceDescription);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateComputeResource();
      }
    }

    public void deleteComputeResource(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteComputeResource_call method_call = new deleteComputeResource_call(authzToken, computeResourceId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteComputeResource_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String computeResourceId;
      public deleteComputeResource_call(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.computeResourceId = computeResourceId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteComputeResource", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteComputeResource_args args = new deleteComputeResource_args();
        args.setAuthzToken(authzToken);
        args.setComputeResourceId(computeResourceId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteComputeResource();
      }
    }

    public void registerStorageResource(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription storageResourceDescription, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      registerStorageResource_call method_call = new registerStorageResource_call(authzToken, storageResourceDescription, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class registerStorageResource_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription storageResourceDescription;
      public registerStorageResource_call(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription storageResourceDescription, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.storageResourceDescription = storageResourceDescription;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("registerStorageResource", org.apache.thrift.protocol.TMessageType.CALL, 0));
        registerStorageResource_args args = new registerStorageResource_args();
        args.setAuthzToken(authzToken);
        args.setStorageResourceDescription(storageResourceDescription);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_registerStorageResource();
      }
    }

    public void getStorageResource(org.apache.airavata.model.security.AuthzToken authzToken, String storageResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getStorageResource_call method_call = new getStorageResource_call(authzToken, storageResourceId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getStorageResource_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String storageResourceId;
      public getStorageResource_call(org.apache.airavata.model.security.AuthzToken authzToken, String storageResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.storageResourceId = storageResourceId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getStorageResource", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getStorageResource_args args = new getStorageResource_args();
        args.setAuthzToken(authzToken);
        args.setStorageResourceId(storageResourceId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getStorageResource();
      }
    }

    public void getAllStorageResourceNames(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllStorageResourceNames_call method_call = new getAllStorageResourceNames_call(authzToken, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllStorageResourceNames_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      public getAllStorageResourceNames_call(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllStorageResourceNames", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllStorageResourceNames_args args = new getAllStorageResourceNames_args();
        args.setAuthzToken(authzToken);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Map<String,String> getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllStorageResourceNames();
      }
    }

    public void updateStorageResource(org.apache.airavata.model.security.AuthzToken authzToken, String storageResourceId, org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription storageResourceDescription, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateStorageResource_call method_call = new updateStorageResource_call(authzToken, storageResourceId, storageResourceDescription, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateStorageResource_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String storageResourceId;
      private org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription storageResourceDescription;
      public updateStorageResource_call(org.apache.airavata.model.security.AuthzToken authzToken, String storageResourceId, org.apache.airavata.model.appcatalog.storageresource.StorageResourceDescription storageResourceDescription, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.storageResourceId = storageResourceId;
        this.storageResourceDescription = storageResourceDescription;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateStorageResource", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateStorageResource_args args = new updateStorageResource_args();
        args.setAuthzToken(authzToken);
        args.setStorageResourceId(storageResourceId);
        args.setStorageResourceDescription(storageResourceDescription);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateStorageResource();
      }
    }

    public void deleteStorageResource(org.apache.airavata.model.security.AuthzToken authzToken, String storageResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteStorageResource_call method_call = new deleteStorageResource_call(authzToken, storageResourceId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteStorageResource_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String storageResourceId;
      public deleteStorageResource_call(org.apache.airavata.model.security.AuthzToken authzToken, String storageResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.storageResourceId = storageResourceId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteStorageResource", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteStorageResource_args args = new deleteStorageResource_args();
        args.setAuthzToken(authzToken);
        args.setStorageResourceId(storageResourceId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteStorageResource();
      }
    }

    public void addLocalSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission localSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addLocalSubmissionDetails_call method_call = new addLocalSubmissionDetails_call(authzToken, computeResourceId, priorityOrder, localSubmission, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addLocalSubmissionDetails_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String computeResourceId;
      private int priorityOrder;
      private org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission localSubmission;
      public addLocalSubmissionDetails_call(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission localSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.computeResourceId = computeResourceId;
        this.priorityOrder = priorityOrder;
        this.localSubmission = localSubmission;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addLocalSubmissionDetails", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addLocalSubmissionDetails_args args = new addLocalSubmissionDetails_args();
        args.setAuthzToken(authzToken);
        args.setComputeResourceId(computeResourceId);
        args.setPriorityOrder(priorityOrder);
        args.setLocalSubmission(localSubmission);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_addLocalSubmissionDetails();
      }
    }

    public void updateLocalSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission localSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateLocalSubmissionDetails_call method_call = new updateLocalSubmissionDetails_call(authzToken, jobSubmissionInterfaceId, localSubmission, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateLocalSubmissionDetails_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String jobSubmissionInterfaceId;
      private org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission localSubmission;
      public updateLocalSubmissionDetails_call(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission localSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.jobSubmissionInterfaceId = jobSubmissionInterfaceId;
        this.localSubmission = localSubmission;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateLocalSubmissionDetails", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateLocalSubmissionDetails_args args = new updateLocalSubmissionDetails_args();
        args.setAuthzToken(authzToken);
        args.setJobSubmissionInterfaceId(jobSubmissionInterfaceId);
        args.setLocalSubmission(localSubmission);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateLocalSubmissionDetails();
      }
    }

    public void getLocalJobSubmission(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getLocalJobSubmission_call method_call = new getLocalJobSubmission_call(authzToken, jobSubmissionId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getLocalJobSubmission_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String jobSubmissionId;
      public getLocalJobSubmission_call(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.jobSubmissionId = jobSubmissionId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getLocalJobSubmission", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getLocalJobSubmission_args args = new getLocalJobSubmission_args();
        args.setAuthzToken(authzToken);
        args.setJobSubmissionId(jobSubmissionId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.appcatalog.computeresource.LOCALSubmission getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getLocalJobSubmission();
      }
    }

    public void addSSHJobSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addSSHJobSubmissionDetails_call method_call = new addSSHJobSubmissionDetails_call(authzToken, computeResourceId, priorityOrder, sshJobSubmission, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addSSHJobSubmissionDetails_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String computeResourceId;
      private int priorityOrder;
      private org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission;
      public addSSHJobSubmissionDetails_call(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.computeResourceId = computeResourceId;
        this.priorityOrder = priorityOrder;
        this.sshJobSubmission = sshJobSubmission;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addSSHJobSubmissionDetails", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addSSHJobSubmissionDetails_args args = new addSSHJobSubmissionDetails_args();
        args.setAuthzToken(authzToken);
        args.setComputeResourceId(computeResourceId);
        args.setPriorityOrder(priorityOrder);
        args.setSshJobSubmission(sshJobSubmission);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_addSSHJobSubmissionDetails();
      }
    }

    public void addSSHForkJobSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addSSHForkJobSubmissionDetails_call method_call = new addSSHForkJobSubmissionDetails_call(authzToken, computeResourceId, priorityOrder, sshJobSubmission, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addSSHForkJobSubmissionDetails_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String computeResourceId;
      private int priorityOrder;
      private org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission;
      public addSSHForkJobSubmissionDetails_call(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.computeResourceId = computeResourceId;
        this.priorityOrder = priorityOrder;
        this.sshJobSubmission = sshJobSubmission;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addSSHForkJobSubmissionDetails", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addSSHForkJobSubmissionDetails_args args = new addSSHForkJobSubmissionDetails_args();
        args.setAuthzToken(authzToken);
        args.setComputeResourceId(computeResourceId);
        args.setPriorityOrder(priorityOrder);
        args.setSshJobSubmission(sshJobSubmission);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_addSSHForkJobSubmissionDetails();
      }
    }

    public void getSSHJobSubmission(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getSSHJobSubmission_call method_call = new getSSHJobSubmission_call(authzToken, jobSubmissionId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getSSHJobSubmission_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String jobSubmissionId;
      public getSSHJobSubmission_call(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.jobSubmissionId = jobSubmissionId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getSSHJobSubmission", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getSSHJobSubmission_args args = new getSSHJobSubmission_args();
        args.setAuthzToken(authzToken);
        args.setJobSubmissionId(jobSubmissionId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getSSHJobSubmission();
      }
    }

    public void addUNICOREJobSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission unicoreJobSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addUNICOREJobSubmissionDetails_call method_call = new addUNICOREJobSubmissionDetails_call(authzToken, computeResourceId, priorityOrder, unicoreJobSubmission, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addUNICOREJobSubmissionDetails_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String computeResourceId;
      private int priorityOrder;
      private org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission unicoreJobSubmission;
      public addUNICOREJobSubmissionDetails_call(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission unicoreJobSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.computeResourceId = computeResourceId;
        this.priorityOrder = priorityOrder;
        this.unicoreJobSubmission = unicoreJobSubmission;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addUNICOREJobSubmissionDetails", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addUNICOREJobSubmissionDetails_args args = new addUNICOREJobSubmissionDetails_args();
        args.setAuthzToken(authzToken);
        args.setComputeResourceId(computeResourceId);
        args.setPriorityOrder(priorityOrder);
        args.setUnicoreJobSubmission(unicoreJobSubmission);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_addUNICOREJobSubmissionDetails();
      }
    }

    public void getUnicoreJobSubmission(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getUnicoreJobSubmission_call method_call = new getUnicoreJobSubmission_call(authzToken, jobSubmissionId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getUnicoreJobSubmission_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String jobSubmissionId;
      public getUnicoreJobSubmission_call(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.jobSubmissionId = jobSubmissionId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getUnicoreJobSubmission", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getUnicoreJobSubmission_args args = new getUnicoreJobSubmission_args();
        args.setAuthzToken(authzToken);
        args.setJobSubmissionId(jobSubmissionId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getUnicoreJobSubmission();
      }
    }

    public void addCloudJobSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission cloudSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addCloudJobSubmissionDetails_call method_call = new addCloudJobSubmissionDetails_call(authzToken, computeResourceId, priorityOrder, cloudSubmission, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addCloudJobSubmissionDetails_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String computeResourceId;
      private int priorityOrder;
      private org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission cloudSubmission;
      public addCloudJobSubmissionDetails_call(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, int priorityOrder, org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission cloudSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.computeResourceId = computeResourceId;
        this.priorityOrder = priorityOrder;
        this.cloudSubmission = cloudSubmission;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addCloudJobSubmissionDetails", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addCloudJobSubmissionDetails_args args = new addCloudJobSubmissionDetails_args();
        args.setAuthzToken(authzToken);
        args.setComputeResourceId(computeResourceId);
        args.setPriorityOrder(priorityOrder);
        args.setCloudSubmission(cloudSubmission);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_addCloudJobSubmissionDetails();
      }
    }

    public void getCloudJobSubmission(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getCloudJobSubmission_call method_call = new getCloudJobSubmission_call(authzToken, jobSubmissionId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getCloudJobSubmission_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String jobSubmissionId;
      public getCloudJobSubmission_call(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.jobSubmissionId = jobSubmissionId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getCloudJobSubmission", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getCloudJobSubmission_args args = new getCloudJobSubmission_args();
        args.setAuthzToken(authzToken);
        args.setJobSubmissionId(jobSubmissionId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getCloudJobSubmission();
      }
    }

    public void updateSSHJobSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateSSHJobSubmissionDetails_call method_call = new updateSSHJobSubmissionDetails_call(authzToken, jobSubmissionInterfaceId, sshJobSubmission, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateSSHJobSubmissionDetails_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String jobSubmissionInterfaceId;
      private org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission;
      public updateSSHJobSubmissionDetails_call(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission sshJobSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.jobSubmissionInterfaceId = jobSubmissionInterfaceId;
        this.sshJobSubmission = sshJobSubmission;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateSSHJobSubmissionDetails", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateSSHJobSubmissionDetails_args args = new updateSSHJobSubmissionDetails_args();
        args.setAuthzToken(authzToken);
        args.setJobSubmissionInterfaceId(jobSubmissionInterfaceId);
        args.setSshJobSubmission(sshJobSubmission);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateSSHJobSubmissionDetails();
      }
    }

    public void updateCloudJobSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission sshJobSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateCloudJobSubmissionDetails_call method_call = new updateCloudJobSubmissionDetails_call(authzToken, jobSubmissionInterfaceId, sshJobSubmission, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateCloudJobSubmissionDetails_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String jobSubmissionInterfaceId;
      private org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission sshJobSubmission;
      public updateCloudJobSubmissionDetails_call(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.CloudJobSubmission sshJobSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.jobSubmissionInterfaceId = jobSubmissionInterfaceId;
        this.sshJobSubmission = sshJobSubmission;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateCloudJobSubmissionDetails", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateCloudJobSubmissionDetails_args args = new updateCloudJobSubmissionDetails_args();
        args.setAuthzToken(authzToken);
        args.setJobSubmissionInterfaceId(jobSubmissionInterfaceId);
        args.setSshJobSubmission(sshJobSubmission);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateCloudJobSubmissionDetails();
      }
    }

    public void updateUnicoreJobSubmissionDetails(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission unicoreJobSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateUnicoreJobSubmissionDetails_call method_call = new updateUnicoreJobSubmissionDetails_call(authzToken, jobSubmissionInterfaceId, unicoreJobSubmission, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateUnicoreJobSubmissionDetails_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String jobSubmissionInterfaceId;
      private org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission unicoreJobSubmission;
      public updateUnicoreJobSubmissionDetails_call(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionInterfaceId, org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission unicoreJobSubmission, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.jobSubmissionInterfaceId = jobSubmissionInterfaceId;
        this.unicoreJobSubmission = unicoreJobSubmission;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateUnicoreJobSubmissionDetails", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateUnicoreJobSubmissionDetails_args args = new updateUnicoreJobSubmissionDetails_args();
        args.setAuthzToken(authzToken);
        args.setJobSubmissionInterfaceId(jobSubmissionInterfaceId);
        args.setUnicoreJobSubmission(unicoreJobSubmission);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateUnicoreJobSubmissionDetails();
      }
    }

    public void addLocalDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.LOCALDataMovement localDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addLocalDataMovementDetails_call method_call = new addLocalDataMovementDetails_call(authzToken, productUri, dataMoveType, priorityOrder, localDataMovement, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addLocalDataMovementDetails_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String productUri;
      private org.apache.airavata.model.data.movement.DMType dataMoveType;
      private int priorityOrder;
      private org.apache.airavata.model.data.movement.LOCALDataMovement localDataMovement;
      public addLocalDataMovementDetails_call(org.apache.airavata.model.security.AuthzToken authzToken, String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.LOCALDataMovement localDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.productUri = productUri;
        this.dataMoveType = dataMoveType;
        this.priorityOrder = priorityOrder;
        this.localDataMovement = localDataMovement;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addLocalDataMovementDetails", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addLocalDataMovementDetails_args args = new addLocalDataMovementDetails_args();
        args.setAuthzToken(authzToken);
        args.setProductUri(productUri);
        args.setDataMoveType(dataMoveType);
        args.setPriorityOrder(priorityOrder);
        args.setLocalDataMovement(localDataMovement);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_addLocalDataMovementDetails();
      }
    }

    public void updateLocalDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementInterfaceId, org.apache.airavata.model.data.movement.LOCALDataMovement localDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateLocalDataMovementDetails_call method_call = new updateLocalDataMovementDetails_call(authzToken, dataMovementInterfaceId, localDataMovement, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateLocalDataMovementDetails_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String dataMovementInterfaceId;
      private org.apache.airavata.model.data.movement.LOCALDataMovement localDataMovement;
      public updateLocalDataMovementDetails_call(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementInterfaceId, org.apache.airavata.model.data.movement.LOCALDataMovement localDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.dataMovementInterfaceId = dataMovementInterfaceId;
        this.localDataMovement = localDataMovement;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateLocalDataMovementDetails", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateLocalDataMovementDetails_args args = new updateLocalDataMovementDetails_args();
        args.setAuthzToken(authzToken);
        args.setDataMovementInterfaceId(dataMovementInterfaceId);
        args.setLocalDataMovement(localDataMovement);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateLocalDataMovementDetails();
      }
    }

    public void getLocalDataMovement(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getLocalDataMovement_call method_call = new getLocalDataMovement_call(authzToken, dataMovementId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getLocalDataMovement_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String dataMovementId;
      public getLocalDataMovement_call(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.dataMovementId = dataMovementId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getLocalDataMovement", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getLocalDataMovement_args args = new getLocalDataMovement_args();
        args.setAuthzToken(authzToken);
        args.setDataMovementId(dataMovementId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.data.movement.LOCALDataMovement getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getLocalDataMovement();
      }
    }

    public void addSCPDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.SCPDataMovement scpDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addSCPDataMovementDetails_call method_call = new addSCPDataMovementDetails_call(authzToken, productUri, dataMoveType, priorityOrder, scpDataMovement, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addSCPDataMovementDetails_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String productUri;
      private org.apache.airavata.model.data.movement.DMType dataMoveType;
      private int priorityOrder;
      private org.apache.airavata.model.data.movement.SCPDataMovement scpDataMovement;
      public addSCPDataMovementDetails_call(org.apache.airavata.model.security.AuthzToken authzToken, String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.SCPDataMovement scpDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.productUri = productUri;
        this.dataMoveType = dataMoveType;
        this.priorityOrder = priorityOrder;
        this.scpDataMovement = scpDataMovement;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addSCPDataMovementDetails", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addSCPDataMovementDetails_args args = new addSCPDataMovementDetails_args();
        args.setAuthzToken(authzToken);
        args.setProductUri(productUri);
        args.setDataMoveType(dataMoveType);
        args.setPriorityOrder(priorityOrder);
        args.setScpDataMovement(scpDataMovement);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_addSCPDataMovementDetails();
      }
    }

    public void updateSCPDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementInterfaceId, org.apache.airavata.model.data.movement.SCPDataMovement scpDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateSCPDataMovementDetails_call method_call = new updateSCPDataMovementDetails_call(authzToken, dataMovementInterfaceId, scpDataMovement, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateSCPDataMovementDetails_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String dataMovementInterfaceId;
      private org.apache.airavata.model.data.movement.SCPDataMovement scpDataMovement;
      public updateSCPDataMovementDetails_call(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementInterfaceId, org.apache.airavata.model.data.movement.SCPDataMovement scpDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.dataMovementInterfaceId = dataMovementInterfaceId;
        this.scpDataMovement = scpDataMovement;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateSCPDataMovementDetails", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateSCPDataMovementDetails_args args = new updateSCPDataMovementDetails_args();
        args.setAuthzToken(authzToken);
        args.setDataMovementInterfaceId(dataMovementInterfaceId);
        args.setScpDataMovement(scpDataMovement);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateSCPDataMovementDetails();
      }
    }

    public void getSCPDataMovement(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getSCPDataMovement_call method_call = new getSCPDataMovement_call(authzToken, dataMovementId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getSCPDataMovement_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String dataMovementId;
      public getSCPDataMovement_call(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.dataMovementId = dataMovementId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getSCPDataMovement", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getSCPDataMovement_args args = new getSCPDataMovement_args();
        args.setAuthzToken(authzToken);
        args.setDataMovementId(dataMovementId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.data.movement.SCPDataMovement getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getSCPDataMovement();
      }
    }

    public void addUnicoreDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.UnicoreDataMovement unicoreDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addUnicoreDataMovementDetails_call method_call = new addUnicoreDataMovementDetails_call(authzToken, productUri, dataMoveType, priorityOrder, unicoreDataMovement, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addUnicoreDataMovementDetails_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String productUri;
      private org.apache.airavata.model.data.movement.DMType dataMoveType;
      private int priorityOrder;
      private org.apache.airavata.model.data.movement.UnicoreDataMovement unicoreDataMovement;
      public addUnicoreDataMovementDetails_call(org.apache.airavata.model.security.AuthzToken authzToken, String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.UnicoreDataMovement unicoreDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.productUri = productUri;
        this.dataMoveType = dataMoveType;
        this.priorityOrder = priorityOrder;
        this.unicoreDataMovement = unicoreDataMovement;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addUnicoreDataMovementDetails", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addUnicoreDataMovementDetails_args args = new addUnicoreDataMovementDetails_args();
        args.setAuthzToken(authzToken);
        args.setProductUri(productUri);
        args.setDataMoveType(dataMoveType);
        args.setPriorityOrder(priorityOrder);
        args.setUnicoreDataMovement(unicoreDataMovement);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_addUnicoreDataMovementDetails();
      }
    }

    public void updateUnicoreDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementInterfaceId, org.apache.airavata.model.data.movement.UnicoreDataMovement unicoreDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateUnicoreDataMovementDetails_call method_call = new updateUnicoreDataMovementDetails_call(authzToken, dataMovementInterfaceId, unicoreDataMovement, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateUnicoreDataMovementDetails_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String dataMovementInterfaceId;
      private org.apache.airavata.model.data.movement.UnicoreDataMovement unicoreDataMovement;
      public updateUnicoreDataMovementDetails_call(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementInterfaceId, org.apache.airavata.model.data.movement.UnicoreDataMovement unicoreDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.dataMovementInterfaceId = dataMovementInterfaceId;
        this.unicoreDataMovement = unicoreDataMovement;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateUnicoreDataMovementDetails", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateUnicoreDataMovementDetails_args args = new updateUnicoreDataMovementDetails_args();
        args.setAuthzToken(authzToken);
        args.setDataMovementInterfaceId(dataMovementInterfaceId);
        args.setUnicoreDataMovement(unicoreDataMovement);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateUnicoreDataMovementDetails();
      }
    }

    public void getUnicoreDataMovement(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getUnicoreDataMovement_call method_call = new getUnicoreDataMovement_call(authzToken, dataMovementId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getUnicoreDataMovement_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String dataMovementId;
      public getUnicoreDataMovement_call(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.dataMovementId = dataMovementId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getUnicoreDataMovement", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getUnicoreDataMovement_args args = new getUnicoreDataMovement_args();
        args.setAuthzToken(authzToken);
        args.setDataMovementId(dataMovementId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.data.movement.UnicoreDataMovement getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getUnicoreDataMovement();
      }
    }

    public void addGridFTPDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.GridFTPDataMovement gridFTPDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addGridFTPDataMovementDetails_call method_call = new addGridFTPDataMovementDetails_call(authzToken, productUri, dataMoveType, priorityOrder, gridFTPDataMovement, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addGridFTPDataMovementDetails_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String productUri;
      private org.apache.airavata.model.data.movement.DMType dataMoveType;
      private int priorityOrder;
      private org.apache.airavata.model.data.movement.GridFTPDataMovement gridFTPDataMovement;
      public addGridFTPDataMovementDetails_call(org.apache.airavata.model.security.AuthzToken authzToken, String productUri, org.apache.airavata.model.data.movement.DMType dataMoveType, int priorityOrder, org.apache.airavata.model.data.movement.GridFTPDataMovement gridFTPDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.productUri = productUri;
        this.dataMoveType = dataMoveType;
        this.priorityOrder = priorityOrder;
        this.gridFTPDataMovement = gridFTPDataMovement;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addGridFTPDataMovementDetails", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addGridFTPDataMovementDetails_args args = new addGridFTPDataMovementDetails_args();
        args.setAuthzToken(authzToken);
        args.setProductUri(productUri);
        args.setDataMoveType(dataMoveType);
        args.setPriorityOrder(priorityOrder);
        args.setGridFTPDataMovement(gridFTPDataMovement);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_addGridFTPDataMovementDetails();
      }
    }

    public void updateGridFTPDataMovementDetails(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementInterfaceId, org.apache.airavata.model.data.movement.GridFTPDataMovement gridFTPDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateGridFTPDataMovementDetails_call method_call = new updateGridFTPDataMovementDetails_call(authzToken, dataMovementInterfaceId, gridFTPDataMovement, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateGridFTPDataMovementDetails_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String dataMovementInterfaceId;
      private org.apache.airavata.model.data.movement.GridFTPDataMovement gridFTPDataMovement;
      public updateGridFTPDataMovementDetails_call(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementInterfaceId, org.apache.airavata.model.data.movement.GridFTPDataMovement gridFTPDataMovement, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.dataMovementInterfaceId = dataMovementInterfaceId;
        this.gridFTPDataMovement = gridFTPDataMovement;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateGridFTPDataMovementDetails", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateGridFTPDataMovementDetails_args args = new updateGridFTPDataMovementDetails_args();
        args.setAuthzToken(authzToken);
        args.setDataMovementInterfaceId(dataMovementInterfaceId);
        args.setGridFTPDataMovement(gridFTPDataMovement);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateGridFTPDataMovementDetails();
      }
    }

    public void getGridFTPDataMovement(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getGridFTPDataMovement_call method_call = new getGridFTPDataMovement_call(authzToken, dataMovementId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getGridFTPDataMovement_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String dataMovementId;
      public getGridFTPDataMovement_call(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.dataMovementId = dataMovementId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getGridFTPDataMovement", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getGridFTPDataMovement_args args = new getGridFTPDataMovement_args();
        args.setAuthzToken(authzToken);
        args.setDataMovementId(dataMovementId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.data.movement.GridFTPDataMovement getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getGridFTPDataMovement();
      }
    }

    public void changeJobSubmissionPriority(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionInterfaceId, int newPriorityOrder, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      changeJobSubmissionPriority_call method_call = new changeJobSubmissionPriority_call(authzToken, jobSubmissionInterfaceId, newPriorityOrder, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class changeJobSubmissionPriority_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String jobSubmissionInterfaceId;
      private int newPriorityOrder;
      public changeJobSubmissionPriority_call(org.apache.airavata.model.security.AuthzToken authzToken, String jobSubmissionInterfaceId, int newPriorityOrder, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.jobSubmissionInterfaceId = jobSubmissionInterfaceId;
        this.newPriorityOrder = newPriorityOrder;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("changeJobSubmissionPriority", org.apache.thrift.protocol.TMessageType.CALL, 0));
        changeJobSubmissionPriority_args args = new changeJobSubmissionPriority_args();
        args.setAuthzToken(authzToken);
        args.setJobSubmissionInterfaceId(jobSubmissionInterfaceId);
        args.setNewPriorityOrder(newPriorityOrder);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_changeJobSubmissionPriority();
      }
    }

    public void changeDataMovementPriority(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementInterfaceId, int newPriorityOrder, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      changeDataMovementPriority_call method_call = new changeDataMovementPriority_call(authzToken, dataMovementInterfaceId, newPriorityOrder, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class changeDataMovementPriority_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String dataMovementInterfaceId;
      private int newPriorityOrder;
      public changeDataMovementPriority_call(org.apache.airavata.model.security.AuthzToken authzToken, String dataMovementInterfaceId, int newPriorityOrder, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.dataMovementInterfaceId = dataMovementInterfaceId;
        this.newPriorityOrder = newPriorityOrder;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("changeDataMovementPriority", org.apache.thrift.protocol.TMessageType.CALL, 0));
        changeDataMovementPriority_args args = new changeDataMovementPriority_args();
        args.setAuthzToken(authzToken);
        args.setDataMovementInterfaceId(dataMovementInterfaceId);
        args.setNewPriorityOrder(newPriorityOrder);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_changeDataMovementPriority();
      }
    }

    public void changeJobSubmissionPriorities(org.apache.airavata.model.security.AuthzToken authzToken, Map<String,Integer> jobSubmissionPriorityMap, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      changeJobSubmissionPriorities_call method_call = new changeJobSubmissionPriorities_call(authzToken, jobSubmissionPriorityMap, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class changeJobSubmissionPriorities_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private Map<String,Integer> jobSubmissionPriorityMap;
      public changeJobSubmissionPriorities_call(org.apache.airavata.model.security.AuthzToken authzToken, Map<String,Integer> jobSubmissionPriorityMap, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.jobSubmissionPriorityMap = jobSubmissionPriorityMap;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("changeJobSubmissionPriorities", org.apache.thrift.protocol.TMessageType.CALL, 0));
        changeJobSubmissionPriorities_args args = new changeJobSubmissionPriorities_args();
        args.setAuthzToken(authzToken);
        args.setJobSubmissionPriorityMap(jobSubmissionPriorityMap);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_changeJobSubmissionPriorities();
      }
    }

    public void changeDataMovementPriorities(org.apache.airavata.model.security.AuthzToken authzToken, Map<String,Integer> dataMovementPriorityMap, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      changeDataMovementPriorities_call method_call = new changeDataMovementPriorities_call(authzToken, dataMovementPriorityMap, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class changeDataMovementPriorities_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private Map<String,Integer> dataMovementPriorityMap;
      public changeDataMovementPriorities_call(org.apache.airavata.model.security.AuthzToken authzToken, Map<String,Integer> dataMovementPriorityMap, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.dataMovementPriorityMap = dataMovementPriorityMap;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("changeDataMovementPriorities", org.apache.thrift.protocol.TMessageType.CALL, 0));
        changeDataMovementPriorities_args args = new changeDataMovementPriorities_args();
        args.setAuthzToken(authzToken);
        args.setDataMovementPriorityMap(dataMovementPriorityMap);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_changeDataMovementPriorities();
      }
    }

    public void deleteJobSubmissionInterface(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, String jobSubmissionInterfaceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteJobSubmissionInterface_call method_call = new deleteJobSubmissionInterface_call(authzToken, computeResourceId, jobSubmissionInterfaceId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteJobSubmissionInterface_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String computeResourceId;
      private String jobSubmissionInterfaceId;
      public deleteJobSubmissionInterface_call(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, String jobSubmissionInterfaceId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.computeResourceId = computeResourceId;
        this.jobSubmissionInterfaceId = jobSubmissionInterfaceId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteJobSubmissionInterface", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteJobSubmissionInterface_args args = new deleteJobSubmissionInterface_args();
        args.setAuthzToken(authzToken);
        args.setComputeResourceId(computeResourceId);
        args.setJobSubmissionInterfaceId(jobSubmissionInterfaceId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteJobSubmissionInterface();
      }
    }

    public void deleteDataMovementInterface(org.apache.airavata.model.security.AuthzToken authzToken, String productUri, String dataMovementInterfaceId, org.apache.airavata.model.data.movement.DMType dataMoveType, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteDataMovementInterface_call method_call = new deleteDataMovementInterface_call(authzToken, productUri, dataMovementInterfaceId, dataMoveType, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteDataMovementInterface_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String productUri;
      private String dataMovementInterfaceId;
      private org.apache.airavata.model.data.movement.DMType dataMoveType;
      public deleteDataMovementInterface_call(org.apache.airavata.model.security.AuthzToken authzToken, String productUri, String dataMovementInterfaceId, org.apache.airavata.model.data.movement.DMType dataMoveType, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.productUri = productUri;
        this.dataMovementInterfaceId = dataMovementInterfaceId;
        this.dataMoveType = dataMoveType;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteDataMovementInterface", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteDataMovementInterface_args args = new deleteDataMovementInterface_args();
        args.setAuthzToken(authzToken);
        args.setProductUri(productUri);
        args.setDataMovementInterfaceId(dataMovementInterfaceId);
        args.setDataMoveType(dataMoveType);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteDataMovementInterface();
      }
    }

    public void registerResourceJobManager(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager resourceJobManager, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      registerResourceJobManager_call method_call = new registerResourceJobManager_call(authzToken, resourceJobManager, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class registerResourceJobManager_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager resourceJobManager;
      public registerResourceJobManager_call(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager resourceJobManager, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.resourceJobManager = resourceJobManager;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("registerResourceJobManager", org.apache.thrift.protocol.TMessageType.CALL, 0));
        registerResourceJobManager_args args = new registerResourceJobManager_args();
        args.setAuthzToken(authzToken);
        args.setResourceJobManager(resourceJobManager);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_registerResourceJobManager();
      }
    }

    public void updateResourceJobManager(org.apache.airavata.model.security.AuthzToken authzToken, String resourceJobManagerId, org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager updatedResourceJobManager, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateResourceJobManager_call method_call = new updateResourceJobManager_call(authzToken, resourceJobManagerId, updatedResourceJobManager, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateResourceJobManager_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String resourceJobManagerId;
      private org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager updatedResourceJobManager;
      public updateResourceJobManager_call(org.apache.airavata.model.security.AuthzToken authzToken, String resourceJobManagerId, org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager updatedResourceJobManager, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.resourceJobManagerId = resourceJobManagerId;
        this.updatedResourceJobManager = updatedResourceJobManager;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateResourceJobManager", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateResourceJobManager_args args = new updateResourceJobManager_args();
        args.setAuthzToken(authzToken);
        args.setResourceJobManagerId(resourceJobManagerId);
        args.setUpdatedResourceJobManager(updatedResourceJobManager);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateResourceJobManager();
      }
    }

    public void getResourceJobManager(org.apache.airavata.model.security.AuthzToken authzToken, String resourceJobManagerId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getResourceJobManager_call method_call = new getResourceJobManager_call(authzToken, resourceJobManagerId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getResourceJobManager_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String resourceJobManagerId;
      public getResourceJobManager_call(org.apache.airavata.model.security.AuthzToken authzToken, String resourceJobManagerId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.resourceJobManagerId = resourceJobManagerId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getResourceJobManager", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getResourceJobManager_args args = new getResourceJobManager_args();
        args.setAuthzToken(authzToken);
        args.setResourceJobManagerId(resourceJobManagerId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getResourceJobManager();
      }
    }

    public void deleteResourceJobManager(org.apache.airavata.model.security.AuthzToken authzToken, String resourceJobManagerId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteResourceJobManager_call method_call = new deleteResourceJobManager_call(authzToken, resourceJobManagerId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteResourceJobManager_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String resourceJobManagerId;
      public deleteResourceJobManager_call(org.apache.airavata.model.security.AuthzToken authzToken, String resourceJobManagerId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.resourceJobManagerId = resourceJobManagerId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteResourceJobManager", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteResourceJobManager_args args = new deleteResourceJobManager_args();
        args.setAuthzToken(authzToken);
        args.setResourceJobManagerId(resourceJobManagerId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteResourceJobManager();
      }
    }

    public void deleteBatchQueue(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, String queueName, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteBatchQueue_call method_call = new deleteBatchQueue_call(authzToken, computeResourceId, queueName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteBatchQueue_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String computeResourceId;
      private String queueName;
      public deleteBatchQueue_call(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, String queueName, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.computeResourceId = computeResourceId;
        this.queueName = queueName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteBatchQueue", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteBatchQueue_args args = new deleteBatchQueue_args();
        args.setAuthzToken(authzToken);
        args.setComputeResourceId(computeResourceId);
        args.setQueueName(queueName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteBatchQueue();
      }
    }

    public void registerGatewayResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile gatewayResourceProfile, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      registerGatewayResourceProfile_call method_call = new registerGatewayResourceProfile_call(authzToken, gatewayResourceProfile, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class registerGatewayResourceProfile_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile gatewayResourceProfile;
      public registerGatewayResourceProfile_call(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile gatewayResourceProfile, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayResourceProfile = gatewayResourceProfile;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("registerGatewayResourceProfile", org.apache.thrift.protocol.TMessageType.CALL, 0));
        registerGatewayResourceProfile_args args = new registerGatewayResourceProfile_args();
        args.setAuthzToken(authzToken);
        args.setGatewayResourceProfile(gatewayResourceProfile);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_registerGatewayResourceProfile();
      }
    }

    public void getGatewayResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getGatewayResourceProfile_call method_call = new getGatewayResourceProfile_call(authzToken, gatewayID, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getGatewayResourceProfile_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayID;
      public getGatewayResourceProfile_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayID = gatewayID;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getGatewayResourceProfile", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getGatewayResourceProfile_args args = new getGatewayResourceProfile_args();
        args.setAuthzToken(authzToken);
        args.setGatewayID(gatewayID);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getGatewayResourceProfile();
      }
    }

    public void updateGatewayResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile gatewayResourceProfile, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateGatewayResourceProfile_call method_call = new updateGatewayResourceProfile_call(authzToken, gatewayID, gatewayResourceProfile, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateGatewayResourceProfile_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayID;
      private org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile gatewayResourceProfile;
      public updateGatewayResourceProfile_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile gatewayResourceProfile, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayID = gatewayID;
        this.gatewayResourceProfile = gatewayResourceProfile;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateGatewayResourceProfile", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateGatewayResourceProfile_args args = new updateGatewayResourceProfile_args();
        args.setAuthzToken(authzToken);
        args.setGatewayID(gatewayID);
        args.setGatewayResourceProfile(gatewayResourceProfile);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateGatewayResourceProfile();
      }
    }

    public void deleteGatewayResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteGatewayResourceProfile_call method_call = new deleteGatewayResourceProfile_call(authzToken, gatewayID, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteGatewayResourceProfile_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayID;
      public deleteGatewayResourceProfile_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayID = gatewayID;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteGatewayResourceProfile", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteGatewayResourceProfile_args args = new deleteGatewayResourceProfile_args();
        args.setAuthzToken(authzToken);
        args.setGatewayID(gatewayID);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteGatewayResourceProfile();
      }
    }

    public void addGatewayComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String computeResourceId, org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference computeResourcePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addGatewayComputeResourcePreference_call method_call = new addGatewayComputeResourcePreference_call(authzToken, gatewayID, computeResourceId, computeResourcePreference, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addGatewayComputeResourcePreference_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayID;
      private String computeResourceId;
      private org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference computeResourcePreference;
      public addGatewayComputeResourcePreference_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String computeResourceId, org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference computeResourcePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayID = gatewayID;
        this.computeResourceId = computeResourceId;
        this.computeResourcePreference = computeResourcePreference;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addGatewayComputeResourcePreference", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addGatewayComputeResourcePreference_args args = new addGatewayComputeResourcePreference_args();
        args.setAuthzToken(authzToken);
        args.setGatewayID(gatewayID);
        args.setComputeResourceId(computeResourceId);
        args.setComputeResourcePreference(computeResourcePreference);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_addGatewayComputeResourcePreference();
      }
    }

    public void addGatewayStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String storageResourceId, org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference storagePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addGatewayStoragePreference_call method_call = new addGatewayStoragePreference_call(authzToken, gatewayID, storageResourceId, storagePreference, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addGatewayStoragePreference_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayID;
      private String storageResourceId;
      private org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference storagePreference;
      public addGatewayStoragePreference_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String storageResourceId, org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference storagePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayID = gatewayID;
        this.storageResourceId = storageResourceId;
        this.storagePreference = storagePreference;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addGatewayStoragePreference", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addGatewayStoragePreference_args args = new addGatewayStoragePreference_args();
        args.setAuthzToken(authzToken);
        args.setGatewayID(gatewayID);
        args.setStorageResourceId(storageResourceId);
        args.setStoragePreference(storagePreference);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_addGatewayStoragePreference();
      }
    }

    public void getGatewayComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String computeResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getGatewayComputeResourcePreference_call method_call = new getGatewayComputeResourcePreference_call(authzToken, gatewayID, computeResourceId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getGatewayComputeResourcePreference_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayID;
      private String computeResourceId;
      public getGatewayComputeResourcePreference_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String computeResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayID = gatewayID;
        this.computeResourceId = computeResourceId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getGatewayComputeResourcePreference", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getGatewayComputeResourcePreference_args args = new getGatewayComputeResourcePreference_args();
        args.setAuthzToken(authzToken);
        args.setGatewayID(gatewayID);
        args.setComputeResourceId(computeResourceId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getGatewayComputeResourcePreference();
      }
    }

    public void getGatewayStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String storageResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getGatewayStoragePreference_call method_call = new getGatewayStoragePreference_call(authzToken, gatewayID, storageResourceId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getGatewayStoragePreference_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayID;
      private String storageResourceId;
      public getGatewayStoragePreference_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String storageResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayID = gatewayID;
        this.storageResourceId = storageResourceId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getGatewayStoragePreference", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getGatewayStoragePreference_args args = new getGatewayStoragePreference_args();
        args.setAuthzToken(authzToken);
        args.setGatewayID(gatewayID);
        args.setStorageResourceId(storageResourceId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getGatewayStoragePreference();
      }
    }

    public void getAllGatewayComputeResourcePreferences(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllGatewayComputeResourcePreferences_call method_call = new getAllGatewayComputeResourcePreferences_call(authzToken, gatewayID, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllGatewayComputeResourcePreferences_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayID;
      public getAllGatewayComputeResourcePreferences_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayID = gatewayID;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllGatewayComputeResourcePreferences", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllGatewayComputeResourcePreferences_args args = new getAllGatewayComputeResourcePreferences_args();
        args.setAuthzToken(authzToken);
        args.setGatewayID(gatewayID);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference> getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllGatewayComputeResourcePreferences();
      }
    }

    public void getAllGatewayStoragePreferences(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllGatewayStoragePreferences_call method_call = new getAllGatewayStoragePreferences_call(authzToken, gatewayID, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllGatewayStoragePreferences_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayID;
      public getAllGatewayStoragePreferences_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayID = gatewayID;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllGatewayStoragePreferences", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllGatewayStoragePreferences_args args = new getAllGatewayStoragePreferences_args();
        args.setAuthzToken(authzToken);
        args.setGatewayID(gatewayID);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference> getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllGatewayStoragePreferences();
      }
    }

    public void getAllGatewayResourceProfiles(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllGatewayResourceProfiles_call method_call = new getAllGatewayResourceProfiles_call(authzToken, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllGatewayResourceProfiles_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      public getAllGatewayResourceProfiles_call(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllGatewayResourceProfiles", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllGatewayResourceProfiles_args args = new getAllGatewayResourceProfiles_args();
        args.setAuthzToken(authzToken);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.appcatalog.gatewayprofile.GatewayResourceProfile> getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllGatewayResourceProfiles();
      }
    }

    public void updateGatewayComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String computeResourceId, org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference computeResourcePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateGatewayComputeResourcePreference_call method_call = new updateGatewayComputeResourcePreference_call(authzToken, gatewayID, computeResourceId, computeResourcePreference, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateGatewayComputeResourcePreference_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayID;
      private String computeResourceId;
      private org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference computeResourcePreference;
      public updateGatewayComputeResourcePreference_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String computeResourceId, org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference computeResourcePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayID = gatewayID;
        this.computeResourceId = computeResourceId;
        this.computeResourcePreference = computeResourcePreference;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateGatewayComputeResourcePreference", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateGatewayComputeResourcePreference_args args = new updateGatewayComputeResourcePreference_args();
        args.setAuthzToken(authzToken);
        args.setGatewayID(gatewayID);
        args.setComputeResourceId(computeResourceId);
        args.setComputeResourcePreference(computeResourcePreference);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateGatewayComputeResourcePreference();
      }
    }

    public void updateGatewayStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String storageId, org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference storagePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateGatewayStoragePreference_call method_call = new updateGatewayStoragePreference_call(authzToken, gatewayID, storageId, storagePreference, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateGatewayStoragePreference_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayID;
      private String storageId;
      private org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference storagePreference;
      public updateGatewayStoragePreference_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String storageId, org.apache.airavata.model.appcatalog.gatewayprofile.StoragePreference storagePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayID = gatewayID;
        this.storageId = storageId;
        this.storagePreference = storagePreference;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateGatewayStoragePreference", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateGatewayStoragePreference_args args = new updateGatewayStoragePreference_args();
        args.setAuthzToken(authzToken);
        args.setGatewayID(gatewayID);
        args.setStorageId(storageId);
        args.setStoragePreference(storagePreference);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateGatewayStoragePreference();
      }
    }

    public void deleteGatewayComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String computeResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteGatewayComputeResourcePreference_call method_call = new deleteGatewayComputeResourcePreference_call(authzToken, gatewayID, computeResourceId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteGatewayComputeResourcePreference_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayID;
      private String computeResourceId;
      public deleteGatewayComputeResourcePreference_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String computeResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayID = gatewayID;
        this.computeResourceId = computeResourceId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteGatewayComputeResourcePreference", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteGatewayComputeResourcePreference_args args = new deleteGatewayComputeResourcePreference_args();
        args.setAuthzToken(authzToken);
        args.setGatewayID(gatewayID);
        args.setComputeResourceId(computeResourceId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteGatewayComputeResourcePreference();
      }
    }

    public void deleteGatewayStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String storageId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteGatewayStoragePreference_call method_call = new deleteGatewayStoragePreference_call(authzToken, gatewayID, storageId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteGatewayStoragePreference_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayID;
      private String storageId;
      public deleteGatewayStoragePreference_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayID, String storageId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayID = gatewayID;
        this.storageId = storageId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteGatewayStoragePreference", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteGatewayStoragePreference_args args = new deleteGatewayStoragePreference_args();
        args.setAuthzToken(authzToken);
        args.setGatewayID(gatewayID);
        args.setStorageId(storageId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteGatewayStoragePreference();
      }
    }

    public void getSSHAccountProvisioners(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getSSHAccountProvisioners_call method_call = new getSSHAccountProvisioners_call(authzToken, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getSSHAccountProvisioners_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      public getSSHAccountProvisioners_call(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getSSHAccountProvisioners", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getSSHAccountProvisioners_args args = new getSSHAccountProvisioners_args();
        args.setAuthzToken(authzToken);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.appcatalog.accountprovisioning.SSHAccountProvisioner> getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getSSHAccountProvisioners();
      }
    }

    public void doesUserHaveSSHAccount(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, String userId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      doesUserHaveSSHAccount_call method_call = new doesUserHaveSSHAccount_call(authzToken, computeResourceId, userId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class doesUserHaveSSHAccount_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String computeResourceId;
      private String userId;
      public doesUserHaveSSHAccount_call(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, String userId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.computeResourceId = computeResourceId;
        this.userId = userId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("doesUserHaveSSHAccount", org.apache.thrift.protocol.TMessageType.CALL, 0));
        doesUserHaveSSHAccount_args args = new doesUserHaveSSHAccount_args();
        args.setAuthzToken(authzToken);
        args.setComputeResourceId(computeResourceId);
        args.setUserId(userId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_doesUserHaveSSHAccount();
      }
    }

    public void isSSHSetupCompleteForUserComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, String airavataCredStoreToken, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      isSSHSetupCompleteForUserComputeResourcePreference_call method_call = new isSSHSetupCompleteForUserComputeResourcePreference_call(authzToken, computeResourceId, airavataCredStoreToken, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class isSSHSetupCompleteForUserComputeResourcePreference_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String computeResourceId;
      private String airavataCredStoreToken;
      public isSSHSetupCompleteForUserComputeResourcePreference_call(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, String airavataCredStoreToken, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.computeResourceId = computeResourceId;
        this.airavataCredStoreToken = airavataCredStoreToken;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("isSSHSetupCompleteForUserComputeResourcePreference", org.apache.thrift.protocol.TMessageType.CALL, 0));
        isSSHSetupCompleteForUserComputeResourcePreference_args args = new isSSHSetupCompleteForUserComputeResourcePreference_args();
        args.setAuthzToken(authzToken);
        args.setComputeResourceId(computeResourceId);
        args.setAiravataCredStoreToken(airavataCredStoreToken);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_isSSHSetupCompleteForUserComputeResourcePreference();
      }
    }

    public void setupUserComputeResourcePreferencesForSSH(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, String userId, String airavataCredStoreToken, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      setupUserComputeResourcePreferencesForSSH_call method_call = new setupUserComputeResourcePreferencesForSSH_call(authzToken, computeResourceId, userId, airavataCredStoreToken, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class setupUserComputeResourcePreferencesForSSH_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String computeResourceId;
      private String userId;
      private String airavataCredStoreToken;
      public setupUserComputeResourcePreferencesForSSH_call(org.apache.airavata.model.security.AuthzToken authzToken, String computeResourceId, String userId, String airavataCredStoreToken, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.computeResourceId = computeResourceId;
        this.userId = userId;
        this.airavataCredStoreToken = airavataCredStoreToken;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("setupUserComputeResourcePreferencesForSSH", org.apache.thrift.protocol.TMessageType.CALL, 0));
        setupUserComputeResourcePreferencesForSSH_args args = new setupUserComputeResourcePreferencesForSSH_args();
        args.setAuthzToken(authzToken);
        args.setComputeResourceId(computeResourceId);
        args.setUserId(userId);
        args.setAiravataCredStoreToken(airavataCredStoreToken);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_setupUserComputeResourcePreferencesForSSH();
      }
    }

    public void registerUserResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile userResourceProfile, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      registerUserResourceProfile_call method_call = new registerUserResourceProfile_call(authzToken, userResourceProfile, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class registerUserResourceProfile_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile userResourceProfile;
      public registerUserResourceProfile_call(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile userResourceProfile, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.userResourceProfile = userResourceProfile;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("registerUserResourceProfile", org.apache.thrift.protocol.TMessageType.CALL, 0));
        registerUserResourceProfile_args args = new registerUserResourceProfile_args();
        args.setAuthzToken(authzToken);
        args.setUserResourceProfile(userResourceProfile);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public String getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_registerUserResourceProfile();
      }
    }

    public void getUserResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getUserResourceProfile_call method_call = new getUserResourceProfile_call(authzToken, userId, gatewayID, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getUserResourceProfile_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String userId;
      private String gatewayID;
      public getUserResourceProfile_call(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.userId = userId;
        this.gatewayID = gatewayID;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getUserResourceProfile", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getUserResourceProfile_args args = new getUserResourceProfile_args();
        args.setAuthzToken(authzToken);
        args.setUserId(userId);
        args.setGatewayID(gatewayID);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getUserResourceProfile();
      }
    }

    public void updateUserResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile userResourceProfile, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateUserResourceProfile_call method_call = new updateUserResourceProfile_call(authzToken, userId, gatewayID, userResourceProfile, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateUserResourceProfile_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String userId;
      private String gatewayID;
      private org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile userResourceProfile;
      public updateUserResourceProfile_call(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile userResourceProfile, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.userId = userId;
        this.gatewayID = gatewayID;
        this.userResourceProfile = userResourceProfile;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateUserResourceProfile", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateUserResourceProfile_args args = new updateUserResourceProfile_args();
        args.setAuthzToken(authzToken);
        args.setUserId(userId);
        args.setGatewayID(gatewayID);
        args.setUserResourceProfile(userResourceProfile);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateUserResourceProfile();
      }
    }

    public void deleteUserResourceProfile(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteUserResourceProfile_call method_call = new deleteUserResourceProfile_call(authzToken, userId, gatewayID, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteUserResourceProfile_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String userId;
      private String gatewayID;
      public deleteUserResourceProfile_call(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.userId = userId;
        this.gatewayID = gatewayID;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteUserResourceProfile", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteUserResourceProfile_args args = new deleteUserResourceProfile_args();
        args.setAuthzToken(authzToken);
        args.setUserId(userId);
        args.setGatewayID(gatewayID);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteUserResourceProfile();
      }
    }

    public void addUserComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userComputeResourceId, org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference userComputeResourcePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addUserComputeResourcePreference_call method_call = new addUserComputeResourcePreference_call(authzToken, userId, gatewayID, userComputeResourceId, userComputeResourcePreference, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addUserComputeResourcePreference_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String userId;
      private String gatewayID;
      private String userComputeResourceId;
      private org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference userComputeResourcePreference;
      public addUserComputeResourcePreference_call(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userComputeResourceId, org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference userComputeResourcePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.userId = userId;
        this.gatewayID = gatewayID;
        this.userComputeResourceId = userComputeResourceId;
        this.userComputeResourcePreference = userComputeResourcePreference;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addUserComputeResourcePreference", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addUserComputeResourcePreference_args args = new addUserComputeResourcePreference_args();
        args.setAuthzToken(authzToken);
        args.setUserId(userId);
        args.setGatewayID(gatewayID);
        args.setUserComputeResourceId(userComputeResourceId);
        args.setUserComputeResourcePreference(userComputeResourcePreference);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_addUserComputeResourcePreference();
      }
    }

    public void addUserStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userStorageResourceId, org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference userStoragePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addUserStoragePreference_call method_call = new addUserStoragePreference_call(authzToken, userId, gatewayID, userStorageResourceId, userStoragePreference, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addUserStoragePreference_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String userId;
      private String gatewayID;
      private String userStorageResourceId;
      private org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference userStoragePreference;
      public addUserStoragePreference_call(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userStorageResourceId, org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference userStoragePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.userId = userId;
        this.gatewayID = gatewayID;
        this.userStorageResourceId = userStorageResourceId;
        this.userStoragePreference = userStoragePreference;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addUserStoragePreference", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addUserStoragePreference_args args = new addUserStoragePreference_args();
        args.setAuthzToken(authzToken);
        args.setUserId(userId);
        args.setGatewayID(gatewayID);
        args.setUserStorageResourceId(userStorageResourceId);
        args.setUserStoragePreference(userStoragePreference);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_addUserStoragePreference();
      }
    }

    public void getUserComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userComputeResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getUserComputeResourcePreference_call method_call = new getUserComputeResourcePreference_call(authzToken, userId, gatewayID, userComputeResourceId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getUserComputeResourcePreference_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String userId;
      private String gatewayID;
      private String userComputeResourceId;
      public getUserComputeResourcePreference_call(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userComputeResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.userId = userId;
        this.gatewayID = gatewayID;
        this.userComputeResourceId = userComputeResourceId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getUserComputeResourcePreference", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getUserComputeResourcePreference_args args = new getUserComputeResourcePreference_args();
        args.setAuthzToken(authzToken);
        args.setUserId(userId);
        args.setGatewayID(gatewayID);
        args.setUserComputeResourceId(userComputeResourceId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getUserComputeResourcePreference();
      }
    }

    public void getUserStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userStorageResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getUserStoragePreference_call method_call = new getUserStoragePreference_call(authzToken, userId, gatewayID, userStorageResourceId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getUserStoragePreference_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String userId;
      private String gatewayID;
      private String userStorageResourceId;
      public getUserStoragePreference_call(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userStorageResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.userId = userId;
        this.gatewayID = gatewayID;
        this.userStorageResourceId = userStorageResourceId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getUserStoragePreference", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getUserStoragePreference_args args = new getUserStoragePreference_args();
        args.setAuthzToken(authzToken);
        args.setUserId(userId);
        args.setGatewayID(gatewayID);
        args.setUserStorageResourceId(userStorageResourceId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getUserStoragePreference();
      }
    }

    public void getAllUserComputeResourcePreferences(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllUserComputeResourcePreferences_call method_call = new getAllUserComputeResourcePreferences_call(authzToken, userId, gatewayID, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllUserComputeResourcePreferences_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String userId;
      private String gatewayID;
      public getAllUserComputeResourcePreferences_call(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.userId = userId;
        this.gatewayID = gatewayID;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllUserComputeResourcePreferences", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllUserComputeResourcePreferences_args args = new getAllUserComputeResourcePreferences_args();
        args.setAuthzToken(authzToken);
        args.setUserId(userId);
        args.setGatewayID(gatewayID);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference> getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllUserComputeResourcePreferences();
      }
    }

    public void getAllUserStoragePreferences(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllUserStoragePreferences_call method_call = new getAllUserStoragePreferences_call(authzToken, userId, gatewayID, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllUserStoragePreferences_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String userId;
      private String gatewayID;
      public getAllUserStoragePreferences_call(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.userId = userId;
        this.gatewayID = gatewayID;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllUserStoragePreferences", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllUserStoragePreferences_args args = new getAllUserStoragePreferences_args();
        args.setAuthzToken(authzToken);
        args.setUserId(userId);
        args.setGatewayID(gatewayID);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference> getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllUserStoragePreferences();
      }
    }

    public void getAllUserResourceProfiles(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllUserResourceProfiles_call method_call = new getAllUserResourceProfiles_call(authzToken, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllUserResourceProfiles_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      public getAllUserResourceProfiles_call(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllUserResourceProfiles", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllUserResourceProfiles_args args = new getAllUserResourceProfiles_args();
        args.setAuthzToken(authzToken);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.appcatalog.userresourceprofile.UserResourceProfile> getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllUserResourceProfiles();
      }
    }

    public void updateUserComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userComputeResourceId, org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference userComputeResourcePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateUserComputeResourcePreference_call method_call = new updateUserComputeResourcePreference_call(authzToken, userId, gatewayID, userComputeResourceId, userComputeResourcePreference, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateUserComputeResourcePreference_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String userId;
      private String gatewayID;
      private String userComputeResourceId;
      private org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference userComputeResourcePreference;
      public updateUserComputeResourcePreference_call(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userComputeResourceId, org.apache.airavata.model.appcatalog.userresourceprofile.UserComputeResourcePreference userComputeResourcePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.userId = userId;
        this.gatewayID = gatewayID;
        this.userComputeResourceId = userComputeResourceId;
        this.userComputeResourcePreference = userComputeResourcePreference;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateUserComputeResourcePreference", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateUserComputeResourcePreference_args args = new updateUserComputeResourcePreference_args();
        args.setAuthzToken(authzToken);
        args.setUserId(userId);
        args.setGatewayID(gatewayID);
        args.setUserComputeResourceId(userComputeResourceId);
        args.setUserComputeResourcePreference(userComputeResourcePreference);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateUserComputeResourcePreference();
      }
    }

    public void updateUserStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userStorageId, org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference userStoragePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      updateUserStoragePreference_call method_call = new updateUserStoragePreference_call(authzToken, userId, gatewayID, userStorageId, userStoragePreference, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class updateUserStoragePreference_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String userId;
      private String gatewayID;
      private String userStorageId;
      private org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference userStoragePreference;
      public updateUserStoragePreference_call(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userStorageId, org.apache.airavata.model.appcatalog.userresourceprofile.UserStoragePreference userStoragePreference, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.userId = userId;
        this.gatewayID = gatewayID;
        this.userStorageId = userStorageId;
        this.userStoragePreference = userStoragePreference;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("updateUserStoragePreference", org.apache.thrift.protocol.TMessageType.CALL, 0));
        updateUserStoragePreference_args args = new updateUserStoragePreference_args();
        args.setAuthzToken(authzToken);
        args.setUserId(userId);
        args.setGatewayID(gatewayID);
        args.setUserStorageId(userStorageId);
        args.setUserStoragePreference(userStoragePreference);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_updateUserStoragePreference();
      }
    }

    public void deleteUserComputeResourcePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userComputeResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteUserComputeResourcePreference_call method_call = new deleteUserComputeResourcePreference_call(authzToken, userId, gatewayID, userComputeResourceId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteUserComputeResourcePreference_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String userId;
      private String gatewayID;
      private String userComputeResourceId;
      public deleteUserComputeResourcePreference_call(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userComputeResourceId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.userId = userId;
        this.gatewayID = gatewayID;
        this.userComputeResourceId = userComputeResourceId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteUserComputeResourcePreference", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteUserComputeResourcePreference_args args = new deleteUserComputeResourcePreference_args();
        args.setAuthzToken(authzToken);
        args.setUserId(userId);
        args.setGatewayID(gatewayID);
        args.setUserComputeResourceId(userComputeResourceId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteUserComputeResourcePreference();
      }
    }

    public void deleteUserStoragePreference(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userStorageId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteUserStoragePreference_call method_call = new deleteUserStoragePreference_call(authzToken, userId, gatewayID, userStorageId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteUserStoragePreference_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String userId;
      private String gatewayID;
      private String userStorageId;
      public deleteUserStoragePreference_call(org.apache.airavata.model.security.AuthzToken authzToken, String userId, String gatewayID, String userStorageId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.userId = userId;
        this.gatewayID = gatewayID;
        this.userStorageId = userStorageId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteUserStoragePreference", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteUserStoragePreference_args args = new deleteUserStoragePreference_args();
        args.setAuthzToken(authzToken);
        args.setUserId(userId);
        args.setGatewayID(gatewayID);
        args.setUserStorageId(userStorageId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public boolean getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteUserStoragePreference();
      }
    }

    public void getAllWorkflows(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllWorkflows_call method_call = new getAllWorkflows_call(authzToken, gatewayId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllWorkflows_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      private String gatewayId;
      public getAllWorkflows_call(org.apache.airavata.model.security.AuthzToken authzToken, String gatewayId, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
        this.gatewayId = gatewayId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllWorkflows", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllWorkflows_args args = new getAllWorkflows_args();
        args.setAuthzToken(authzToken);
        args.setGatewayId(gatewayId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<String> getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllWorkflows();
      }
    }

    public void getLatestQueueStatuses(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getLatestQueueStatuses_call method_call = new getLatestQueueStatuses_call(authzToken, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getLatestQueueStatuses_call extends org.apache.thrift.async.TAsyncMethodCall {
      private org.apache.airavata.model.security.AuthzToken authzToken;
      public getLatestQueueStatuses_call(org.apache.airavata.model.security.AuthzToken authzToken, org.apache.thrift.async.AsyncMethodCallback resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.authzToken = authzToken;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getLatestQueueStatuses", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getLatestQueueStatuses_args args = new getLatestQueueStatuses_args();
        args.setAuthzToken(authzToken);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public List<org.apache.airavata.model.status.QueueStatusModel> getResult() throws org.apache.airavata.model.error.InvalidRequestException, org.apache.airavata.model.error.AiravataClientException, org.apache.airavata.model.error.AiravataSystemException, org.apache.airavata.model.error.AuthorizationException, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getLatestQueueStatuses();
      }
    }

    public void getWorkflow(org.apache.airavata.model.security.AuthzToken authzToken, String workflowTemplateId, org.apache.thrift.async.AsyncMethodCallback resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getWorkflow_call method_call = new getWorkflow_call(authzToken, workflowTemplateId, re