/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.stream;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

public class StreamGobbler
extends Thread
implements Closeable {
    protected final InputStream stream;
    protected final PrintStream out;
    protected final Logger log;
    private final AtomicBoolean running = new AtomicBoolean(true);
    String logPrefix = "";
    String printPrefix = "";
    private final StringBuilder lineSoFar = new StringBuilder(16);
    private volatile boolean finished = false;

    public StreamGobbler(InputStream stream, OutputStream out, Logger log) {
        this(stream, out != null ? new PrintStream(out) : null, log);
    }

    public StreamGobbler(InputStream stream, PrintStream out, Logger log) {
        this.stream = stream;
        this.out = out;
        this.log = log;
    }

    @Override
    public void close() {
        this.running.set(false);
        this.interrupt();
    }

    @Deprecated
    public void shutdown() {
        this.close();
    }

    public StreamGobbler setPrefix(String prefix) {
        this.setLogPrefix(prefix);
        this.setPrintPrefix(prefix);
        return this;
    }

    public StreamGobbler setPrintPrefix(String prefix) {
        this.printPrefix = prefix;
        return this;
    }

    public StreamGobbler setLogPrefix(String prefix) {
        this.logPrefix = prefix;
        return this;
    }

    @Override
    public void run() {
        int c = -1;
        try {
            while (this.running.get() && (c = this.stream.read()) >= 0) {
                this.onChar(c);
            }
            this.onClose();
        }
        catch (IOException e) {
            this.onClose();
            if (this.log != null && this.log.isTraceEnabled()) {
                this.log.trace(this.logPrefix + "exception reading from stream (" + e + ")");
            }
        }
        finally {
            if (this.out != null) {
                this.out.flush();
            }
        }
    }

    public void onChar(int c) {
        if (c == 10 || c == 13) {
            if (this.lineSoFar.length() > 0) {
                this.onLine(this.lineSoFar.toString());
            }
            this.lineSoFar.setLength(0);
        } else {
            this.lineSoFar.append((char)c);
        }
    }

    public void onLine(String line) {
        while (line.length() > 0 && Character.isWhitespace(line.charAt(line.length() - 1))) {
            line = line.substring(0, line.length() - 1);
        }
        while (line.length() > 0 && (line.charAt(0) == '\n' || line.charAt(0) == '\r')) {
            line = line.substring(1);
        }
        if (!line.isEmpty()) {
            if (this.out != null) {
                this.out.println(this.printPrefix + line);
            }
            if (this.log != null && this.log.isDebugEnabled()) {
                this.log.debug(this.logPrefix + line);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose() {
        this.onLine(this.lineSoFar.toString());
        if (this.out != null) {
            this.out.flush();
        }
        this.lineSoFar.setLength(0);
        this.finished = true;
        StreamGobbler streamGobbler = this;
        synchronized (streamGobbler) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockUntilFinished() throws InterruptedException {
        StreamGobbler streamGobbler = this;
        synchronized (streamGobbler) {
            while (!this.finished) {
                this.wait();
            }
        }
    }

    public boolean isFinished() {
        return this.finished;
    }
}

