/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.transform;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.ws.rs.core.UriBuilder;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.effector.ParameterType;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.core.config.Sanitizer;
import org.apache.brooklyn.rest.api.ApplicationApi;
import org.apache.brooklyn.rest.api.EffectorApi;
import org.apache.brooklyn.rest.api.EntityApi;
import org.apache.brooklyn.rest.domain.EffectorSummary;
import org.apache.brooklyn.rest.util.WebResourceUtils;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;

public class EffectorTransformer {
    public static EffectorSummary effectorSummary(final Entity entity, Effector<?> effector, UriBuilder ub) {
        URI applicationUri = WebResourceUtils.serviceUriBuilder(ub, ApplicationApi.class, "get").build(new Object[]{entity.getApplicationId()});
        URI entityUri = WebResourceUtils.serviceUriBuilder(ub, EntityApi.class, "get").build(new Object[]{entity.getApplicationId(), entity.getId()});
        URI selfUri = WebResourceUtils.serviceUriBuilder(ub, EffectorApi.class, "invoke").build(new Object[]{entity.getApplicationId(), entity.getId(), effector.getName()});
        return new EffectorSummary(effector.getName(), effector.getReturnTypeName(), (Set)ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)effector.getParameters(), (Function)new Function<ParameterType<?>, EffectorSummary.ParameterSummary<?>>(){

            public EffectorSummary.ParameterSummary<?> apply(@Nullable ParameterType<?> parameterType) {
                return EffectorTransformer.parameterSummary(entity, parameterType);
            }
        })), effector.getDescription(), (Map)ImmutableMap.of((Object)"self", (Object)selfUri, (Object)"entity", (Object)entityUri, (Object)"application", (Object)applicationUri));
    }

    public static EffectorSummary effectorSummaryForCatalog(Effector<?> effector) {
        ImmutableSet parameters = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)effector.getParameters(), (Function)new Function<ParameterType<?>, EffectorSummary.ParameterSummary<?>>(){

            public EffectorSummary.ParameterSummary<?> apply(ParameterType<?> parameterType) {
                return EffectorTransformer.parameterSummary(null, parameterType);
            }
        }));
        return new EffectorSummary(effector.getName(), effector.getReturnTypeName(), (Set)parameters, effector.getDescription(), null);
    }

    protected static EffectorSummary.ParameterSummary<?> parameterSummary(Entity entity, ParameterType<?> parameterType) {
        try {
            Maybe defaultValue = Tasks.resolving((Object)parameterType.getDefaultValue()).as(parameterType.getParameterType()).context(entity).immediately(true).getMaybe();
            return new EffectorSummary.ParameterSummary(parameterType.getName(), parameterType.getParameterClassName(), parameterType.getDescription(), WebResourceUtils.getValueForDisplay(defaultValue.orNull(), true, false), Sanitizer.IS_SECRET_PREDICATE.apply((Object)parameterType.getName()));
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }
}

