/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.extensions;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Atomics;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.CloneImageTemplate;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.ImageTemplate;
import org.jclouds.compute.domain.ImageTemplateBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.domain.Location;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.domain.Reservation;
import org.jclouds.ec2.features.AMIApi;
import org.jclouds.ec2.features.InstanceApi;
import org.jclouds.ec2.options.CreateImageOptions;
import org.jclouds.location.predicates.LocationPredicates;
import org.jclouds.logging.Logger;

public class EC2ImageExtension
implements ImageExtension {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final EC2Api ec2Api;
    private final ListeningExecutorService userExecutor;
    private final Supplier<Set<? extends Location>> locations;
    private final Predicate<AtomicReference<Image>> imageAvailablePredicate;

    @Inject
    public EC2ImageExtension(EC2Api ec2Api, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, @Memoized Supplier<Set<? extends Location>> locations, @Named(value="jclouds.compute.timeout.image-available") Predicate<AtomicReference<Image>> imageAvailablePredicate) {
        this.ec2Api = (EC2Api)Preconditions.checkNotNull((Object)ec2Api, (Object)"ec2Api");
        this.userExecutor = (ListeningExecutorService)Preconditions.checkNotNull((Object)userExecutor, (Object)"userExecutor");
        this.locations = (Supplier)Preconditions.checkNotNull(locations, (Object)"locations");
        this.imageAvailablePredicate = (Predicate)Preconditions.checkNotNull(imageAvailablePredicate, (Object)"imageAvailablePredicate");
    }

    public ImageTemplate buildImageTemplateFromNode(String name, String id) {
        String[] parts = AWSUtils.parseHandle((String)id);
        String region = parts[0];
        String instanceId = parts[1];
        Reservation instance = (Reservation)Iterables.getOnlyElement(((InstanceApi)this.ec2Api.getInstanceApi().get()).describeInstancesInRegion(region, instanceId));
        if (instance == null) {
            throw new NoSuchElementException("Cannot find server with id: " + id);
        }
        CloneImageTemplate template = new ImageTemplateBuilder.CloneImageTemplateBuilder().nodeId(id).name(name).build();
        return template;
    }

    public ListenableFuture<Image> createImage(ImageTemplate template) {
        Preconditions.checkState((boolean)(template instanceof CloneImageTemplate), (Object)" ec2 only supports creating images through cloning.");
        CloneImageTemplate cloneTemplate = (CloneImageTemplate)template;
        String[] parts = AWSUtils.parseHandle((String)cloneTemplate.getSourceNodeId());
        String region = parts[0];
        String instanceId = parts[1];
        String imageId = ((AMIApi)this.ec2Api.getAMIApi().get()).createImageInRegion(region, cloneTemplate.getName(), instanceId, CreateImageOptions.NONE);
        final AtomicReference image = Atomics.newReference((Object)new ImageBuilder().location((Location)Iterables.find((Iterable)((Iterable)this.locations.get()), (Predicate)LocationPredicates.idEquals((String)region))).id(region + "/" + imageId).providerId(imageId).description(cloneTemplate.getName()).operatingSystem(OperatingSystem.builder().description(cloneTemplate.getName()).build()).status(Image.Status.PENDING).build());
        return this.userExecutor.submit((Callable)new Callable<Image>(){

            @Override
            public Image call() throws Exception {
                if (EC2ImageExtension.this.imageAvailablePredicate.apply((Object)image)) {
                    return (Image)image.get();
                }
                throw new UncheckedTimeoutException("Image was not created within the time limit: " + image.get());
            }
        });
    }

    public boolean deleteImage(String id) {
        String[] parts = AWSUtils.parseHandle((String)id);
        String region = parts[0];
        String instanceId = parts[1];
        try {
            ((AMIApi)this.ec2Api.getAMIApi().get()).deregisterImageInRegion(region, instanceId);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

