/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.policy.ha;

import com.google.common.base.Preconditions;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.policy.AbstractPolicy;
import org.apache.brooklyn.policy.ha.HASensors;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalSuspendPolicy
extends AbstractPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(ConditionalSuspendPolicy.class);
    @SetFromFlag(value="suppressSensor")
    public static final ConfigKey<Sensor<?>> SUSPEND_SENSOR = ConfigKeys.newConfigKey(Sensor.class, (String)"suppressSensor", (String)"Sensor which will suppress the target policy", HASensors.CONNECTION_FAILED);
    @SetFromFlag(value="resetSensor")
    public static final ConfigKey<Sensor<?>> RESUME_SENSOR = ConfigKeys.newConfigKey(Sensor.class, (String)"resetSensor", (String)"Resume target policy when this sensor is observed", HASensors.CONNECTION_RECOVERED);
    @SetFromFlag(value="target")
    public static final ConfigKey<Object> SUSPEND_TARGET = ConfigKeys.newConfigKey(Object.class, (String)"target", (String)"The target policy to suspend. Either direct reference or the value of the suspendTarget config on a policy from the same entity.");

    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        Object target = this.config().get(SUSPEND_TARGET);
        Preconditions.checkNotNull((Object)target, (Object)"Suspend target required");
        Preconditions.checkNotNull((Object)this.getTargetPolicy(), (Object)("Can't find target policy set in " + SUSPEND_TARGET.getName() + ": " + target));
        this.subscribe();
        this.uniqueTag = JavaClassNames.simpleClassName(((Object)((Object)this)).getClass()) + ":" + ((Sensor)this.getConfig(SUSPEND_SENSOR)).getName() + ":" + ((Sensor)this.getConfig(RESUME_SENSOR)).getName();
    }

    private void subscribe() {
        this.subscriptions().subscribe((Entity)this.entity, (Sensor)this.getConfig(SUSPEND_SENSOR), (SensorEventListener)new SensorEventListener<Object>(){

            public void onEvent(SensorEvent<Object> event) {
                if (ConditionalSuspendPolicy.this.isRunning()) {
                    Policy target = ConditionalSuspendPolicy.this.getTargetPolicy();
                    target.suspend();
                    LOG.debug("Suspended policy " + target + ", triggered by " + event.getSensor() + " = " + event.getValue());
                }
            }
        });
        this.subscriptions().subscribe((Entity)this.entity, (Sensor)this.getConfig(RESUME_SENSOR), (SensorEventListener)new SensorEventListener<Object>(){

            public void onEvent(SensorEvent<Object> event) {
                if (ConditionalSuspendPolicy.this.isRunning()) {
                    Policy target = ConditionalSuspendPolicy.this.getTargetPolicy();
                    target.resume();
                    LOG.debug("Resumed policy " + target + ", triggered by " + event.getSensor() + " = " + event.getValue());
                }
            }
        });
    }

    private Policy getTargetPolicy() {
        Object target = this.config().get(SUSPEND_TARGET);
        if (target instanceof Policy) {
            return (Policy)target;
        }
        if (target instanceof String) {
            for (Policy policy : this.entity.policies()) {
                if (!target.equals(policy.getDisplayName()) && !target.equals(policy.getClass().getName())) continue;
                return policy;
            }
        } else {
            throw new IllegalStateException("Unexpected type " + target.getClass() + " for target " + target);
        }
        return null;
    }
}

