/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationplatformstatus.traits;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;
import java.util.Optional;
import org.apache.camel.v1.integrationplatformstatus.traits.Istio;
import org.apache.camel.v1.integrationplatformstatus.traits.istio.Configuration;
import org.apache.camel.v1.integrationplatformstatus.traits.istio.ConfigurationBuilder;
import org.apache.camel.v1.integrationplatformstatus.traits.istio.ConfigurationFluent;

public class IstioFluent<A extends IstioFluent<A>>
extends BaseFluent<A> {
    private String allow;
    private ConfigurationBuilder configuration;
    private Boolean enabled;
    private Boolean inject;

    public IstioFluent() {
    }

    public IstioFluent(Istio instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Istio instance) {
        Istio istio = instance = instance != null ? instance : new Istio();
        if (instance != null) {
            this.withAllow(instance.getAllow());
            this.withConfiguration(instance.getConfiguration());
            this.withEnabled(instance.getEnabled());
            this.withInject(instance.getInject());
        }
    }

    public String getAllow() {
        return this.allow;
    }

    public A withAllow(String allow) {
        this.allow = allow;
        return (A)((Object)this);
    }

    public boolean hasAllow() {
        return this.allow != null;
    }

    public Configuration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    public A withConfiguration(Configuration configuration) {
        this._visitables.remove((Object)"configuration");
        if (configuration != null) {
            this.configuration = new ConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public ConfigurationNested<A> withNewConfigurationLike(Configuration item) {
        return new ConfigurationNested(item);
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new ConfigurationBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(Configuration item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public Boolean getInject() {
        return this.inject;
    }

    public A withInject(Boolean inject) {
        this.inject = inject;
        return (A)((Object)this);
    }

    public boolean hasInject() {
        return this.inject != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IstioFluent that = (IstioFluent)((Object)o);
        if (!Objects.equals(this.allow, that.allow)) {
            return false;
        }
        if (!Objects.equals((Object)this.configuration, (Object)that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        return Objects.equals(this.inject, that.inject);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allow, this.configuration, this.enabled, this.inject, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allow != null) {
            sb.append("allow:");
            sb.append(this.allow + ",");
        }
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.inject != null) {
            sb.append("inject:");
            sb.append(this.inject);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public A withInject() {
        return this.withInject(true);
    }

    public class ConfigurationNested<N>
    extends ConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        ConfigurationBuilder builder;

        ConfigurationNested(Configuration item) {
            this.builder = new ConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)IstioFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }
}

