/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationspec.template.spec.containers;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.generator.annotation.Required;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import org.apache.camel.v1.integrationspec.template.spec.containers.env.ValueFrom;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "value", "valueFrom"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Env
implements KubernetesResource {
    @JsonProperty(value="name")
    @Required
    @JsonPropertyDescription(value="Name of the environment variable. Must be a C_IDENTIFIER.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String name;
    @JsonProperty(value="value")
    @JsonPropertyDescription(value="Variable references $(VAR_NAME) are expanded using the previously defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. \"$$(VAR_NAME)\" will produce the string literal \"$(VAR_NAME)\". Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to \"\".")
    @JsonSetter(nulls=Nulls.SKIP)
    private String value;
    @JsonProperty(value="valueFrom")
    @JsonPropertyDescription(value="Source for the environment variable's value. Cannot be used if value is not empty.")
    @JsonSetter(nulls=Nulls.SKIP)
    private ValueFrom valueFrom;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ValueFrom getValueFrom() {
        return this.valueFrom;
    }

    public void setValueFrom(ValueFrom valueFrom) {
        this.valueFrom = valueFrom;
    }

    public String toString() {
        return "Env(name=" + this.getName() + ", value=" + this.getValue() + ", valueFrom=" + this.getValueFrom() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Env)) {
            return false;
        }
        Env other = (Env)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        ValueFrom this$valueFrom = this.getValueFrom();
        ValueFrom other$valueFrom = other.getValueFrom();
        return !(this$valueFrom == null ? other$valueFrom != null : !((Object)this$valueFrom).equals(other$valueFrom));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Env;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        ValueFrom $valueFrom = this.getValueFrom();
        result = result * 59 + ($valueFrom == null ? 43 : ((Object)$valueFrom).hashCode());
        return result;
    }
}

