/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1alpha1.kameletbindingspec.integration.template.spec.volumes.projected.sources;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.generator.annotation.Required;
import io.fabric8.kubernetes.api.model.KubernetesResource;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"audience", "expirationSeconds", "path"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class ServiceAccountToken
implements KubernetesResource {
    @JsonProperty(value="audience")
    @JsonPropertyDescription(value="audience is the intended audience of the token. A recipient of a token must identify itself with an identifier specified in the audience of the token, and otherwise should reject the token. The audience defaults to the identifier of the apiserver.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String audience;
    @JsonProperty(value="expirationSeconds")
    @JsonPropertyDescription(value="expirationSeconds is the requested duration of validity of the service account token. As the token approaches expiration, the kubelet volume plugin will proactively rotate the service account token. The kubelet will start trying to rotate the token if the token is older than 80 percent of its time to live or if the token is older than 24 hours.Defaults to 1 hour and must be at least 10 minutes.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Long expirationSeconds;
    @JsonProperty(value="path")
    @Required
    @JsonPropertyDescription(value="path is the path relative to the mount point of the file to project the token into.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String path;

    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public Long getExpirationSeconds() {
        return this.expirationSeconds;
    }

    public void setExpirationSeconds(Long expirationSeconds) {
        this.expirationSeconds = expirationSeconds;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String toString() {
        return "ServiceAccountToken(audience=" + this.getAudience() + ", expirationSeconds=" + this.getExpirationSeconds() + ", path=" + this.getPath() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceAccountToken)) {
            return false;
        }
        ServiceAccountToken other = (ServiceAccountToken)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$expirationSeconds = this.getExpirationSeconds();
        Long other$expirationSeconds = other.getExpirationSeconds();
        if (this$expirationSeconds == null ? other$expirationSeconds != null : !((Object)this$expirationSeconds).equals(other$expirationSeconds)) {
            return false;
        }
        String this$audience = this.getAudience();
        String other$audience = other.getAudience();
        if (this$audience == null ? other$audience != null : !this$audience.equals(other$audience)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        return !(this$path == null ? other$path != null : !this$path.equals(other$path));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServiceAccountToken;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $expirationSeconds = this.getExpirationSeconds();
        result = result * 59 + ($expirationSeconds == null ? 43 : ((Object)$expirationSeconds).hashCode());
        String $audience = this.getAudience();
        result = result * 59 + ($audience == null ? 43 : $audience.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        return result;
    }
}

