/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.MockHttpServletRequest;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class MultipartStreamTest {
    private static final String BOUNDARY_TEXT = "myboundary";

    @Test
    public void testMalformedUploadTruncatedHeaders() throws IOException, FileUploadException {
        String request = "-----1234\r\nContent-Disposition: form-data; name=\"file1\"; filename=\"foo1.tab\"\r\nContent-Type: text/whatever\r\nContent-Length: 10\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; name=\"file2\"; filename=\"foo2.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n";
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        upload.setFileSizeMax(-1L);
        upload.setSizeMax(-1L);
        MockHttpServletRequest req = new MockHttpServletRequest("-----1234\r\nContent-Disposition: form-data; name=\"file1\"; filename=\"foo1.tab\"\r\nContent-Type: text/whatever\r\nContent-Length: 10\r\n\r\nThis is the content of the file\n\r\n-----1234\r\nContent-Disposition: form-data; name=\"file2\"; filename=\"foo2.tab\"\r\nContent-Type: text/whatever\r\n\r\nThis is the content of the file\n".getBytes("US-ASCII"), "multipart/form-data; boundary=---1234");
        Assertions.assertThrows(FileUploadBase.IOFileUploadException.class, () -> upload.parseRequest((HttpServletRequest)req));
    }

    @Test
    public void testMalformedUploadTruncatedHeadersOnBoundary() throws IOException {
        StringBuilder request = new StringBuilder("-----1234\r\nContent-Disposition: form-data; name=\"file1\"; filename=\"foo1.tab\"\r\nContent-Type: text/whatever\r\nContent-Length: 10\r\nX-Padding: ");
        int paddingLength = 4096 - request.length();
        for (int i = 0; i < paddingLength; ++i) {
            request.append('x');
        }
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        upload.setFileSizeMax(-1L);
        upload.setSizeMax(-1L);
        upload.setPartHeaderSizeMax(-1);
        MockHttpServletRequest req = new MockHttpServletRequest(request.toString().getBytes("US-ASCII"), "multipart/form-data; boundary=---1234");
        FileUploadException e = (FileUploadException)Assertions.assertThrows(FileUploadException.class, () -> upload.parseRequest((HttpServletRequest)req));
        Assertions.assertInstanceOf(MultipartStream.MalformedStreamException.class, (Object)e.getCause());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSmallBuffer() throws Exception {
        String strData = "foobar";
        byte[] contents = "foobar".getBytes();
        ByteArrayInputStream input = new ByteArrayInputStream(contents);
        byte[] boundary = BOUNDARY_TEXT.getBytes();
        boolean iBufSize = true;
        MultipartStream unused = new MultipartStream((InputStream)input, boundary, 1, new MultipartStream.ProgressNotifier(null, (long)contents.length));
    }

    @Test
    public void testThreeParamConstructor() throws Exception {
        String strData = "foobar";
        byte[] contents = "foobar".getBytes();
        ByteArrayInputStream input = new ByteArrayInputStream(contents);
        byte[] boundary = BOUNDARY_TEXT.getBytes();
        int iBufSize = boundary.length + MultipartStream.BOUNDARY_PREFIX.length + 1;
        MultipartStream ms = new MultipartStream((InputStream)input, boundary, iBufSize, new MultipartStream.ProgressNotifier(null, (long)contents.length));
        Assertions.assertNotNull((Object)ms);
    }

    @Test
    public void testTwoParamConstructor() throws Exception {
        String strData = "foobar";
        byte[] contents = "foobar".getBytes();
        ByteArrayInputStream input = new ByteArrayInputStream(contents);
        byte[] boundary = BOUNDARY_TEXT.getBytes();
        MultipartStream ms = new MultipartStream((InputStream)input, boundary, new MultipartStream.ProgressNotifier(null, (long)contents.length));
        Assertions.assertNotNull((Object)ms);
    }
}

