/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.spherical.twod;

import org.apache.commons.geometry.euclidean.threed.Vector3D;
import org.apache.commons.geometry.spherical.oned.AngularInterval;
import org.apache.commons.geometry.spherical.oned.Point1S;
import org.apache.commons.geometry.spherical.twod.GreatArc;
import org.apache.commons.geometry.spherical.twod.GreatCircle;
import org.apache.commons.geometry.spherical.twod.Point2S;
import org.apache.commons.numbers.core.Precision;

public final class GreatCircles {
    private GreatCircles() {
    }

    public static GreatCircle fromPole(Vector3D pole, Precision.DoubleEquivalence precision) {
        Vector3D.Unit u = pole.orthogonal();
        Vector3D.Unit v = pole.cross((Vector3D)u).normalize();
        return new GreatCircle(pole.normalize(), u, v, precision);
    }

    public static GreatCircle fromPoleAndU(Vector3D pole, Vector3D u, Precision.DoubleEquivalence precision) {
        Vector3D.Unit unitPole = pole.normalize();
        Vector3D.Unit unitX = pole.orthogonal(u);
        Vector3D.Unit unitY = pole.cross(u).normalize();
        return new GreatCircle(unitPole, unitX, unitY, precision);
    }

    public static GreatCircle fromPoints(Point2S a, Point2S b, Precision.DoubleEquivalence precision) {
        if (!a.isFinite() || !b.isFinite()) {
            throw new IllegalArgumentException("Invalid points for great circle: " + a + ", " + b);
        }
        String err = null;
        double dist = a.distance(b);
        if (precision.eqZero(dist)) {
            err = "equal";
        } else if (precision.eq(dist, Math.PI)) {
            err = "antipodal";
        }
        if (err != null) {
            throw new IllegalArgumentException("Cannot create great circle from points " + a + " and " + b + ": points are " + err);
        }
        Vector3D.Unit u = a.getVector().normalize();
        Vector3D.Unit pole = u.cross((Vector3D)b.getVector()).normalize();
        Vector3D.Unit v = pole.cross((Vector3D)u).normalize();
        return new GreatCircle(pole, u, v, precision);
    }

    public static GreatArc arcFromPoints(Point2S start, Point2S end, Precision.DoubleEquivalence precision) {
        GreatCircle circle = GreatCircles.fromPoints(start, end, precision);
        Point1S subspaceStart = circle.toSubspace(start);
        Point1S subspaceEnd = circle.toSubspace(end);
        AngularInterval.Convex interval = AngularInterval.Convex.of(subspaceStart, subspaceEnd, precision);
        return GreatCircles.arcFromInterval(circle, interval);
    }

    public static GreatArc arcFromInterval(GreatCircle circle, AngularInterval.Convex interval) {
        return new GreatArc(circle, interval);
    }

    static void validateGreatCirclesEquivalent(GreatCircle expected, GreatCircle actual) {
        if (!expected.eq(actual, expected.getPrecision())) {
            throw new IllegalArgumentException("Arguments do not represent the same great circle. Expected " + (Object)((Object)expected) + " but was " + (Object)((Object)actual) + ".");
        }
    }
}

