/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.core.partitioning;

import org.apache.commons.geometry.core.partitioning.SplitLocation;

public final class Split<T> {
    private final T minus;
    private final T plus;

    public Split(T minus, T plus) {
        this.minus = minus;
        this.plus = plus;
    }

    public T getMinus() {
        return this.minus;
    }

    public T getPlus() {
        return this.plus;
    }

    public SplitLocation getLocation() {
        if (this.minus != null) {
            return this.plus != null ? SplitLocation.BOTH : SplitLocation.MINUS;
        }
        if (this.plus != null) {
            return SplitLocation.PLUS;
        }
        return SplitLocation.NEITHER;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[location= ").append((Object)this.getLocation()).append(", minus= ").append(this.minus).append(", plus= ").append(this.plus).append(']');
        return sb.toString();
    }
}

