/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.IndexStatsUtil;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.SQLUtilities;
import org.apache.derbyTesting.junit.TestConfiguration;

public class UpdateStatisticsTest
extends BaseJDBCTestCase {
    public UpdateStatisticsTest(String string) {
        super(string);
    }

    public static Test suite() {
        Test test = TestConfiguration.defaultSuite(UpdateStatisticsTest.class);
        Test test2 = DatabasePropertyTestSetup.singleProperty(test, "derby.storage.indexStats.auto", "false", true);
        return test2;
    }

    public void testIndexAndColumnNamedStatistics() throws SQLException {
        String string = "T1";
        IndexStatsUtil indexStatsUtil = new IndexStatsUtil(this.openDefaultConnection());
        Statement statement = this.createStatement();
        int n = indexStatsUtil.getStats().length;
        statement.executeUpdate("CREATE TABLE t1 (c11 int, statistics int not null)");
        statement.executeUpdate("CREATE INDEX statistIcs ON t1(c11)");
        statement.executeUpdate("INSERT INTO t1 VALUES(1,1)");
        indexStatsUtil.assertNoStatsTable(string);
        statement.executeUpdate("ALTER TABLE t1 DROP statistics");
        statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1','STATISTICS')");
        indexStatsUtil.assertTableStats(string, 1);
        statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_DROP_STATISTICS('APP','T1','STATISTICS')");
        indexStatsUtil.assertNoStatsTable(string);
        statement.executeUpdate("ALTER TABLE t1 ADD COLUMN statistics int");
        indexStatsUtil.assertNoStatsTable(string);
        statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_DROP_STATISTICS('APP','T1','STATISTICS')");
        indexStatsUtil.assertNoStatsTable(string);
        statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1','STATISTICS')");
        indexStatsUtil.assertTableStats(string, 1);
        statement.executeUpdate("DROP TABLE t1");
        UpdateStatisticsTest.assertEquals((int)n, (int)indexStatsUtil.getStats().length);
    }

    public void testStatisticsProcsWithEmptyParamsDerby5750() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table DERBY5750_t1 (c11 int)");
        statement.executeUpdate("CREATE INDEX DERBY5750_I1 ON DERBY5750_t1(c11)");
        UpdateStatisticsTest.assertStatementError("42Y07", statement, "call syscs_util.SYSCS_UPDATE_STATISTICS('','DERBY5750_T1','DERBY5750_I1')");
        UpdateStatisticsTest.assertStatementError("42Y07", statement, "call syscs_util.SYSCS_DROP_STATISTICS('','DERBY5750_T1','DERBY5750_I1')");
        UpdateStatisticsTest.assertStatementError("42Y07", statement, "call syscs_util.SYSCS_UPDATE_STATISTICS('','','DERBY5750_I1')");
        UpdateStatisticsTest.assertStatementError("42Y07", statement, "call syscs_util.SYSCS_DROP_STATISTICS('','','DERBY5750_I1')");
        statement.execute("call syscs_util.SYSCS_UPDATE_STATISTICS(null,'DERBY5750_T1','DERBY5750_I1')");
        statement.execute("call syscs_util.SYSCS_DROP_STATISTICS(null,'DERBY5750_T1','DERBY5750_I1')");
        UpdateStatisticsTest.assertStatementError("42X05", statement, "call syscs_util.SYSCS_UPDATE_STATISTICS(null,'','DERBY5750_I1')");
        UpdateStatisticsTest.assertStatementError("42X05", statement, "call syscs_util.SYSCS_DROP_STATISTICS(null,'','DERBY5750_I1')");
        UpdateStatisticsTest.assertStatementError("42X05", statement, "call syscs_util.SYSCS_UPDATE_STATISTICS('APP','','DERBY5750_I1')");
        UpdateStatisticsTest.assertStatementError("42X05", statement, "call syscs_util.SYSCS_DROP_STATISTICS('APP','','DERBY5750_I1')");
        UpdateStatisticsTest.assertStatementError("42X05", statement, "call syscs_util.SYSCS_UPDATE_STATISTICS(null,null,'DERBY5750_I1')");
        UpdateStatisticsTest.assertStatementError("42X05", statement, "call syscs_util.SYSCS_DROP_STATISTICS(null,null,'DERBY5750_I1')");
        UpdateStatisticsTest.assertStatementError("42X05", statement, "call syscs_util.SYSCS_UPDATE_STATISTICS('APP',null,'DERBY5750_I1')");
        UpdateStatisticsTest.assertStatementError("42X05", statement, "call syscs_util.SYSCS_DROP_STATISTICS('APP',null,'DERBY5750_I1')");
        statement.execute("call syscs_util.SYSCS_UPDATE_STATISTICS('APP','DERBY5750_T1','DERBY5750_I1')");
        statement.execute("call syscs_util.SYSCS_DROP_STATISTICS('APP','DERBY5750_T1','DERBY5750_I1')");
        UpdateStatisticsTest.assertStatementError("42X65", statement, "call syscs_util.SYSCS_UPDATE_STATISTICS('APP','DERBY5750_T1','')");
        UpdateStatisticsTest.assertStatementError("42X65", statement, "call syscs_util.SYSCS_DROP_STATISTICS('APP','DERBY5750_T1','')");
        statement.execute("drop table DERBY5750_t1");
    }

    public void testUpdateAndDropStatistics() throws SQLException {
        String string = "T1";
        IndexStatsUtil indexStatsUtil = new IndexStatsUtil(this.openDefaultConnection());
        Statement statement = this.createStatement();
        this.dropTable("T1");
        UpdateStatisticsTest.assertStatementError("42Y55", statement, "CALL SYSCS_UTIL.SYSCS_DROP_STATISTICS('APP','T1',null)");
        UpdateStatisticsTest.assertStatementError("42Y55", statement, "CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1',null)");
        statement.executeUpdate("CREATE TABLE t1 (c11 int, c12 varchar(128))");
        statement.execute("CALL SYSCS_UTIL.SYSCS_DROP_STATISTICS('APP','T1',null)");
        statement.execute("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1',null)");
        UpdateStatisticsTest.assertStatementError("42X65", statement, "CALL SYSCS_UTIL.SYSCS_DROP_STATISTICS('APP','T1','I1')");
        UpdateStatisticsTest.assertStatementError("42X65", statement, "CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1','I1')");
        statement.executeUpdate("CREATE INDEX i1 on t1(c12)");
        statement.execute("CALL SYSCS_UTIL.SYSCS_DROP_STATISTICS('APP','T1','I1')");
        statement.execute("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1','I1')");
        indexStatsUtil.assertNoStatsTable(string);
        statement.executeUpdate("INSERT INTO T1 VALUES(1,'a'),(2,'b'),(3,'c'),(4,'d')");
        statement.executeUpdate("CREATE INDEX i2 ON t1(c11)");
        indexStatsUtil.assertTableStats(string, 1);
        statement.execute("CALL SYSCS_UTIL.SYSCS_DROP_STATISTICS('APP','T1','I2')");
        indexStatsUtil.assertNoStatsTable(string);
        statement.execute("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1','I2')");
        indexStatsUtil.assertTableStats(string, 1);
        statement.execute("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1','I1')");
        indexStatsUtil.assertTableStats(string, 2);
        statement.execute("CALL SYSCS_UTIL.SYSCS_DROP_STATISTICS('APP','T1','I1')");
        indexStatsUtil.assertTableStats(string, 1);
        statement.execute("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1','I1')");
        indexStatsUtil.assertTableStats(string, 2);
        statement.execute("CALL SYSCS_UTIL.SYSCS_DROP_STATISTICS('APP','T1',null)");
        indexStatsUtil.assertNoStatsTable(string);
        statement.execute("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T1',null)");
        indexStatsUtil.assertTableStats(string, 2);
        statement.executeUpdate("DROP INDEX I1");
        indexStatsUtil.assertTableStats(string, 1);
        UpdateStatisticsTest.assertStatementError("42X01", statement, "ALTER TABLE APP.T1 ALL UPDATE STATISTICS");
        UpdateStatisticsTest.assertStatementError("42X01", statement, "ALTER TABLE APP.T1 UPDATE STATISTICS I1");
        UpdateStatisticsTest.assertStatementError("42X01", statement, "ALTER TABLE APP.T1 ALL DROP STATISTICS");
        UpdateStatisticsTest.assertStatementError("42X01", statement, "ALTER TABLE APP.T1 STATISTICS DROP I1");
        statement.executeUpdate("DROP TABLE t1");
        statement.executeUpdate("declare global temporary table SESSION.t1(c11 int, c12 int) on commit delete rows not logged");
        statement.executeUpdate("insert into session.t1 values(11, 1)");
        UpdateStatisticsTest.assertStatementError("42995", statement, "CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('SESSION','T1',null)");
        UpdateStatisticsTest.assertStatementError("42995", statement, "CALL SYSCS_UTIL.SYSCS_DROP_STATISTICS('SESSION','T1',null)");
        statement.executeUpdate("CREATE TABLE t2(c21 int, c22 char(14), c23 char(200))");
        statement.executeUpdate("CREATE INDEX t2i1 ON t2(c21)");
        statement.executeUpdate("CREATE INDEX t2i2 ON t2(c22)");
        indexStatsUtil.assertNoStatsTable("T2");
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO T2 VALUES(?,?,?)");
        for (int i = 0; i < 1000; ++i) {
            preparedStatement.setInt(1, i % 2);
            preparedStatement.setString(2, "Tuple " + i);
            preparedStatement.setString(3, "any value");
            preparedStatement.addBatch();
        }
        preparedStatement.executeBatch();
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        preparedStatement = this.prepareStatement("SELECT * FROM t2 WHERE c21=? AND c22=?");
        preparedStatement.setInt(1, 0);
        preparedStatement.setString(2, "Tuple 4");
        JDBC.assertDrainResults(preparedStatement.executeQuery());
        RuntimeStatisticsParser runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        UpdateStatisticsTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("T2", "T2I1"));
        statement.execute("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','T2','T2I2')");
        indexStatsUtil.assertIndexStats("T2I2", 1);
        JDBC.assertDrainResults(preparedStatement.executeQuery());
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        UpdateStatisticsTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("T2", "T2I2"));
        statement.execute("CALL SYSCS_UTIL.SYSCS_DROP_STATISTICS('APP','T2','T2I2')");
        indexStatsUtil.assertIndexStats("T2I2", 0);
        JDBC.assertDrainResults(preparedStatement.executeQuery());
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        UpdateStatisticsTest.assertTrue((boolean)runtimeStatisticsParser.usedSpecificIndexForIndexScan("T2", "T2I1"));
        statement.executeUpdate("DROP TABLE t2");
        indexStatsUtil.release();
    }

    public void testNoExclusiveLockOnTable() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table t (x char(1))");
        statement.execute("create index ti on t(x)");
        statement.execute("insert into t values 'a','b','c','d'");
        this.setAutoCommit(false);
        statement.execute("lock table t in share mode");
        Connection connection = this.openDefaultConnection();
        Statement statement2 = connection.createStatement();
        statement2.execute("call syscs_util.syscs_update_statistics('APP', 'T', null)");
        statement2.close();
        connection.close();
        statement.execute("drop table t");
        this.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParallelCompilationAndUpdate() throws Exception {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create table derby5153(a int, b int, c int, d int)");
        statement.execute("create index idx on derby5153(a,b,c,d)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into derby5153 values (1,2,3,4)");
        for (int i = 0; i < 100; ++i) {
            preparedStatement.execute();
        }
        this.commit();
        Connection connection = this.openDefaultConnection();
        IndexUpdateThread indexUpdateThread = new IndexUpdateThread(connection, "APP", "DERBY5153", "IDX");
        indexUpdateThread.start();
        try {
            for (int i = 0; i < 100; ++i) {
                ResultSet resultSet = statement.executeQuery("select * from derby5153 t1, derby5153 t2 where t1.a = t2.a");
                resultSet.close();
            }
        }
        finally {
            indexUpdateThread.done = true;
        }
        indexUpdateThread.join();
        if (indexUpdateThread.exception != null) {
            throw indexUpdateThread.exception;
        }
        connection.close();
        this.dropTable("derby5153");
        this.commit();
    }

    public void testDERBY5681() throws Exception {
        IndexStatsUtil indexStatsUtil = new IndexStatsUtil(this.openDefaultConnection());
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE TABLE TEST_TAB_1 (c11 int not null,c12 int not null, c13 int)");
        indexStatsUtil.assertNoStatsTable("TEST_TAB_1");
        statement.executeUpdate("INSERT INTO TEST_TAB_1 VALUES(1,1,1),(2,2,2)");
        statement.execute("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TEST_TAB_1', null)");
        indexStatsUtil.assertNoStatsTable("TEST_TAB_1");
        statement.executeUpdate("ALTER TABLE TEST_TAB_1 ADD CONSTRAINT TEST_TAB_1_PK_1 PRIMARY KEY (c11)");
        indexStatsUtil.assertNoStatsTable("TEST_TAB_1");
        statement.executeUpdate("ALTER TABLE TEST_TAB_1 DROP CONSTRAINT TEST_TAB_1_PK_1");
        indexStatsUtil.assertNoStatsTable("TEST_TAB_1");
        statement.execute("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TEST_TAB_1', null)");
        indexStatsUtil.assertNoStatsTable("TEST_TAB_1");
        statement.executeUpdate("ALTER TABLE TEST_TAB_1 ADD CONSTRAINT TEST_TAB_1_PK_1 PRIMARY KEY (c11)");
        indexStatsUtil.assertNoStatsTable("TEST_TAB_1");
        statement.executeUpdate("ALTER TABLE TEST_TAB_1 ADD CONSTRAINT TEST_TAB_1_UNQ_1 UNIQUE (c12)");
        indexStatsUtil.assertNoStatsTable("TEST_TAB_1");
        statement.executeUpdate("ALTER TABLE TEST_TAB_1 DROP CONSTRAINT TEST_TAB_1_UNQ_1");
        indexStatsUtil.assertNoStatsTable("TEST_TAB_1");
        statement.executeUpdate("ALTER TABLE TEST_TAB_1 DROP CONSTRAINT TEST_TAB_1_PK_1");
        indexStatsUtil.assertNoStatsTable("TEST_TAB_1");
        statement.executeUpdate("ALTER TABLE TEST_TAB_1 ADD CONSTRAINT TEST_TAB_1_PK_1 PRIMARY KEY (c11)");
        indexStatsUtil.assertNoStatsTable("TEST_TAB_1");
        statement.executeUpdate("CREATE INDEX TEST_TAB_1_NUNQ_1 ON TEST_TAB_1(c12)");
        indexStatsUtil.assertTableStats("TEST_TAB_1", 1);
        statement.executeUpdate("DROP INDEX TEST_TAB_1_NUNQ_1");
        indexStatsUtil.assertNoStatsTable("TEST_TAB_1");
        statement.executeUpdate("ALTER TABLE TEST_TAB_1 DROP CONSTRAINT TEST_TAB_1_PK_1");
        indexStatsUtil.assertNoStatsTable("TEST_TAB_1");
        statement.executeUpdate("ALTER TABLE TEST_TAB_1 ADD CONSTRAINT TEST_TAB_1_PK_1 PRIMARY KEY (c11)");
        indexStatsUtil.assertNoStatsTable("TEST_TAB_1");
        statement.executeUpdate("ALTER TABLE TEST_TAB_1 ADD CONSTRAINT TEST_TAB_1_UNQ_2 UNIQUE (c12, c13)");
        indexStatsUtil.assertTableStats("TEST_TAB_1", 2);
        statement.executeUpdate("ALTER TABLE TEST_TAB_1 DROP CONSTRAINT TEST_TAB_1_UNQ_2");
        indexStatsUtil.assertNoStatsTable("TEST_TAB_1");
        statement.executeUpdate("ALTER TABLE TEST_TAB_1 DROP CONSTRAINT TEST_TAB_1_PK_1");
        indexStatsUtil.assertNoStatsTable("TEST_TAB_1");
        statement.executeUpdate("ALTER TABLE TEST_TAB_1 ADD CONSTRAINT TEST_TAB_1_PK_1 PRIMARY KEY (c11)");
        indexStatsUtil.assertNoStatsTable("TEST_TAB_1");
        statement.executeUpdate("CREATE TABLE TEST_TAB_3 (c31 int not null)");
        statement.executeUpdate("INSERT INTO TEST_TAB_3 VALUES(1),(2)");
        statement.executeUpdate("ALTER TABLE TEST_TAB_3 ADD CONSTRAINT TEST_TAB_3_FK_1 FOREIGN KEY(c31) REFERENCES TEST_TAB_1(c11)");
        indexStatsUtil.assertTableStats("TEST_TAB_3", 1);
        statement.executeUpdate("ALTER TABLE TEST_TAB_3 DROP CONSTRAINT TEST_TAB_3_FK_1");
        indexStatsUtil.assertNoStatsTable("TEST_TAB_3");
        statement.executeUpdate("CREATE TABLE TEST_TAB_2 (c21 int not null)");
        statement.executeUpdate("INSERT INTO TEST_TAB_2 VALUES(1),(2)");
        statement.executeUpdate("ALTER TABLE TEST_TAB_2 ADD CONSTRAINT TEST_TAB_2_PK_1 PRIMARY KEY (c21)");
        indexStatsUtil.assertNoStatsTable("TEST_TAB_2");
        statement.executeUpdate("ALTER TABLE TEST_TAB_2 ADD CONSTRAINT TEST_TAB_2_FK_1 FOREIGN KEY(c21) REFERENCES TEST_TAB_1(c11)");
        indexStatsUtil.assertNoStatsTable("TEST_TAB_2");
        statement.execute("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TEST_TAB_2', null)");
        indexStatsUtil.assertTableStats("TEST_TAB_2", 1);
        indexStatsUtil.assertNoStatsTable("TEST_TAB_1");
        statement.executeUpdate("ALTER TABLE TEST_TAB_2 DROP CONSTRAINT TEST_TAB_2_FK_1");
        indexStatsUtil.assertNoStatsTable("TEST_TAB_2");
        statement.execute("CALL SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP','TEST_TAB_2', null)");
        indexStatsUtil.assertNoStatsTable("TEST_TAB_2");
        statement.execute("CALL SYSCS_UTIL.SYSCS_DROP_STATISTICS('APP','TEST_TAB_2', null)");
        indexStatsUtil.assertNoStatsTable("TEST_TAB_2");
        statement.execute("drop table TEST_TAB_2");
        statement.execute("drop table TEST_TAB_1");
        indexStatsUtil.release();
    }

    public void testDisposableStatsEagerness() throws SQLException {
        int n;
        this.setAutoCommit(false);
        String string = "DISPOSABLE_STATS_EAGERNESS";
        String string2 = string + "_FK";
        String string3 = "NU_" + string;
        Statement statement = this.createStatement();
        statement.executeUpdate("create table " + string2 + "(pk1 int generated always as identity)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into " + string2 + " values (DEFAULT)");
        for (n = 1; n <= 1000; ++n) {
            preparedStatement.executeUpdate();
        }
        statement.executeUpdate("create table " + string + "(pk1 int generated always as identity,pk2 int not null,mynonunique int, fk int not null)");
        preparedStatement = this.prepareStatement("insert into " + string + " values (DEFAULT, ?, ?, ?)");
        for (n = 1; n <= 1000; ++n) {
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(2, n % 35);
            preparedStatement.setInt(3, n);
            preparedStatement.executeUpdate();
        }
        statement.executeUpdate("alter table " + string2 + " add constraint PK_" + string2 + " primary key (pk1)");
        statement.executeUpdate("alter table " + string + " add constraint PK_" + string + " primary key (pk1, pk2)");
        statement.executeUpdate("alter table " + string + " add constraint FK_" + string + " foreign key (fk) references " + string2 + "(pk1)");
        statement.executeUpdate("create index " + string3 + " on " + string + "(mynonunique)");
        this.commit();
        this.setAutoCommit(true);
        IndexStatsUtil indexStatsUtil = new IndexStatsUtil(this.getConnection());
        indexStatsUtil.assertNoStatsTable(string2);
        indexStatsUtil.assertTableStats(string, 4);
        IndexStatsUtil.IdxStats[] idxStatsArray = indexStatsUtil.getStatsTable(string);
        UpdateStatisticsTest.sleepAtLeastOneTick();
        preparedStatement = this.prepareStatement("call syscs_util.syscs_update_statistics('APP', ?, ?)");
        preparedStatement.setNull(2, 12);
        preparedStatement.setString(1, string);
        preparedStatement.execute();
        preparedStatement.setString(1, string2);
        preparedStatement.execute();
        indexStatsUtil.assertNoStatsTable(string2);
        indexStatsUtil.assertTableStats(string, 4);
        IndexStatsUtil.IdxStats[] idxStatsArray2 = indexStatsUtil.getStatsTable(string);
        UpdateStatisticsTest.assertEquals((int)idxStatsArray.length, (int)idxStatsArray2.length);
        for (int i = 0; i < idxStatsArray2.length; ++i) {
            UpdateStatisticsTest.assertTrue((boolean)idxStatsArray2[i].after(idxStatsArray[i]));
        }
        UpdateStatisticsTest.sleepAtLeastOneTick();
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string3);
        preparedStatement.execute();
        IndexStatsUtil.IdxStats idxStats = indexStatsUtil.getStatsIndex(string3)[0];
        UpdateStatisticsTest.assertTrue((boolean)idxStats.after(idxStatsArray2[0]));
        indexStatsUtil.assertNoStatsTable(string2);
        indexStatsUtil.assertTableStats(string, 4);
        this.dropTable(string);
        this.dropTable(string2);
    }

    private static class IndexUpdateThread
    extends Thread {
        private final CallableStatement updateStats;
        private volatile boolean done;
        private Exception exception;

        private IndexUpdateThread(Connection connection, String string, String string2, String string3) throws SQLException {
            this.updateStats = connection.prepareCall("call syscs_util.syscs_update_statistics(?,?,?)");
            this.updateStats.setString(1, string);
            this.updateStats.setString(2, string2);
            this.updateStats.setString(3, string3);
        }

        @Override
        public void run() {
            try {
                while (!this.done) {
                    this.updateStats.execute();
                }
                this.updateStats.close();
            }
            catch (Exception exception) {
                this.exception = exception;
            }
        }
    }
}

