/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.graph;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Subgraph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public final class EntityGraphHelper {
    private EntityGraphHelper() {
    }

    public static Object getEntityGraph(EntityManager em, Class<?> entityClass, org.apache.deltaspike.data.api.EntityGraph entityGraphAnn) {
        String graphName = entityGraphAnn.value();
        if (graphName.isEmpty()) {
            return EntityGraphHelper.buildEntityGraph(em, entityClass, entityGraphAnn.paths());
        }
        return em.getEntityGraph(graphName);
    }

    private static Object createEntityGraph(EntityManager em, Class<?> entityClass) {
        return em.createEntityGraph(entityClass);
    }

    private static Object addSubgraph(Object graph, String attributeName) {
        if (graph instanceof EntityGraph) {
            return ((EntityGraph)graph).addSubgraph(attributeName);
        }
        if (graph instanceof Subgraph) {
            return ((Subgraph)graph).addSubgraph(attributeName);
        }
        return null;
    }

    private static void addAttributeNodes(Object graph, String attributeName) {
        if (graph instanceof EntityGraph) {
            ((EntityGraph)graph).addAttributeNodes(new String[]{attributeName});
        } else if (graph instanceof Subgraph) {
            ((Subgraph)graph).addAttributeNodes(new String[]{attributeName});
        }
    }

    private static Object buildEntityGraph(EntityManager em, Class<?> entityClass, String[] attributePaths) {
        Object graph = EntityGraphHelper.createEntityGraph(em, entityClass);
        ArrayList<String> paths = new ArrayList<String>(Arrays.asList(attributePaths));
        Collections.sort(paths);
        Collections.reverse(paths);
        for (String path : attributePaths) {
            if (path.contains(".")) {
                String[] segments = path.split("\\.");
                Object parent = EntityGraphHelper.addSubgraph(graph, segments[0]);
                for (int i = 1; i < segments.length - 1; ++i) {
                    EntityGraphHelper.addSubgraph(parent, segments[i]);
                }
                EntityGraphHelper.addAttributeNodes(parent, segments[segments.length - 1]);
                continue;
            }
            EntityGraphHelper.addAttributeNodes(graph, path);
        }
        return graph;
    }
}

