/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.api.config.view;

import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.Set;
import org.apache.deltaspike.core.api.config.view.metadata.SkipMetaDataMerge;
import org.apache.deltaspike.core.api.config.view.metadata.ViewMetaData;
import org.apache.deltaspike.core.spi.config.view.ConfigPreProcessor;
import org.apache.deltaspike.core.spi.config.view.ViewConfigNode;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.jsf.api.config.base.JsfBaseConfig;
import org.apache.deltaspike.jsf.api.config.view.Folder;
import org.apache.deltaspike.jsf.api.literal.ViewLiteral;
import org.apache.deltaspike.jsf.util.NamingConventionUtils;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@ViewMetaData(preProcessor=ViewConfigPreProcessor.class)
public @interface View {
    @SkipMetaDataMerge
    public String basePath() default "";

    @SkipMetaDataMerge
    public String name() default "";

    public String extension() default "";

    public NavigationMode navigation() default NavigationMode.DEFAULT;

    public ViewParameterMode viewParams() default ViewParameterMode.DEFAULT;

    public Class<? extends NameBuilder> basePathBuilder() default DefaultBasePathBuilder.class;

    public Class<? extends NameBuilder> fileNameBuilder() default DefaultFileNameBuilder.class;

    public Class<? extends NameBuilder> extensionBuilder() default DefaultExtensionBuilder.class;

    public static class DefaultExtensionBuilder
    extends AbstractNameBuilder {
        @Override
        public String build(View view, ViewConfigNode viewConfigNode) {
            String extension = view.extension();
            if ("".equals(extension) || extension == null) {
                this.defaultValueReplaced = true;
                extension = "xhtml";
            }
            return extension;
        }
    }

    public static class DefaultFileNameBuilder
    extends AbstractNameBuilder {
        @Override
        public String build(View view, ViewConfigNode viewConfigNode) {
            Object name = view.name();
            Class source = viewConfigNode.getSource();
            if (("".equals(name) || name == null) && ViewConfigPreProcessor.isView(source)) {
                this.defaultValueReplaced = true;
                String className = viewConfigNode.getSource().getSimpleName();
                name = className.substring(0, 1).toLowerCase() + className.substring(1);
            }
            return name;
        }
    }

    public static class DefaultBasePathBuilder
    extends AbstractNameBuilder {
        @Override
        public String build(View view, ViewConfigNode viewConfigNode) {
            Object basePath = view.basePath();
            Class source = viewConfigNode.getSource();
            if (("".equals(basePath) || basePath == null) && ViewConfigPreProcessor.isView(source)) {
                this.defaultValueReplaced = true;
                basePath = NamingConventionUtils.toPath(viewConfigNode.getParent());
            }
            if (basePath != null && ((String)basePath).startsWith(".")) {
                basePath = NamingConventionUtils.toPath(viewConfigNode.getParent()) + ((String)basePath).substring(1);
                this.defaultValueReplaced = true;
            }
            if (basePath != null && !((String)basePath).startsWith(".") && !((String)basePath).startsWith("/")) {
                basePath = NamingConventionUtils.toPath(viewConfigNode.getParent()) + (String)basePath;
                this.defaultValueReplaced = true;
            }
            if (basePath != null && !((String)basePath).endsWith("/")) {
                basePath = (String)basePath + "/";
                this.defaultValueReplaced = true;
            }
            if (basePath != null && ((String)basePath).contains("//")) {
                basePath = ((String)basePath).replace("//", "/");
                this.defaultValueReplaced = true;
            }
            return basePath;
        }
    }

    public static abstract class AbstractNameBuilder
    implements NameBuilder {
        protected boolean defaultValueReplaced = false;

        @Override
        public boolean isDefaultValueReplaced() {
            return this.defaultValueReplaced;
        }
    }

    public static interface NameBuilder {
        public String build(View var1, ViewConfigNode var2);

        public boolean isDefaultValueReplaced();
    }

    public static class ViewConfigPreProcessor
    implements ConfigPreProcessor<View> {
        public View beforeAddToConfig(View view, ViewConfigNode viewConfigNode) {
            this.validateViewMetaData(view, viewConfigNode);
            boolean defaultValueReplaced = false;
            NavigationMode navigation = view.navigation();
            ViewParameterMode viewParams = view.viewParams();
            NameBuilder basePathBuilder = this.getBasePathBuilder(view);
            String basePath = basePathBuilder.build(view, viewConfigNode);
            if (basePathBuilder.isDefaultValueReplaced()) {
                defaultValueReplaced = true;
            }
            NameBuilder fileNameBuilder = this.getFileNameBuilder(view);
            String name = fileNameBuilder.build(view, viewConfigNode);
            if (fileNameBuilder.isDefaultValueReplaced()) {
                defaultValueReplaced = true;
            }
            NameBuilder extensionBuilder = this.getExtensionBuilder(view);
            String extension = extensionBuilder.build(view, viewConfigNode);
            if (extensionBuilder.isDefaultValueReplaced()) {
                defaultValueReplaced = true;
            }
            if (NavigationMode.DEFAULT.equals((Object)navigation) || navigation == null) {
                defaultValueReplaced = true;
                navigation = NavigationMode.FORWARD;
            }
            if (ViewParameterMode.DEFAULT.equals((Object)viewParams) || viewParams == null) {
                defaultValueReplaced = true;
                viewParams = ViewParameterMode.EXCLUDE;
            }
            if (defaultValueReplaced) {
                ViewLiteral result = new ViewLiteral(basePath, name, extension, navigation, viewParams, view.basePathBuilder(), view.fileNameBuilder(), view.extensionBuilder());
                this.updateNodeMetaData(viewConfigNode, result);
                return result;
            }
            return view;
        }

        protected void validateViewMetaData(View view, ViewConfigNode viewConfigNode) {
            String basePath = view.basePath();
            if (viewConfigNode.getSource().isInterface() && !"".equals(basePath) && basePath != null) {
                throw new IllegalStateException("Using @" + View.class.getName() + "#basePath isn't allowed on folder-nodes (= interfaces). Use @" + Folder.class.getName() + " for intended folder-nodes or a class instead of the interface for page-nodes.");
            }
        }

        private void updateNodeMetaData(ViewConfigNode viewConfigNode, View view) {
            Set metaData = viewConfigNode.getMetaData();
            Iterator metaDataIterator = metaData.iterator();
            while (metaDataIterator.hasNext()) {
                if (!View.class.equals(((Annotation)metaDataIterator.next()).annotationType())) continue;
                metaDataIterator.remove();
                break;
            }
            metaData.add(view);
        }

        private NameBuilder getBasePathBuilder(View view) {
            String customDefaultBasePathBuilderClassName;
            NameBuilder basePathBuilder = DefaultBasePathBuilder.class.equals(view.basePathBuilder()) ? ((customDefaultBasePathBuilderClassName = JsfBaseConfig.ViewConfigCustomization.CUSTOM_DEFAULT_BASE_PATH_BUILDER) != null ? (NameBuilder)ClassUtils.tryToInstantiateClassForName((String)customDefaultBasePathBuilderClassName) : new DefaultBasePathBuilder()) : (NameBuilder)ClassUtils.tryToInstantiateClass(view.basePathBuilder());
            return basePathBuilder;
        }

        private NameBuilder getFileNameBuilder(View view) {
            String customDefaultFileNameBuilderClassName;
            NameBuilder fileNameBuilder = DefaultFileNameBuilder.class.equals(view.fileNameBuilder()) ? ((customDefaultFileNameBuilderClassName = JsfBaseConfig.ViewConfigCustomization.CUSTOM_DEFAULT_FILE_NAME_BUILDER) != null ? (NameBuilder)ClassUtils.tryToInstantiateClassForName((String)customDefaultFileNameBuilderClassName) : new DefaultFileNameBuilder()) : (NameBuilder)ClassUtils.tryToInstantiateClass(view.fileNameBuilder());
            return fileNameBuilder;
        }

        private NameBuilder getExtensionBuilder(View view) {
            String customDefaultExtensionBuilderClassName;
            NameBuilder extensionBuilder = DefaultExtensionBuilder.class.equals(view.extensionBuilder()) ? ((customDefaultExtensionBuilderClassName = JsfBaseConfig.ViewConfigCustomization.CUSTOM_DEFAULT_EXTENSION_BUILDER) != null ? (NameBuilder)ClassUtils.tryToInstantiateClassForName((String)customDefaultExtensionBuilderClassName) : new DefaultExtensionBuilder()) : (NameBuilder)ClassUtils.tryToInstantiateClass(view.extensionBuilder());
            return extensionBuilder;
        }

        private static boolean isView(Class source) {
            return !Modifier.isAbstract(source.getModifiers()) && !Modifier.isInterface(source.getModifiers());
        }
    }

    public static enum ViewParameterMode {
        DEFAULT,
        INCLUDE,
        EXCLUDE;

    }

    public static enum NavigationMode {
        DEFAULT,
        FORWARD,
        REDIRECT;

    }

    public static interface Extension {
        public static final String DEFAULT = "";
        public static final String XHTML = "xhtml";
        public static final String JSF = "jsf";
        public static final String FACES = "faces";
        public static final String JSP = "jsp";
    }
}

