/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.blueprint.compendium.cm;

import java.io.IOException;
import java.util.Dictionary;
import org.apache.aries.blueprint.compendium.cm.CmUtils;
import org.apache.aries.blueprint.ext.PropertyPlaceholder;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmPropertyPlaceholder
extends PropertyPlaceholder {
    private static final Logger LOGGER = LoggerFactory.getLogger(CmPropertyPlaceholder.class);
    private BlueprintContainer blueprintContainer;
    private ConfigurationAdmin configAdmin;
    private String persistentId;
    private transient Configuration config;

    public BlueprintContainer getBlueprintContainer() {
        return this.blueprintContainer;
    }

    public void setBlueprintContainer(BlueprintContainer blueprintContainer) {
        this.blueprintContainer = blueprintContainer;
    }

    public ConfigurationAdmin getConfigAdmin() {
        return this.configAdmin;
    }

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    public String getPersistentId() {
        return this.persistentId;
    }

    public void setPersistentId(String persistentId) {
        this.persistentId = persistentId;
    }

    protected String getProperty(String val) {
        LOGGER.debug("Retrieving property value {} from configuration with pid {}", (Object)val, (Object)this.persistentId);
        Configuration config = this.getConfig();
        String v = null;
        if (config != null) {
            Dictionary props = config.getProperties();
            if (props != null) {
                v = props.get(val);
                if (v != null) {
                    LOGGER.debug("Found property value {}", (Object)v);
                } else {
                    LOGGER.debug("Property not found in configuration");
                }
            } else {
                LOGGER.debug("No dictionary available from configuration");
            }
        }
        if (v == null) {
            v = super.getProperty(val);
        }
        return v != null ? v.toString() : null;
    }

    protected synchronized Configuration getConfig() {
        if (this.config == null) {
            try {
                this.config = CmUtils.getConfiguration(this.configAdmin, this.persistentId);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.config;
    }
}

