/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.keyselector;

import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.runtime.generated.GeneratedProjection;
import org.apache.flink.table.runtime.generated.Projection;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;

public class BinaryRowDataKeySelector
implements RowDataKeySelector {
    private static final long serialVersionUID = 5375355285015381919L;
    private final InternalTypeInfo<RowData> keyRowType;
    private final GeneratedProjection generatedProjection;
    private transient Projection<RowData, BinaryRowData> projection;

    public BinaryRowDataKeySelector(InternalTypeInfo<RowData> keyRowType, GeneratedProjection generatedProjection) {
        this.keyRowType = keyRowType;
        this.generatedProjection = generatedProjection;
    }

    @Override
    public RowData getKey(RowData value) throws Exception {
        if (this.projection == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            this.projection = (Projection)this.generatedProjection.newInstance(cl);
        }
        return this.projection.apply(value).copy();
    }

    @Override
    public InternalTypeInfo<RowData> getProducedType() {
        return this.keyRowType;
    }
}

