/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.runtime.checkpoint.Checkpoint;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.util.AutoCloseableAsync;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.RunnableWithException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CheckpointsCleaner
implements Serializable,
AutoCloseableAsync {
    private static final Logger LOG = LoggerFactory.getLogger(CheckpointsCleaner.class);
    private static final long serialVersionUID = 2545865801947537790L;
    @GuardedBy(value="this")
    private int numberOfCheckpointsToClean;
    @Nullable
    @GuardedBy(value="this")
    private CompletableFuture<Void> cleanUpFuture;

    synchronized int getNumberOfCheckpointsToClean() {
        return this.numberOfCheckpointsToClean;
    }

    public void cleanCheckpoint(Checkpoint checkpoint, boolean shouldDiscard, Runnable postCleanAction, Executor executor) {
        Checkpoint.DiscardObject discardObject = shouldDiscard ? checkpoint.markAsDiscarded() : Checkpoint.NOOP_DISCARD_OBJECT;
        this.cleanup(checkpoint, discardObject::discard, postCleanAction, executor);
    }

    public void cleanCheckpointOnFailedStoring(CompletedCheckpoint completedCheckpoint, Executor executor) {
        Checkpoint.DiscardObject discardObject = completedCheckpoint.markAsDiscarded();
        this.cleanup(completedCheckpoint, discardObject::discard, () -> {}, executor);
    }

    private void cleanup(Checkpoint checkpoint, RunnableWithException cleanupAction, Runnable postCleanupAction, Executor executor) {
        this.incrementNumberOfCheckpointsToClean();
        executor.execute(() -> {
            try {
                cleanupAction.run();
            }
            catch (Exception e) {
                LOG.warn("Could not properly discard completed checkpoint {}.", (Object)checkpoint.getCheckpointID(), (Object)e);
            }
            finally {
                this.decrementNumberOfCheckpointsToClean();
                postCleanupAction.run();
            }
        });
    }

    private synchronized void incrementNumberOfCheckpointsToClean() {
        Preconditions.checkState(this.cleanUpFuture == null, "CheckpointsCleaner has already been closed");
        ++this.numberOfCheckpointsToClean;
    }

    private synchronized void decrementNumberOfCheckpointsToClean() {
        --this.numberOfCheckpointsToClean;
        this.maybeCompleteCloseUnsafe();
    }

    private void maybeCompleteCloseUnsafe() {
        if (this.numberOfCheckpointsToClean == 0 && this.cleanUpFuture != null) {
            this.cleanUpFuture.complete(null);
        }
    }

    @Override
    public synchronized CompletableFuture<Void> closeAsync() {
        if (this.cleanUpFuture == null) {
            this.cleanUpFuture = new CompletableFuture();
        }
        this.maybeCompleteCloseUnsafe();
        return this.cleanUpFuture;
    }
}

