/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.log;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public enum LogLevel {
    ERROR("error"),
    WARNING("warning"),
    INFO("info"),
    DEBUG("debug"),
    TRACE("trace");

    private static final String LOGBACK_XML_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<configuration>\n\n    <!-- Default appender -->\n    <appender name=\"GUAC-DEFAULT\" class=\"ch.qos.logback.core.ConsoleAppender\">\n        <encoder>\n            <pattern>%%d{HH:mm:ss.SSS} [%%thread] %%-5level %%logger{36} - %%msg%%n</pattern>\n        </encoder>\n    </appender>\n\n    <!-- Log at level defined with \"log-level\" property -->\n    <root level=\"%s\">\n        <appender-ref ref=\"GUAC-DEFAULT\" />\n    </root>\n\n</configuration>\n";
    private final String canonicalName;
    private final byte[] logbackConfig;

    private LogLevel(String canonicalName, String logbackLogLevel) {
        this.canonicalName = canonicalName;
        this.logbackConfig = String.format(LOGBACK_XML_TEMPLATE, logbackLogLevel).getBytes(StandardCharsets.UTF_8);
    }

    private LogLevel(String logLevel) {
        this(string, n, logLevel, logLevel);
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public InputStream getLogbackConfiguration() {
        return new ByteArrayInputStream(this.logbackConfig);
    }
}

