/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.management.cache.CacheContentionCommandArg;
import org.apache.ignite.internal.management.cache.ContentionClosure;
import org.apache.ignite.internal.management.cache.ContentionInfo;
import org.apache.ignite.internal.management.cache.ContentionJobResult;
import org.apache.ignite.internal.management.cache.ContentionTaskResult;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class ContentionTask
extends VisorMultiNodeTask<CacheContentionCommandArg, ContentionTaskResult, ContentionJobResult> {
    private static final long serialVersionUID = 0L;

    @Override
    @Nullable
    protected ContentionTaskResult reduce0(List<ComputeJobResult> list) throws IgniteException {
        HashMap<UUID, Exception> exceptions = new HashMap<UUID, Exception>();
        ArrayList<ContentionJobResult> infos = new ArrayList<ContentionJobResult>();
        for (ComputeJobResult res : list) {
            if (res.getException() != null) {
                exceptions.put(res.getNode().id(), res.getException());
                continue;
            }
            infos.add((ContentionJobResult)res.getData());
        }
        return new ContentionTaskResult(infos, exceptions);
    }

    @Override
    protected VisorJob<CacheContentionCommandArg, ContentionJobResult> job(CacheContentionCommandArg arg) {
        return new CacheContentionJob(arg, this.debug);
    }

    private static class CacheContentionJob
    extends VisorJob<CacheContentionCommandArg, ContentionJobResult> {
        private static final long serialVersionUID = 0L;

        protected CacheContentionJob(@Nullable CacheContentionCommandArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected ContentionJobResult run(@Nullable CacheContentionCommandArg arg) throws IgniteException {
            try {
                ContentionClosure clo = new ContentionClosure(arg.minQueueSize(), arg.maxPrint());
                this.ignite.context().resource().injectGeneric(clo);
                ContentionInfo info = clo.call();
                return new ContentionJobResult(info);
            }
            catch (Exception e) {
                throw new IgniteException(e);
            }
        }

        public String toString() {
            return S.toString(CacheContentionJob.class, this);
        }
    }
}

