/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.transactions;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.util.GridSerializableIterator;
import org.apache.ignite.internal.util.GridSerializableSet;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgnitePredicate;
import org.jetbrains.annotations.Nullable;

public class IgniteTxMap
extends AbstractMap<IgniteTxKey, IgniteTxEntry>
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private Map<IgniteTxKey, IgniteTxEntry> txMap;
    private Set<Map.Entry<IgniteTxKey, IgniteTxEntry>> entrySet;
    private int size = -1;
    private Boolean empty;
    private boolean sealed;
    private IgnitePredicate<IgniteTxEntry> filter;

    public IgniteTxMap() {
    }

    public IgniteTxMap(Map<IgniteTxKey, IgniteTxEntry> txMap, IgnitePredicate<IgniteTxEntry> filter) {
        this.txMap = txMap;
        this.filter = filter;
    }

    IgniteTxMap seal() {
        this.sealed = true;
        return this;
    }

    boolean sealed() {
        return this.sealed;
    }

    @Override
    public Set<Map.Entry<IgniteTxKey, IgniteTxEntry>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new GridSerializableSet<Map.Entry<IgniteTxKey, IgniteTxEntry>>(){
                private Set<Map.Entry<IgniteTxKey, IgniteTxEntry>> set;
                {
                    this.set = IgniteTxMap.this.txMap.entrySet();
                }

                @Override
                public Iterator<Map.Entry<IgniteTxKey, IgniteTxEntry>> iterator() {
                    return new GridSerializableIterator<Map.Entry<IgniteTxKey, IgniteTxEntry>>(){
                        private Iterator<Map.Entry<IgniteTxKey, IgniteTxEntry>> it;
                        private Map.Entry<IgniteTxKey, IgniteTxEntry> cur;
                        {
                            this.it = set.iterator();
                            this.advance();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.cur != null;
                        }

                        @Override
                        public Map.Entry<IgniteTxKey, IgniteTxEntry> next() {
                            if (this.cur == null) {
                                throw new NoSuchElementException();
                            }
                            Map.Entry<IgniteTxKey, IgniteTxEntry> e = this.cur;
                            this.advance();
                            return e;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }

                        private void advance() {
                            this.cur = null;
                            while (this.cur == null && this.it.hasNext()) {
                                Map.Entry<IgniteTxKey, IgniteTxEntry> e = this.it.next();
                                if (!IgniteTxMap.this.filter.apply(e.getValue())) continue;
                                this.cur = e;
                            }
                        }
                    };
                }

                @Override
                public int size() {
                    return !IgniteTxMap.this.sealed ? F.size(this.iterator(), new IgnitePredicate[0]) : (IgniteTxMap.this.size == -1 ? (IgniteTxMap.this.size = F.size(this.iterator(), new IgnitePredicate[0])) : IgniteTxMap.this.size);
                }

                @Override
                public boolean isEmpty() {
                    boolean bl = !IgniteTxMap.this.sealed ? !this.iterator().hasNext() : (IgniteTxMap.this.empty == null ? (IgniteTxMap.this.empty = Boolean.valueOf(!this.iterator().hasNext())) : IgniteTxMap.this.empty);
                    return bl;
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    @Nullable
    public IgniteTxEntry get(Object key) {
        IgniteTxEntry e = this.txMap.get(key);
        return e == null ? null : (this.filter.apply(e) ? e : null);
    }

    @Override
    public IgniteTxEntry remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        throw new IllegalStateException("Transaction view map should never be serialized: " + this);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new IllegalStateException("Transaction view map should never be serialized: " + this);
    }
}

