/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.rel.agg;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteAggregate;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteConvention;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistributions;
import org.apache.ignite.internal.processors.query.calcite.trait.TraitUtils;
import org.apache.ignite.internal.processors.query.calcite.trait.TraitsAwareIgniteRel;

public abstract class IgniteMapAggregateBase
extends IgniteAggregate
implements TraitsAwareIgniteRel {
    protected IgniteMapAggregateBase(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        super(cluster, traitSet, input, groupSet, groupSets, aggCalls);
    }

    protected IgniteMapAggregateBase(RelInput input) {
        super(TraitUtils.changeTraits(input, new RelTrait[]{IgniteConvention.INSTANCE}));
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughDistribution(RelTraitSet nodeTraits, List<RelTraitSet> inTraits) {
        if (TraitUtils.distribution(nodeTraits).satisfies((RelTrait)IgniteDistributions.single())) {
            return null;
        }
        return TraitsAwareIgniteRel.super.passThroughDistribution(nodeTraits, inTraits);
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveRewindability(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        return ImmutableList.of((Object)Pair.of((Object)nodeTraits, (Object)ImmutableList.of((Object)inputTraits.get(0))));
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveDistribution(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelTraitSet in = inputTraits.get(0);
        if (TraitUtils.distribution(in).satisfies((RelTrait)IgniteDistributions.single())) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)Pair.of((Object)nodeTraits.replace((RelTrait)TraitUtils.distribution(in)), (Object)ImmutableList.of((Object)in)));
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveCorrelation(RelTraitSet nodeTraits, List<RelTraitSet> inTraits) {
        return ImmutableList.of((Object)Pair.of((Object)nodeTraits.replace((RelTrait)TraitUtils.correlation(inTraits.get(0))), inTraits));
    }
}

