/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rel;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.Pair;
import org.apache.ignite.internal.sql.engine.metadata.cost.IgniteCostFactory;
import org.apache.ignite.internal.sql.engine.rel.AbstractIgniteJoin;
import org.apache.ignite.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite.internal.sql.engine.rel.IgniteRelVisitor;
import org.apache.ignite.internal.sql.engine.trait.CorrelationTrait;
import org.apache.ignite.internal.sql.engine.trait.RewindabilityTrait;
import org.apache.ignite.internal.sql.engine.trait.TraitUtils;
import org.apache.ignite.internal.sql.engine.util.Commons;

public class IgniteCorrelatedNestedLoopJoin
extends AbstractIgniteJoin {
    public IgniteCorrelatedNestedLoopJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType) {
        super(cluster, traitSet, left, right, condition, variablesSet, joinType);
    }

    public IgniteCorrelatedNestedLoopJoin(RelInput input) {
        this(input.getCluster(), input.getTraitSet().replace((RelTrait)IgniteConvention.INSTANCE), (RelNode)input.getInputs().get(0), (RelNode)input.getInputs().get(1), input.getExpression("condition"), Set.copyOf(Commons.transform(input.getIntegerList("variablesSet"), CorrelationId::new)), (JoinRelType)input.getEnum("joinType", JoinRelType.class));
    }

    public Join copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        return new IgniteCorrelatedNestedLoopJoin(this.getCluster(), traitSet, left, right, condition, (Set<CorrelationId>)this.variablesSet, joinType);
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveCollation(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelTraitSet left = inputTraits.get(0);
        RelTraitSet right = inputTraits.get(1);
        RelCollation leftCollation = TraitUtils.collation(left);
        RelCollation rightCollation = TraitUtils.collation(right);
        IntList newRightCollationFields = Commons.maxPrefix(rightCollation.getKeys(), (Collection<Integer>)this.joinInfo.leftKeys);
        if (newRightCollationFields.isEmpty()) {
            return List.of(Pair.of((Object)nodeTraits.replace((RelTrait)RelCollations.EMPTY), inputTraits));
        }
        nodeTraits = this.variablesSet.size() == 1 ? nodeTraits.replace((RelTrait)leftCollation) : nodeTraits.replace((RelTrait)RelCollations.EMPTY);
        return List.of(Pair.of((Object)nodeTraits, inputTraits));
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveRewindability(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelTraitSet left = inputTraits.get(0);
        RelTraitSet right = inputTraits.get(1);
        RewindabilityTrait rewindability = TraitUtils.rewindability(left);
        return List.of(Pair.of((Object)nodeTraits.replace((RelTrait)rewindability), List.of(left, right.replace((RelTrait)RewindabilityTrait.REWINDABLE))));
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughCollation(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelTraitSet left = inputTraits.get(0);
        RelTraitSet right = inputTraits.get(1);
        if (this.variablesSet.size() == 1) {
            Pair<RelTraitSet, List<RelTraitSet>> baseTraits = super.passThroughCollation(nodeTraits, inputTraits);
            return Pair.of((Object)((RelTraitSet)baseTraits.getKey()), List.of((RelTraitSet)((List)baseTraits.getValue()).get(0), (RelTraitSet)((List)baseTraits.getValue()).get(1)));
        }
        return Pair.of((Object)nodeTraits.replace((RelTrait)RelCollations.EMPTY), List.of(left.replace((RelTrait)RelCollations.EMPTY), right));
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughRewindability(RelTraitSet nodeTraits, List<RelTraitSet> inputTraits) {
        RelTraitSet left = inputTraits.get(0);
        RelTraitSet right = inputTraits.get(1);
        RewindabilityTrait rewindability = TraitUtils.rewindability(nodeTraits);
        return Pair.of((Object)nodeTraits.replace((RelTrait)rewindability), List.of(left.replace((RelTrait)rewindability), right.replace((RelTrait)RewindabilityTrait.REWINDABLE)));
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        IgniteCostFactory costFactory = (IgniteCostFactory)planner.getCostFactory();
        double leftCount = mq.getRowCount(this.getLeft());
        if (Double.isInfinite(leftCount)) {
            return costFactory.makeInfiniteCost();
        }
        double rightCount = mq.getRowCount(this.getRight());
        if (Double.isInfinite(rightCount)) {
            return costFactory.makeInfiniteCost();
        }
        double rows = leftCount * rightCount;
        return costFactory.makeCost(rows, rows * 4.0, 0.0);
    }

    @Override
    public Pair<RelTraitSet, List<RelTraitSet>> passThroughCorrelation(RelTraitSet nodeTraits, List<RelTraitSet> inTraits) {
        CorrelationTrait nodeCorr = TraitUtils.correlation(nodeTraits);
        HashSet<CorrelationId> selfCorrIds = new HashSet<CorrelationId>(CorrelationTrait.correlations((Collection<CorrelationId>)this.variablesSet).correlationIds());
        selfCorrIds.addAll(nodeCorr.correlationIds());
        return Pair.of((Object)nodeTraits, List.of(inTraits.get(0).replace((RelTrait)nodeCorr), inTraits.get(1).replace((RelTrait)CorrelationTrait.correlations(selfCorrIds))));
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveCorrelation(RelTraitSet nodeTraits, List<RelTraitSet> inTraits) {
        Set<CorrelationId> rightCorrIds = TraitUtils.correlation(inTraits.get(1)).correlationIds();
        if (!rightCorrIds.containsAll((Collection<?>)this.variablesSet)) {
            return List.of();
        }
        HashSet<CorrelationId> corrIds = new HashSet<CorrelationId>(rightCorrIds);
        corrIds.addAll(TraitUtils.correlation(inTraits.get(0)).correlationIds());
        corrIds.removeAll((Collection<?>)this.variablesSet);
        return List.of(Pair.of((Object)nodeTraits.replace((RelTrait)CorrelationTrait.correlations(corrIds)), inTraits));
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteCorrelatedNestedLoopJoin(cluster, this.getTraitSet(), (RelNode)inputs.get(0), (RelNode)inputs.get(1), this.getCondition(), this.getVariablesSet(), this.getJoinType());
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("correlationVariables", (Object)this.getVariablesSet());
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        return super.estimateRowCount(mq) / mq.getSelectivity((RelNode)this, this.getCondition());
    }
}

