/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.schema;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.ColumnStrategy;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql2rel.InitializerContext;
import org.apache.calcite.sql2rel.NullInitializerExpressionFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.sql.engine.schema.ColumnDescriptor;
import org.apache.ignite.internal.sql.engine.schema.ColumnDescriptorImpl;
import org.apache.ignite.internal.sql.engine.schema.DefaultValueStrategy;
import org.apache.ignite.internal.sql.engine.schema.TableDescriptor;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistribution;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistributions;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;

public class TableDescriptorImpl
extends NullInitializerExpressionFactory
implements TableDescriptor {
    private static final ColumnDescriptor[] DUMMY = new ColumnDescriptor[0];
    private final ColumnDescriptor[] descriptors;
    private final Map<String, ColumnDescriptor> descriptorsMap;
    private final ImmutableBitSet insertFields;
    private final ImmutableBitSet keyFields;

    public TableDescriptorImpl(List<ColumnDescriptor> columnDescriptors) {
        ImmutableBitSet.Builder keyFieldsBuilder = ImmutableBitSet.builder();
        HashMap<String, ColumnDescriptor> descriptorsMap = new HashMap<String, ColumnDescriptor>(columnDescriptors.size());
        boolean implicitKeyFound = false;
        ImmutableBitSet.Builder builder = ImmutableBitSet.builder();
        for (ColumnDescriptor descriptor : columnDescriptors) {
            if (descriptor.key()) {
                keyFieldsBuilder.set(descriptor.logicalIndex());
            }
            if (Commons.implicitPkEnabled() && "__p_key".equals(descriptor.name())) {
                assert (!implicitKeyFound);
                implicitKeyFound = true;
                descriptor = this.injectDefault(descriptor);
            } else {
                builder.set(descriptor.logicalIndex());
            }
            descriptorsMap.put(descriptor.name(), descriptor);
        }
        if (implicitKeyFound) {
            columnDescriptors = columnDescriptors.stream().map(desc -> (ColumnDescriptor)descriptorsMap.get(desc.name())).collect(Collectors.toList());
        }
        this.descriptors = columnDescriptors.toArray(DUMMY);
        this.descriptorsMap = descriptorsMap;
        this.insertFields = builder.build();
        this.keyFields = keyFieldsBuilder.build();
    }

    private ColumnDescriptor injectDefault(ColumnDescriptor desc) {
        assert (Commons.implicitPkEnabled() && "__p_key".equals(desc.name())) : desc;
        return new ColumnDescriptorImpl(desc.name(), desc.key(), desc.nullable(), desc.logicalIndex(), desc.physicalIndex(), desc.physicalType(), DefaultValueStrategy.DEFAULT_COMPUTED, () -> UUID.randomUUID().toString());
    }

    @Override
    public RelDataType insertRowType(IgniteTypeFactory factory) {
        return this.rowType(factory, this.insertFields);
    }

    @Override
    public RelDataType deleteRowType(IgniteTypeFactory factory) {
        return this.rowType(factory, this.keyFields);
    }

    @Override
    public IgniteDistribution distribution() {
        return IgniteDistributions.random();
    }

    @Override
    public boolean isUpdateAllowed(RelOptTable tbl, int colIdx) {
        return !this.descriptors[colIdx].key();
    }

    public ColumnStrategy generationStrategy(RelOptTable tbl, int colIdx) {
        if (this.descriptors[colIdx].defaultStrategy() != DefaultValueStrategy.DEFAULT_NULL) {
            return ColumnStrategy.DEFAULT;
        }
        return super.generationStrategy(tbl, colIdx);
    }

    public RexNode newColumnDefaultValue(RelOptTable tbl, int colIdx, InitializerContext ctx) {
        ColumnDescriptor descriptor = this.descriptors[colIdx];
        RexBuilder rexBuilder = ctx.getRexBuilder();
        switch (descriptor.defaultStrategy()) {
            case DEFAULT_NULL: {
                RelDataType fieldType = ((RelDataTypeField)tbl.getRowType().getFieldList().get(colIdx)).getType();
                return rexBuilder.makeNullLiteral(fieldType);
            }
            case DEFAULT_CONSTANT: {
                IgniteTypeFactory typeFactory = (IgniteTypeFactory)rexBuilder.getTypeFactory();
                Object defaultValue = TypeUtils.toInternal(null, descriptor.defaultValue());
                return rexBuilder.makeLiteral(defaultValue, this.deriveLogicalType((RelDataTypeFactory)typeFactory, descriptor), false);
            }
            case DEFAULT_COMPUTED: {
                return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.DEFAULT, new RexNode[0]);
            }
        }
        throw new IllegalStateException("Unknown default strategy: " + descriptor.defaultStrategy());
    }

    @Override
    public RelDataType rowType(IgniteTypeFactory factory, ImmutableBitSet usedColumns) {
        RelDataTypeFactory.Builder b = new RelDataTypeFactory.Builder((RelDataTypeFactory)factory);
        if (usedColumns == null) {
            for (int i = 0; i < this.descriptors.length; ++i) {
                b.add(this.descriptors[i].name(), this.deriveLogicalType((RelDataTypeFactory)factory, this.descriptors[i]));
            }
        } else {
            int i = usedColumns.nextSetBit(0);
            while (i != -1) {
                b.add(this.descriptors[i].name(), this.deriveLogicalType((RelDataTypeFactory)factory, this.descriptors[i]));
                i = usedColumns.nextSetBit(i + 1);
            }
        }
        return b.build();
    }

    @Override
    public ColumnDescriptor columnDescriptor(String fieldName) {
        return fieldName == null ? null : this.descriptorsMap.get(fieldName);
    }

    @Override
    public ColumnDescriptor columnDescriptor(int idx) {
        return idx < 0 || idx >= this.descriptors.length ? null : this.descriptors[idx];
    }

    @Override
    public int columnsCount() {
        return this.descriptors.length;
    }

    private RelDataType deriveLogicalType(RelDataTypeFactory factory, ColumnDescriptor desc) {
        return TypeUtils.native2relationalType(factory, desc.physicalType(), desc.nullable());
    }
}

