/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.serialization;

import java.lang.reflect.Field;
import org.apache.ignite.internal.network.serialization.BrokenFieldAccessor;
import org.apache.ignite.internal.network.serialization.UnsafeFieldAccessor;
import org.jetbrains.annotations.Nullable;

public interface FieldAccessor {
    public static FieldAccessor forField(Field field) {
        return new UnsafeFieldAccessor(field);
    }

    public static FieldAccessor forFieldName(String fieldName, Class<?> declaringClass) {
        Field field = FieldAccessor.findField(fieldName, declaringClass);
        if (field != null) {
            return new UnsafeFieldAccessor(field);
        }
        return new BrokenFieldAccessor(fieldName, declaringClass.getName());
    }

    @Nullable
    private static Field findField(String fieldName, Class<?> declaringClass) {
        try {
            return declaringClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public Object getObject(Object var1);

    public void setObject(Object var1, Object var2);

    public byte getByte(Object var1);

    public void setByte(Object var1, byte var2);

    public short getShort(Object var1);

    public void setShort(Object var1, short var2);

    public int getInt(Object var1);

    public void setInt(Object var1, int var2);

    public long getLong(Object var1);

    public void setLong(Object var1, long var2);

    public float getFloat(Object var1);

    public void setFloat(Object var1, float var2);

    public double getDouble(Object var1);

    public void setDouble(Object var1, double var2);

    public char getChar(Object var1);

    public void setChar(Object var1, char var2);

    public boolean getBoolean(Object var1);

    public void setBoolean(Object var1, boolean var2);
}

