/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.serialization.marshal;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.io.NotActiveException;
import org.apache.ignite.internal.network.serialization.ClassDescriptor;
import org.apache.ignite.internal.network.serialization.DescriptorRegistry;
import org.apache.ignite.internal.network.serialization.marshal.DefaultFieldsReaderWriter;
import org.apache.ignite.internal.network.serialization.marshal.TypedValueReader;
import org.apache.ignite.internal.network.serialization.marshal.UosObjectInputStream;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.jetbrains.annotations.Nullable;

class UnmarshallingContext
implements DescriptorRegistry {
    private final IgniteDataInput source;
    private final DescriptorRegistry descriptors;
    private final ClassLoader classLoader;
    private final Int2ObjectMap<Object> idsToObjects = new Int2ObjectOpenHashMap();
    private final IntSet unsharedObjectIds = new IntOpenHashSet();
    private Object objectCurrentlyReadWithReadObject;
    private ClassDescriptor descriptorOfObjectCurrentlyReadWithReadObject;
    private UosObjectInputStream objectInputStream;

    public UnmarshallingContext(IgniteDataInput source, DescriptorRegistry descriptors, ClassLoader classLoader) {
        this.source = source;
        this.descriptors = descriptors;
        this.classLoader = classLoader;
    }

    @Override
    @Nullable
    public ClassDescriptor getDescriptor(int descriptorId) {
        return this.descriptors.getDescriptor(descriptorId);
    }

    @Override
    @Nullable
    public ClassDescriptor getDescriptor(Class<?> clazz) {
        return this.descriptors.getDescriptor(clazz);
    }

    public ClassLoader classLoader() {
        return this.classLoader;
    }

    public void registerReference(int objectId, Object object, boolean unshared) {
        this.idsToObjects.put(objectId, object);
        if (unshared) {
            this.unsharedObjectIds.add(objectId);
        }
    }

    public boolean isKnownObjectId(int objectId) {
        return this.idsToObjects.containsKey(objectId);
    }

    public <T> T dereference(int objectId) {
        Object result = this.idsToObjects.get(objectId);
        if (result == null) {
            throw new IllegalStateException("Unknown object ID: " + objectId);
        }
        return (T)result;
    }

    public boolean isUnsharedObjectId(int objectId) {
        return this.unsharedObjectIds.contains(objectId);
    }

    public void markSource(int readAheadLimit) {
        this.source.mark(readAheadLimit);
    }

    public void resetSourceToMark() throws IOException {
        this.source.reset();
    }

    public Object objectCurrentlyReadWithReadObject() throws NotActiveException {
        if (this.objectCurrentlyReadWithReadObject == null) {
            throw new NotActiveException("not in call to readObject");
        }
        return this.objectCurrentlyReadWithReadObject;
    }

    public ClassDescriptor descriptorOfObjectCurrentlyReadWithReadObject() {
        if (this.descriptorOfObjectCurrentlyReadWithReadObject == null) {
            throw new IllegalStateException("No object is currently being read with readObject()");
        }
        return this.descriptorOfObjectCurrentlyReadWithReadObject;
    }

    public void startReadingWithReadObject(Object object, ClassDescriptor descriptor) {
        this.objectCurrentlyReadWithReadObject = object;
        this.descriptorOfObjectCurrentlyReadWithReadObject = descriptor;
    }

    public void endReadingWithReadObject() {
        this.objectCurrentlyReadWithReadObject = null;
        this.descriptorOfObjectCurrentlyReadWithReadObject = null;
    }

    UosObjectInputStream objectInputStream(IgniteDataInput input, TypedValueReader valueReader, TypedValueReader unsharedReader, DefaultFieldsReaderWriter defaultFieldsReaderWriter) throws IOException {
        if (this.objectInputStream == null) {
            this.objectInputStream = new UosObjectInputStream(input, valueReader, unsharedReader, defaultFieldsReaderWriter, this);
        }
        return this.objectInputStream;
    }
}

