/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import org.apache.ignite.network.serialization.MessageDeserializer;
import org.apache.ignite.network.serialization.MessageMappingException;
import org.apache.ignite.network.serialization.MessageReader;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.rpc.ReadIndexRequestBuilder;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;

class ReadIndexRequestDeserializer
implements MessageDeserializer<RpcRequests.ReadIndexRequest> {
    private final ReadIndexRequestBuilder msg;

    ReadIndexRequestDeserializer(RaftMessagesFactory messageFactory) {
        this.msg = messageFactory.readIndexRequest();
    }

    public Class<RpcRequests.ReadIndexRequest> klass() {
        return RpcRequests.ReadIndexRequest.class;
    }

    public RpcRequests.ReadIndexRequest getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.msg.entriesListByteArray(reader.readByteArray("entriesListByteArray"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.msg.groupId(reader.readString("groupId"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.msg.peerId(reader.readString("peerId"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.msg.serverId(reader.readString("serverId"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(RpcRequests.ReadIndexRequest.class);
    }
}

