/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.AnnotationDefinition;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.ParameterizedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;

public class FieldDefinition {
    private final ClassDefinition declaringClass;
    private final Set<Access> access;
    private final String name;
    private final ParameterizedType type;
    private final List<AnnotationDefinition> annotations = new ArrayList<AnnotationDefinition>();

    public FieldDefinition(ClassDefinition declaringClass, EnumSet<Access> access, String name, ParameterizedType type) {
        this.declaringClass = declaringClass;
        this.access = Collections.unmodifiableSet(access);
        this.name = name;
        this.type = type;
    }

    public FieldDefinition(ClassDefinition declaringClass, EnumSet<Access> access, String name, Class<?> type) {
        this(declaringClass, access, name, ParameterizedType.type(type));
    }

    public ClassDefinition getDeclaringClass() {
        return this.declaringClass;
    }

    public Set<Access> getAccess() {
        return this.access;
    }

    public String getName() {
        return this.name;
    }

    public ParameterizedType getType() {
        return this.type;
    }

    public List<AnnotationDefinition> getAnnotations() {
        return List.copyOf(this.annotations);
    }

    public AnnotationDefinition declareAnnotation(Class<?> type) {
        AnnotationDefinition annotationDefinition = new AnnotationDefinition(type);
        this.annotations.add(annotationDefinition);
        return annotationDefinition;
    }

    public AnnotationDefinition declareAnnotation(ParameterizedType type) {
        AnnotationDefinition annotationDefinition = new AnnotationDefinition(type);
        this.annotations.add(annotationDefinition);
        return annotationDefinition;
    }

    public void visit(ClassVisitor visitor) {
        FieldVisitor fieldVisitor = visitor.visitField(Access.toAccessModifier(this.access), this.name, this.type.getType(), this.type.isPrimitive() ? null : this.type.getGenericSignature(), null);
        if (fieldVisitor == null) {
            return;
        }
        for (AnnotationDefinition annotation : this.annotations) {
            annotation.visitFieldAnnotation(fieldVisitor);
        }
        fieldVisitor.visitEnd();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FieldDefinition");
        sb.append("{access=").append(this.access);
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", type=").append(this.type);
        sb.append('}');
        return sb.toString();
    }
}

