/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema.row;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.BitSet;
import java.util.UUID;
import org.apache.ignite.internal.schema.AssemblyException;
import org.apache.ignite.internal.schema.BinaryRow;
import org.apache.ignite.internal.schema.BitmaskNativeType;
import org.apache.ignite.internal.schema.ByteBufferRow;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.Columns;
import org.apache.ignite.internal.schema.DecimalNativeType;
import org.apache.ignite.internal.schema.InvalidTypeException;
import org.apache.ignite.internal.schema.NativeType;
import org.apache.ignite.internal.schema.NativeTypeSpec;
import org.apache.ignite.internal.schema.NativeTypes;
import org.apache.ignite.internal.schema.NumberNativeType;
import org.apache.ignite.internal.schema.SchemaDescriptor;
import org.apache.ignite.internal.schema.SchemaMismatchException;
import org.apache.ignite.internal.schema.TemporalNativeType;
import org.apache.ignite.internal.schema.row.ExpandableByteBuf;
import org.apache.ignite.internal.schema.row.TemporalTypesHelper;
import org.apache.ignite.internal.schema.row.VarTableFormat;
import org.apache.ignite.internal.util.HashUtils;

public class RowAssembler {
    private final SchemaDescriptor schema;
    private final int valVartblLen;
    private final ExpandableByteBuf buf;
    private Columns curCols;
    private int curCol;
    private int curOff;
    private int curVartblEntry;
    private int baseOff;
    private int nullMapOff;
    private int varTblOff;
    private int dataOff;
    private byte flags;
    private CharsetEncoder strEncoder;
    private int keyChunkLength;

    private static int varTableChunkLength(int entries, int entrySize) {
        return entries <= 1 ? 0 : 2 + (entries - 1) * entrySize;
    }

    public static int utf8EncodedLength(CharSequence seq) {
        int cnt = 0;
        int len = seq.length();
        for (int i = 0; i < len; ++i) {
            char ch = seq.charAt(i);
            if (ch <= '\u007f') {
                ++cnt;
                continue;
            }
            if (ch <= '\u07ff') {
                cnt += 2;
                continue;
            }
            if (Character.isHighSurrogate(ch)) {
                cnt += 4;
                ++i;
                continue;
            }
            cnt += 3;
        }
        return cnt;
    }

    public static void writeValue(RowAssembler rowAsm, Column col, Object val) throws SchemaMismatchException {
        RowAssembler.writeValue(rowAsm, col.type(), val);
    }

    public static void writeValue(RowAssembler rowAsm, NativeType type, Object val) throws SchemaMismatchException {
        if (val == null) {
            rowAsm.appendNull();
            return;
        }
        switch (type.spec()) {
            case INT8: {
                rowAsm.appendByte((Byte)val);
                break;
            }
            case INT16: {
                rowAsm.appendShort((Short)val);
                break;
            }
            case INT32: {
                rowAsm.appendInt((Integer)val);
                break;
            }
            case INT64: {
                rowAsm.appendLong((Long)val);
                break;
            }
            case FLOAT: {
                rowAsm.appendFloat(((Float)val).floatValue());
                break;
            }
            case DOUBLE: {
                rowAsm.appendDouble((Double)val);
                break;
            }
            case UUID: {
                rowAsm.appendUuid((UUID)val);
                break;
            }
            case TIME: {
                rowAsm.appendTime((LocalTime)val);
                break;
            }
            case DATE: {
                rowAsm.appendDate((LocalDate)val);
                break;
            }
            case DATETIME: {
                rowAsm.appendDateTime((LocalDateTime)val);
                break;
            }
            case TIMESTAMP: {
                rowAsm.appendTimestamp((Instant)val);
                break;
            }
            case STRING: {
                rowAsm.appendString((String)val);
                break;
            }
            case BYTES: {
                rowAsm.appendBytes((byte[])val);
                break;
            }
            case BITMASK: {
                rowAsm.appendBitmask((BitSet)val);
                break;
            }
            case NUMBER: {
                rowAsm.appendNumber((BigInteger)val);
                break;
            }
            case DECIMAL: {
                rowAsm.appendDecimal((BigDecimal)val);
                break;
            }
            default: {
                throw new InvalidTypeException("Unexpected value: " + type);
            }
        }
    }

    public static int sizeInBytes(BigInteger val) {
        return val.bitLength() / 8 + 1;
    }

    public static int sizeInBytes(BigDecimal val) {
        return RowAssembler.sizeInBytes(val.unscaledValue());
    }

    public RowAssembler(SchemaDescriptor schema, int nonNullVarlenKeyCols, int nonNullVarlenValCols) {
        this(schema, 0, nonNullVarlenKeyCols, 0, nonNullVarlenValCols);
    }

    public RowAssembler(SchemaDescriptor schema, int keyVarlenSize, int keyVarlenCols, int valVarlenSize, int valVarlenCols) {
        this.schema = schema;
        this.curCols = schema.keyColumns();
        this.curCol = 0;
        this.strEncoder = null;
        int keyVartblLen = RowAssembler.varTableChunkLength(keyVarlenCols, 4);
        this.valVartblLen = RowAssembler.varTableChunkLength(valVarlenCols, 4);
        this.initChunk(6, this.curCols.nullMapSize(), keyVartblLen);
        Columns valCols = schema.valueColumns();
        int size = 14 + keyVarlenSize + valVarlenSize + keyVartblLen + this.valVartblLen + this.curCols.fixsizeMaxLen() + valCols.fixsizeMaxLen() + this.curCols.nullMapSize() + valCols.nullMapSize();
        this.buf = new ExpandableByteBuf(size);
        this.buf.putShort(0, (short)schema.version());
    }

    public RowAssembler appendNull() throws SchemaMismatchException {
        if (!this.curCols.column(this.curCol).nullable()) {
            throw new SchemaMismatchException("Failed to set column (null was passed, but column is not nullable): " + this.curCols.column(this.curCol));
        }
        this.setNull(this.curCol);
        this.shiftColumn(0);
        return this;
    }

    public RowAssembler appendByte(byte val) throws SchemaMismatchException {
        this.checkType(NativeTypes.INT8);
        this.buf.put(this.curOff, val);
        this.shiftColumn(NativeTypes.INT8.sizeInBytes());
        return this;
    }

    public RowAssembler appendShort(short val) throws SchemaMismatchException {
        this.checkType(NativeTypes.INT16);
        this.buf.putShort(this.curOff, val);
        this.shiftColumn(NativeTypes.INT16.sizeInBytes());
        return this;
    }

    public RowAssembler appendInt(int val) throws SchemaMismatchException {
        this.checkType(NativeTypes.INT32);
        this.buf.putInt(this.curOff, val);
        this.shiftColumn(NativeTypes.INT32.sizeInBytes());
        return this;
    }

    public RowAssembler appendLong(long val) throws SchemaMismatchException {
        this.checkType(NativeTypes.INT64);
        this.buf.putLong(this.curOff, val);
        this.shiftColumn(NativeTypes.INT64.sizeInBytes());
        return this;
    }

    public RowAssembler appendFloat(float val) throws SchemaMismatchException {
        this.checkType(NativeTypes.FLOAT);
        this.buf.putFloat(this.curOff, val);
        this.shiftColumn(NativeTypes.FLOAT.sizeInBytes());
        return this;
    }

    public RowAssembler appendDouble(double val) throws SchemaMismatchException {
        this.checkType(NativeTypes.DOUBLE);
        this.buf.putDouble(this.curOff, val);
        this.shiftColumn(NativeTypes.DOUBLE.sizeInBytes());
        return this;
    }

    public RowAssembler appendNumber(BigInteger val) throws SchemaMismatchException {
        this.checkType(NativeTypeSpec.NUMBER);
        Column col = this.curCols.column(this.curCol);
        NumberNativeType type = (NumberNativeType)col.type();
        if (type.precision() > 0 && new BigDecimal(val).precision() > type.precision()) {
            throw new SchemaMismatchException("Failed to set number value for column '" + col.name() + "' (max precision exceeds allocated precision) [number=" + val + ", max precision=" + type.precision() + "]");
        }
        byte[] bytes = val.toByteArray();
        this.buf.putBytes(this.curOff, bytes);
        this.writeVarlenOffset(this.curVartblEntry, this.curOff - this.dataOff);
        ++this.curVartblEntry;
        this.shiftColumn(bytes.length);
        return this;
    }

    public RowAssembler appendDecimal(BigDecimal val) throws SchemaMismatchException {
        this.checkType(NativeTypeSpec.DECIMAL);
        Column col = this.curCols.column(this.curCol);
        DecimalNativeType type = (DecimalNativeType)col.type();
        val = val.setScale(type.scale(), RoundingMode.HALF_UP);
        if (val.precision() > type.precision()) {
            throw new SchemaMismatchException("Failed to set decimal value for column '" + col.name() + "' (max precision exceeds allocated precision) [decimal=" + val + ", max precision=" + type.precision() + "]");
        }
        byte[] bytes = val.unscaledValue().toByteArray();
        this.buf.putBytes(this.curOff, bytes);
        this.writeVarlenOffset(this.curVartblEntry, this.curOff - this.dataOff);
        ++this.curVartblEntry;
        this.shiftColumn(bytes.length);
        return this;
    }

    public RowAssembler appendUuid(UUID uuid) throws SchemaMismatchException {
        this.checkType(NativeTypes.UUID);
        this.buf.putLong(this.curOff, uuid.getLeastSignificantBits());
        this.buf.putLong(this.curOff + 8, uuid.getMostSignificantBits());
        this.shiftColumn(NativeTypes.UUID.sizeInBytes());
        return this;
    }

    public RowAssembler appendString(String val) throws SchemaMismatchException {
        this.checkType(NativeTypeSpec.STRING);
        try {
            int written = this.buf.putString(this.curOff, val, this.encoder());
            this.writeVarlenOffset(this.curVartblEntry, this.curOff - this.dataOff);
            ++this.curVartblEntry;
            this.shiftColumn(written);
            return this;
        }
        catch (CharacterCodingException e) {
            throw new AssemblyException("Failed to encode string", e);
        }
    }

    public RowAssembler appendBytes(byte[] val) throws SchemaMismatchException {
        this.checkType(NativeTypeSpec.BYTES);
        this.buf.putBytes(this.curOff, val);
        this.writeVarlenOffset(this.curVartblEntry, this.curOff - this.dataOff);
        ++this.curVartblEntry;
        this.shiftColumn(val.length);
        return this;
    }

    public RowAssembler appendBitmask(BitSet bitSet) throws SchemaMismatchException {
        Column col = this.curCols.column(this.curCol);
        this.checkType(NativeTypeSpec.BITMASK);
        BitmaskNativeType maskType = (BitmaskNativeType)col.type();
        if (bitSet.length() > maskType.bits()) {
            throw new IllegalArgumentException("Failed to set bitmask for column '" + col.name() + "' (mask size exceeds allocated size) [mask=" + bitSet + ", maxSize=" + maskType.bits() + "]");
        }
        byte[] arr = bitSet.toByteArray();
        this.buf.putBytes(this.curOff, arr);
        for (int i = 0; i < maskType.sizeInBytes() - arr.length; ++i) {
            this.buf.put(this.curOff + arr.length + i, (byte)0);
        }
        this.shiftColumn(maskType.sizeInBytes());
        return this;
    }

    public RowAssembler appendDate(LocalDate val) throws SchemaMismatchException {
        this.checkType(NativeTypes.DATE);
        int date = TemporalTypesHelper.encodeDate(val);
        this.writeDate(this.curOff, date);
        this.shiftColumn(NativeTypes.DATE.sizeInBytes());
        return this;
    }

    public RowAssembler appendTime(LocalTime val) throws SchemaMismatchException {
        this.checkType(NativeTypeSpec.TIME);
        TemporalNativeType type = (TemporalNativeType)this.curCols.column(this.curCol).type();
        RowAssembler.writeTime(this.buf, this.curOff, val, type);
        this.shiftColumn(type.sizeInBytes());
        return this;
    }

    public RowAssembler appendDateTime(LocalDateTime val) throws SchemaMismatchException {
        this.checkType(NativeTypeSpec.DATETIME);
        TemporalNativeType type = (TemporalNativeType)this.curCols.column(this.curCol).type();
        int date = TemporalTypesHelper.encodeDate(val.toLocalDate());
        this.writeDate(this.curOff, date);
        RowAssembler.writeTime(this.buf, this.curOff + 3, val.toLocalTime(), type);
        this.shiftColumn(type.sizeInBytes());
        return this;
    }

    public RowAssembler appendTimestamp(Instant val) throws SchemaMismatchException {
        this.checkType(NativeTypeSpec.TIMESTAMP);
        TemporalNativeType type = (TemporalNativeType)this.curCols.column(this.curCol).type();
        long seconds = val.getEpochSecond();
        int nanos = TemporalTypesHelper.normalizeNanos(val.getNano(), type.precision());
        this.buf.putLong(this.curOff, seconds);
        if (type.precision() != 0) {
            this.buf.putInt(this.curOff + 8, nanos);
        }
        this.shiftColumn(type.sizeInBytes());
        return this;
    }

    public BinaryRow build() {
        this.flush();
        return new ByteBufferRow(this.buf.unwrap());
    }

    public byte[] toBytes() {
        this.flush();
        return this.buf.toArray();
    }

    private void flush() {
        if (this.schema.keyColumns() == this.curCols) {
            throw new AssemblyException("Key column missed: colIdx=" + this.curCol);
        }
        if (this.curCol == 0) {
            this.buf.putShort(0, (short)0);
        } else if (this.schema.valueColumns().length() != this.curCol) {
            throw new AssemblyException("Value column missed: colIdx=" + this.curCol);
        }
        int hash = HashUtils.hash32((byte[])this.buf.unwrap().array(), (int)6, (int)this.keyChunkLength, (int)0);
        this.buf.putInt(2, hash);
    }

    private CharsetEncoder encoder() {
        if (this.strEncoder == null) {
            this.strEncoder = StandardCharsets.UTF_8.newEncoder();
        }
        return this.strEncoder;
    }

    private void writeVarlenOffset(int entryIdx, int off) {
        if (entryIdx == 0) {
            return;
        }
        this.buf.putInt(this.varTblOff + 2 + (entryIdx - 1) * 4, off);
    }

    private void writeDate(int off, int date) {
        this.buf.putShort(off, (short)(date >>> 8));
        this.buf.put(off + 2, (byte)(date & 0xFF));
    }

    static void writeTime(ExpandableByteBuf buf, int off, LocalTime val, TemporalNativeType type) {
        long time = TemporalTypesHelper.encodeTime(type, val);
        if (type.precision() > 3) {
            time = time >>> 32 << 30 | time & 0x3FFFFFFFL;
            buf.putInt(off, (int)(time >>> 16));
            buf.putShort(off + 4, (short)(time & 0xFFFFFFFFL));
        } else {
            time = time >>> 32 << 14 | time & 0x3FFFL;
            buf.putInt(off, (int)time);
        }
    }

    private void checkType(NativeTypeSpec type) {
        Column col = this.curCols.column(this.curCol);
        if (col.type().spec() != type) {
            throw new SchemaMismatchException("Failed to set column (" + type.name() + " was passed, but column is of different type): " + col);
        }
    }

    private void checkType(NativeType type) {
        this.checkType(type.spec());
    }

    private void setNull(int colIdx) {
        assert (this.nullMapOff < this.varTblOff) : "Null-map is omitted.";
        int byteInMap = colIdx >> 3;
        int bitInByte = colIdx & 7;
        this.buf.ensureCapacity(this.nullMapOff + byteInMap + 1);
        this.buf.put(this.nullMapOff + byteInMap, (byte)(Byte.toUnsignedInt(this.buf.get(this.nullMapOff + byteInMap)) | 1 << bitInByte));
    }

    private void shiftColumn(int size) {
        ++this.curCol;
        this.curOff += size;
        if (this.curCol == this.curCols.length()) {
            this.finishChunk();
        }
    }

    private void finishChunk() {
        if (this.curVartblEntry > 1) {
            assert (this.varTblOff < this.dataOff) : "Illegal writing of varlen when 'omit vartable' flag is set for a chunk.";
            assert (this.varTblOff + RowAssembler.varTableChunkLength(this.curVartblEntry, 4) == this.dataOff) : "Vartable overlow: size=" + this.curVartblEntry;
            VarTableFormat format = VarTableFormat.format(this.curOff - this.dataOff, this.valVartblLen);
            this.curOff -= format.compactVarTable(this.buf, this.varTblOff, this.curVartblEntry - 1);
            this.flags = (byte)(this.flags | format.formatId());
        }
        int chunkLen = this.curOff - this.baseOff;
        this.buf.putInt(this.baseOff, chunkLen);
        this.buf.put(this.baseOff + 4, this.flags);
        if (this.schema.keyColumns() == this.curCols) {
            this.keyChunkLength = chunkLen;
            this.switchToValueChunk(6 + chunkLen);
        }
    }

    private void switchToValueChunk(int baseOff) {
        this.curCols = this.schema.valueColumns();
        this.curCol = 0;
        this.initChunk(baseOff, this.curCols.nullMapSize(), this.valVartblLen);
    }

    private void initChunk(int baseOff, int nullMapLen, int vartblLen) {
        this.baseOff = baseOff;
        this.nullMapOff = baseOff + 4 + 1;
        this.varTblOff = this.nullMapOff + nullMapLen;
        this.curOff = this.dataOff = this.varTblOff + vartblLen;
        this.curVartblEntry = 0;
        this.flags = 0;
    }

    private boolean isKeyChunk() {
        return this.baseOff == 6;
    }
}

