/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metrics;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.ignite.internal.metrics.MetricSet;
import org.apache.ignite.internal.metrics.MetricSetBuilder;
import org.apache.ignite.internal.metrics.MetricSource;

public abstract class AbstractMetricSource<T extends Holder<T>>
implements MetricSource {
    private static final AtomicReferenceFieldUpdater<AbstractMetricSource, Holder> HOLDER_FIELD_UPD = AtomicReferenceFieldUpdater.newUpdater(AbstractMetricSource.class, Holder.class, "holder");
    private final String name;
    private volatile T holder;

    protected AbstractMetricSource(String name) {
        this.name = name;
    }

    @Override
    public final String name() {
        return this.name;
    }

    @Override
    public final boolean enabled() {
        return this.holder != null;
    }

    public final T holder() {
        return this.holder;
    }

    protected abstract T createHolder();

    @Override
    public final MetricSet enable() {
        MetricSetBuilder bldr = new MetricSetBuilder(this.name);
        T hldr = this.createHolder();
        this.init(bldr, hldr);
        MetricSet metricSet = bldr.build();
        return HOLDER_FIELD_UPD.compareAndSet(this, (Holder)null, (Holder)hldr) ? metricSet : null;
    }

    @Override
    public final void disable() {
        T holder0 = this.holder;
        if (HOLDER_FIELD_UPD.compareAndSet(this, (Holder)holder0, (Holder)null)) {
            this.cleanup(holder0);
        }
    }

    protected abstract void init(MetricSetBuilder var1, T var2);

    protected void cleanup(T holder) {
    }

    protected static interface Holder<T extends Holder<T>> {
    }
}

