/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.decorators;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.internal.cli.core.decorator.Decorator;
import org.apache.ignite.internal.cli.core.decorator.TerminalOutput;
import org.apache.ignite.rest.client.model.MetricSource;

public class MetricListDecorator
implements Decorator<List<MetricSource>, TerminalOutput> {
    @Override
    public TerminalOutput decorate(List<MetricSource> data) {
        return () -> {
            String enabled = data.stream().filter(MetricSource::getEnabled).map(MetricSource::getName).collect(Collectors.joining(System.lineSeparator()));
            String disabled = data.stream().filter(metricSource -> metricSource.getEnabled() == false).map(MetricSource::getName).collect(Collectors.joining(System.lineSeparator()));
            return Stream.of("Enabled metric sources:", enabled, "Disabled metric sources:", disabled).filter(s -> !s.isEmpty()).collect(Collectors.joining(System.lineSeparator()));
        };
    }
}

