/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration;

import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigObject;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.ignite.configuration.RootKey;
import org.apache.ignite.configuration.validation.Validator;
import org.apache.ignite.internal.configuration.ConfigurationRegistry;
import org.apache.ignite.internal.configuration.hocon.HoconConverter;
import org.apache.ignite.internal.configuration.storage.ConfigurationStorage;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.intellij.lang.annotations.Language;

public class ConfigurationManager
implements IgniteComponent {
    private final ConfigurationRegistry registry;

    public ConfigurationManager(Collection<RootKey<?, ?>> rootKeys, Map<Class<? extends Annotation>, Set<Validator<? extends Annotation, ?>>> validators, ConfigurationStorage storage, Collection<Class<?>> internalSchemaExtensions, Collection<Class<?>> polymorphicSchemaExtensions) {
        this.registry = new ConfigurationRegistry(rootKeys, validators, storage, internalSchemaExtensions, polymorphicSchemaExtensions);
    }

    public void start() {
        this.registry.start();
    }

    public void stop() throws Exception {
        this.registry.stop();
    }

    public void bootstrap(@Language(value="HOCON") String hoconStr) throws InterruptedException, ExecutionException {
        ConfigObject hoconCfg = ConfigFactory.parseString((String)hoconStr).root();
        this.registry.change(HoconConverter.hoconSource(hoconCfg)).get();
    }

    public ConfigurationRegistry configurationRegistry() {
        return this.registry;
    }
}

