/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.server;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Entry {
    @NotNull
    private final byte[] key;
    @Nullable
    private final byte[] val;
    private final long rev;
    private final long updCntr;

    public Entry(@NotNull byte[] key, @NotNull byte[] val, long rev, long updCntr) {
        assert (key != null) : "key can't be null";
        assert (val != null) : "value can't be null";
        this.key = key;
        this.val = val;
        this.rev = rev;
        this.updCntr = updCntr;
    }

    private Entry(@NotNull byte[] key, long rev, long updCntr) {
        assert (key != null) : "key can't be null";
        this.key = key;
        this.val = null;
        this.rev = rev;
        this.updCntr = updCntr;
    }

    @NotNull
    public static Entry empty(byte[] key) {
        return new Entry(key, 0L, 0L);
    }

    public boolean empty() {
        return this.val == null && this.rev == 0L && this.updCntr == 0L;
    }

    @NotNull
    public static Entry tombstone(byte[] key, long rev, long updCntr) {
        assert (rev > 0L) : "rev must be positive for tombstone entry.";
        assert (updCntr > 0L) : "updCntr must be positive for tombstone entry.";
        return new Entry(key, rev, updCntr);
    }

    public boolean tombstone() {
        return this.val == null && this.rev > 0L && this.updCntr > 0L;
    }

    @NotNull
    public byte[] key() {
        return this.key;
    }

    @Nullable
    public byte[] value() {
        return this.val;
    }

    public long revision() {
        return this.rev;
    }

    public long updateCounter() {
        return this.updCntr;
    }
}

