/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.schema;

import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.ignite.internal.sql.engine.schema.IgniteIndex;
import org.apache.ignite.internal.sql.engine.schema.InternalIgniteTable;

public class IgniteSchema
extends AbstractSchema {
    private final String schemaName;
    private final Map<String, Table> tblMap;
    private final Map<UUID, IgniteIndex> idxMap;

    public IgniteSchema(String schemaName, Map<String, Table> tblMap, Map<UUID, IgniteIndex> idxMap) {
        this.schemaName = schemaName;
        this.tblMap = tblMap == null ? new ConcurrentHashMap<String, Table>() : new ConcurrentHashMap<String, Table>(tblMap);
        this.idxMap = idxMap == null ? new ConcurrentHashMap<UUID, IgniteIndex>() : new ConcurrentHashMap<UUID, IgniteIndex>(idxMap);
    }

    public IgniteSchema(String schemaName) {
        this(schemaName, null, null);
    }

    public static IgniteSchema copy(IgniteSchema old) {
        return new IgniteSchema(old.schemaName, old.tblMap, old.idxMap);
    }

    public String getName() {
        return this.schemaName;
    }

    protected Map<String, Table> getTableMap() {
        return Collections.unmodifiableMap(this.tblMap);
    }

    public void addTable(String tblName, InternalIgniteTable tbl) {
        this.tblMap.put(tblName, (Table)tbl);
    }

    public void removeTable(String tblName) {
        InternalIgniteTable rmv = (InternalIgniteTable)this.tblMap.remove(tblName);
        this.idxMap.values().removeIf(idx -> idx.index().tableId().equals(rmv.id()));
    }

    public void addIndex(UUID indexId, IgniteIndex index) {
        this.idxMap.put(indexId, index);
    }

    public IgniteIndex removeIndex(UUID indexId) {
        return this.idxMap.remove(indexId);
    }

    public IgniteIndex index(UUID indexId) {
        return this.idxMap.get(indexId);
    }
}

