/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.lang;

import java.util.Objects;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;

public final class NullableValue<T> {
    private static final NullableValue<?> NULL = new NullableValue<Object>(null);
    private T value;

    public static <T> NullableValue<T> of(@Nullable T obj) {
        return obj == null ? NULL : new NullableValue<T>(obj);
    }

    private NullableValue(@Nullable T value) {
        this.value = value;
    }

    @Nullable
    public T get() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NullableValue that = (NullableValue)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return "NullableValue[value=" + String.valueOf(this.value) + "]";
    }
}

