/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.sql;

import java.util.Objects;
import org.apache.ignite.internal.catalog.sql.AbstractCatalogQuery;
import org.apache.ignite.internal.catalog.sql.Name;
import org.apache.ignite.internal.catalog.sql.QueryContext;
import org.apache.ignite.sql.IgniteSql;

class DropZoneImpl
extends AbstractCatalogQuery<Name> {
    private Name zoneName;
    private boolean ifExists;

    DropZoneImpl(IgniteSql sql) {
        super(sql);
    }

    @Override
    protected Name result() {
        return this.zoneName;
    }

    DropZoneImpl name(String ... names) {
        Objects.requireNonNull(names, "Zone name must not be null");
        this.zoneName = new Name(names);
        return this;
    }

    DropZoneImpl ifExists() {
        this.ifExists = true;
        return this;
    }

    @Override
    protected void accept(QueryContext ctx) {
        ctx.sql("DROP ZONE ");
        if (this.ifExists) {
            ctx.sql("IF EXISTS ");
        }
        ctx.visit(this.zoneName);
        ctx.sql(";");
    }
}

