/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.exp;

import java.util.Collection;
import java.util.List;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.sql.engine.exec.exp.SqlComparator;
import org.apache.ignite.internal.util.CollectionUtils;
import org.jetbrains.annotations.Nullable;

class ComparatorImplementor {
    ComparatorImplementor() {
    }

    <RowT> SqlComparator<RowT> implement(RelCollation collation) {
        assert (collation != null && !CollectionUtils.nullOrEmpty((Collection)collation.getFieldCollations())) : collation;
        return (context, r1, r2) -> {
            RowHandler<Object> hnd = context.rowHandler();
            List collations = collation.getFieldCollations();
            int colsCountRow1 = hnd.columnCount(r1);
            int colsCountRow2 = hnd.columnCount(r2);
            int maxCols = Math.min(Math.max(colsCountRow1, colsCountRow2), collations.size());
            for (int i = 0; i < maxCols; ++i) {
                int res;
                boolean ascending;
                RelFieldCollation field = (RelFieldCollation)collations.get(i);
                boolean bl = ascending = field.direction == RelFieldCollation.Direction.ASCENDING;
                if (i == colsCountRow1) {
                    return ascending ? -1 : 1;
                }
                if (i == colsCountRow2) {
                    return ascending ? 1 : -1;
                }
                int fieldIdx = field.getFieldIndex();
                Object c1 = hnd.get(fieldIdx, r1);
                Object c2 = hnd.get(fieldIdx, r2);
                int nullComparison = field.nullDirection.nullComparison;
                int n = res = ascending ? ComparatorImplementor.compare(c1, c2, nullComparison) : ComparatorImplementor.compare(c2, c1, -nullComparison);
                if (res == 0) continue;
                return res;
            }
            return 0;
        };
    }

    <RowT> SqlComparator<RowT> implement(List<RelFieldCollation> left, List<RelFieldCollation> right, ImmutableBitSet equalNulls) {
        if (CollectionUtils.nullOrEmpty(left) || CollectionUtils.nullOrEmpty(right) || left.size() != right.size()) {
            throw new IllegalArgumentException("Both inputs should be non-empty and have the same size: left=" + String.valueOf(left != null ? Integer.valueOf(left.size()) : "null") + ", right=" + String.valueOf(right != null ? Integer.valueOf(right.size()) : "null"));
        }
        for (int i = 0; i < left.size(); ++i) {
            if (left.get((int)i).nullDirection.nullComparison != right.get((int)i).nullDirection.nullComparison) {
                throw new IllegalArgumentException("Can't be compared: left=" + String.valueOf(left.get(i)) + ", right=" + String.valueOf(right.get(i)));
            }
            if (left.get((int)i).direction == right.get((int)i).direction) continue;
            throw new IllegalArgumentException("Can't be compared: left=" + String.valueOf(left.get(i)) + ", right=" + String.valueOf(right.get(i)));
        }
        return (context, r1, r2) -> {
            boolean hasNulls = false;
            RowHandler<Object> hnd = context.rowHandler();
            for (int i = 0; i < left.size(); ++i) {
                int res;
                RelFieldCollation leftField = (RelFieldCollation)left.get(i);
                RelFieldCollation rightField = (RelFieldCollation)right.get(i);
                int leftIdx = leftField.getFieldIndex();
                int rightIdx = rightField.getFieldIndex();
                Object c1 = hnd.get(leftIdx, r1);
                Object c2 = hnd.get(rightIdx, r2);
                if (!equalNulls.get(leftIdx) && c1 == null && c2 == null) {
                    hasNulls = true;
                    continue;
                }
                int nullComparison = leftField.nullDirection.nullComparison;
                int n = res = leftField.direction == RelFieldCollation.Direction.ASCENDING ? ComparatorImplementor.compare(c1, c2, nullComparison) : ComparatorImplementor.compare(c2, c1, -nullComparison);
                if (res == 0) continue;
                return res;
            }
            return hasNulls ? 1 : 0;
        };
    }

    private static int compare(@Nullable Object o1, @Nullable Object o2, int nullComparison) {
        Comparable c1 = (Comparable)o1;
        Comparable c2 = (Comparable)o2;
        return RelFieldCollation.compare((Comparable)c1, (Comparable)c2, (int)nullComparison);
    }
}

