/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.compaction.message;

import org.apache.ignite3.internal.catalog.compaction.message.AvailablePartitionsMessage;
import org.apache.ignite3.internal.catalog.compaction.message.AvailablePartitionsMessageImpl;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;

class AvailablePartitionsMessageSerializer
implements MessageSerializer<AvailablePartitionsMessage> {
    public static final AvailablePartitionsMessageSerializer INSTANCE = new AvailablePartitionsMessageSerializer();

    private AvailablePartitionsMessageSerializer() {
    }

    @Override
    public boolean writeMessage(AvailablePartitionsMessage msg, MessageWriter writer) throws MessageMappingException {
        AvailablePartitionsMessageImpl message = (AvailablePartitionsMessageImpl)msg;
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)2)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeBitSet("partitions", message.partitions());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeInt("tableId", message.tableId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

