/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.serialization.marshal;

import java.util.List;
import org.apache.ignite3.internal.network.serialization.marshal.Instantiation;
import org.apache.ignite3.internal.network.serialization.marshal.InstantiationException;

class BestEffortInstantiation
implements Instantiation {
    private final List<Instantiation> delegates;

    BestEffortInstantiation(Instantiation ... delegates) {
        this.delegates = List.of(delegates);
    }

    @Override
    public boolean supports(Class<?> objectClass) {
        for (Instantiation delegate : this.delegates) {
            if (!delegate.supports(objectClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object newInstance(Class<?> objectClass) throws InstantiationException {
        for (Instantiation delegate : this.delegates) {
            if (!delegate.supports(objectClass)) continue;
            return delegate.newInstance(objectClass);
        }
        throw new InstantiationException("No delegate supports " + objectClass);
    }
}

